/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.osd.win32;

import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiipwClusterWindowsOps {
    static ClusterWindows cmd = null;
    static String s_separator = "\\";

    public static void regCopyKey(String dkey, String dsubkey, String[] nodeList) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Copy reg. key on nodes:" + dkey + ":" + dsubkey + ": " + OiixFunctionOps.implodeList(nodeList, ","));
            }
            cmd.createRegKeyOnNodes(dkey, dsubkey, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{dkey, dsubkey, sNodeList, e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("OUI-35019", obj), OiiolTextLogger.LOG_BASIC);
        }
    }

    public static void regCreateKey(String dkey, String dsubkey, String[] nodeList) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create reg. key on nodes:" + dkey + ":" + dsubkey + ": " + OiixFunctionOps.implodeList(nodeList, ","));
            }
            cmd.createRegKeyOnNodes(dkey, dsubkey, nodeList);
        }
        catch (ClusterException e) {
            e.printStackTrace();
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{dkey, dsubkey, sNodeList, e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("OUI-35020", obj), OiiolTextLogger.LOG_BASIC);
        }
    }

    public static void regDeleteKey(String dkey, String dsubkey, String[] nodeList) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Delete reg. key on nodes:" + dkey + ":" + dsubkey + ": " + OiixFunctionOps.implodeList(nodeList, ","));
            }
            cmd.deleteRegKeyOnNodes(dkey, dsubkey, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{dkey, dsubkey, sNodeList, e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("OUI-35021", obj), OiiolTextLogger.LOG_BASIC);
        }
    }

    public static void regSetValue(String dkey, String dsubkey, String value, String data, String[] nodeList) {
        String key = dkey.concat(s_separator);
        key = key.concat(dsubkey);
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create string reg. value on nodes:" + dkey + ":" + dsubkey + ": " + data + ":" + OiixFunctionOps.implodeList(nodeList, ","));
            }
            cmd.setRegValueOnNodes(key, value, data, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{key, value, data, sNodeList, e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("OUI-35022", obj), OiiolTextLogger.LOG_BASIC);
        }
    }

    public static void regSetValue(String dkey, String dsubkey, String value, Integer data, String[] nodeList) {
        String key = dkey.concat(s_separator);
        key = key.concat(dsubkey);
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create integer reg. value on nodes:" + dkey + ":" + dsubkey + ": " + data + ":" + OiixFunctionOps.implodeList(nodeList, ","));
            }
            cmd.setRegValueOnNodes(key, value, data, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            String sData = data.toString();
            Object[] obj = new Object[]{key, value, sData, sNodeList, e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("OUI-35022", obj), OiiolTextLogger.LOG_BASIC);
        }
    }

    public static void regSetValue(String dkey, String dsubkey, String value, String[] data, String[] nodeList) {
        String key = dkey.concat(s_separator);
        key = key.concat(dsubkey);
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create stringlist reg. value on nodes:" + dkey + ":" + dsubkey + ": " + OiixFunctionOps.implodeList(data, ",") + ":" + OiixFunctionOps.implodeList(nodeList, ","));
            }
            cmd.setRegValueOnNodes(key, value, data, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{key, value, data, sNodeList, e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("OUI-35022", obj), OiiolTextLogger.LOG_BASIC);
        }
    }

    public static void regDeleteValue(String dkey, String dsubkey, String value, String[] nodeList) {
        String key = dkey.concat(s_separator);
        key = key.concat(dsubkey);
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Delete reg. value on nodes:" + dkey + ":" + dsubkey + ":" + OiixFunctionOps.implodeList(nodeList, ","));
            }
            cmd.deleteRegValueOnNodes(key, value, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{key, value, sNodeList, e.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("OUI-35023", obj), OiiolTextLogger.LOG_BASIC);
        }
    }

    public static void registryCopyKey(String dkey, String dsubkey, String[] nodeList) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Copy reg. key on nodes:" + dkey + ":" + dsubkey + ": " + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd.createRegKeyOnNodes(dkey, dsubkey, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{dkey, dsubkey, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35019", obj, e);
        }
    }

    public static void registryCreateKey(String dkey, String dsubkey, String[] nodeList) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create reg. key on nodes:" + dkey + ":" + dsubkey + ": " + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd.createRegKeyOnNodes(dkey, dsubkey, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{dkey, dsubkey, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35020", obj, e);
        }
    }

    public static void registryDeleteKey(String dkey, String dsubkey, String[] nodeList) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Delete reg. key on nodes:" + dkey + ":" + dsubkey + ": " + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd.deleteRegKeyOnNodes(dkey, dsubkey, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{dkey, dsubkey, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35021", obj, e);
        }
    }

    public static void registryDeleteKeyRecursivelyOnNodes(String dkey, String[] nodeList) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Delete reg. key on nodes:" + dkey + ": " + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd.deleteRegRecursiveOnNodes(dkey, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{dkey, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35021", obj, e);
        }
    }

    public static boolean registryKeyExistsOnNodes(String dkey, String[] nodeList) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Checkk reg. key existence on nodes:" + dkey + ": " + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.regKeyExistsOnNodes(dkey, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{dkey, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35079", obj, e);
            return false;
        }
    }

    public static void registrySetValue(String dkey, String dsubkey, String value, String data, String[] nodeList) throws OiipgRemoteOpsException {
        OiipwClusterWindowsOps.registrySetValue(dkey, dsubkey, value, data, false, nodeList);
    }

    public static void registrySetValue(String dkey, String dsubkey, String value, String data, boolean expand, String[] nodeList) throws OiipgRemoteOpsException {
        String key = dkey.concat(s_separator);
        key = key.concat(dsubkey);
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create string reg. value on nodes:" + dkey + ":" + dsubkey + ": " + data + ":" + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd.setRegValueOnNodes(key, value, data, expand, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{key, value, data, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35022", obj, e);
        }
    }

    public static void registrySetValue(String dkey, String dsubkey, String value, Integer data, String[] nodeList) throws OiipgRemoteOpsException {
        String key = dkey.concat(s_separator);
        key = key.concat(dsubkey);
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create integer reg. value on nodes:" + dkey + ":" + dsubkey + ": " + data + ":" + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd.setRegValueOnNodes(key, value, data, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            String sData = data.toString();
            Object[] obj = new Object[]{key, value, sData, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35022", obj, e);
        }
    }

    public static void registrySetValue(String dkey, String dsubkey, String value, String[] data, String[] nodeList) throws OiipgRemoteOpsException {
        String key = dkey.concat(s_separator);
        key = key.concat(dsubkey);
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create stringlist reg. value on nodes:" + dkey + ":" + dsubkey + ": " + OiixFunctionOps.implodeList(data, ",") + ":" + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd.setRegValueOnNodes(key, value, data, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{key, value, data, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35022", obj, e);
        }
    }

    public static void registryDeleteValue(String dkey, String dsubkey, String value, String[] nodeList) throws OiipgRemoteOpsException {
        String key = dkey.concat(s_separator);
        key = key.concat(dsubkey);
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Delete reg. value on nodes:" + dkey + ":" + dsubkey + ":" + OiixFunctionOps.implodeList(nodeList, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd.deleteRegValueOnNodes(key, value, nodeList);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] obj = new Object[]{key, value, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35023", obj, e);
        }
    }

    public static String[] getRegSubKey(String dkey, String node) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***getRegSubKey:" + dkey + ":" + node, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.getRegSubKey(dkey, node);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{dkey, node, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35902", obj, e);
            return null;
        }
    }

    public static String getRegStringDataOnNode(String key, String value, String nodeName) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Get reg. String data on node:" + key + ":" + nodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.getRegStringDataOnNode(key, value, nodeName);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{key, value, nodeName, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35071", obj, e);
            return null;
        }
    }

    public static Integer getRegIntegerDataOnNode(String key, String value, String nodeName) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Get reg. Integer data on node:" + key + ":" + nodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.getRegIntegerDataOnNode(key, value, nodeName);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{key, value, nodeName, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35071", obj, e);
            return null;
        }
    }

    public static String[] getRegStringArrayDataOnNode(String key, String value, String nodeName) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Get reg. string array data on node:" + key + ":" + nodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.getRegStringArrayDataOnNode(key, value, nodeName);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{key, value, nodeName, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35071", obj, e);
            return null;
        }
    }

    public static boolean deleteServiceOnNode(String serviceName, String nodeName) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***delete service on node:" + serviceName + ": " + nodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.deleteServiceOnNode(serviceName, nodeName);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{serviceName, nodeName, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35075", obj, e);
            return false;
        }
    }

    public static boolean stopServiceOnNode(String serviceName, String nodeName) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***stop service on node:" + serviceName + ": " + nodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.stopServiceOnNode(serviceName, nodeName);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{serviceName, nodeName, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35074", obj, e);
            return false;
        }
    }

    public static boolean startServiceOnNode(String serviceName, String nodeName) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***start service on node:" + serviceName + ": " + nodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.startServiceOnNode(serviceName, nodeName);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{serviceName, nodeName, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35073", obj, e);
            return false;
        }
    }

    public static boolean startServiceOnNodes(String serviceName, String[] nodeNames) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***start service on nodes:" + serviceName + ": " + OiixFunctionOps.implodeList(nodeNames, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd = new ClusterWindows();
            return cmd.startServiceOnNodes(serviceName, nodeNames);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeNames, ",");
            Object[] obj = new Object[]{serviceName, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35073", obj, e);
            return false;
        }
    }

    public static boolean stopServiceOnNodes(String serviceName, String[] nodeNames) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***stop service on nodes:" + serviceName + ": " + OiixFunctionOps.implodeList(nodeNames, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd = new ClusterWindows();
            return cmd.stopServiceOnNodes(serviceName, nodeNames);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeNames, ",");
            Object[] obj = new Object[]{serviceName, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35074", obj, e);
            return false;
        }
    }

    public static boolean deleteServiceOnNodes(String serviceName, String[] nodeNames) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***delete service on nodes:" + serviceName + ": " + OiixFunctionOps.implodeList(nodeNames, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd = new ClusterWindows();
            return cmd.deleteServiceOnNodes(serviceName, nodeNames);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeNames, ",");
            Object[] obj = new Object[]{serviceName, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35075", obj, e);
            return false;
        }
    }

    public static boolean createServiceOnNodes(String exeName, String serviceName, int serviceType, String[] nodeNames) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***create service on nodes:" + serviceName + ": " + OiixFunctionOps.implodeList(nodeNames, ","), OiiolTextLogger.LOG_DETAILED);
            }
            cmd = new ClusterWindows();
            return cmd.createServiceOnNodes(serviceName, exeName, serviceType, nodeNames);
        }
        catch (ClusterException e) {
            String sNodeList = OiixFunctionOps.implodeList(nodeNames, ",");
            Object[] obj = new Object[]{exeName, serviceName, sNodeList, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35072", obj, e);
            return false;
        }
    }

    public static boolean createServiceOnNode(String exeName, String serviceName, int serviceType, String nodeName) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***screate service on node:" + serviceName + ": " + nodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.createServiceOnNode(serviceName, exeName, serviceType, nodeName);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{exeName, serviceName, nodeName, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35072", obj, e);
            return false;
        }
    }

    public static void rebootNode(String[] nodeNames, String srcLoc) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***reboot remote nodes:" + nodeNamesStr, OiiolTextLogger.LOG_DETAILED);
            }
            cmd.rebootNode(nodeNames, srcLoc);
        }
        catch (RemoteFileOperationException rfoe) {
            String[] args = new String[]{nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35076", args, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] args = new String[]{nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35076", args, ce);
        }
    }

    public static void registerOCX(String[] nodeNames, String ocxName, String wDir, boolean bFlag, String srcLoc) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***registering ocx on remote nodes:" + ocxName + ": " + wDir + ": " + nodeNamesStr, OiiolTextLogger.LOG_DETAILED);
            }
            cmd.registerOCX(nodeNames, ocxName, wDir, bFlag, srcLoc);
        }
        catch (RemoteFileOperationException rfoe) {
            String[] args = new String[]{nodeNamesStr, ocxName, wDir, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35077", args, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] args = new String[]{nodeNamesStr, ocxName, wDir, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35077", args, ce);
        }
    }

    public static void updateEnv(String[] nodeNames, String srcLoc) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***updating env on remote nodes:" + nodeNamesStr, OiiolTextLogger.LOG_DETAILED);
            }
            cmd.updateEnv(nodeNames, srcLoc);
        }
        catch (RemoteFileOperationException rfoe) {
            String[] args = new String[]{nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35078", args, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] args = new String[]{nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35078", args, ce);
        }
    }

    public static void setPermissions(String[] nodeNames, String path, boolean isAdmin) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***setting Permissions on remote nodes:" + nodeNamesStr + ": " + path + ": " + isAdmin, OiiolTextLogger.LOG_DETAILED);
            }
            cmd.setPermissions(nodeNames, path, isAdmin);
        }
        catch (RemoteFileOperationException rfoe) {
            String[] args = new String[]{nodeNamesStr, path, String.valueOf(isAdmin), rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-25036", args, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] args = new String[]{nodeNamesStr, path, String.valueOf(isAdmin), ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-25036", args, ce);
        }
    }

    public static boolean checkServiceRunningOnNode(String serviceName, String nodeName) throws OiipgRemoteOpsException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***check service running on node:" + serviceName + ": " + nodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return cmd.checkServiceRunningOnNode(serviceName, nodeName);
        }
        catch (ClusterException e) {
            Object[] obj = new Object[]{serviceName, nodeName, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35087", obj, e);
            return false;
        }
    }

    public static void main(String[] args) {
        String[] nodeNames = new String[]{"netf1", "netf2"};
        Integer intVal = Integer.valueOf("100");
        String[] testStrArr = new String[]{"node1", "node2"};
        String testStr = "node1";
        String dkey = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\";
        String value1 = "TEST1";
        String value2 = "TEST2";
        String value3 = "TEST3";
        String newkey = "RACTEST";
        String dsubkey = "ALL_HOMES";
        try {
            OiipwClusterWindowsOps.registryCreateKey(dkey, newkey, nodeNames);
            OiipwClusterWindowsOps.regSetValue(dkey, dsubkey, value1, intVal, nodeNames);
            System.out.println("Set integer");
            OiipwClusterWindowsOps.registrySetValue(dkey, dsubkey, value2, testStrArr, nodeNames);
            System.out.println("Set str array");
            OiipwClusterWindowsOps.registrySetValue(dkey, dsubkey, value3, testStr, nodeNames);
            System.out.println("Set str");
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    static {
        try {
            cmd = new ClusterWindows();
        }
        catch (ClusterException ce) {
            cmd = null;
            Object[] args = new String[]{ce.getMessage()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35018", args));
        }
    }
}

