/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.IOException;
import java.util.Enumeration;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisVariable;

public class OiisCompContextProxy {
    private OiisCompContext m_compContext;
    private OiiiInstallCompInvEntry m_invEntry;

    private OiisCompContextProxy(OiiiInstallCompInvEntry invEntry) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sXMLContextFileLoc = iac.getXMLContextLoc(invEntry.getOHIndex(), invEntry.getLocationInXMLInventory());
        this.m_compContext = OiisCompContext.readXMLContext(sXMLContextFileLoc);
        this.m_invEntry = invEntry;
    }

    public OiisVariable getVariable(String sVarName) {
        return this.m_compContext.getVariable(sVarName);
    }

    public Enumeration getAllVariables() {
        return this.m_compContext.getAllVariables();
    }

    public void save() throws IOException {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        if (iac.getAccessLevel() < 1) {
            throw new IOException("Current access level does not allow writing to the inventory");
        }
        String sXMLContextFileLoc = iac.getXMLContextLoc(this.m_invEntry.getOHIndex(), this.m_invEntry.getLocationInXMLInventory());
        this.m_compContext.writeXMLContext(sXMLContextFileLoc);
    }

    public static OiisCompContextProxy getCompContextProxy(OiiiInstallCompInvEntry invEntry) {
        OiisCompContextProxy contextProxy = new OiisCompContextProxy(invEntry);
        return contextProxy;
    }
}

