/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolConfigLogEntry;
import oracle.sysman.oii.oiis.OiisCompActions;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisIdentifierOps;
import oracle.sysman.oii.oiis.OiisPreRequisiteVar;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisStagedCompRep;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceVariants;

public class OiisCompInstallation
extends OiisStagedCompRep {
    private OiisVariableOwner m_parContext;
    private OiisCompContext m_Cntxt = null;
    private OiisCompActions m_Actions = null;
    private OiisProdHomeVar m_ProdHome = null;
    private OiisPreRequisiteVar m_PreRequisite = null;
    private Vector m_configLogVect;
    private boolean m_bContextInitDone;
    private boolean m_bRecomputePreReq;
    private boolean m_bProdHomeCalcPresent;
    private boolean m_bPreReqCalcPresent;
    private String m_sHelpDir = null;
    private int m_nDiskNumber = -1;
    private OiiiStageCompInvEntry m_oStageCompInvEntry = null;
    private Vector m_vUpgradeLangs = null;

    public OiisCompInstallation(OiisVariableOwner parentContext) {
        this.m_parContext = parentContext;
        this.m_configLogVect = new Vector();
        this.m_bContextInitDone = false;
        this.m_bRecomputePreReq = true;
    }

    public void dispose() {
        super.dispose();
        if (this.m_Cntxt != null) {
            this.m_Cntxt.dispose();
            this.m_Cntxt.disposeVars();
            this.m_Cntxt.disposeWizardElems();
        }
        this.m_oPlatIndMap = null;
        this.m_oLangIndMap = null;
        this.m_oDestIndMap = null;
        this.m_ProdHome = null;
        this.m_PreRequisite = null;
        this.m_Actions = null;
    }

    public void disposeUnusedObjects(int phase) {
        this.disposeUnusedObjects(phase, false);
    }

    public void disposeUnusedObjects(int phase, boolean bLinkPhaseNeeded) {
        boolean bObjectsNeeded = false;
        if (phase == 1) {
            if (!this.isPre22Comp()) {
                if (bLinkPhaseNeeded && this.getContext().getLKPFlowCount() > 0) {
                    bObjectsNeeded = true;
                }
            } else {
                bObjectsNeeded = true;
            }
            this.disposeMinimumObjects(phase);
        }
        if (phase == 1 || phase == 2) {
            if (!this.isPre22Comp()) {
                if (!bObjectsNeeded && this.getContext().getIP2FlowCount() > 0) {
                    bObjectsNeeded = true;
                }
            } else {
                bObjectsNeeded = true;
            }
        }
        if (!bObjectsNeeded && this.isConfigToolsNeeded()) {
            bObjectsNeeded = true;
        }
        if (!bObjectsNeeded) {
            this.disposeMaximumObjects();
        }
    }

    private void disposeMinimumObjects(int phase) {
        this.m_PreRequisite = null;
        this.m_Cntxt.disposeWizardElems();
    }

    void disposeMaximumObjects() {
        super.disposeMaximumObjects();
        this.m_oPlatIndMap = null;
        this.m_oLangIndMap = null;
        this.m_oDestIndMap = null;
        this.m_ProdHome = null;
        this.m_PreRequisite = null;
    }

    private boolean isConfigToolsNeeded() {
        return this.getProperties().getConfigToolCount() > 0;
    }

    public boolean equals(Object other) {
        boolean bRet = false;
        if (other != null) {
            if (other instanceof OiisCompInstallation) {
                bRet = super.equals(other);
            } else if (other instanceof OiiiCompInstallID) {
                OiiiCompInstallID cid = (OiiiCompInstallID)other;
                bRet = this.getCompInstallID().equals(cid);
            }
        }
        return bRet;
    }

    public void setComputePreReq(boolean b) {
        this.m_bRecomputePreReq = b;
    }

    public void setProdHomeCalcPresent(boolean bPresent) {
        this.m_bProdHomeCalcPresent = bPresent;
    }

    public void setPreReqCalcPresent(boolean bPresent) {
        this.m_bPreReqCalcPresent = bPresent;
    }

    public OiisCompContext getContext() {
        if (this.m_Cntxt == null) {
            try {
                this.getContext(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_Cntxt;
    }

    public OiisCompContext loadCompContext(boolean bAllPlats) {
        OiisCompContext compContext = null;
        try {
            compContext = this.getCompJarLoader().loadCompContext(bAllPlats, this.getProperties());
            compContext.init(this.getCompInstallID(), this.getSession());
            this.setContext(compContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return compContext;
    }

    public OiisCompContext loadCompContext() {
        return this.loadCompContext(false);
    }

    public void initContext() throws IOException {
        try {
            if (this.m_Cntxt == null) {
                OiisCompContext compContext = this.getCompJarLoader().loadCompContext(false, this.getProperties());
                this.setContext(compContext);
                this.m_Cntxt.init(this.getCompInstallID(), this.getSession());
            } else {
                this.m_ProdHome = null;
            }
            OiisProdHomeVar oProdHome = this.calculateProdHome();
            if (oProdHome == null) {
                oProdHome = new OiisProdHomeVar();
            }
            oProdHome.setOwner(this.m_Cntxt);
            this.setProdHome(oProdHome);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public OiisCompContext getContext(boolean bThrow) throws OiifbCancelException {
        try {
            OiisPreRequisiteVar oVar;
            if (this.m_Cntxt == null) {
                this.initContext();
            }
            if ((oVar = this.getPreRequisite()) != null) {
                oVar.setOwner(this.m_Cntxt);
                this.m_Cntxt.setPreRequisite(oVar);
            }
        }
        catch (Exception e) {
            if (e instanceof OiifbCancelException) {
                throw (OiifbCancelException)e;
            }
            e.printStackTrace();
        }
        return this.m_Cntxt;
    }

    public OiisCompActions getActions() {
        if (this.m_Actions == null) {
            try {
                OiisCompActions compActions = this.getCompJarLoader().loadCompActions(this.getCompJarInfo());
                compActions.init(this.getSession(), this);
                this.setActions(compActions);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_Actions;
    }

    public String getHelpDir() {
        if (this.m_sHelpDir != null) {
            return this.m_sHelpDir;
        }
        String helpDir = null;
        boolean bPre20Comp = this.isPre20Comp();
        if (bPre20Comp) {
            helpDir = ".";
        } else {
            OiisCompJarInfo compJarInfo = this.getProperties().getCompJarInfo();
            helpDir = compJarInfo.getHelpDir();
            OiixJarClassLoader helpJarClassLoader = this.getHelpJarClassLoader();
            Enumeration resourceVariants = OiixResourceVariants.genResourceVariants();
            while (resourceVariants.hasMoreElements()) {
                String currentVariant = (String)resourceVariants.nextElement();
                String dir = helpDir;
                if (currentVariant != null && currentVariant.length() != 0) {
                    if (currentVariant.startsWith("_")) {
                        currentVariant = currentVariant.substring(1);
                    }
                    dir = dir + currentVariant + "/";
                }
                if (!helpJarClassLoader.directoryExists(dir)) continue;
                helpDir = dir;
                break;
            }
            helpDir = OiixPathOps.getStandardForm(helpDir);
            helpDir = OiixPathOps.directorify(helpDir);
        }
        this.m_sHelpDir = helpDir;
        return this.m_sHelpDir;
    }

    public OiixJarClassLoader getHelpJarClassLoader() {
        OiixJarClassLoader helpJarClassLoader = null;
        boolean bPre20Comp = this.isPre20Comp();
        if (bPre20Comp) {
            try {
                String helpLoc = this.getCompJarLoader().getHelpJarLoc();
                helpJarClassLoader = OiixJarClassLoader.createLoader(helpLoc, true);
            }
            catch (IOException iOException) {}
        } else {
            helpJarClassLoader = this.getCompJarLoader().getJarClassLoader();
        }
        return helpJarClassLoader;
    }

    public OiisProdHomeVar getProdHome() {
        if (this.m_ProdHome == null) {
            OiisProdHomeVar prodHome = null;
            try {
                prodHome = this.calculateProdHome();
            }
            catch (OiifbCancelException fb) {
                prodHome = new OiisProdHomeVar();
            }
            this.setProdHome(prodHome);
        }
        return this.m_ProdHome;
    }

    public OiisProdHomeVar calculateProdHome() throws OiifbCancelException {
        if (this.m_ProdHome == null) {
            OiiiCompInstallID cid = this.getCompInstallID();
            OiisProdHomeVar prodHome = null;
            if (!this.isPre22Comp()) {
                prodHome = new OiisProdHomeVar();
                prodHome.setCalcMethodPresent(this.m_bProdHomeCalcPresent);
                prodHome.setValidationMethodPresent(true);
            } else {
                try {
                    if (this.getProperties().isNoProdHomeAvailable()) {
                        throw new ClassNotFoundException();
                    }
                    prodHome = this.getCompJarLoader().loadProdHome(this.getCompJarInfo());
                }
                catch (Exception e) {
                    prodHome = new OiisProdHomeVar();
                }
            }
            if (this.m_Cntxt == null) {
                prodHome.init((OiisVariableOwner)((OiicSessionContext)this.m_parContext), cid, this.getSession());
            } else {
                prodHome.init((OiisVariableOwner)this.m_Cntxt, cid, this.getSession());
                prodHome.setOwner(this.m_Cntxt);
            }
            prodHome.computeVarValue(cid);
            this.setProdHome(prodHome);
        }
        return this.m_ProdHome;
    }

    public OiisPreRequisiteVar getPreRequisite() {
        OiiiCompInstallID cid = this.getCompInstallID();
        if (this.m_PreRequisite == null) {
            OiisPreRequisiteVar preReq;
            if (!this.isPre22Comp()) {
                preReq = new OiisPreRequisiteVar();
                preReq.setCalcMethodPresent(this.m_bPreReqCalcPresent);
                preReq.setValidationMethodPresent(false);
                this.m_Cntxt.setPreRequisite(preReq);
            } else {
                try {
                    if (this.getProperties().isNoPreReqAvailable()) {
                        throw new ClassNotFoundException();
                    }
                    preReq = this.getCompJarLoader().loadPreRequisite(this.getCompJarInfo());
                }
                catch (Exception e) {
                    preReq = new OiisPreRequisiteVar();
                }
            }
            if (this.m_Cntxt == null) {
                preReq.init((OiisVariableOwner)((OiicSessionContext)this.m_parContext), cid, this.getSession());
            } else {
                preReq.init((OiisVariableOwner)this.m_Cntxt, cid, this.getSession());
                preReq.setOwner(this.m_Cntxt);
            }
            this.setPreRequisite(preReq);
        }
        if (this.m_bRecomputePreReq) {
            try {
                this.m_PreRequisite.setVariable(cid);
                this.setComputePreReq(false);
            }
            catch (OiisVarSettingException vse) {
                vse.printStackTrace();
                try {
                    this.m_PreRequisite.setValue(Boolean.TRUE, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (OiifbCancelException ce) {
                ce.printStackTrace();
            }
            catch (OiifbEndIterateException e) {
                e.printStackTrace();
            }
        }
        return this.m_PreRequisite;
    }

    public void setContext(OiisCompContext compContext) {
        this.m_Cntxt = compContext;
        this.m_Cntxt.setParContext(this.m_parContext);
        this.m_fileSizeInfo.setCompContext(compContext);
    }

    public void setParentContext(OiisVariableOwner parentContext) {
        this.m_parContext = parentContext;
        if (this.m_Cntxt != null) {
            this.m_Cntxt.setParContext(this.m_parContext);
        }
    }

    public void setActions(OiisCompActions actions) {
        this.m_Actions = actions;
    }

    public void setProdHome(OiisProdHomeVar oVar) {
        this.m_ProdHome = oVar;
        if (this.m_Cntxt != null) {
            this.m_Cntxt.setProdHome(this.m_ProdHome);
        }
    }

    public void setPreRequisite(OiisPreRequisiteVar oVar) {
        this.m_PreRequisite = oVar;
    }

    public void addConfigLogEntry(OiiolConfigLogEntry cle) {
        this.m_configLogVect.addElement(cle);
    }

    public Vector returnConfigLogEntries() {
        return this.m_configLogVect;
    }

    public String instantiate(String s) {
        if (s.lastIndexOf(37) != -1) {
            s = OiisIdentifierOps.instantiateString(s, this.m_Cntxt);
        }
        return s;
    }

    public void setDiskNumber(int nDiskNumber) {
        this.m_nDiskNumber = nDiskNumber;
    }

    public int getDiskNumber() {
        return this.m_nDiskNumber;
    }

    public void setStageCompInvEntry(OiiiStageCompInvEntry scie) {
        this.m_oStageCompInvEntry = scie;
    }

    public OiiiStageCompInvEntry getStageCompInvEntry() {
        return this.m_oStageCompInvEntry;
    }

    public void setUpgradeLangs(Vector vLangs) {
        this.m_vUpgradeLangs = vLangs;
    }

    public Vector getUpgradeLangs() {
        return this.m_vUpgradeLangs;
    }
}

