/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiii.OiiiObjectInputStream;
import oracle.sysman.oii.oiis.OiisCompActions;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisCompStaging;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oii.oiis.OiisFileMapXMLReader;
import oracle.sysman.oii.oiis.OiisIdentifiersXMLReader;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.sysman.oii.oiis.OiisPreRequisiteVar;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceVariants;

public final class OiisCompJarLoader {
    private OiixJarClassLoader m_classLoader;
    private OiisCompJarInfo m_compJarInfo;
    private String m_jarLoc;
    private String m_resJarLoc;
    private OiixJarResourceBundle m_jarResrcBndl = null;
    private String m_helpJarLoc;
    private ResourceBundle m_IDBundle;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;

    public OiisCompJarLoader(String jarLoc) throws IOException {
        this(jarLoc, false);
    }

    public OiisCompJarLoader(String jarLoc, boolean bKeepJarOpen) throws IOException {
        try {
            this.m_jarLoc = jarLoc;
            this.m_jarLoc = this.m_jarLoc.replace('\\', '/');
            this.m_jarLoc = this.m_jarLoc.replace('/', File.separatorChar);
            this.m_classLoader = OiixJarClassLoader.createLoader(this.m_jarLoc, true, bKeepJarOpen);
            this.m_resJarLoc = null;
            this.m_helpJarLoc = null;
            this.m_compJarInfo = null;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    public OiixJarClassLoader getJarClassLoader() {
        return this.m_classLoader;
    }

    public void setCompJarInfo(OiisCompJarInfo compJarInfo) {
        this.m_compJarInfo = compJarInfo;
    }

    public OiisCompJarInfo getCompJarInfo() throws IOException {
        try {
            if (this.m_compJarInfo == null) {
                OiisCompJarInfo compJarInfo = new OiisCompJarInfo();
                InputStream is = this.m_classLoader.getLocalResourceAsStream("properties.ci");
                compJarInfo.load(is);
                this.setCompJarInfo(compJarInfo);
            }
            return this.m_compJarInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    private ResourceBundle loadIDBundle() {
        String resourceBase = "resources/CompID";
        PropertyResourceBundle rb = null;
        boolean foundResource = false;
        try {
            Enumeration vars = OiixResourceVariants.genResourceVariants();
            while (vars.hasMoreElements()) {
                String resLoc = resourceBase + (String)vars.nextElement() + ".properties";
                InputStream is = this.m_classLoader.getLocalResourceAsStream(resLoc);
                if (is != null) {
                    try {
                        rb = new PropertyResourceBundle(is);
                        is.close();
                    }
                    catch (IOException ioe) {
                        rb = null;
                        continue;
                    }
                    foundResource = true;
                }
                if (!foundResource) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rb;
    }

    public String getName() {
        if (this.m_IDBundle == null) {
            this.loadIDBundle();
        }
        return this.m_IDBundle.getString("Name");
    }

    public String getDescription() {
        return this.m_IDBundle.getString("Description");
    }

    public ResourceBundle loadIDBundle(Locale loc) {
        String resourceBase = "resources/CompID";
        PropertyResourceBundle rb = null;
        String resLoc = resourceBase + loc.toString() + ".properties";
        InputStream is = this.m_classLoader.getLocalResourceAsStream(resLoc);
        if (is != null) {
            try {
                rb = new PropertyResourceBundle(is);
                is.close();
            }
            catch (IOException ioe) {
                rb = null;
            }
        }
        return rb;
    }

    public void loadCompInstallation(OiisCompInstallation ci) throws OiisCompLoadingException {
        try {
            ci.setJarLoc(this.m_jarLoc);
            OiisCompProperties compProps = this.loadCompProperties();
            ci.setProperties(compProps);
            OiisDepInfo compDeps = this.loadCompDeps();
            ci.setDeps(compDeps);
            OiisFileMap filemap = this.loadFileMap();
            filemap.setPlatIndexMapping(ci.getPlatIndexMapping());
            filemap.setLangIndexMapping(ci.getLangIndexMapping());
            filemap.setDestIndexMapping(ci.getDestIndexMapping());
            ci.setFileMap(filemap);
            OiisCompContext compCntxt = this.loadCompContext();
            ci.setContext(compCntxt);
            compCntxt.setCompInsJarLoc(this.m_jarLoc);
            OiisCompActions compActions = this.loadCompActions();
            ci.setActions(compActions);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OiisCompLoadingException(e.toString());
        }
    }

    public void loadCompInstallation(OiisCompInstallation ci, String resJarLoc) throws OiisCompLoadingException {
        try {
            ci.setJarLoc(this.m_jarLoc);
            this.initResHelpLocs(resJarLoc, null);
            OiisCompProperties compProps = this.loadCompProperties();
            ci.setProperties(compProps);
            OiisDepInfo compDeps = this.loadCompDeps();
            ci.setDeps(compDeps);
            OiisFileMap filemap = this.loadFileMap();
            filemap.setPlatIndexMapping(ci.getPlatIndexMapping());
            filemap.setLangIndexMapping(ci.getLangIndexMapping());
            filemap.setDestIndexMapping(ci.getDestIndexMapping());
            ci.setFileMap(filemap);
            OiisCompContext compCntxt = this.loadCompContext();
            ci.setContext(compCntxt);
            compCntxt.setCompInsJarLoc(this.m_jarLoc);
            OiisCompActions compActions = this.loadCompActions();
            ci.setActions(compActions);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OiisCompLoadingException(e.toString());
        }
        try {
            OiisProdHomeVar prodHome = this.loadProdHome();
            ci.setProdHome(prodHome);
        }
        catch (Exception e) {
            ci.setProdHome(new OiisProdHomeVar());
        }
        try {
            OiisPreRequisiteVar preReq = this.loadPreRequisite();
            ci.setPreRequisite(preReq);
        }
        catch (Exception e) {
            ci.setPreRequisite(null);
        }
    }

    public void loadCompInstallation(OiisCompInstallation ci, String resJarLoc, String helpJarLoc) throws OiisCompLoadingException {
        try {
            ci.setJarLoc(this.m_jarLoc);
            this.initResHelpLocs(resJarLoc, helpJarLoc);
            OiisCompProperties compProps = this.loadCompProperties();
            ci.setProperties(compProps);
            OiisDepInfo compDeps = this.loadCompDeps();
            ci.setDeps(compDeps);
            OiisFileMap filemap = this.loadFileMap();
            filemap.setPlatIndexMapping(ci.getPlatIndexMapping());
            filemap.setLangIndexMapping(ci.getLangIndexMapping());
            filemap.setDestIndexMapping(ci.getDestIndexMapping());
            ci.setFileMap(filemap);
            OiisCompContext compCntxt = this.loadCompContext();
            ci.setContext(compCntxt);
            compCntxt.setCompInsJarLoc(this.m_jarLoc);
            OiisCompActions compActions = this.loadCompActions();
            ci.setActions(compActions);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OiisCompLoadingException(e.toString());
        }
        try {
            OiisProdHomeVar prodHome = this.loadProdHome();
            ci.setProdHome(prodHome);
        }
        catch (Exception e) {
            ci.setProdHome(new OiisProdHomeVar());
        }
        try {
            OiisPreRequisiteVar preReq = this.loadPreRequisite();
            ci.setPreRequisite(preReq);
        }
        catch (Exception e) {
            ci.setPreRequisite(null);
        }
    }

    public void initResHelpLocs(String resJarLoc, String helpJarLoc) {
        this.m_resJarLoc = resJarLoc;
        this.m_helpJarLoc = helpJarLoc;
    }

    public void loadCompStaging(OiisCompStaging cs) throws OiisCompLoadingException {
        try {
            OiisCompProperties compProps = this.loadCompProperties();
            cs.setProperties(compProps);
            OiisDepInfo compDeps = this.loadCompDeps();
            cs.setDeps(compDeps);
            OiisFileMap filemap = this.loadFileMap();
            cs.setFileMap(filemap);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OiisCompLoadingException(e.toString());
        }
    }

    public OiisCompProperties loadCompProperties() throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        String propObjName = this.getCompJarInfo().getPropObj();
        InputStream is = this.m_classLoader.getLocalResourceAsStream(propObjName);
        OiiiObjectInputStream ois = new OiiiObjectInputStream(is);
        OiisCompProperties retProp = (OiisCompProperties)ois.readObject();
        is.close();
        retProp.setResBundle(this.loadCompResources());
        retProp.convertLibDepsVector();
        return retProp;
    }

    public OiisDepInfo loadCompDeps() throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        String depsObjName = this.getCompJarInfo().getDepObj();
        InputStream is = this.m_classLoader.getLocalResourceAsStream(depsObjName);
        ObjectInputStream ois = new ObjectInputStream(is);
        OiisDeps deps = (OiisDeps)ois.readObject();
        OiisDepInfo retDeps = new OiisDepInfo(deps);
        is.close();
        return retDeps;
    }

    public OiisFileMap loadFileMap() throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        OiisCompJarInfo compJarInfo = this.getCompJarInfo();
        OiisFileMap retMap = this.loadFileMap(compJarInfo);
        return retMap;
    }

    public OiisFileMap loadFileMap(OiisCompJarInfo compJarInfo) throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        String filesObjName = compJarInfo.getFileMapObj();
        OiisFileMap retMap = null;
        if (filesObjName.endsWith(".xml")) {
            InputStream is = (InputStream)OiixJarClassLoader.getLocalResource(this.m_jarLoc, filesObjName);
            OiisFileMapXMLReader reader = OiisFileMapXMLReader.getReader();
            retMap = reader.readFileMapXML(is);
            is.close();
        } else {
            InputStream is = this.m_classLoader.getLocalResourceAsStream(filesObjName);
            ObjectInputStream ois = new ObjectInputStream(is);
            retMap = (OiisFileMap)ois.readObject();
            is.close();
        }
        retMap.setFileMapPath(OiixPathOps.getParentDir(filesObjName));
        retMap.setClassLoader(this.m_classLoader);
        return retMap;
    }

    public OiisCompContext loadCompContext() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this.loadCompContext(false);
    }

    public OiisCompContext loadCompContext(boolean bLoadAllConst) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        OiisCompJarInfo compJarInfo = this.m_compJarInfo;
        OiixJarResourceBundle jrb = this.loadCompResources();
        OiisCompContext retContext = this.loadCompContext(bLoadAllConst, compJarInfo, jrb);
        return retContext;
    }

    public OiisCompContext loadCompContext(boolean bLoadAllConst, OiisCompProperties compProps) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        OiisCompJarInfo compJarInfo = compProps.getCompJarInfo();
        OiixJarResourceBundle jrb = compProps.getResBundle();
        return this.loadCompContext(bLoadAllConst, compJarInfo, jrb);
    }

    private OiisCompContext loadCompContext(boolean bLoadAllConst, OiisCompJarInfo compJarInfo, OiixJarResourceBundle jrb) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String contextClassName = compJarInfo.getContextClass();
        Class cls = this.m_classLoader.loadClass(contextClassName);
        OiisCompContext retContext = (OiisCompContext)cls.newInstance();
        retContext.setResourceBundle(jrb);
        String sIdentifiersXMLName = compJarInfo.getIdentifiersXML();
        if (sIdentifiersXMLName != null) {
            InputStream iFile = (InputStream)OiixJarClassLoader.getLocalResource(this.m_jarLoc, sIdentifiersXMLName);
            OiisIdentifiersXMLReader.loadIdentifiers(sIdentifiersXMLName, iFile, retContext, jrb, bLoadAllConst);
            try {
                iFile.close();
            }
            catch (IOException e) {}
        } else if (compJarInfo.getConstantsClass() != null) {
            try {
                retContext.setConstants(this.loadCompConstants(bLoadAllConst, compJarInfo, jrb));
            }
            catch (Exception cnf) {
                // empty catch block
            }
        }
        return retContext;
    }

    public OiisProdHomeVar loadProdHome() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        OiisCompJarInfo compJarInfo = this.m_compJarInfo;
        OiisProdHomeVar prodHome = this.loadProdHome(compJarInfo);
        return prodHome;
    }

    public OiisProdHomeVar loadProdHome(OiisCompJarInfo compJarInfo) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String prodhomeClassName = compJarInfo.getProdHomeClass();
        Class cls = this.m_classLoader.loadClass(prodhomeClassName);
        OiisProdHomeVar prodHome = (OiisProdHomeVar)cls.newInstance();
        return prodHome;
    }

    public OiisPreRequisiteVar loadPreRequisite() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        OiisCompJarInfo compJarInfo = this.m_compJarInfo;
        OiisPreRequisiteVar preReq = this.loadPreRequisite(compJarInfo);
        return preReq;
    }

    public OiisPreRequisiteVar loadPreRequisite(OiisCompJarInfo compJarInfo) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String preReqClassName = compJarInfo.getPreRequisiteClass();
        Class cls = this.m_classLoader.loadClass(preReqClassName);
        OiisPreRequisiteVar preReq = (OiisPreRequisiteVar)cls.newInstance();
        return preReq;
    }

    public OiisCompActions loadCompActions() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        OiisCompJarInfo compJarInfo = this.m_compJarInfo;
        OiisCompActions retActions = this.loadCompActions(compJarInfo);
        return retActions;
    }

    public OiisCompActions loadCompActions(OiisCompJarInfo compJarInfo) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        OiisCompActions retActions;
        String actionsClassName = compJarInfo.getActionsClass();
        if (actionsClassName.equals("oracle.sysman.oii.oiis.OiisCompActions")) {
            retActions = new OiisCompActions();
        } else {
            try {
                Class cls = this.m_classLoader.loadClass(actionsClassName);
                retActions = (OiisCompActions)cls.newInstance();
            }
            catch (ClassNotFoundException e) {
                retActions = new OiisCompActions();
            }
        }
        return retActions;
    }

    public OiisPostInstallTool loadConfigTool(String toolClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class cls = this.m_classLoader.loadClass(toolClassName);
        OiisPostInstallTool retTool = (OiisPostInstallTool)cls.newInstance();
        return retTool;
    }

    public OiisPatchDeps loadPatchDeps() throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        String patchDepsObjName = this.m_compJarInfo.getPatchDepsObj();
        InputStream is = this.m_classLoader.getLocalResourceAsStream(patchDepsObjName);
        ObjectInputStream ois = new ObjectInputStream(is);
        OiisPatchDeps patchDeps = (OiisPatchDeps)ois.readObject();
        is.close();
        return patchDeps;
    }

    public OiisPatchSetContents loadPSetContents() throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        return this.loadPSetContents(this.getCompJarInfo());
    }

    public OiisPatchSetContents loadPSetContents(OiisCompJarInfo compJarInfo) throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        String pSetContsObjName = compJarInfo.getPatchSetContents();
        if (pSetContsObjName == null) {
            return null;
        }
        InputStream is = this.m_classLoader.getLocalResourceAsStream(pSetContsObjName);
        OiiiObjectInputStream ois = new OiiiObjectInputStream(is);
        OiisPatchSetContents retConts = (OiisPatchSetContents)ois.readObject();
        is.close();
        return retConts;
    }

    public OiisCompConstants loadCompConstants(boolean bLoadAll) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        OiisCompJarInfo compJarInfo = this.m_compJarInfo;
        OiixJarResourceBundle jrb = this.loadCompResources();
        OiisCompConstants retConst = this.loadCompConstants(bLoadAll, compJarInfo, jrb);
        return retConst;
    }

    private OiisCompConstants loadCompConstants(boolean bLoadAll, OiisCompJarInfo compJarInfo, OiixJarResourceBundle jrb) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String constClassName = compJarInfo.getConstantsClass();
        Class cls = this.m_classLoader.loadClass(constClassName);
        OiisCompConstants retConst = (OiisCompConstants)cls.newInstance();
        retConst.setResourceBundle(jrb);
        retConst.initConstants(bLoadAll);
        return retConst;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage : java oracle.sysman.oii.oiis.OiisCompJarLoader <Comp Install Jar Loc>");
        } else {
            try {
                String jarLoc = args[0];
                OiisCompJarLoader jl = new OiisCompJarLoader(jarLoc);
                OiisCompInstallation ci = new OiisCompInstallation(null);
                jl.loadCompInstallation(ci);
                ci.getActions().stateChangeActions();
                OiisFileMap fm = ci.getFileMap();
                System.err.println("CI's File Groups :");
                Enumeration enum_1 = fm.getFileGroupNames();
                while (enum_1.hasMoreElements()) {
                    System.err.println((String)enum_1.nextElement());
                }
                System.err.println("CI's Language File Groups :");
                enum_1 = fm.getLangFileGroupNames();
                while (enum_1.hasMoreElements()) {
                    System.err.println((String)enum_1.nextElement());
                }
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " occurred during test");
                e.printStackTrace();
            }
        }
    }

    public String getJarLoc() {
        return this.m_jarLoc;
    }

    public String getHelpJarLoc() {
        return this.m_helpJarLoc;
    }

    public String getCompResString(String sID) {
        try {
            return this.loadCompResources().getString(sID);
        }
        catch (MissingResourceException e) {
            return sID;
        }
    }

    public void setResourceBundle(ResourceBundle rb) {
        System.out.println("Resource bundle set for this component");
        this.m_jarResrcBndl = new OiixJarResourceBundle(rb);
    }

    public OiixJarResourceBundle loadCompResources() {
        ResourceBundle externalBundle = null;
        if (this.m_jarResrcBndl == null) {
            this.m_jarResrcBndl = new OiixJarResourceBundle();
            try {
                File resFile;
                if (this.m_resJarLoc == null) {
                    this.m_jarLoc = this.m_jarLoc.replace('\\', '/');
                    int dirPos = this.m_jarLoc.lastIndexOf(47);
                    String dir = this.m_jarLoc.substring(0, dirPos);
                    this.m_resJarLoc = dir + "/resources/CompRes.jar";
                }
                if (this.m_resJarLoc != null && (resFile = new File(this.m_resJarLoc)).exists()) {
                    externalBundle = OiixJarResourceBundle.extractCompResBundle(this.m_resJarLoc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (externalBundle != null) {
                try {
                    OiixJarResourceBundle rb;
                    OiixJarResourceBundle extBundle = new OiixJarResourceBundle();
                    extBundle.addResourceBundle(externalBundle);
                    this.m_jarResrcBndl = rb = OiixJarResourceBundle.setInternalCompResBundle(this.m_classLoader, externalBundle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.m_jarResrcBndl;
    }

    void fetchFastCopyLog(OiisCompJarInfo compJarInfo, String sTargetLocation) {
        String sLocation = compJarInfo.getFastCopyLogXML();
        if (sLocation != null) {
            try {
                InputStream iFile = (InputStream)OiixJarClassLoader.getLocalResource(this.m_jarLoc, sLocation);
                InputStreamReader isr = new InputStreamReader(iFile);
                BufferedReader br = new BufferedReader(isr);
                FileOutputStream fos = new FileOutputStream(sTargetLocation);
                PrintWriter pw = new PrintWriter(fos);
                String sText = null;
                while ((sText = br.readLine()) != null) {
                    pw.println(sText);
                }
                pw.close();
                fos.close();
                br.close();
                isr.close();
                iFile.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

