/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIDCreator;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiConfigToolID;
import oracle.sysman.oii.oiii.OiiiLibType;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiReadmeID;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisLibDeps;
import oracle.sysman.oii.oiis.OiisReadmeDetails;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiisCompProperties
implements Serializable,
Cloneable,
OiivVerIndMergeCapable {
    static final long serialVersionUID = 2266961441150486794L;
    private OiiiCompInstallID m_cID;
    private Vector m_languages;
    private Vector m_supLangs;
    private Locale m_defLang = null;
    private transient OiixJarResourceBundle m_resBundle;
    private String m_location;
    private Vector[] m_libDeps;
    private boolean m_bNoProdHome = false;
    private boolean m_bNoPreReq = false;
    private Vector m_configToolDetails = new Vector();
    private Vector m_configToolsToSuppress = new Vector();
    private Vector m_readmeDetails = new Vector();
    private Vector m_readmesToSuppress = new Vector();
    private String m_bookName;
    private transient boolean m_storedInInv = false;
    private OiisCompJarInfo m_compJarInfo;
    public static final int INTERVIEW_PHASE = 1;
    public static final int INSTALL_PHASE_1 = 2;
    public static final int INSTALL_PHASE_2 = 4;
    public static final int LINK_PHASE = 8;
    public static final int PRE_REQ_CALC = 16;
    public static final int PROD_HOME_CALC = 32;
    public static final int VAR_CALC = 64;
    public static final int VAR_VALIDATION = 96;
    public static final int ALL_PHASES = 255;
    public static final int NONE_PHASES = 0;
    private static final String CID = "cid";
    private static final String CIDMOREINFO = "cidMoreInfo";
    private static final String SUPLANGVECT = "supLangVect";
    private static final String COMPJARINFO = "compJarInfo";
    private static final String DEFLOCALE = "defLocale";
    private static final String LOCATION = "location";
    private static final String NOPRODHOME = "noProdHome";
    private static final String NOPREREQ = "noPreReq";
    private static final String LIBDEPS = "libDeps";
    private static final String CONFIGTOOLDETAILS = "configToolDetails";
    private static final String CONFIGTOOLSTOSUPPRESS = "configToolsToSuppress";
    private static final String READMEDETAILS = "readmeDetails";
    private static final String READMESTOSUPPRESS = "readmesToSuppress";
    private static final String BOOKNAME = "bookName";

    public OiisCompProperties(OiiiCompInstallID id) {
        this.m_cID = id;
        this.init();
    }

    private void init() {
        this.m_languages = new Vector();
        this.m_supLangs = new Vector();
        this.m_resBundle = null;
        this.m_location = null;
        this.m_libDeps = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            this.m_libDeps[i] = new Vector();
        }
        this.m_compJarInfo = null;
    }

    public OiisCompProperties(OiivVerIndObjectRep viObj) {
        Object bookName;
        Vector[] verIndLibDeps;
        this.m_storedInInv = true;
        this.init();
        this.m_cID = OiiiCompIDCreator.getInstallID(viObj, CID, CIDMOREINFO);
        this.m_supLangs = (Vector)viObj.getObjectForName(SUPLANGVECT);
        Properties oClassProps = (Properties)viObj.getObjectForName(COMPJARINFO);
        this.m_compJarInfo = oClassProps != null ? new OiisCompJarInfo(oClassProps) : new OiisCompJarInfo();
        this.m_defLang = (Locale)viObj.getObjectForName(DEFLOCALE);
        this.m_location = (String)viObj.getObjectForName(LOCATION);
        this.m_bNoProdHome = (Boolean)viObj.getObjectForName(NOPRODHOME);
        this.m_bNoPreReq = (Boolean)viObj.getObjectForName(NOPREREQ);
        Vector verIndDeps = (Vector)viObj.getObjectForName(CONFIGTOOLDETAILS);
        if (verIndDeps != null) {
            this.m_configToolDetails = OiivVerIndObjectRep.getVerDepFormOfVect(verIndDeps);
        }
        if ((verIndDeps = (Vector)viObj.getObjectForName(CONFIGTOOLSTOSUPPRESS)) != null) {
            this.m_configToolsToSuppress = OiivVerIndObjectRep.getVerDepFormOfVect(verIndDeps);
        }
        if ((verIndDeps = (Vector)viObj.getObjectForName(READMEDETAILS)) != null) {
            this.m_readmeDetails = OiivVerIndObjectRep.getVerDepFormOfVect(verIndDeps);
        }
        if ((verIndDeps = (Vector)viObj.getObjectForName(READMESTOSUPPRESS)) != null) {
            this.m_readmesToSuppress = OiivVerIndObjectRep.getVerDepFormOfVect(verIndDeps);
        }
        if ((verIndLibDeps = (Vector[])viObj.getObjectForName(LIBDEPS)) != null) {
            this.m_libDeps = new Vector[verIndLibDeps.length];
            for (int i = 0; i < verIndLibDeps.length; ++i) {
                this.m_libDeps[i] = OiivVerIndObjectRep.getVerDepFormOfVect(verIndLibDeps[i]);
            }
        }
        if ((bookName = viObj.getObjectForName(BOOKNAME)) != null) {
            this.m_bookName = (String)bookName;
        }
    }

    public OiivVerIndObjectRep getVerIndRep() {
        Vector verIndDeps;
        OiivVerIndObjectRep retRep = null;
        retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        if (this.m_cID != null) {
            retRep.addNVPair(CID, this.m_cID.getIDAsCompID());
            Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_cID.getAdditionalInfo());
            retRep.addNVPair(CIDMOREINFO, additionalInfo);
        }
        if (this.m_supLangs != null) {
            retRep.addNVPair(SUPLANGVECT, this.m_supLangs);
        }
        if (this.m_compJarInfo != null) {
            Properties oClassProps = this.m_compJarInfo.getProperties();
            retRep.addNVPair(COMPJARINFO, oClassProps);
        }
        if (this.m_defLang != null) {
            retRep.addNVPair(DEFLOCALE, this.m_defLang);
        }
        if (this.m_location != null) {
            retRep.addNVPair(LOCATION, this.m_location);
        }
        retRep.addNVPair(NOPRODHOME, OiixUtilityOps.booleanValueOf(this.m_bNoProdHome));
        retRep.addNVPair(NOPREREQ, OiixUtilityOps.booleanValueOf(this.m_bNoPreReq));
        if (this.m_configToolDetails != null) {
            verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_configToolDetails);
            retRep.addNVPair(CONFIGTOOLDETAILS, verIndDeps);
        }
        if (this.m_configToolsToSuppress != null) {
            verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_configToolsToSuppress);
            retRep.addNVPair(CONFIGTOOLSTOSUPPRESS, verIndDeps);
        }
        if (this.m_readmeDetails != null) {
            verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_readmeDetails);
            retRep.addNVPair(READMEDETAILS, verIndDeps);
        }
        if (this.m_readmesToSuppress != null) {
            verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_readmesToSuppress);
            retRep.addNVPair(READMESTOSUPPRESS, verIndDeps);
        }
        if (this.m_libDeps != null) {
            Vector[] verIndLibDeps = new Vector[this.m_libDeps.length];
            for (int i = 0; i < this.m_libDeps.length; ++i) {
                verIndLibDeps[i] = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_libDeps[i]);
            }
            retRep.addNVPair(LIBDEPS, verIndLibDeps);
        }
        if (this.m_bookName != null) {
            retRep.addNVPair(BOOKNAME, this.m_bookName);
        }
        return retRep;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals(CID)) {
            return this.m_cID == null ? value == null : this.m_cID.equals(value);
        }
        if (key.equals(SUPLANGVECT)) {
            return this.m_supLangs == null ? value == null : this.m_supLangs.equals(value);
        }
        if (key.equals(COMPJARINFO)) {
            return this.m_compJarInfo == null ? value == null : this.m_compJarInfo.equals(value);
        }
        if (key.equals(DEFLOCALE)) {
            return this.m_defLang == null ? value == null : this.m_defLang.equals(value);
        }
        if (key.equals(LOCATION)) {
            return this.m_location == null ? value == null : this.m_location.equals(value);
        }
        if (key.equals(NOPRODHOME)) {
            return this.m_bNoProdHome == (Boolean)value;
        }
        if (key.equals(NOPREREQ)) {
            return this.m_bNoPreReq == (Boolean)value;
        }
        if (key.equals(LIBDEPS)) {
            return this.m_libDeps == null ? value == null : this.m_libDeps.equals(value);
        }
        if (key.equals(CONFIGTOOLDETAILS)) {
            return this.m_configToolDetails == null ? value == null : this.m_configToolDetails.equals(value);
        }
        if (key.equals(CONFIGTOOLSTOSUPPRESS)) {
            return this.m_configToolsToSuppress == null ? value == null : this.m_configToolsToSuppress.equals(value);
        }
        if (key.equals(READMEDETAILS)) {
            return this.m_readmeDetails == null ? value == null : this.m_readmeDetails.equals(value);
        }
        if (key.equals(READMESTOSUPPRESS)) {
            return this.m_readmesToSuppress == null ? value == null : this.m_readmesToSuppress.equals(value);
        }
        if (key.equals(BOOKNAME)) {
            return this.m_bookName == null ? value == null : this.m_bookName.equals(value);
        }
        return false;
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep retRep = vIndObj;
        if (this.m_cID != null) {
            retRep.setNVPair(CID, this.m_cID.getIDAsCompID());
            Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_cID.getAdditionalInfo());
            retRep.setNVPair(CIDMOREINFO, additionalInfo);
        }
        retRep.setNVPair(SUPLANGVECT, this.m_supLangs);
        Object oClassProps = null;
        if (this.m_compJarInfo != null) {
            this.m_compJarInfo.getProperties();
        }
        retRep.setNVPair(COMPJARINFO, oClassProps);
        retRep.setNVPair(DEFLOCALE, this.m_defLang);
        retRep.setNVPair(LOCATION, this.m_location);
        retRep.setNVPair(NOPRODHOME, OiixUtilityOps.booleanValueOf(this.m_bNoProdHome));
        retRep.setNVPair(NOPREREQ, OiixUtilityOps.booleanValueOf(this.m_bNoPreReq));
        Vector verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_configToolDetails);
        retRep.setNVPair(CONFIGTOOLDETAILS, verIndDeps);
        verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_configToolsToSuppress);
        retRep.setNVPair(CONFIGTOOLSTOSUPPRESS, verIndDeps);
        verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_readmeDetails);
        retRep.setNVPair(READMEDETAILS, verIndDeps);
        verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_readmesToSuppress);
        retRep.setNVPair(READMESTOSUPPRESS, verIndDeps);
        Vector[] verIndLibDeps = new Vector[this.m_libDeps.length];
        for (int i = 0; i < this.m_libDeps.length; ++i) {
            verIndLibDeps[i] = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_libDeps[i]);
        }
        retRep.setNVPair(LIBDEPS, verIndLibDeps);
        if (this.m_bookName != null) {
            retRep.setNVPair(LOCATION, this.m_bookName);
        }
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return !this.m_storedInInv;
    }

    void setCompInstallID(OiiiCompInstallID cid) {
        this.m_cID = cid;
    }

    public void setCompJarInfo(OiisCompJarInfo compJarInfo) {
        this.m_compJarInfo = compJarInfo;
    }

    public OiisCompJarInfo getCompJarInfo() {
        return this.m_compJarInfo;
    }

    public Object clone() {
        OiisCompProperties oClone = null;
        try {
            oClone = (OiisCompProperties)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.m_compJarInfo != null) {
            oClone.m_compJarInfo = (OiisCompJarInfo)this.m_compJarInfo.clone();
        }
        return oClone;
    }

    public void convertLibDepsVector() {
        for (int i = 0; i < 3; ++i) {
            int nSize = this.m_libDeps[i].size();
            Vector<OiisLibDeps> v = new Vector<OiisLibDeps>(nSize);
            int defMap = this.getDefaultPhaseMap(i);
            for (int j = 0; j < nSize; ++j) {
                OiiiLibraryID lid = (OiiiLibraryID)this.m_libDeps[i].elementAt(j);
                OiisLibDeps ldep = new OiisLibDeps(lid, defMap);
                v.addElement(ldep);
            }
            this.m_libDeps[i] = v;
        }
    }

    private int getDefaultPhaseMap(int libType) {
        int defMap = 255;
        switch (libType) {
            case 0: {
                defMap = 6;
                break;
            }
            case 1: {
                defMap = 255;
                break;
            }
            case 2: {
                defMap = 1;
            }
        }
        return defMap;
    }

    public Vector getLibraryDeps(int libType) {
        if (OiiiLibType.validType(libType)) {
            int size = this.m_libDeps[libType].size();
            Vector<OiiiLibraryID> v = new Vector<OiiiLibraryID>(size);
            for (int i = 0; i < size; ++i) {
                OiisLibDeps ldp = (OiisLibDeps)this.m_libDeps[libType].elementAt(i);
                v.addElement(ldp.getLibID());
            }
            return v;
        }
        return new Vector();
    }

    public int getPhaseMap(OiiiLibraryID lid, int libType) {
        int phaseMap = 0;
        if (OiiiLibType.validType(libType)) {
            boolean bFoundEntry = false;
            int nSize = this.m_libDeps[libType].size();
            OiisLibDeps ldep = null;
            for (int i = 0; i < nSize; ++i) {
                ldep = (OiisLibDeps)this.m_libDeps[libType].elementAt(i);
                if (!ldep.getLibID().equals(lid)) continue;
                bFoundEntry = true;
                break;
            }
            if (bFoundEntry) {
                phaseMap = ldep.getDepMap();
            }
        }
        return phaseMap;
    }

    public void setLibraryDeps(Vector libDeps, int libType, int phase) {
        if (OiiiLibType.validType(libType)) {
            if (libDeps == null) {
                libDeps = new Vector();
            }
            Enumeration en = libDeps.elements();
            while (en.hasMoreElements()) {
                OiiiLibraryID lid = (OiiiLibraryID)en.nextElement();
                OiisLibDeps ldep = null;
                boolean bFoundEntry = false;
                int nSize = this.m_libDeps[libType].size();
                for (int i = 0; i < nSize; ++i) {
                    ldep = (OiisLibDeps)this.m_libDeps[libType].elementAt(i);
                    if (!ldep.getLibID().equals(lid)) continue;
                    bFoundEntry = true;
                    break;
                }
                if (bFoundEntry) {
                    ldep.addDep(phase);
                    continue;
                }
                ldep = new OiisLibDeps(lid, phase);
                this.m_libDeps[libType].addElement(ldep);
            }
        }
    }

    public void setLibraryDeps(Vector libDeps, int libType) {
        this.setLibraryDeps(libDeps, libType, 255);
    }

    public void clearLibraryDepMap(OiiiLibraryID lid, int libType) {
        if (OiiiLibType.validType(libType)) {
            boolean bFoundEntry = false;
            int nSize = this.m_libDeps[libType].size();
            OiisLibDeps ldep = null;
            for (int i = 0; i < nSize; ++i) {
                ldep = (OiisLibDeps)this.m_libDeps[libType].elementAt(i);
                if (!ldep.getLibID().equals(lid)) continue;
                bFoundEntry = true;
                break;
            }
            if (bFoundEntry) {
                ldep.setDepMap(0);
            }
        }
    }

    public OiiiCompInstallID getCompInstallID() {
        return this.m_cID;
    }

    public void setLanguages(Vector langs) {
        this.m_languages = langs;
    }

    public void setResBundle(OiixJarResourceBundle resBundle) {
        int i;
        int size;
        Enumeration e;
        this.m_resBundle = resBundle;
        if (this.m_readmeDetails != null) {
            e = this.m_readmeDetails.elements();
            size = this.m_readmeDetails.size();
            for (i = 0; i < size; ++i) {
                OiisReadmeDetails rd = (OiisReadmeDetails)e.nextElement();
                rd.setBundle(resBundle);
            }
        }
        if (this.m_configToolDetails != null) {
            e = this.m_configToolDetails.elements();
            size = this.m_configToolDetails.size();
            for (i = 0; i < size; ++i) {
                OiisConfigToolDetails cd = (OiisConfigToolDetails)e.nextElement();
                cd.setBundle(resBundle);
            }
        }
    }

    public Vector getLanguages() {
        return this.m_languages;
    }

    public void addLanguage(Locale lang) {
        this.m_languages.addElement(lang);
    }

    public void removeLanguage(Locale lang) {
        if (lang != null) {
            this.m_languages.removeElement(lang);
        }
    }

    public void setSupportedLangs(Vector langs) {
        this.m_supLangs = langs;
        if (this.m_defLang == null && !langs.isEmpty()) {
            this.m_defLang = (Locale)this.m_supLangs.firstElement();
        }
    }

    public Vector getSupportedLangs() {
        return this.m_supLangs;
    }

    public void addSupportedLang(Locale lang) {
        this.m_supLangs.addElement(lang);
    }

    public void removeSupportedLang(Locale lang) {
        if (lang != null) {
            this.m_supLangs.removeElement(lang);
        }
    }

    public void setDefaultLang(Locale lang) {
        this.m_defLang = lang;
    }

    public Locale getDefaultLang() {
        return this.m_defLang;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String loc) {
        this.m_location = loc;
    }

    public boolean isNoProdHomeAvailable() {
        return this.m_bNoProdHome;
    }

    public void setNoProdHomeAvailable(boolean bNoProdHome) {
        this.m_bNoProdHome = bNoProdHome;
    }

    public boolean isNoPreReqAvailable() {
        return this.m_bNoPreReq;
    }

    public void setNoPreReqAvailable(boolean bNoPreReq) {
        this.m_bNoPreReq = bNoPreReq;
    }

    public String getDisplayName() {
        return this.m_resBundle.getString("Name");
    }

    public String getDisplayDescription() {
        return this.m_resBundle.getString("Description");
    }

    public Vector[] getLibDeps() {
        return this.m_libDeps;
    }

    public OiixJarResourceBundle getResBundle() {
        return this.m_resBundle;
    }

    public Vector getReadmeDetails() {
        if (this.m_readmeDetails == null) {
            this.m_readmeDetails = new Vector();
        }
        return this.m_readmeDetails;
    }

    public Vector getReadmesToSuppress() {
        if (this.m_readmesToSuppress == null) {
            this.m_readmesToSuppress = new Vector();
        }
        return this.m_readmesToSuppress;
    }

    public void addReadmeDetails(OiisReadmeDetails rdetails) {
        if (this.m_readmeDetails == null) {
            this.m_readmeDetails = new Vector();
        }
        this.m_readmeDetails.addElement(rdetails);
    }

    public void setReadmeDetails(Vector v) {
        this.m_readmeDetails = v;
    }

    public void setReadmesToSuppress(Vector v) {
        this.m_readmesToSuppress = v;
    }

    public void addReadmeToSuppress(OiiiReadmeID rid) {
        if (this.m_readmesToSuppress == null) {
            this.m_readmesToSuppress = new Vector();
        }
        this.m_readmesToSuppress.addElement(rid);
    }

    public void addConfigToolDetails(OiisConfigToolDetails cdetails) {
        if (this.m_configToolDetails == null) {
            this.m_configToolDetails = new Vector();
        }
        this.m_configToolDetails.addElement(cdetails);
    }

    public void setConfigToolDetails(Vector v) {
        this.m_configToolDetails = v;
    }

    public Vector getConfigToolDetails() {
        if (this.m_configToolDetails == null) {
            this.m_configToolDetails = new Vector();
        }
        return this.m_configToolDetails;
    }

    public int getConfigToolCount() {
        return this.getConfigToolDetails().size();
    }

    public Vector getConfigToolsToSuppress() {
        if (this.m_configToolsToSuppress == null) {
            this.m_configToolsToSuppress = new Vector();
        }
        return this.m_configToolsToSuppress;
    }

    public void setConfigToolsToSuppress(Vector v) {
        this.m_configToolsToSuppress = v;
    }

    public void addConfigToolToSuppress(OiiiConfigToolID cid) {
        if (this.m_configToolsToSuppress == null) {
            this.m_configToolsToSuppress = new Vector();
        }
        this.m_configToolsToSuppress.addElement(cid);
    }

    public void setHelpBookName(String bookName) {
        this.m_bookName = bookName;
    }

    public String getHelpBookName() {
        return this.m_bookName;
    }
}

