/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiConfigToolID;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiisConfigToolDetails
implements Serializable,
OiivVerIndMergeCapable {
    static final long serialVersionUID = 4165211835903929401L;
    OiiiConfigToolID m_toolID;
    String m_externalName;
    String m_description;
    String m_location;
    String m_parameters;
    transient OiixJarResourceBundle m_resBundle;
    Vector m_waitingForTools;
    boolean m_applicableOnAllPlatforms = true;
    private transient boolean m_storedInInv = false;
    int[] m_setOfPlatforms;
    String m_className;
    String m_sAggregateName;
    String m_sDispName = "";
    transient OiisPostInstallTool m_pTool;
    String m_visibilityCheckVariable;
    private static final String TOOLID = "toolID";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String LOCATION = "location";
    private static final String PARAMETERS = "parameters";
    private static final String WAITINGFORTOOLS = "waitingForTools";
    private static final String ALL_PLATFORMS = "allPlatforms";
    private static final String PLATFORMS = "platforms";
    private static final String CLASSNAME = "className";
    private static final String VISIBILITYCHECKVARIABLE = "visibilityCheckVariable";
    private static final String AGGREGATENAME = "aggregateName";

    public OiisConfigToolDetails() {
    }

    public OiisConfigToolDetails(OiiiConfigToolID toolID, String externalName, String description, String location, String parameters) {
        this.m_toolID = toolID;
        this.m_externalName = externalName;
        this.m_description = description;
        this.m_location = location;
        this.m_parameters = parameters;
    }

    public OiisConfigToolDetails(OiiiConfigToolID toolID, String externalName, String description) {
        this(toolID, externalName, description, null, null);
    }

    public OiisConfigToolDetails(OiivVerIndObjectRep viObj) {
        this.m_storedInInv = true;
        OiivVerIndObjectRep oVerIndObj = (OiivVerIndObjectRep)viObj.getObjectForName(TOOLID);
        if (oVerIndObj != null) {
            this.m_toolID = new OiiiConfigToolID(oVerIndObj);
        }
        this.m_externalName = (String)viObj.getObjectForName(NAME);
        this.m_description = (String)viObj.getObjectForName(DESCRIPTION);
        this.m_location = (String)viObj.getObjectForName(LOCATION);
        this.m_parameters = (String)viObj.getObjectForName(PARAMETERS);
        Vector verIndVect = (Vector)viObj.getObjectForName(WAITINGFORTOOLS);
        if (verIndVect != null) {
            this.m_waitingForTools = OiivVerIndObjectRep.getVerDepFormOfVect(verIndVect);
        }
        this.m_applicableOnAllPlatforms = (Boolean)viObj.getObjectForName(ALL_PLATFORMS);
        this.m_setOfPlatforms = (int[])viObj.getObjectForName(PLATFORMS);
        this.m_className = (String)viObj.getObjectForName(CLASSNAME);
        this.m_sAggregateName = (String)viObj.getObjectForName(AGGREGATENAME);
        this.m_visibilityCheckVariable = (String)viObj.getObjectForName(VISIBILITYCHECKVARIABLE);
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        OiivVerIndObjectRep oVerIndObj = this.m_toolID.getVerIndRep();
        retRep.addNVPair(TOOLID, oVerIndObj);
        retRep.addNVPair(NAME, this.m_externalName);
        retRep.addNVPair(DESCRIPTION, this.m_description);
        retRep.addNVPair(LOCATION, this.m_location);
        retRep.addNVPair(PARAMETERS, this.m_parameters);
        if (this.m_waitingForTools != null) {
            Vector verIndVect = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_waitingForTools);
            retRep.addNVPair(WAITINGFORTOOLS, verIndVect);
        }
        retRep.addNVPair(ALL_PLATFORMS, new Boolean(this.m_applicableOnAllPlatforms));
        retRep.addNVPair(PLATFORMS, this.m_setOfPlatforms);
        retRep.addNVPair(CLASSNAME, this.m_className);
        retRep.addNVPair(AGGREGATENAME, this.m_sAggregateName);
        retRep.addNVPair(VISIBILITYCHECKVARIABLE, this.m_visibilityCheckVariable);
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return !this.m_storedInInv;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals(TOOLID)) {
            return this.m_toolID.equals(value);
        }
        if (key.equals(NAME)) {
            return this.m_externalName == null ? value == null : this.m_externalName.equals(value);
        }
        if (key.equals(DESCRIPTION)) {
            return this.m_description == null ? value == null : this.m_description.equals(value);
        }
        if (key.equals(LOCATION)) {
            return this.m_location == null ? value == null : this.m_location.equals(value);
        }
        if (key.equals(PARAMETERS)) {
            return this.m_parameters == null ? value == null : this.m_parameters.equals(value);
        }
        if (key.equals(WAITINGFORTOOLS)) {
            return this.m_waitingForTools == null ? value == null : this.m_waitingForTools.equals(value);
        }
        if (key.equals(ALL_PLATFORMS)) {
            return this.m_applicableOnAllPlatforms == (Boolean)value;
        }
        if (key.equals(PLATFORMS)) {
            return this.m_setOfPlatforms == null ? value == null : this.m_setOfPlatforms.equals(value);
        }
        if (key.equals(CLASSNAME)) {
            return this.m_className == null ? value == null : this.m_className.equals(value);
        }
        if (key.equals(AGGREGATENAME)) {
            return this.m_sAggregateName == null ? value == null : this.m_sAggregateName.equals(value);
        }
        if (key.equals(VISIBILITYCHECKVARIABLE)) {
            return this.m_visibilityCheckVariable == null ? value == null : this.m_visibilityCheckVariable.equals(value);
        }
        return false;
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep retRep = vIndObj;
        OiivVerIndObjectRep oVerIndObj = this.m_toolID.mergeVerIndRep((OiivVerIndObjectRep)retRep.getObjectForName(TOOLID));
        retRep.setNVPair(TOOLID, oVerIndObj);
        retRep.setNVPair(NAME, this.m_externalName);
        retRep.setNVPair(DESCRIPTION, this.m_description);
        retRep.setNVPair(LOCATION, this.m_location);
        retRep.setNVPair(PARAMETERS, this.m_parameters);
        if (this.m_waitingForTools != null) {
            Vector verIndVect = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_waitingForTools);
            retRep.setNVPair(WAITINGFORTOOLS, verIndVect);
        }
        retRep.setNVPair(ALL_PLATFORMS, new Boolean(this.m_applicableOnAllPlatforms));
        retRep.setNVPair(PLATFORMS, this.m_setOfPlatforms);
        retRep.setNVPair(CLASSNAME, this.m_className);
        retRep.setNVPair(AGGREGATENAME, this.m_sAggregateName);
        retRep.setNVPair(VISIBILITYCHECKVARIABLE, this.m_visibilityCheckVariable);
        return retRep;
    }

    public boolean isCurrentPlatSupported() {
        return this.isCurrentPlatSupported(OiixPlatform.getCurrentPlatform());
    }

    public boolean isCurrentPlatSupported(int curPlat) {
        for (int i = 0; i < this.m_setOfPlatforms.length; ++i) {
            if (this.m_setOfPlatforms[i] != curPlat) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.m_setOfPlatforms.length; ++i) {
            s = s + "," + this.m_setOfPlatforms[i];
        }
        return this.m_toolID + "::" + s;
    }

    public void setToolClassName(String sName) {
        this.m_className = sName;
    }

    public void setAggregateName(String sName) {
        this.m_sAggregateName = sName;
    }

    public String getAggregateName() {
        return this.m_sAggregateName;
    }

    public String getToolClassName() {
        return this.m_className;
    }

    public void setPostInstallTool(OiisPostInstallTool pTool) {
        this.m_pTool = pTool;
    }

    public OiisPostInstallTool getPostInstallTool() {
        return this.m_pTool;
    }

    public void setPlatforms(int[] a) {
        int size = a.length;
        this.m_setOfPlatforms = new int[size];
        for (int i = 0; i < size; ++i) {
            this.m_setOfPlatforms[i] = a[i];
        }
    }

    public int[] getPlatforms() {
        return this.m_setOfPlatforms;
    }

    public boolean isApplicableOnAllPlatforms() {
        return this.m_applicableOnAllPlatforms;
    }

    public void setVisibilityCheckVariable(String s) {
        this.m_visibilityCheckVariable = s;
    }

    public String getVisibilityCheckVariable() {
        return this.m_visibilityCheckVariable;
    }

    public void setBundle(OiixJarResourceBundle res) {
        this.m_resBundle = res;
    }

    public OiiiConfigToolID getConfigToolID() {
        return this.m_toolID;
    }

    public void setDisplayName(String sDisplayName) {
        this.m_sDispName = sDisplayName;
    }

    public String getDisplayName() {
        return this.m_sDispName;
    }

    public String getExternalName() {
        if (this.m_resBundle == null) {
            return this.m_externalName;
        }
        try {
            String ret = (String)this.m_resBundle.getObject(this.m_externalName);
            return ret;
        }
        catch (MissingResourceException e) {
            return this.m_externalName;
        }
    }

    public String getExternalNameID() {
        return this.m_externalName;
    }

    public String getDescription() {
        if (this.m_resBundle == null) {
            return this.m_description;
        }
        try {
            String ret = this.m_resBundle.getString(this.m_description);
            return ret;
        }
        catch (MissingResourceException e) {
            return this.m_description;
        }
    }

    public String getDescriptionID() {
        return this.m_description;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getParameters() {
        return this.m_parameters;
    }

    public void setLocation(String s) {
        this.m_location = new String(s);
    }

    public void setParameters(String s) {
        this.m_parameters = new String(s);
    }

    public void setWaitingForTools(Vector toolsVect) {
        this.m_waitingForTools = toolsVect;
    }

    public Vector getWaitingForTools() {
        return this.m_waitingForTools;
    }
}

