/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import [Ljava.lang.String;;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisDataTypeDetails;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiisDataTypes {
    private static Vector m_Types = new Vector();
    public static final OiisDataTypeDetails STRING = new OiisDataTypeDetails(1, "String", String.class);
    public static final OiisDataTypeDetails NUMBER = new OiisDataTypeDetails(2, "Number", Integer.class);
    public static final OiisDataTypeDetails BOOL = new OiisDataTypeDetails(3, "Boolean", Boolean.class);
    public static final OiisDataTypeDetails STRINGLIST = new OiisDataTypeDetails(4, "StringList", String;.class);
    public static final int UNKNOWN_TYPE = -1;
    private static final String STRINGLIST_DELIMITER = ",";

    private OiisDataTypes() {
    }

    public static void addDataType(OiisDataTypeDetails type) {
        if (OiisDataTypes.findDataType(type.getID(), type.getName(), type.getTypeClass()) != null) {
            throw new IllegalArgumentException("Data type already exists:" + type);
        }
        m_Types.addElement(type);
    }

    public static OiisDataTypeDetails findTypeWithID(int nID) {
        for (int i = 0; i < m_Types.size(); ++i) {
            OiisDataTypeDetails type = (OiisDataTypeDetails)m_Types.elementAt(i);
            if (type.getID() != nID) continue;
            return type;
        }
        return null;
    }

    public static OiisDataTypeDetails findTypeWithName(String sName) {
        return OiisDataTypes.findDataType(0, sName, null);
    }

    public static OiisDataTypeDetails findTypeWithClass(Class typeClass) {
        return OiisDataTypes.findDataType(0, "", typeClass);
    }

    public static OiisDataTypeDetails findDataType(int nID, String sName, Class typeClass) {
        for (int i = 0; i < m_Types.size(); ++i) {
            OiisDataTypeDetails type = (OiisDataTypeDetails)m_Types.elementAt(i);
            if (type.getID() != nID && !type.getName().equalsIgnoreCase(sName) && type.getTypeClass() != typeClass) continue;
            return type;
        }
        return null;
    }

    static boolean checkObjectType(int type, Object value) {
        if (type == -1) {
            return true;
        }
        OiisDataTypeDetails typeDetails = OiisDataTypes.findTypeWithID(type);
        if (typeDetails == null) {
            return false;
        }
        Class<?> typeClass = value.getClass();
        return typeClass == typeDetails.getTypeClass();
    }

    public static Object getValueObject(String sValue, String sType) {
        String[] value = null;
        if (sType.equalsIgnoreCase(STRING.getName())) {
            value = sValue;
        }
        if (sType.equalsIgnoreCase(BOOL.getName())) {
            value = Boolean.valueOf(sValue);
        }
        if (sType.equalsIgnoreCase(NUMBER.getName())) {
            value = Integer.valueOf(sValue);
        }
        if (sType.equalsIgnoreCase(STRINGLIST.getName())) {
            value = OiisDataTypes.getStringListObject(sValue);
        }
        return value;
    }

    public static String getStringValue(Object obj, String sType) {
        String sValue = "";
        if (obj != null) {
            if (sType.equalsIgnoreCase(STRINGLIST.getName())) {
                String[] sList = (String[])obj;
                sValue = "";
                for (int i = 0; i < sList.length; ++i) {
                    sValue = sValue + sList[i];
                    if (i == sList.length - 1) continue;
                    sValue = sValue + STRINGLIST_DELIMITER;
                }
            } else {
                sValue = obj.toString();
            }
        }
        return sValue;
    }

    public static String[] getStringListObject(String sValue) {
        if (sValue == null) {
            return new String[0];
        }
        if ((sValue = sValue.trim()).startsWith("{") && sValue.endsWith("}")) {
            sValue = sValue.substring(1, sValue.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(sValue, STRINGLIST_DELIMITER);
        int length = st.countTokens();
        String[] sList = new String[length];
        int i = 0;
        while (st.hasMoreTokens()) {
            sList[i] = OiixPathOps.stripQuotes(st.nextToken().trim());
            ++i;
        }
        return sList;
    }

    public static int getTypeID(String sType) {
        int nType = STRING.getID();
        if (sType.equals(STRING.getName())) {
            nType = STRING.getID();
        }
        if (sType.equals(BOOL.getName())) {
            nType = BOOL.getID();
        }
        if (sType.equals(NUMBER.getName())) {
            nType = NUMBER.getID();
        }
        if (sType.equals(STRINGLIST.getName())) {
            nType = STRINGLIST.getID();
        }
        return nType;
    }

    static {
        m_Types.addElement(STRING);
        m_Types.addElement(NUMBER);
        m_Types.addElement(BOOL);
        m_Types.addElement(STRINGLIST);
    }
}

