/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDepRuleComp;
import oracle.sysman.oii.oiis.OiisDepRuleProperty;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisDepInfo {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    private OiisDeps m_deps;
    private String m_sInstallTypeName;
    private int m_depModeId;
    private String m_sdescID;

    public OiisDepInfo(OiisDeps deps) {
        this.m_deps = deps;
        this.m_depModeId = 0;
    }

    public void setResourceBundle(OiixJarResourceBundle jrb) {
        this.m_deps.setResourceBundle(jrb);
    }

    public void setDepModeId(int id) {
        this.m_depModeId = id;
        this.setDepModeName(OiisDepMode.getInternalNameForID(id));
    }

    public int getDepModeId() {
        return this.m_depModeId;
    }

    public void setDepModeName(String id) {
        this.m_sInstallTypeName = id;
    }

    public String getDepModeName() {
        if (this.m_sInstallTypeName == null) {
            this.setDepModeName(OiisDepMode.getInternalNameForID(this.m_depModeId));
        }
        return this.m_sInstallTypeName;
    }

    public void setDepModeDescID(String id) {
        this.m_sdescID = id;
    }

    public String getDepModeDescID() {
        if (this.m_sdescID == null) {
            this.setDepModeDescID(this.getDepMode().getDescriptionID());
        }
        return this.m_sdescID;
    }

    public OiisDeps getDeps() {
        return this.m_deps;
    }

    public OiisDepMode getDepMode() {
        return this.getDepMode(this.getDepModeName());
    }

    public OiisDepMode getDepMode(int mode_id) {
        switch (mode_id) {
            case -2: {
                return this.getMinDepMode();
            }
            case -3: {
                return this.getMaxDepMode();
            }
            case -1: {
                return this.getTypDepMode();
            }
            case 0: {
                return this.getCustomDepMode();
            }
        }
        return this.getDepModeInternal(OiisDepMode.getInternalNameForID(mode_id));
    }

    public OiisDepMode getDepMode(String sTypeName) {
        OiisDepMode oMode = null;
        if (sTypeName.equalsIgnoreCase("Minimum")) {
            oMode = this.getMinDepMode();
        }
        if (sTypeName.equalsIgnoreCase("Complete")) {
            oMode = this.getMaxDepMode();
        }
        if (sTypeName.equalsIgnoreCase("Typical")) {
            oMode = this.getTypDepMode();
        }
        if (sTypeName.equalsIgnoreCase("Custom")) {
            oMode = this.getCustomDepMode();
        }
        if (oMode == null) {
            oMode = this.getDepModeInternal(sTypeName);
        }
        return oMode;
    }

    private OiisDepMode getDepModeInternal(String sName) {
        Vector depModes = this.m_deps.getDepModes();
        int nIndex = OiixVectorOps.vectIndexOf(depModes, (Object)sName);
        if (nIndex != -1) {
            return (OiisDepMode)depModes.elementAt(nIndex);
        }
        return null;
    }

    public String[] getDepModeNames() {
        Vector depModes = this.m_deps.getDepModes();
        String[] depModeNames = new String[depModes.size()];
        for (int i = 0; i < depModes.size(); ++i) {
            OiisDepMode depMode = (OiisDepMode)depModes.elementAt(i);
            depModeNames[i] = depMode.getName();
        }
        return depModeNames;
    }

    public OiisDepMode getMinDepMode() {
        OiisDepMode retDepMode = null;
        retDepMode = this.getDepModeInternal("Minimum");
        if (retDepMode == null) {
            Vector depRules = this.m_deps.getDepRules();
            int numRules = depRules.size();
            Vector<OiisDepRuleProperty> ruleProps = new Vector<OiisDepRuleProperty>();
            for (int i = 0; i < numRules; ++i) {
                ruleProps.addElement(OiisDepInfo.getMinProperty((OiisDepRule)depRules.elementAt(i)));
            }
            retDepMode = new OiisDepMode("Minimum", OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_MINIMAL"), ruleProps);
        }
        return retDepMode;
    }

    public OiisDepMode getTypDepMode() {
        OiisDepMode retDepMode = null;
        retDepMode = this.getDepModeInternal("Typical");
        if (retDepMode == null) {
            OiisDepMode minMode = this.getMinDepMode();
            retDepMode = new OiisDepMode("Typical", OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TYPICAL"), minMode.getDepRuleProps());
        }
        return retDepMode;
    }

    public OiisDepMode getCustomDepMode() {
        OiisDepMode retDepMode = null;
        retDepMode = this.getDepModeInternal("Custom");
        if (retDepMode == null) {
            OiisDepMode typMode = this.getTypDepMode();
            Vector typProps = typMode.getDepRuleProps();
            int numRules = typProps.size();
            Vector<OiisDepRuleProperty> custProps = new Vector<OiisDepRuleProperty>();
            for (int i = 0; i < numRules; ++i) {
                OiisDepRuleProperty typProp = (OiisDepRuleProperty)typProps.elementAt(i);
                custProps.addElement(OiisDepInfo.getCustVersion(typProp));
            }
            retDepMode = new OiisDepMode("Custom", OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CUSTOM"), custProps);
        }
        return retDepMode;
    }

    public OiisDepMode getMaxDepMode() {
        OiisDepMode retDepMode = null;
        retDepMode = this.getDepModeInternal("Complete");
        if (retDepMode == null) {
            Vector depRules = this.m_deps.getDepRules();
            int numRules = depRules.size();
            Vector<OiisDepRuleProperty> ruleProps = new Vector<OiisDepRuleProperty>();
            for (int i = 0; i < numRules; ++i) {
                ruleProps.addElement(OiisDepInfo.getMaxProperty((OiisDepRule)depRules.elementAt(i)));
            }
            retDepMode = new OiisDepMode("Complete", OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_MAXIMUM"), ruleProps);
        }
        return retDepMode;
    }

    public static OiisDepRuleProperty getCustVersion(OiisDepRuleProperty typProp) {
        String id = typProp.getRuleName();
        boolean ask = true;
        Vector typComps = typProp.getDepRuleComps();
        int numComps = typComps.size();
        Vector<OiisDepRuleComp> comps = new Vector<OiisDepRuleComp>();
        Enumeration typCompEn = typComps.elements();
        while (typCompEn.hasMoreElements()) {
            OiisDepRuleComp typComp = (OiisDepRuleComp)typCompEn.nextElement();
            comps.addElement(new OiisDepRuleComp(typComp.getComp(), typComp.getSelected(), "Custom"));
        }
        return new OiisDepRuleProperty(id, ask, comps);
    }

    public static OiisDepRuleProperty getMinProperty(OiisDepRule rule) {
        int i;
        String id = rule.getInternalName();
        boolean ask = false;
        Vector cids = rule.getDepCompIds();
        int numComps = cids.size();
        Vector<OiisDepRuleComp> comps = new Vector<OiisDepRuleComp>();
        boolean[] selections = new boolean[numComps];
        for (i = 0; i < numComps; ++i) {
            selections[i] = false;
        }
        switch (rule.getType()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                if (numComps <= 0) break;
                selections[0] = true;
                break;
            }
            case 3: {
                for (i = 0; i < numComps; ++i) {
                    selections[i] = true;
                }
                break;
            }
        }
        for (i = 0; i < numComps; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)cids.elementAt(i);
            comps.addElement(new OiisDepRuleComp(cid, selections[i], "Minimum"));
        }
        return new OiisDepRuleProperty(id, false, comps);
    }

    public static OiisDepRuleProperty getMaxProperty(OiisDepRule rule) {
        int i;
        String id = rule.getInternalName();
        boolean ask = false;
        Vector cids = rule.getDepCompIds();
        int numComps = cids.size();
        Vector<OiisDepRuleComp> comps = new Vector<OiisDepRuleComp>();
        boolean[] selections = new boolean[numComps];
        for (i = 0; i < numComps; ++i) {
            selections[i] = false;
        }
        switch (rule.getType()) {
            case 2: {
                if (numComps <= 0) break;
                selections[0] = true;
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                for (i = 0; i < numComps; ++i) {
                    selections[i] = true;
                }
                break;
            }
        }
        for (i = 0; i < numComps; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)cids.elementAt(i);
            comps.addElement(new OiisDepRuleComp(cid, selections[i], "Complete"));
        }
        return new OiisDepRuleProperty(id, false, comps);
    }

    public void releaseDeps() {
        this.m_deps = null;
    }
}

