/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiisDepRule
implements Serializable {
    static final long serialVersionUID = -4912834052796234388L;
    public static final int ZERO_OR_MORE = 0;
    public static final int ONE_OR_MORE = 1;
    public static final int EXACTLY_ONE = 2;
    public static final int ALL = 3;
    public static final String S_DEFAULT_NAME_ALL = "Required";
    public static final String S_DEFAULT_NAME_ZERO_OR_MORE = "Optional";
    public static final String S_DEFAULT_NAME = "Group";
    private int m_id;
    private int m_type;
    private boolean m_bOpen;
    private String m_name;
    private String m_sInternalName;
    private transient OiixJarResourceBundle m_rb;
    private Vector m_deps;

    public OiisDepRule(int id, int type, String name, Vector deps) {
        this.m_id = id;
        this.m_sInternalName = S_DEFAULT_NAME + this.m_id;
        this.m_type = type;
        this.m_name = name;
        this.m_deps = deps;
        this.m_bOpen = true;
    }

    public OiisDepRule(String sInternalName, int type, String name, Vector deps) {
        this.m_sInternalName = sInternalName;
        this.m_type = type;
        this.m_name = name;
        this.m_deps = deps;
        this.m_bOpen = true;
    }

    public int getID() {
        return this.m_id;
    }

    public void setID(int nId) {
        this.m_id = nId;
    }

    public void setInternalName(String sName) {
        this.m_sInternalName = sName;
    }

    public String getInternalName() {
        if (this.m_sInternalName == null) {
            this.setInternalName(S_DEFAULT_NAME + this.m_id);
        }
        return this.m_sInternalName;
    }

    public void optimizePlatList() {
        int numComps = this.m_deps.size();
        for (int i = 0; i < numComps; ++i) {
            OiiiCompInstallID oCompId = (OiiiCompInstallID)this.m_deps.elementAt(i);
            oCompId.optimizePlatList();
        }
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public Vector getDepCompIds() {
        return this.m_deps;
    }

    public void setDepCompIds(Vector deps) {
        this.m_deps = deps;
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean bTranslation) {
        return this.getResource(this.m_name, bTranslation);
    }

    public String getNameID() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean isOpen() {
        return this.m_bOpen;
    }

    public void setOpen(boolean bOpen) {
        this.m_bOpen = bOpen;
    }

    public String getTypeString() {
        switch (this.m_type) {
            case 0: {
                return "O";
            }
            case 1: {
                return "M";
            }
            case 2: {
                return "X";
            }
            case 3: {
                return "R";
            }
        }
        return "Unknown type";
    }

    public static int getTypeFromString(String sType) {
        if (sType.equals("O")) {
            return 0;
        }
        if (sType.equals("M")) {
            return 1;
        }
        if (sType.equals("X")) {
            return 2;
        }
        return 3;
    }

    public void setResourceBundle(OiixJarResourceBundle rb) {
        this.m_rb = rb;
    }

    private String getResource(String key) {
        return this.getResource(key, true);
    }

    private String getResource(String key, boolean bTranslate) {
        String res = key;
        if (this.m_rb != null) {
            try {
                res = bTranslate ? this.m_rb.getString(key) : this.m_rb.getEnglishString(key);
                if (res != null && res == key && bTranslate) {
                    res = this.m_rb.getString(OiisGenericConstant.formDefaultName(key));
                }
            }
            catch (MissingResourceException e) {
                System.err.println("MissingResourceException in " + this.getInternalName() + ":" + key);
            }
        }
        return res;
    }

    public boolean equals(String sName) {
        if (sName == null) {
            return false;
        }
        return sName.equalsIgnoreCase(this.getInternalName());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof String) {
            return this.equals((String)other);
        }
        return super.equals(other);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(OiixResourceBundle.getString("S_LOG_ID"));
        sbuf.append(this.getInternalName());
        sbuf.append(OiixResourceBundle.getString("S_LOG_NAME"));
        sbuf.append(this.getName());
        sbuf.append(OiixResourceBundle.getString("S_LOG_TYPE"));
        sbuf.append(this.getType());
        sbuf.append(OiixResourceBundle.getString("S_LOG_PROPERTIES_DEPRULE"));
        Vector depCompIds = this.getDepCompIds();
        int numdcis = depCompIds.size();
        for (int i = 0; i < numdcis; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)depCompIds.elementAt(i);
            sbuf.append(cid);
            sbuf.append(", ");
        }
        sbuf.append(" ]]");
        sbuf.append(System.getProperty("line.separator"));
        return sbuf.toString();
    }
}

