/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.sysman.oii.oiiv.OiivVerIndCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;

public class OiisDestinationIndexMapping
implements OiivVerIndCapable,
Serializable {
    static final long serialVersionUID = -2132989419388593772L;
    private String[] m_asDestinationIndexMap = null;
    private transient Hashtable m_oDestinationIndexMap = null;
    private boolean m_bCreatedInThisSession;
    private static final String S_DESTINATIONMAP = "destinationmap";

    public OiisDestinationIndexMapping() {
        this(10);
    }

    public OiisDestinationIndexMapping(int iSize) {
        this.m_oDestinationIndexMap = new Hashtable(iSize);
        this.m_bCreatedInThisSession = true;
    }

    public OiisDestinationIndexMapping(OiivVerIndObjectRep objRep) {
        this.m_bCreatedInThisSession = false;
        this.m_asDestinationIndexMap = (String[])objRep.getObjectForName(S_DESTINATIONMAP);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("created:" + this.wasCreatedInThisSession());
        if (this.wasCreatedInThisSession()) {
            Enumeration e = this.m_oDestinationIndexMap.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                sb.append(key + ":" + this.m_oDestinationIndexMap.get(key) + "\n");
            }
        } else {
            for (int i = 0; i < this.m_asDestinationIndexMap.length; ++i) {
                sb.append("[" + i + "]:" + this.m_asDestinationIndexMap[i] + "\n");
            }
        }
        return sb.toString();
    }

    public boolean wasCreatedInThisSession() {
        return this.m_bCreatedInThisSession;
    }

    public boolean compareKeyValue(String key, Object value) {
        return true;
    }

    public void commitInserts() {
        if (this.m_asDestinationIndexMap == null) {
            if (this.wasCreatedInThisSession()) {
                this.m_asDestinationIndexMap = new String[this.m_oDestinationIndexMap.size()];
                Enumeration keys = this.m_oDestinationIndexMap.keys();
                while (keys.hasMoreElements()) {
                    String sDest = (String)keys.nextElement();
                    int idx = (Integer)this.m_oDestinationIndexMap.get(sDest);
                    this.m_asDestinationIndexMap[idx] = sDest;
                }
            } else {
                this.m_asDestinationIndexMap = new String[0];
            }
            this.m_oDestinationIndexMap = null;
            this.m_bCreatedInThisSession = false;
        }
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        this.commitInserts();
        retRep.addNVPair(S_DESTINATIONMAP, this.m_asDestinationIndexMap);
        return retRep;
    }

    public int addDestination(String sDest) {
        if (sDest == null) {
            return -1;
        }
        if (this.wasCreatedInThisSession()) {
            if (this.m_oDestinationIndexMap.containsKey(sDest)) {
                return (Integer)this.m_oDestinationIndexMap.get(sDest);
            }
            int idx = this.m_oDestinationIndexMap.size();
            this.m_oDestinationIndexMap.put(sDest, new Integer(idx));
            return idx;
        }
        return this.getDestinationIndex(sDest);
    }

    public int getDestinationIndex(String sDest) {
        if (this.wasCreatedInThisSession()) {
            if (this.m_oDestinationIndexMap.containsKey(sDest)) {
                return (Integer)this.m_oDestinationIndexMap.get(sDest);
            }
            return -1;
        }
        for (int i = 0; i < this.m_asDestinationIndexMap.length; ++i) {
            if (!this.m_asDestinationIndexMap[i].equals(sDest)) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        if (!this.wasCreatedInThisSession()) {
            return this.m_asDestinationIndexMap.length;
        }
        return this.m_oDestinationIndexMap.size();
    }

    public String getDestination(int idx) {
        String sDest;
        block3: {
            block2: {
                sDest = null;
                if (this.wasCreatedInThisSession()) break block2;
                if (idx < 0 || idx >= this.m_asDestinationIndexMap.length) break block3;
                sDest = this.m_asDestinationIndexMap[idx];
                break block3;
            }
            if (idx >= 0 && idx < this.m_oDestinationIndexMap.size()) {
                int value;
                Enumeration keys = this.m_oDestinationIndexMap.keys();
                while (keys.hasMoreElements() && (value = ((Integer)this.m_oDestinationIndexMap.get(sDest = (String)keys.nextElement())).intValue()) != idx) {
                }
            }
        }
        return sDest;
    }
}

