/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixp.OixpIAttribute;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpXmlParserCreationException;
import oracle.sysman.oix.oixp.OixpXmlParserFactory;

public class OiisFileDeletionReader
implements OixpIHandler {
    public static final String FILEMAP_TAG = "FILEMAP";
    public static final String FILEMAP_GENERIC_TAG = "FILEMAP_GENERIC";
    public static final String ENTRY_TAG = "ENTRY";
    public static final String DESTINATION_TAG = "DESTINATION";
    public static final String INCLUDE_TAG = "INCLUDE";
    public static final String FILE_ATT = "FILE";
    private ArrayList Files_List = new ArrayList();
    private String m_sLoc;
    private String m_sohLoc;
    private String m_sDest;
    private String m_sInclude;

    public OiisFileDeletionReader(String loc, String ohLoc) {
        this.m_sLoc = loc;
        this.m_sohLoc = ohLoc;
        this.m_sDest = "";
        this.m_sInclude = "";
    }

    public String getLoc() {
        return this.m_sLoc;
    }

    public String getohLoc() {
        return this.m_sohLoc;
    }

    public String getDest() {
        return this.m_sDest;
    }

    public String getInclude() {
        return this.m_sInclude;
    }

    public ArrayList getFilesToDelete() {
        return this.Files_List;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromFile() throws IOException {
        FileInputStream fis;
        block8: {
            block7: {
                fis = null;
                try {
                    try {
                        OixpIXmlParser parser = OixpXmlParserFactory.createXmlParser();
                        File f = new File(this.m_sLoc);
                        if (!f.exists()) {
                            Object var5_6 = null;
                            if (fis == null) return;
                            break block7;
                        }
                        parser.setHandler(this);
                        parser.readXML((OixpIHandler)this, new File(this.m_sLoc));
                        break block8;
                    }
                    catch (OixpXmlParserCreationException xpce) {
                        OiiolTextLogger.appendException(xpce);
                        throw new IOException(xpce.getMessage());
                    }
                    catch (Exception e) {
                        OiiolTextLogger.appendException(e);
                        Object var5_8 = null;
                        if (fis == null) return;
                        fis.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
            }
            fis.close();
            return;
        }
        Object var5_7 = null;
        if (fis == null) return;
        fis.close();
    }

    public boolean doStartTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(INCLUDE_TAG)) {
            OixpIAttribute[] retLst = el.getAllAttributes();
            for (int i = 0; i < retLst.length; ++i) {
                String tmp = retLst[i].getName().toUpperCase();
                if (!tmp.equals(FILE_ATT)) continue;
                this.m_sInclude = retLst[i].getValue();
            }
        }
        return false;
    }

    public boolean doText(OixpIElement el, String text) {
        String type = el.getType();
        if (type.equalsIgnoreCase(DESTINATION_TAG)) {
            this.m_sDest = text;
        }
        return false;
    }

    public boolean doEndTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(ENTRY_TAG)) {
            if (!this.m_sDest.equalsIgnoreCase("") || !this.m_sInclude.equalsIgnoreCase("")) {
                this.m_sDest = OiixPathOps.getStandardForm(this.m_sDest);
                this.m_sInclude = OiixPathOps.getStandardForm(this.m_sInclude);
                String relPath = OiixPathOps.concatPath(this.m_sDest, this.m_sInclude);
                String fullPath = OiixPathOps.concatPath(this.m_sohLoc, relPath);
                this.Files_List.add(fullPath);
            }
            this.m_sDest = "";
            this.m_sInclude = "";
        }
        return false;
    }
}

