/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisPathEntry;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisFileEntry
extends OiisPathEntry
implements Serializable {
    static final long serialVersionUID = -4834235475737672924L;
    private String m_sourceLoc;
    private String m_perms;
    private boolean m_append;
    private boolean m_compress;
    private boolean m_instantiate;
    private boolean m_bEmptyDir;
    private int m_size;
    private long m_lSize;
    private boolean m_bForAllStagedPlats = false;
    private int m_platBitSetRefPos;
    private int m_langBitSetRefPos;
    private transient OiisFileGroup m_groupRef;

    public OiisFileEntry(String source, String dest, String perms, int size, boolean append) {
        this(source, dest, perms, size, append, false, false);
    }

    public OiisFileEntry(String source, String dest, String perms, int size, boolean append, boolean compress, boolean instantiate) {
        this(source, dest, perms, (long)size, append, compress, instantiate);
    }

    public OiisFileEntry(String source, String dest, String perms, long size, boolean append, boolean compress, boolean instantiate) {
        super(dest);
        this.m_sourceLoc = source;
        this.m_perms = perms;
        this.m_lSize = size;
        this.m_size = (int)size;
        this.m_append = append;
        this.m_compress = compress;
        this.m_instantiate = instantiate;
        this.setLangBitSetRefPos(0);
        this.setPlatBitSetRefPos(0);
    }

    public void setLangBitSetRefPos(int langBitSetRefPos) {
        this.m_langBitSetRefPos = langBitSetRefPos;
    }

    public int getLangBitSetRefPos() {
        return this.m_langBitSetRefPos;
    }

    public void setPlatBitSetRefPos(int platBitSetRefPos) {
        this.m_platBitSetRefPos = platBitSetRefPos;
    }

    public int getPlatBitSetRefPos() {
        return this.m_platBitSetRefPos;
    }

    public void setGroupRef(OiisFileGroup groupRef) {
        this.m_groupRef = groupRef;
    }

    public int[] getPlatforms() {
        if (this.m_groupRef == null) {
            return null;
        }
        return this.m_groupRef.getPlatformsForPlatSet(this.m_platBitSetRefPos);
    }

    public Locale[] getLanguages() {
        if (this.m_groupRef == null) {
            return null;
        }
        return this.m_groupRef.getLanguagesForLangSet(this.m_langBitSetRefPos);
    }

    public boolean equals(OiisFileEntry fileEntry) {
        boolean result = true;
        if (fileEntry == null) {
            return false;
        }
        if (fileEntry == this) {
            return true;
        }
        result &= this.m_sourceLoc.equals(fileEntry.getSource());
        result &= this.m_perms.equals(fileEntry.getPermissions());
        result &= this.getSizeEx() == fileEntry.getSizeEx();
        result &= this.m_append == fileEntry.isAppended();
        result &= this.m_compress == fileEntry.isCompressed();
        result &= this.m_instantiate == fileEntry.isInstantiatable();
        return result &= this.getDestination() == fileEntry.getDestination();
    }

    public void setAsDirectoryEntry(boolean bEmptyDir) {
        this.m_bEmptyDir = bEmptyDir;
    }

    public boolean isDirectoryEntry() {
        return this.m_bEmptyDir;
    }

    public void setPermissions(String perms) {
        this.m_perms = perms;
    }

    public void setSize(int size) {
        this.m_size = size;
        this.m_lSize = size;
    }

    public void setSizeEx(long size) {
        this.m_lSize = size;
        this.m_size = (int)size;
    }

    public void setSource(String source) {
        this.m_sourceLoc = source;
    }

    public String getPermissions() {
        return this.m_perms;
    }

    public int getSize() {
        return (int)this.getSizeEx();
    }

    public long getSizeEx() {
        if (this.m_lSize == 0L && this.m_size > 0) {
            this.m_lSize = this.m_size;
        }
        return this.m_lSize;
    }

    void updateFileSizeInfo(OiisFileSizeInfo fsi) {
        String sTargetVolume = this.getTargetVolume();
        if (sTargetVolume != null && sTargetVolume.trim().length() != 0) {
            fsi.updateSize(this.getLangBitSetRefPos(), this.getPlatBitSetRefPos(), sTargetVolume, this.getSizeEx());
        }
    }

    public String getSource() {
        return this.m_sourceLoc;
    }

    public void setAppended(boolean append) {
        this.m_append = append;
    }

    public void setCompressed(boolean compress) {
        this.m_compress = compress;
    }

    public void setInstantiatable(boolean instantiate) {
        this.m_instantiate = instantiate;
    }

    public boolean isAppended() {
        return this.m_append;
    }

    public boolean isCompressed() {
        return this.m_compress;
    }

    public boolean isInstantiatable() {
        return this.m_instantiate;
    }

    public String toString() {
        int i;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[" + this.m_sourceLoc + super.toString() + this.getSizeEx());
        sbuf.append(OiixResourceBundle.getString("S_LOG_PLATS")).append(this.m_platBitSetRefPos);
        sbuf.append("=>[");
        int[] platArr = this.getPlatforms();
        if (platArr != null) {
            for (i = 0; i < platArr.length - 1; ++i) {
                sbuf.append(platArr[i]).append(",");
            }
            if (platArr.length > 0) {
                sbuf.append(platArr[i]);
            }
        }
        sbuf.append("]");
        sbuf.append(OiixResourceBundle.getString("S_LOG_LANGS")).append(this.m_langBitSetRefPos);
        sbuf.append("=>[");
        Locale[] langArr = this.getLanguages();
        if (langArr != null) {
            for (i = 0; i < langArr.length - 1; ++i) {
                sbuf.append(langArr[i]).append(",");
            }
            if (langArr.length > 0) {
                sbuf.append(langArr[i]);
            }
        }
        sbuf.append("]");
        sbuf.append("]");
        sbuf.append(System.getProperty("line.separator"));
        return sbuf.toString();
    }

    public boolean isForAllStagedPlats() {
        return this.m_bForAllStagedPlats;
    }

    public void setForAllStagedPlats(boolean bValidForAllStagedPlats) {
        this.m_bForAllStagedPlats = bValidForAllStagedPlats;
    }

    public OiisFileEntry findMatchingEntry(Vector vEntries) {
        OiisFileEntry oRetEntry = null;
        OiisFileEntry oPotMatchEntry = null;
        if (vEntries != null) {
            Vector vLangs = OiixVectorOps.arrayToVect(this.getLanguages());
            Vector vPlats = OiixVectorOps.arrayToVect(this.getPlatforms());
            Enumeration oAllEntries = vEntries.elements();
            while (oAllEntries.hasMoreElements()) {
                Vector vTgtPlats;
                Vector vTgtLangs;
                OiisFileEntry oAnEntry = (OiisFileEntry)oAllEntries.nextElement();
                if (!oAnEntry.getDestination().equals(this.getDestination()) || !OiixVectorOps.vectorsEqual(vTgtLangs = OiixVectorOps.arrayToVect(oAnEntry.getLanguages()), vLangs) || !OiixVectorOps.vectorSubset(vTgtPlats = OiixVectorOps.arrayToVect(oAnEntry.getPlatforms()), vPlats)) continue;
                if (vTgtPlats.size() == vPlats.size()) {
                    oRetEntry = oAnEntry;
                    break;
                }
                oPotMatchEntry = oAnEntry;
            }
        }
        if (oRetEntry == null && oPotMatchEntry != null) {
            oRetEntry = oPotMatchEntry;
        }
        return oRetEntry;
    }
}

