/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileEntry;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisLangFileGroup;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPathEntry;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisFileMap
implements Serializable {
    static final long serialVersionUID = -164895278713513121L;
    public static final String FILEMAP_FILE = "filemap.ser";
    private Vector m_fGroups;
    private Vector m_lGroups;
    private transient OiixJarClassLoader m_classLoader;
    private OiisPlatIndexMapping m_platIndMap;
    private OiisLangIndexMapping m_langIndMap;
    private transient OiisDestinationIndexMapping m_destIndMap;
    private transient String m_sFileMapPath = "trial/";
    private static final int FILEMAP_OPT_PLATLANG_INFO = 1;
    private int m_iFileMapType = 0;

    public OiisFileMap() {
        this.m_fGroups = new Vector();
        this.m_platIndMap = new OiisPlatIndexMapping();
        this.m_langIndMap = new OiisLangIndexMapping();
    }

    public OiisFileMap(int nGroups, OiisPlatIndexMapping platIndMap, OiisLangIndexMapping langIndMap, OiisDestinationIndexMapping destIndMap) {
        this.m_fGroups = new Vector(nGroups, 5);
        this.m_platIndMap = platIndMap;
        this.m_langIndMap = langIndMap;
        this.m_destIndMap = destIndMap;
        this.m_iFileMapType = 1;
    }

    void setFileMapPath(String sPath) {
        this.m_sFileMapPath = sPath == null ? "" : OiixPathOps.directorify(sPath);
    }

    String getFileMapPath() {
        return this.m_sFileMapPath == null ? "" : this.m_sFileMapPath;
    }

    public OiisPlatIndexMapping getPlatIndexMapping() {
        return this.m_platIndMap;
    }

    public OiisLangIndexMapping getLangIndexMapping() {
        return this.m_langIndMap;
    }

    public OiisDestinationIndexMapping getDestIndexMapping() {
        return this.m_destIndMap;
    }

    public void setPlatIndexMapping(OiisPlatIndexMapping pim) {
        this.m_platIndMap = pim;
    }

    public void setLangIndexMapping(OiisLangIndexMapping lim) {
        this.m_langIndMap = lim;
    }

    public void setDestIndexMapping(OiisDestinationIndexMapping dim) {
        this.m_destIndMap = dim;
    }

    public OiisFileGroup addFileGroup(String name) {
        OiisFileGroup retGp = null;
        if (this.m_fGroups.indexOf(name) == -1) {
            retGp = new OiisFileGroup(name);
            this.m_fGroups.addElement(retGp);
            retGp.setFileMapRef(this);
        }
        return retGp;
    }

    public OiisLangFileGroup addLangFileGroup(String name) {
        OiisLangFileGroup retLgp = null;
        if (this.m_lGroups == null) {
            this.m_lGroups = new Vector(5, 5);
        }
        if (this.m_lGroups.indexOf(name) == -1) {
            retLgp = new OiisLangFileGroup(name);
            this.m_lGroups.addElement(retLgp);
            retLgp.setFileMapRef(this);
        }
        return retLgp;
    }

    public void removeFileGroup(String name) {
        OiisFileGroup gp = null;
        for (int pos = 0; pos < this.m_fGroups.size(); ++pos) {
            gp = (OiisFileGroup)this.m_fGroups.elementAt(pos);
            if (!gp.getName().equals(name)) continue;
            this.m_fGroups.removeElementAt(pos);
            return;
        }
    }

    public void removeLangFileGroup(String name) {
        OiisLangFileGroup lgp = null;
        if (this.m_lGroups == null) {
            return;
        }
        for (int pos = 0; pos < this.m_lGroups.size(); ++pos) {
            lgp = (OiisLangFileGroup)this.m_lGroups.elementAt(pos);
            if (!lgp.getName().equals(name)) continue;
            this.m_lGroups.removeElementAt(pos);
            return;
        }
    }

    public OiisFileGroup getFileGroup(String groupName) {
        OiisFileGroup retGp = null;
        for (int pos = 0; pos < this.m_fGroups.size(); ++pos) {
            retGp = (OiisFileGroup)this.m_fGroups.elementAt(pos);
            if (!retGp.getName().equals(groupName)) continue;
            return retGp;
        }
        return null;
    }

    public OiisLangFileGroup getLangFileGroup(String groupName) {
        OiisLangFileGroup retGp = null;
        if (this.m_lGroups == null) {
            return null;
        }
        for (int pos = 0; pos < this.m_lGroups.size(); ++pos) {
            retGp = (OiisLangFileGroup)this.m_lGroups.elementAt(pos);
            if (!retGp.getName().equals(groupName)) continue;
            return retGp;
        }
        return null;
    }

    public Enumeration getFileGroupNames() {
        Vector<String> names = new Vector<String>();
        Enumeration enum_1 = this.m_fGroups.elements();
        while (enum_1.hasMoreElements()) {
            String name = ((OiisFileGroup)enum_1.nextElement()).getName();
            names.addElement(name);
        }
        return names.elements();
    }

    public Enumeration getLangFileGroupNames() {
        Vector<String> names = new Vector<String>();
        if (this.m_lGroups != null) {
            Enumeration enum_1 = this.m_lGroups.elements();
            while (enum_1.hasMoreElements()) {
                String name = ((OiisLangFileGroup)enum_1.nextElement()).getName();
                names.addElement(name);
            }
        }
        return names.elements();
    }

    public long getSize(int nPlat, Vector langs) {
        long size = 0L;
        for (int i = 0; i < this.m_fGroups.size(); ++i) {
            OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            Vector<Integer> vPlat = new Vector<Integer>();
            vPlat.addElement(new Integer(nPlat));
            size += fg.getSize(langs, vPlat);
        }
        return size;
    }

    public long getSize(Vector langs) {
        long size = 0L;
        for (int i = 0; i < this.m_fGroups.size(); ++i) {
            OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            size += fg.getSize(langs);
        }
        return size;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(OiixResourceBundle.getString("S_LOG_FILEGROUPS"));
        sbuf.append(this.m_fGroups.toString());
        if (this.m_lGroups != null) {
            sbuf.append(OiixResourceBundle.getString("S_LOG_LANG_FILEGROUPS"));
            sbuf.append(this.m_lGroups.toString());
        }
        return sbuf.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.m_iFileMapType != 1) {
            OiisLangIndexMapping newLangIndMap;
            OiisPlatIndexMapping newPlatIndMap = new OiisPlatIndexMapping();
            if (newPlatIndMap.updateFrom(this.m_platIndMap)) {
                this.m_platIndMap = newPlatIndMap;
            }
            if ((newLangIndMap = new OiisLangIndexMapping()).updateFrom(this.m_langIndMap)) {
                this.m_langIndMap = newLangIndMap;
            }
        }
        this.setBackRefs();
        if (this.m_iFileMapType != 1) {
            this.computeSetMappings();
        }
    }

    public void moveLangGpsToReg() {
        if (this.m_lGroups != null) {
            int numLGps = this.m_lGroups.size();
            for (int i = 0; i < numLGps; ++i) {
                OiisLangFileGroup lfg = (OiisLangFileGroup)this.m_lGroups.elementAt(i);
                OiisFileGroup fg = this.addFileGroup(lfg.getName());
                if (fg == null) continue;
                Enumeration sgLocs = lfg.getSubGroupLocales();
                while (sgLocs.hasMoreElements()) {
                    Locale lfgLoc;
                    Locale fgLoc = lfgLoc = (Locale)sgLocs.nextElement();
                    if (lfgLoc.equals(OiixLanguage.OLD_US_ENGLISH)) {
                        fgLoc = OiixLanguage.US_ENGLISH;
                    } else if (lfgLoc.equals(OiixLanguage.OLD_FR_FRENCH)) {
                        fgLoc = OiixLanguage.FR_FRENCH;
                    }
                    Vector<Locale> langsVect = new Vector<Locale>();
                    langsVect.addElement(fgLoc);
                    BitSet lbs = fg.genLangsBitSet(langsVect);
                    int exlPos = fg.indexOfLangBitSet(lbs);
                    BitSet pbs = fg.genPlatAllBitSet();
                    int expPos = fg.indexOfLangBitSet(pbs);
                    OiisFileGroup sgp = lfg.getFileGroup(lfgLoc);
                    Vector sgEntries = sgp.getEntries();
                    int numSgEntries = sgEntries.size();
                    for (int j = 0; j < numSgEntries; ++j) {
                        OiisPathEntry pe = (OiisPathEntry)sgEntries.elementAt(j);
                        if (!(pe instanceof OiisFileEntry)) continue;
                        OiisFileEntry fpe = (OiisFileEntry)pe;
                        fg.addEntry(fpe, lbs, exlPos, pbs, expPos);
                        if (exlPos == -1) {
                            exlPos = fg.indexOfLangBitSet(lbs);
                        }
                        if (expPos != -1) continue;
                        expPos = fg.indexOfPlatBitSet(pbs);
                    }
                }
            }
            this.m_lGroups = null;
        }
    }

    private void setBackRefs() {
        int numFGps = this.m_fGroups.size();
        for (int i = 0; i < numFGps; ++i) {
            OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            fg.setFileMapRef(this);
        }
    }

    public void computeSetMappings() {
        int numFGps = this.m_fGroups.size();
        for (int i = 0; i < numFGps; ++i) {
            OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            fg.computePlatToSetsMapping();
            fg.computeLangToSetsMapping();
        }
    }

    public OiisFileSizeInfo computeFileSizeInfo() {
        if (this.m_iFileMapType == 1) {
            OiisFileSizeInfo fsi = new OiisFileSizeInfo(this.m_platIndMap, this.m_langIndMap, this.m_destIndMap);
            int numFGps = this.m_fGroups.size();
            for (int i = 0; i < numFGps; ++i) {
                OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
                fg.updateFileSizeInfo(fsi);
            }
            return fsi;
        }
        return null;
    }

    public OiisFileSizeInfo computeFileSizeInfo(Vector plats) {
        OiisFileGroup fg;
        int i;
        if (this.m_iFileMapType == 1) {
            return this.computeFileSizeInfo();
        }
        int numFGps = this.m_fGroups.size();
        OiisFileSizeInfo fsi = new OiisFileSizeInfo(this.m_platIndMap, this.m_langIndMap, plats);
        for (i = 0; i < numFGps; ++i) {
            fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            fsi.addFileGroupSetsInfo(fg, plats);
        }
        fsi.initSizesArray();
        for (i = 0; i < numFGps; ++i) {
            fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            fsi.addFileGroupSizeInfo(fg, plats);
        }
        fsi.initMappings();
        return fsi;
    }

    public Vector getFileEntriesList() {
        Vector vFileNames = new Vector(10, 10);
        int nGrps = this.m_fGroups.size();
        for (int i = 0; i < nGrps; ++i) {
            OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            OiixVectorOps.unionInPlace(vFileNames, fg.getFileEntriesList());
        }
        return vFileNames;
    }

    public Vector writeFileMap(String sLocation) throws IOException {
        int size = this.m_fGroups.size();
        Vector fileNames = new Vector();
        for (int i = 0; i < size; ++i) {
            OiisFileGroup fg = (OiisFileGroup)this.m_fGroups.elementAt(i);
            Vector fNames = fg.writeFileEntries(sLocation);
            int nNames = fNames.size();
            for (int j = 0; j < nNames; ++j) {
                fileNames.addElement(fNames.elementAt(j));
            }
        }
        String path = sLocation + File.separator + FILEMAP_FILE;
        FileOutputStream fileOut = new FileOutputStream(path);
        BufferedOutputStream bFileOut = new BufferedOutputStream(fileOut);
        ObjectOutputStream outStream = new ObjectOutputStream(bFileOut);
        outStream.writeObject(this);
        outStream.close();
        bFileOut.close();
        fileOut.close();
        fileNames.addElement(path);
        return fileNames;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        OiisPlatIndexMapping pim = this.m_platIndMap;
        OiisLangIndexMapping lim = this.m_langIndMap;
        if (this.m_iFileMapType == 1) {
            this.m_platIndMap = null;
            this.m_langIndMap = null;
        }
        out.defaultWriteObject();
        if (this.m_iFileMapType == 1) {
            this.m_platIndMap = pim;
            this.m_langIndMap = lim;
        }
    }

    public void setClassLoader(OiixJarClassLoader jcl) {
        this.m_classLoader = jcl;
    }

    public OiixJarClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    int getType() {
        return this.m_iFileMapType;
    }

    void setType(int iType) {
        this.m_iFileMapType = iType;
    }

    public Vector getFileGroupVector() {
        return this.m_fGroups;
    }

    public void setFileGroupVector(Vector vFileGroup) {
        this.m_fGroups = vFileGroup;
    }

    public static void main(String[] argv) throws Exception {
        ObjectInputStream os = new ObjectInputStream(new FileInputStream(argv[0]));
        OiisFileMap oFM = (OiisFileMap)os.readObject();
        os.close();
        System.out.println("Groups:" + oFM.m_fGroups.size());
        System.out.println(oFM.getFileEntriesList());
        System.exit(0);
    }
}

