/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisFileEntriesXMLHandler;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oii.oiis.OiisFileMapXMLHandler;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiisFileMapXMLReader {
    private static OiisFileMapXMLReader m_reader;

    private OiisFileMapXMLReader() {
    }

    static OiisFileMapXMLReader getReader() {
        if (m_reader == null) {
            m_reader = new OiisFileMapXMLReader();
        }
        return m_reader;
    }

    public OiisFileMap readFileMapXML(InputStream is) throws IOException {
        Parser parser = OixsXMLOps.createSAXParser();
        OiisFileMapXMLHandler handler = null;
        OiisFileMap oFileMap = null;
        try {
            handler = new OiisFileMapXMLHandler();
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(is));
            oFileMap = handler.getFileMap();
            return oFileMap;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Exception in reading filemap:" + e.getMessage());
        }
        return oFileMap;
    }

    public Vector readFileEntriesXML(InputStream is) throws IOException {
        Parser parser = OixsXMLOps.createSAXParser();
        OiisFileEntriesXMLHandler entryHandler = null;
        Vector vFileGroup = null;
        try {
            entryHandler = new OiisFileEntriesXMLHandler();
            parser.setDocumentHandler(entryHandler);
            parser.setErrorHandler(entryHandler);
            parser.parse(new InputSource(is));
            vFileGroup = entryHandler.getFileEntryVector();
            return vFileGroup;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return vFileGroup;
        }
    }
}

