/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisInstantiateInfo;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixp.OixpIAttribute;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpXmlParserCreationException;
import oracle.sysman.oix.oixp.OixpXmlParserFactory;

public class OiisGenActionsReader
implements OixpIHandler {
    public static final String INSTANTIATE_LIST = "INSTANTIATE_LIST";
    public static final String COMPONENT_TAG = "COMPONENT";
    public static final String INSTANTIATE_TAG = "INSTANTIATE";
    public static final String SOURCE_TAG = "SOURCE";
    public static final String DESTINATION_TAG = "DESTINATION";
    public static final String REPLACE_VARS_TAG = "REPLACE_VARS";
    public static final String VARIABLE_TAG = "VARIABLE";
    public static final String DELIMITER_TAG = "DELIMITER";
    public static final String NAME_ATT = "NAME";
    public static final String VERSION_ATT = "VERSION";
    public static final String PLATFORMS_ATT = "PLATFORMS";
    public static final String CONDITION_ATT = "CONDITION";
    public static final String FILENAME_ATT = "FILENAME";
    public static final String ACTIONTYPE_ATT = "ACTIONTYPE";
    public static final String SPECIALCHAR_ATT = "SPECIALCHAR";
    public static final String INSTALL = "INSTALL";
    public static final String DEINSTALL = "DEINSTALL";
    public static final String BOTH = "BOTH";
    public static final String NONE = "NONE";
    private String m_sLoc;
    private boolean b_isInstall;
    private OiiiCompInstallID m_oCompInstallID;
    private String m_sCond = "";
    private String m_sCur_action = "BOTH";
    private String m_sSource = "";
    private String m_sDest = "";
    private ArrayList m_VVarsToReplace = null;
    private String m_sDelimiter = "";
    public static ArrayList m_ListInstantiateInfo;

    public OiisGenActionsReader(String loc) {
        this.m_sLoc = loc;
    }

    public OiisGenActionsReader(String loc, boolean isInstall) {
        this.m_sLoc = loc;
        this.b_isInstall = isInstall;
        m_ListInstantiateInfo = new ArrayList();
        this.m_VVarsToReplace = null;
    }

    public String getLoc() {
        return this.m_sLoc;
    }

    public boolean isInstall() {
        return this.b_isInstall;
    }

    public ArrayList getListInstantiates() {
        return m_ListInstantiateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromFile() throws IOException {
        FileInputStream fis;
        block8: {
            block7: {
                fis = null;
                try {
                    try {
                        OixpIXmlParser parser = OixpXmlParserFactory.createXmlParser();
                        File f = new File(this.m_sLoc);
                        if (!f.exists()) {
                            Object var5_8 = null;
                            if (fis == null) return;
                            break block7;
                        }
                        parser.setHandler(this);
                        parser.readXML((OixpIHandler)this, new File(this.m_sLoc));
                        break block8;
                    }
                    catch (OixpXmlParserCreationException xpce) {
                        Object[] args = new String[]{this.m_sLoc, xpce.getMessage()};
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INSTANTIATEFILE_UNABLE_TO_LOAD_XML", args));
                        throw new IOException(xpce.getMessage());
                    }
                    catch (Exception e) {
                        Object[] args = new String[]{this.m_sLoc, e.getMessage()};
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INSTANTIATEFILE_UNABLE_TO_LOAD_XML", args));
                        Object var5_10 = null;
                        if (fis == null) return;
                        fis.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_11 = null;
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
            }
            fis.close();
            return;
        }
        Object var5_9 = null;
        if (fis == null) return;
        fis.close();
    }

    public boolean doStartTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(COMPONENT_TAG)) {
            String sCurrCompName = "";
            String sCurrCompVersion = "0.0.0.0.0";
            String sCurrCompPlat = "ALL_PLATFORMS";
            OixpIAttribute[] retLst = el.getAllAttributes();
            for (int i = 0; i < retLst.length; ++i) {
                String tmp = retLst[i].getName().toUpperCase();
                if (tmp.equals(NAME_ATT)) {
                    sCurrCompName = retLst[i].getValue();
                    continue;
                }
                if (tmp.equals(VERSION_ATT)) {
                    sCurrCompVersion = retLst[i].getValue();
                    continue;
                }
                if (tmp.equals(PLATFORMS_ATT)) {
                    sCurrCompPlat = retLst[i].getValue();
                    continue;
                }
                OiiolTextLogger.appendText("Improper attribute found in COMPONENT TAG");
            }
            this.m_oCompInstallID = new OiiiCompInstallID(sCurrCompName, new OiiiVersion(sCurrCompVersion), OiilXMLHelper.platCommonNames2IntVector(sCurrCompPlat, " ", null));
        } else if (type.equalsIgnoreCase(INSTANTIATE_TAG)) {
            OixpIAttribute[] retLst = el.getAllAttributes();
            for (int i = 0; i < retLst.length; ++i) {
                String tmp = retLst[i].getName().toUpperCase();
                if (tmp.equals(CONDITION_ATT)) {
                    this.m_sCond = retLst[i].getValue();
                    continue;
                }
                if (tmp.equals(ACTIONTYPE_ATT)) {
                    this.m_sCur_action = retLst[i].getValue();
                    continue;
                }
                OiiolTextLogger.appendText("Improper attribute found in INSTANTIATE TAG");
            }
        } else if (type.equalsIgnoreCase(SOURCE_TAG)) {
            this.m_sSource = el.getAttribValue(FILENAME_ATT);
        } else if (type.equalsIgnoreCase(DESTINATION_TAG)) {
            this.m_sDest = el.getAttribValue(FILENAME_ATT);
        } else if (type.equalsIgnoreCase(DELIMITER_TAG)) {
            this.m_sDelimiter = el.getAttribValue(SPECIALCHAR_ATT);
        } else if (type.equalsIgnoreCase(REPLACE_VARS_TAG)) {
            this.m_VVarsToReplace = new ArrayList();
        } else if (type.equalsIgnoreCase(VARIABLE_TAG)) {
            this.m_VVarsToReplace.add(el.getAttribValue(NAME_ATT));
        }
        return false;
    }

    public boolean doText(OixpIElement el, String text) {
        return false;
    }

    public boolean doEndTag(OixpIElement el) {
        String type = el.getType();
        if (type.equalsIgnoreCase(INSTANTIATE_TAG)) {
            OiisInstantiateInfo obj = new OiisInstantiateInfo();
            if (!this.m_sSource.equals("")) {
                obj.setSource(this.m_sSource);
            }
            if (!this.m_sDest.equals("")) {
                obj.setDest(this.m_sDest);
            } else {
                obj.setDest(obj.getSource());
            }
            obj.setCompInstallId(this.m_oCompInstallID);
            if (!this.m_sCond.equals("")) {
                obj.setCondVar(this.m_sCond);
            }
            if (!this.m_sCur_action.equals(BOTH)) {
                if (this.m_sCur_action.equals(INSTALL)) {
                    obj.setActionType(0);
                } else if (this.m_sCur_action.equals(DEINSTALL)) {
                    obj.setActionType(1);
                } else if (this.m_sCur_action.equals(NONE)) {
                    obj.setActionType(3);
                }
            }
            if (this.m_VVarsToReplace != null) {
                obj.setVarsToReplace(this.m_VVarsToReplace);
            }
            if (!this.m_sDelimiter.equals("")) {
                obj.setDelimiter(this.m_sDelimiter);
            }
            if (this.m_sCur_action.equalsIgnoreCase(BOTH) || this.m_sCur_action.equalsIgnoreCase(INSTALL) && this.b_isInstall || this.m_sCur_action.equalsIgnoreCase(DEINSTALL) && !this.b_isInstall) {
                m_ListInstantiateInfo.add(obj);
            } else {
                OiiolTextLogger.appendText("Improper Action Type Found in Parsing" + this.m_sCur_action);
            }
            this.m_sCond = "";
            this.m_sCur_action = BOTH;
            this.m_sSource = "";
            this.m_sDest = "";
            this.m_sDelimiter = "";
            this.m_VVarsToReplace = null;
        } else if (type.equalsIgnoreCase(COMPONENT_TAG)) {
            this.m_oCompInstallID = null;
        }
        return false;
    }
}

