/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisIdentifiersXMLHandler;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiisIdentifiersXMLReader {
    private static OiisIdentifiersXMLReader m_Reader;
    private OiisCompContext m_oContext;

    private OiisIdentifiersXMLReader() {
    }

    public static void loadIdentifiers(String sFile, InputStream iFile, OiisCompContext oContext, OiixJarResourceBundle jrb, boolean bLoadAllVariables) {
        try {
            Parser parser = OixsXMLOps.createSAXParser();
            OiisIdentifiersXMLHandler handler = null;
            try {
                handler = new OiisIdentifiersXMLHandler(oContext, jrb, bLoadAllVariables);
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(new InputSource(iFile));
            }
            catch (SAXException e) {
                e.printStackTrace();
                OiiolTextLogger.appendText("Exception while parsing Identifiers XML " + sFile + " : " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            OiiolTextLogger.appendText("Identifiers XML not found in location " + sFile);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void main(String[] s) {
        OiisIdentifiersXMLReader.loadIdentifiers(s[0], null, new OiisCompContext(), null, false);
    }
}

