/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;

public class OiisLibDeps
implements Serializable,
OiivVerIndMergeCapable {
    private int m_depMap;
    private OiiiLibraryID m_libId;
    private transient boolean m_storedInInv = false;
    private static final String DEPMAP = "depMap";
    private static final String LID = "lid";

    public OiisLibDeps(OiiiLibraryID lid, int depMap) {
        this.m_libId = lid;
        this.m_depMap = depMap;
    }

    public OiisLibDeps(OiivVerIndObjectRep viObj) {
        this.m_storedInInv = true;
        this.m_depMap = (Integer)viObj.getObjectForName(DEPMAP);
        this.m_libId = (OiiiLibraryID)viObj.getObjectForName(LID);
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = null;
        retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        if (this.m_libId != null) {
            retRep.addNVPair(LID, this.m_libId);
        }
        retRep.addNVPair(DEPMAP, new Integer(this.m_depMap));
        return retRep;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals(LID)) {
            return this.m_libId == null ? value == null : this.m_libId.equals(value);
        }
        if (key.equals(DEPMAP)) {
            return this.m_depMap == (Integer)value;
        }
        return false;
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep retRep = vIndObj;
        if (this.m_libId != null) {
            retRep.setNVPair(LID, this.m_libId);
        }
        retRep.setNVPair(DEPMAP, new Integer(this.m_depMap));
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return !this.m_storedInInv;
    }

    public void setDepMap(int depMap) {
        this.m_depMap = depMap;
    }

    public int getDepMap() {
        return this.m_depMap;
    }

    public void addDep(int map) {
        this.m_depMap |= map;
    }

    public void setLibId(OiiiLibraryID lid) {
        this.m_libId = lid;
    }

    public OiiiLibraryID getLibID() {
        return this.m_libId;
    }
}

