/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiObjectInputStream;
import oracle.sysman.oii.oiil.OiilActionArg;
import oracle.sysman.oii.oiil.OiilActionInfo;
import oracle.sysman.oii.oiil.OiilDialogInfo;
import oracle.sysman.oii.oiil.OiilExceptionInfo;
import oracle.sysman.oii.oiil.OiilLibElemInfo;
import oracle.sysman.oii.oiil.OiilLibElemTable;
import oracle.sysman.oii.oiil.OiilLibraryXMLReader;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiisLibraryLoader {
    private OiilLibElemTable m_nameToClassMap;
    private OiixJarClassLoader m_classLoader;
    private Vector extractedNativeClassesList;
    private Vector extractedNativeLibrariesList;
    private String jarFileLocation;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    private static final String S_LIBXML_FILENAME = "library.xml";
    private static final String S_LIBMAP_FILENAME = "library.map";
    private String m_sJarLoc;

    public OiisLibraryLoader(String jarLoc) throws IOException {
        try {
            this.loadLibrary(jarLoc);
            this.m_sJarLoc = jarLoc;
            ResourceBundle rb = OiixJarResourceBundle.extractBundle(this.m_classLoader);
            OiixJarResourceBundle jrb = new OiixJarResourceBundle(rb);
            this.m_nameToClassMap.setResourceBundle(jrb);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected OiisLibraryLoader(String jarLoc, String resJarLoc) throws IOException {
        try {
            this.loadLibrary(jarLoc);
            this.m_sJarLoc = jarLoc;
            ResourceBundle i_rb = OiixJarResourceBundle.extractBundle(this.m_classLoader);
            ResourceBundle x_rb = OiixJarResourceBundle.extractBundle(resJarLoc);
            OiixJarResourceBundle jrb = new OiixJarResourceBundle(x_rb);
            jrb.addResourceBundle(i_rb);
            this.m_nameToClassMap.setResourceBundle(jrb);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    private void loadLibrary(String jarLoc) throws IOException {
        this.m_classLoader = OiixJarClassLoader.createLoader(jarLoc);
        try {
            this.m_nameToClassMap = this.m_classLoader.entryExists(S_LIBXML_FILENAME) ? this.loadLibraryXML() : this.loadLibraryMap();
            File f = new File(OiixPathOps.getNativeForm(jarLoc));
            this.jarFileLocation = f.getParent();
            if (this.jarFileLocation == null) {
                this.jarFileLocation = ".";
            }
            this.extractedNativeClassesList = new Vector(1);
            this.extractedNativeLibrariesList = new Vector(1);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected Class loadClass(String name, int platform) throws ClassNotFoundException, IOException, OiifbCancelException {
        Properties pp = System.getProperties();
        String destination = pp.getProperty("oracle.installer.scratchPath");
        this.extractNativeClass(name, platform, destination);
        this.extractNativeLibrary(name, platform, destination);
        pp = System.getProperties();
        pp.put("oracle.installer.NatLibDir", destination + File.separatorChar);
        OiilActionInfo acInfo = (OiilActionInfo)this.m_nameToClassMap.getTableElement(name);
        if (acInfo == null) {
            return null;
        }
        String clName = acInfo.getActionClassName(platform);
        if (clName == null) {
            return null;
        }
        return this.m_classLoader.loadClass(clName);
    }

    public void unload() {
        OiixJarClassLoader.forgetLoader(this.m_sJarLoc);
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        OiilDialogInfo dlgInfo = (OiilDialogInfo)this.m_nameToClassMap.getTableElement(name);
        if (dlgInfo == null) {
            throw new ClassNotFoundException(name);
        }
        String clName = dlgInfo.getDialogClassName();
        return this.m_classLoader.loadClass(clName);
    }

    protected void extractNativeClass(String name, int platform, String location) throws IOException, OiifbCancelException {
        OiilActionInfo acInfo = (OiilActionInfo)this.m_nameToClassMap.getTableElement(name);
        if (acInfo == null) {
            return;
        }
        String[] clName = acInfo.getNativeClassNames(platform);
        if (clName == null) {
            return;
        }
        for (int i = 0; i < clName.length; ++i) {
            if (clName[i] == null) {
                return;
            }
            if (this.extractedNativeClassesList.contains(clName[i])) {
                return;
            }
            String classFileName = clName[i].replace('.', '/') + ".class";
            String locStd = OiixPathOps.concatPath(OiixPathOps.getStandardForm(location), classFileName);
            String loc = OiixPathOps.getNativeForm(locStd);
            File f = new File(loc);
            String baseDir = f.getParent();
            File f1 = new File(baseDir);
            OiixFileOps.mkdirs(f1);
            this.m_classLoader.extractClass(clName[i], loc, true);
            this.extractedNativeClassesList.addElement(clName[i]);
        }
    }

    protected void extractNativeLibrary(String name, int platform, String location) throws IOException, OiifbCancelException {
        OiilActionInfo acInfo = (OiilActionInfo)this.m_nameToClassMap.getTableElement(name);
        if (acInfo == null) {
            return;
        }
        String[] libNames = acInfo.getNativeLibraryNames(platform);
        if (libNames == null) {
            return;
        }
        for (int i = 0; i < libNames.length; ++i) {
            if (libNames[i] == null || this.extractedNativeLibrariesList.contains(libNames[i])) continue;
            String sLibName = OiixPathOps.getFileName(OiixPathOps.getStandardForm(libNames[i]));
            String loc = OiixPathOps.concatPath(OiixPathOps.getStandardForm(location), sLibName);
            loc = OiixPathOps.getNativeForm(loc);
            this.m_classLoader.extractFile(libNames[i], loc, true);
            if (OiipgBootstrap.isNatLibExecNeeded()) {
                OiipgBootstrap.setUnixPermissions(loc, 511);
            }
            this.extractedNativeLibrariesList.addElement(libNames[i]);
        }
    }

    private OiilLibElemTable loadLibraryMap() throws IOException, StreamCorruptedException, OptionalDataException, ClassNotFoundException {
        InputStream is = this.m_classLoader.getLocalResourceAsStream(S_LIBMAP_FILENAME);
        OiiiObjectInputStream ois = new OiiiObjectInputStream(is);
        OiilLibElemTable retMap = (OiilLibElemTable)ois.readObject();
        is.close();
        return retMap;
    }

    private OiilLibElemTable loadLibraryXML() throws IOException, StreamCorruptedException, OptionalDataException {
        InputStream is = this.m_classLoader.getLocalResourceAsStream(S_LIBXML_FILENAME);
        InputStreamReader iReader = new InputStreamReader(is, "UTF-8");
        BufferedReader buffReader = new BufferedReader(iReader);
        OiilLibElemTable retMap = OiilLibraryXMLReader.getLibraryTable(buffReader);
        buffReader.close();
        iReader.close();
        is.close();
        return retMap;
    }

    public OiiiLibraryID getLibraryID() {
        return this.m_nameToClassMap.getLibraryID();
    }

    public OiilLibElemTable getLibraryMap() {
        return this.m_nameToClassMap;
    }

    public boolean isActionAvailable(String name, int platform) {
        OiilLibElemInfo elemInfo = this.m_nameToClassMap.getTableElement(name);
        if (elemInfo instanceof OiilActionInfo) {
            OiilActionInfo aInfo = (OiilActionInfo)elemInfo;
            return aInfo.isActionSupportedOnPlatform(platform);
        }
        return false;
    }

    public boolean isFileAvailable(String name) {
        return this.m_classLoader.entryExists(name);
    }

    public String getJarLoc() {
        return this.m_sJarLoc;
    }

    public void setJarLoc(String sJarLoc) {
        this.m_sJarLoc = sJarLoc;
    }

    public static void main(String[] argv) {
        Locale lc = Locale.getDefault();
        String libJar = argv[0];
        if (argv.length > 1) {
            String lang = argv[1];
            String country = "";
            if (argv.length > 2) {
                country = argv[2];
            }
            Locale.setDefault(new Locale(lang, country));
        }
        System.out.println("Locale is " + Locale.getDefault());
        try {
            System.out.println("Library jar is + " + argv[0]);
            System.out.println("");
            OiisActionLibLoader ll = new OiisActionLibLoader(argv[0]);
            OiilLibElemTable libmap = ll.getLibraryMap();
            Enumeration libent = libmap.getAllElements();
            while (libent.hasMoreElements()) {
                OiilActionInfo ai = (OiilActionInfo)libent.nextElement();
                System.out.println(ai.getInternalName() + " is " + ai.getName());
                OiilActionArg arg = ai.getArgument(0);
                System.out.println("Arg" + arg.getInternalName() + " is " + arg.getName());
                System.out.println("Arg Description is " + arg.getDescription());
                OiilExceptionInfo ex = ai.getException(0);
                System.out.println("Exception NAME: " + ex.getExceptionName());
                System.out.println("Exception STRING: " + ex.getExceptionString());
                System.out.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

