/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisMakeConfigReader;
import oracle.sysman.oii.oiis.OiisMakeConfigWriter;
import oracle.sysman.oii.oiis.OiisTargetStructure;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiisMakeConfig {
    private static final String sMake = "makeorder.xml";
    public static String sOHLoc = "";
    private ArrayList m_targetStructure;
    private static OiisMakeConfig s_MakeConfig = null;

    public String getMakeXMLLocation() {
        String makedir = OiiiInstallAreaControl.getMakeDirForHome(sOHLoc);
        File f = new File(makedir);
        if (!f.exists()) {
            f.mkdir();
        }
        String sLoc = OiixPathOps.concatPath(makedir, sMake);
        sLoc = OiixPathOps.getNativeForm(sLoc);
        return sLoc;
    }

    public ArrayList getTargetStructure() {
        return this.m_targetStructure;
    }

    public String getOHome() {
        return sOHLoc;
    }

    public void saveToFile(ArrayList args) {
        for (int i = 0; i < args.size(); ++i) {
            OiisTargetStructure ts = (OiisTargetStructure)args.get(i);
            String fileName = ts.getFilename();
            ts.setFilename(fileName.replaceFirst(sOHLoc + File.separator, ""));
            args.set(i, ts);
        }
        ArrayList<OiisTargetStructure> tgtList = new ArrayList<OiisTargetStructure>();
        for (int i = 0; i < args.size(); ++i) {
            OiisTargetStructure ts = (OiisTargetStructure)args.get(i);
            String st = ts.getTarget();
            if (st != null) {
                StringTokenizer parseTgt = new StringTokenizer(st);
                while (parseTgt.hasMoreTokens()) {
                    try {
                        OiisTargetStructure tNew = ts.returnClone();
                        tNew.setTarget(parseTgt.nextToken());
                        tgtList.add(tNew);
                    }
                    catch (Exception e) {
                        OiiolTextLogger.appendException(e);
                    }
                }
                continue;
            }
            tgtList.add(ts);
        }
        try {
            OiisMakeConfigReader mc_Reader = new OiisMakeConfigReader(this.getMakeXMLLocation(), tgtList);
            this.m_targetStructure = mc_Reader.parseMakeXML();
            OiisMakeConfigWriter mc_Writer = new OiisMakeConfigWriter(this.getMakeXMLLocation(), this.m_targetStructure);
            mc_Writer.saveMakeXML();
        }
        catch (IOException e) {
            String sMsg = e.getMessage();
            OiiolTextLogger.appendText(sMsg);
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
        }
    }
}

