/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIDCreator;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiiv.OiivVerIndCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;

public class OiisPatchDepObj
implements Serializable,
OiivVerIndCapable {
    static final long serialVersionUID = -9019480533289194807L;
    private OiiiCompInstallID m_origDepId;
    private boolean m_verUpgraded;
    private OiiiCompInstallID m_curDepId;
    private transient boolean m_bWasCreated;

    public OiisPatchDepObj(OiiiCompInstallID origDepId) {
        this(origDepId, null);
    }

    public OiisPatchDepObj(OiiiCompInstallID origDepId, OiiiCompInstallID curDepId) {
        this.m_origDepId = origDepId;
        if (curDepId != null) {
            this.setCurDepId(curDepId);
        } else {
            this.m_verUpgraded = false;
        }
        this.m_bWasCreated = true;
    }

    public OiisPatchDepObj(OiivVerIndObjectRep vIndObj) {
        this.m_origDepId = OiiiCompIDCreator.getInstallID(vIndObj, "origDepID", "origDepIDMoreInfo");
        this.m_curDepId = OiiiCompIDCreator.getInstallID(vIndObj, "curDepID", "curDepIDMoreInfo");
        this.m_verUpgraded = (Boolean)vIndObj.getObjectForName("upgrade");
        this.m_bWasCreated = false;
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        retRep.addNVPair("origDepID", this.m_origDepId.getIDAsCompID());
        Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_origDepId.getAdditionalInfo());
        retRep.addNVPair("origDepIDMoreInfo", additionalInfo);
        if (this.m_curDepId != null) {
            retRep.addNVPair("curDepID", this.m_curDepId.getIDAsCompID());
            additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_curDepId.getAdditionalInfo());
            retRep.addNVPair("curDepIDMoreInfo", additionalInfo);
        }
        retRep.addNVPair("upgrade", new Boolean(this.m_verUpgraded));
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return this.m_bWasCreated;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals("origDepID")) {
            return this.m_origDepId.getIDAsCompID().equals(value);
        }
        if (key.equals("curDepID")) {
            if (this.m_curDepId != null) {
                return this.m_curDepId.getIDAsCompID().equals(value);
            }
            return false;
        }
        if (key.equals("upgrade")) {
            return (Boolean)value == this.m_verUpgraded;
        }
        return false;
    }

    public OiiiCompInstallID getOrigDepId() {
        return this.m_origDepId;
    }

    public boolean isVerUpgraded() {
        return this.m_verUpgraded;
    }

    public OiiiCompInstallID getCurDepId() {
        if (this.m_verUpgraded) {
            return this.m_curDepId;
        }
        return this.m_origDepId;
    }

    public void setCurDepId(OiiiCompInstallID curDepId) throws IllegalArgumentException {
        if (!this.m_origDepId.equals(curDepId)) {
            if (!this.m_origDepId.getName().equals(curDepId.getName()) || !curDepId.getVersion().laterThan(this.m_origDepId.getVersion())) {
                throw new IllegalArgumentException(curDepId + " !> " + this.m_origDepId);
            }
            this.m_verUpgraded = true;
            this.m_curDepId = curDepId;
        } else {
            this.m_verUpgraded = false;
        }
    }

    public String toString() {
        if (this.m_curDepId != null) {
            return "[" + this.m_curDepId.toString() + "]" + "[" + this.m_verUpgraded + "]";
        }
        return "[" + this.m_origDepId.toString() + "]" + "[" + this.m_verUpgraded + "]";
    }
}

