/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisPatchDepObj;
import oracle.sysman.oii.oiiv.OiivVerIndCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisPatchDeps
implements Serializable,
OiivVerIndCapable {
    static final long serialVersionUID = -304715800480749438L;
    private Vector m_depObjs;
    private transient boolean m_bWasCreated;

    public OiisPatchDeps() {
        this.m_depObjs = new Vector(5, 2);
        this.m_bWasCreated = true;
    }

    public OiisPatchDeps(OiivVerIndObjectRep vIndObj) {
        Vector verIndDeps = (Vector)vIndObj.getObjectForName("patchDeps");
        this.m_depObjs = OiivVerIndObjectRep.getVerDepFormOfVect(verIndDeps);
        this.m_bWasCreated = false;
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        Vector verIndDeps = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_depObjs);
        retRep.addNVPair("patchDeps", verIndDeps);
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return this.m_bWasCreated;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals("patchDeps")) {
            Vector vdDeps = OiivVerIndObjectRep.getVerDepFormOfVect((Vector)value);
            return OiixVectorOps.vectorsEqual(this.m_depObjs, vdDeps);
        }
        return false;
    }

    public OiisPatchDepObj getDepObj(String intName) {
        OiisPatchDepObj retObj = null;
        int numDeps = this.m_depObjs.size();
        for (int i = 0; i < numDeps; ++i) {
            OiisPatchDepObj pdObj = (OiisPatchDepObj)this.m_depObjs.elementAt(i);
            if (!pdObj.getCurDepId().getName().equals(intName)) continue;
            retObj = pdObj;
            break;
        }
        return retObj;
    }

    public void addDepObj(OiisPatchDepObj pdObj) {
        this.m_depObjs.addElement(pdObj);
    }

    public void removeDepObj(OiisPatchDepObj pdObj) {
        this.m_depObjs.removeElement(pdObj);
    }

    public Vector getDepObjs() {
        return this.m_depObjs;
    }

    public void setDepObjs(Vector depObjs) {
        this.m_depObjs = depObjs;
    }

    public Vector getDependeeIDs() {
        Vector<OiiiCompInstallID> depIDs = new Vector<OiiiCompInstallID>();
        int numDeps = this.m_depObjs != null ? this.m_depObjs.size() : 0;
        for (int i = 0; i < numDeps; ++i) {
            OiisPatchDepObj depObj = (OiisPatchDepObj)this.m_depObjs.elementAt(i);
            depIDs.addElement(depObj.getCurDepId());
        }
        return depIDs;
    }

    public String toString() {
        if (this.m_depObjs != null) {
            return this.m_depObjs.toString();
        }
        return "[]";
    }
}

