/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIDCreator;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisPatchSetContents
implements Serializable,
OiivVerIndMergeCapable {
    static final long serialVersionUID = -7815872986403179684L;
    private transient boolean m_storedInInv = false;
    private Vector m_containedPatches;

    public OiisPatchSetContents(Vector containedPatches) {
        this.setContainedPatches(containedPatches);
    }

    public OiisPatchSetContents(OiivVerIndObjectRep viObj) {
        this.m_storedInInv = true;
        Vector vPatchSetContents = (Vector)viObj.getObjectForName("patchsetContents");
        if (vPatchSetContents != null) {
            int iSize = vPatchSetContents.size();
            this.m_containedPatches = new Vector(iSize);
            for (int i = 0; i < iSize; ++i) {
                OiivVerIndObjectRep oVerIndPatchID = (OiivVerIndObjectRep)vPatchSetContents.elementAt(i);
                OiiiCompInstallID cid = OiiiCompIDCreator.getInstallID(oVerIndPatchID, "cid", "cidMoreInfo");
                this.m_containedPatches.addElement(cid);
            }
        }
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = null;
        Vector<OiivVerIndObjectRep> vPatchSetContents = null;
        if (this.m_containedPatches != null) {
            int iSize = this.m_containedPatches.size();
            vPatchSetContents = new Vector<OiivVerIndObjectRep>(iSize);
            for (int i = 0; i < iSize; ++i) {
                OiiiCompInstallID cid = (OiiiCompInstallID)this.m_containedPatches.elementAt(i);
                retRep = new OiivVerIndObjectRep();
                retRep.setClassName(cid.getClass().getName());
                retRep.addNVPair("cid", cid.getIDAsCompID());
                Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(cid.getAdditionalInfo());
                retRep.addNVPair("cidMoreInfo", additionalInfo);
                vPatchSetContents.addElement(retRep);
            }
        }
        retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        retRep.addNVPair("patchsetContents", vPatchSetContents);
        return retRep;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals("patchsetContents")) {
            return this.m_containedPatches == null ? value == null : this.m_containedPatches.equals(value);
        }
        return false;
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep retRep = vIndObj;
        Vector<OiivVerIndObjectRep> vPatchSetContents = null;
        if (this.m_containedPatches != null) {
            int iSize = this.m_containedPatches.size();
            vPatchSetContents = new Vector<OiivVerIndObjectRep>(iSize);
            for (int i = 0; i < iSize; ++i) {
                OiiiCompInstallID cid = (OiiiCompInstallID)this.m_containedPatches.elementAt(i);
                retRep = new OiivVerIndObjectRep();
                retRep.setClassName(cid.getClass().getName());
                retRep.addNVPair("cid", cid.getIDAsCompID());
                Vector additionalInfo = OiivVerIndObjectRep.getVerIndepFormOfVect(cid.getAdditionalInfo());
                retRep.addNVPair("cidMoreInfo", additionalInfo);
                vPatchSetContents.addElement(retRep);
            }
        }
        retRep.setNVPair("patchsetContents", vPatchSetContents);
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return !this.m_storedInInv;
    }

    public Vector getContainedPatches() {
        return this.m_containedPatches;
    }

    public void setContainedPatches(Vector containedPatches) {
        this.m_containedPatches = containedPatches;
    }

    public void addPatch(OiiiPatchInstallID pid) {
        int pindex;
        if (this.m_containedPatches == null) {
            this.m_containedPatches = new Vector();
        }
        if ((pindex = OiixVectorOps.vectIndexOf(this.m_containedPatches, (Object)pid)) == -1) {
            this.m_containedPatches.addElement(pid);
        }
    }

    public void removePatch(OiiiPatchInstallID pid) {
        int pindex = -1;
        if (this.m_containedPatches != null) {
            pindex = OiixVectorOps.vectIndexOf(this.m_containedPatches, (Object)pid);
        }
        if (pindex == -1) {
            this.m_containedPatches.removeElementAt(pindex);
        }
    }

    public String toString() {
        return "[Patches :" + OiixVectorOps.objToString(this.m_containedPatches) + "]";
    }
}

