/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import oracle.sysman.oii.oiix.OiixPathOps;

public abstract class OiisPathEntry
implements Serializable {
    static final long serialVersionUID = -1770220786055744327L;
    private String m_destPath;
    private transient String m_sTargetVolume;

    public OiisPathEntry(String dest) {
        this.m_destPath = dest;
        this.m_sTargetVolume = null;
    }

    public String getDestination() {
        return this.m_destPath;
    }

    public void setDestination(String dest) {
        this.m_destPath = dest;
    }

    public String getTargetVolume() {
        if (this.m_sTargetVolume == null) {
            this.m_sTargetVolume = OiisPathEntry.getTargetVolume(this.m_destPath);
        }
        return this.m_sTargetVolume;
    }

    void setTargetVolume(String sTargetVolume) {
        this.m_sTargetVolume = sTargetVolume;
    }

    public static String getTargetVolume(String sDest) {
        String sTargetVolume = null;
        if (sDest == null || sDest.trim().length() == 0) {
            return null;
        }
        if ((sDest = OiixPathOps.getStandardForm(sDest)).startsWith("/")) {
            if (sDest.length() > 1) {
                int idx = sDest.indexOf("/", 1);
                sTargetVolume = sDest.substring(0, idx);
            } else {
                sTargetVolume = sDest;
            }
        } else {
            int idx = sDest.indexOf("/", 0);
            if (idx != -1) {
                sTargetVolume = sDest.substring(0, idx);
            }
        }
        return sTargetVolume;
    }

    public boolean equals(String dest) {
        return this.m_destPath.equals(dest);
    }

    protected int getSize() {
        return 0;
    }

    public String toString() {
        return " ->" + this.m_destPath + " ";
    }
}

