/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;
import oracle.sysman.oii.oiiv.OiivVerIndCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiisPlatIndexMapping
implements Serializable,
Cloneable,
OiivVerIndCapable {
    static final long serialVersionUID = 4823480249598900492L;
    private int[] m_platArr;
    private Vector m_vPlatSets;
    private transient int[] m_aiCurPlatToPlatSetMapping;
    private boolean m_bCreatedInThisSession;
    private static final String S_PLATFORMS = "platforms";
    private static final String S_PLAT_SETS = "platsets";

    public OiisPlatIndexMapping() {
        this(new int[0]);
    }

    public OiisPlatIndexMapping(int[] aiPlats) {
        if (aiPlats != null) {
            this.m_platArr = new int[aiPlats.length];
            System.arraycopy(aiPlats, 0, this.m_platArr, 0, aiPlats.length);
        } else {
            this.m_platArr = new int[0];
        }
        this.m_vPlatSets = new Vector(5, 5);
        this.addPlatSet(null);
        this.m_bCreatedInThisSession = true;
    }

    public OiisPlatIndexMapping(OiivVerIndObjectRep objRep) {
        this.m_platArr = (int[])objRep.getObjectForName(S_PLATFORMS);
        Vector vivect = (Vector)objRep.getObjectForName(S_PLAT_SETS);
        this.m_vPlatSets = OiivVerIndObjectRep.getVerDepFormOfVect(vivect);
        this.m_bCreatedInThisSession = false;
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep obj = new OiivVerIndObjectRep();
        obj.addNVPair(S_PLATFORMS, this.m_platArr);
        Vector vivect = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_vPlatSets);
        obj.addNVPair(S_PLAT_SETS, vivect);
        return obj;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals(S_PLATFORMS)) {
            return this.m_platArr.equals(value);
        }
        if (key.equals(S_PLAT_SETS)) {
            return this.m_vPlatSets.equals(value);
        }
        return false;
    }

    public boolean wasCreatedInThisSession() {
        return this.m_bCreatedInThisSession;
    }

    public int[] getPlats() {
        return this.m_platArr;
    }

    public Vector getPlatSets() {
        return this.m_vPlatSets;
    }

    public boolean updateFrom(OiisPlatIndexMapping oldMapping) {
        boolean anyChanges = false;
        int[] curPlats = OiixPlatform.getPlatforms();
        if (oldMapping == null) {
            anyChanges = true;
        } else {
            Vector<Integer> newPlats = new Vector<Integer>();
            for (int i = 0; i < curPlats.length; ++i) {
                if (oldMapping.indexOfPlat(curPlats[i]) != -1) continue;
                newPlats.addElement(new Integer(curPlats[i]));
            }
            int numAddPlats = newPlats.size();
            int[] oldPlats = oldMapping.getPlats();
            this.m_platArr = new int[oldPlats.length + numAddPlats];
            System.arraycopy(oldPlats, 0, this.m_platArr, 0, oldPlats.length);
            if (numAddPlats != 0) {
                anyChanges = true;
                int oldLen = oldPlats.length;
                for (int i = 0; i < numAddPlats; ++i) {
                    this.m_platArr[oldLen + i] = (Integer)newPlats.elementAt(i);
                }
            }
        }
        return anyChanges;
    }

    public int indexOfPlat(int platID) {
        int retInd = -1;
        int numPlats = this.m_platArr.length;
        for (int i = 0; i < numPlats; ++i) {
            if (this.m_platArr[i] != platID) continue;
            retInd = i;
            break;
        }
        return retInd;
    }

    public void addPlat(int platID) {
        int[] tmpPlatArr = new int[this.m_platArr.length + 1];
        System.arraycopy(this.m_platArr, 0, tmpPlatArr, 0, this.m_platArr.length);
        tmpPlatArr[tmpPlatArr.length - 1] = platID;
        this.m_platArr = tmpPlatArr;
    }

    public void addPlats(int[] platIDs) {
        if (platIDs == null) {
            return;
        }
        int[] tmpPlatArr = new int[this.m_platArr.length + platIDs.length];
        System.arraycopy(this.m_platArr, 0, tmpPlatArr, 0, this.m_platArr.length);
        System.arraycopy(platIDs, 0, tmpPlatArr, this.m_platArr.length, platIDs.length);
        this.m_platArr = tmpPlatArr;
    }

    public BitSet genPlatsBitSet(Vector plats) {
        return this.genPlatsBitSet(plats, false);
    }

    public BitSet genPlatsBitSet(Vector plats, boolean bAddPlats) {
        BitSet retBs = null;
        if (plats == null) {
            retBs = this.genPlatAllBitSet();
        } else {
            int i;
            int numFPlats = plats.size();
            int[] aiNewPlats = new int[numFPlats];
            int[] aiPlatsIdx = new int[numFPlats];
            int nNewPlats = 0;
            for (i = 0; i < numFPlats; ++i) {
                int platID = (Integer)plats.elementAt(i);
                aiPlatsIdx[i] = this.indexOfPlat(platID);
                if (aiPlatsIdx[i] != -1 || !bAddPlats) continue;
                aiNewPlats[nNewPlats] = platID;
                aiPlatsIdx[i] = this.m_platArr.length + ++nNewPlats;
            }
            if (bAddPlats & nNewPlats > 0) {
                int[] aiTmpNewPlats = new int[nNewPlats];
                System.arraycopy(aiNewPlats, 0, aiTmpNewPlats, 0, nNewPlats);
                this.addPlats(aiTmpNewPlats);
            }
            retBs = new BitSet(this.m_platArr.length);
            for (i = 0; i < aiPlatsIdx.length; ++i) {
                if (aiPlatsIdx[i] == -1) continue;
                retBs.set(aiPlatsIdx[i]);
            }
        }
        return retBs;
    }

    public BitSet genPlatAllBitSet() {
        return null;
    }

    public int indexOfPlatBitSet(BitSet bs) {
        int exPos = -1;
        if (OiisPlatIndexMapping.isPlatAllBitSet(bs)) {
            int numPS = this.m_vPlatSets.size();
            for (int i = 0; i < numPS; ++i) {
                BitSet exBS = (BitSet)this.m_vPlatSets.elementAt(i);
                if (!OiisPlatIndexMapping.isPlatAllBitSet(exBS)) continue;
                exPos = i;
                break;
            }
        } else {
            exPos = this.m_vPlatSets.indexOf(bs);
        }
        return exPos;
    }

    public int addPlatSet(BitSet pbs) {
        int idx = this.indexOfPlatBitSet(pbs);
        if (idx == -1) {
            idx = this.m_vPlatSets.size();
            this.m_vPlatSets.addElement(pbs);
        }
        return idx;
    }

    public static boolean isPlatAllBitSet(BitSet bs) {
        return bs == null;
    }

    public int[] getRelevantPlatSetList() {
        if (this.m_aiCurPlatToPlatSetMapping == null) {
            this.m_aiCurPlatToPlatSetMapping = this.getRelevantPlatSetList(OiixPlatform.getCurrentPlatform());
        }
        return this.m_aiCurPlatToPlatSetMapping;
    }

    public int[] getRelevantPlatSetList(Vector plats) {
        int nPlatSets = this.m_vPlatSets.size();
        int[] aiPlatSets = new int[nPlatSets];
        if (plats == null) {
            for (int i = 0; i < nPlatSets; ++i) {
                aiPlatSets[i] = i;
            }
        } else {
            BitSet bs = this.genPlatsBitSet(plats, false);
            int nCnt = 0;
            for (int i = 0; i < nPlatSets; ++i) {
                BitSet bsPS = (BitSet)this.m_vPlatSets.elementAt(i);
                BitSet bsClone = (BitSet)bs.clone();
                if (!OiisPlatIndexMapping.isPlatAllBitSet(bsPS)) {
                    bsClone.and(bsPS);
                }
                if (bsClone.length() == 0) continue;
                aiPlatSets[nCnt] = i;
                ++nCnt;
            }
            if (nCnt > 0) {
                int[] aiTmpPlatSets = new int[nCnt];
                System.arraycopy(aiPlatSets, 0, aiTmpPlatSets, 0, nCnt);
                aiPlatSets = aiTmpPlatSets;
            }
        }
        return aiPlatSets;
    }

    public int[] getRelevantPlatSetList(int platform) {
        Vector<Integer> vPlats = new Vector<Integer>(1);
        vPlats.addElement(new Integer(platform));
        return this.getRelevantPlatSetList(vPlats);
    }

    public Vector getRelevantPlatSets(Vector plats) {
        int[] setList = this.getRelevantPlatSetList(plats);
        Vector retSets = new Vector(setList.length);
        for (int i = 0; i < setList.length; ++i) {
            retSets.addElement(this.m_vPlatSets.elementAt(setList[i]));
        }
        return retSets;
    }

    public int[] getPlatsForPlatSet(BitSet bsPS) {
        Vector vPlats = new Vector(this.m_platArr.length, 5);
        if (OiisPlatIndexMapping.isPlatAllBitSet(bsPS)) {
            return this.m_platArr;
        }
        int numSetPlats = 0;
        int bsSize = bsPS.length();
        for (int i = 0; i < bsSize; ++i) {
            if (!bsPS.get(i)) continue;
            ++numSetPlats;
        }
        int[] plats = new int[numSetPlats];
        int nCtr = 0;
        int nMaxSize = Math.min(this.m_platArr.length, bsSize);
        for (int i = 0; i < nMaxSize; ++i) {
            if (!bsPS.get(i)) continue;
            plats[nCtr++] = this.m_platArr[i];
        }
        return plats;
    }

    public int[] getPlatsForPlatSetIndex(int idx) {
        if (idx < 0 || idx > this.m_vPlatSets.size()) {
            return null;
        }
        BitSet bsPS = (BitSet)this.m_vPlatSets.elementAt(idx);
        return this.getPlatsForPlatSet(bsPS);
    }

    public BitSet getPlatSetForIndex(int idx) {
        return (BitSet)this.m_vPlatSets.elementAt(idx);
    }

    public Object clone() {
        OiisPlatIndexMapping oClone = null;
        try {
            oClone = (OiisPlatIndexMapping)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return oClone;
    }

    public String toString() {
        int i;
        StringBuffer sbuf = new StringBuffer();
        for (i = 0; i < this.m_platArr.length - 1; ++i) {
            sbuf.append("[" + i + "=>" + this.m_platArr[i] + "]");
            sbuf.append(",");
        }
        sbuf.append("[" + i + "=>" + this.m_platArr[i] + "]");
        return sbuf.toString();
    }

    public static void main(String[] args) {
        OiisPlatIndexMapping pim = new OiisPlatIndexMapping();
        System.out.println(pim.toString());
    }
}

