/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixRetryException;

public class OiisPreRequisiteVar
extends OiisVariable {
    protected OiisCompContext component;
    private String m_sErrorMessage;
    private int m_nErrorID;
    public static final int SUCCESS = 0;
    public static final int FAIL = 1;
    public static final int UNSELECT = 2;
    public static final int REMOVE = 3;
    private static String LOG_VAR_RESOURCE_PREREQ = "S_LOG_SETTING_PREREQ_VAR_VALUE";

    public OiisPreRequisiteVar() {
        super(null, "PRE_REQUISITE");
        this.setFailureID(2);
    }

    public void setOwner(OiisVariableOwner owner) {
        this.m_owner = owner;
        this.component = (OiisCompContext)owner;
    }

    public void init(OiisVariableOwner owner, OiiiCompInstallID id, OiicInstallSession oSession) {
        this.init(owner, id, (OiicPullSession)oSession);
    }

    public void init(OiisVariableOwner owner, OiiiCompInstallID id, OiicPullSession oSession) {
        this.m_owner = owner;
        this.component = new OiisCompContext();
        this.component.setParContext(owner);
        this.component.init(id, oSession);
    }

    public String getFailureMessage() {
        return this.m_sErrorMessage;
    }

    public void setFailureMessage(String sMsg) {
        this.m_sErrorMessage = sMsg;
    }

    public int getFailureID() {
        return this.m_nErrorID;
    }

    public void setFailureID(int id) {
        this.m_nErrorID = id;
    }

    public OiisAdvisedValue getCalculatedValue() throws OiisVarSettingException, OiifbCancelException {
        if (this.isCalcMethodPresent()) {
            try {
                return this.component.getCalculatedValue(this.getName());
            }
            catch (OiixRetryException re) {
                return this.getCalculatedValue();
            }
        }
        return new OiisAdvisedValue(new Boolean(true), true);
    }

    protected void logValue(Object val) {
        if (val != null && this.isCalcMethodPresent() && this.isPreReqSpecified()) {
            String sValue = val.toString();
            OiiiCompInstallID oID = this.component.getCompInstallID();
            Object[] args = new Object[]{oID.getName(), oID.getVersion().toString(), sValue, this.getValueTypeLogString()};
            OiiolTextLogger.appendText(OiixResourceBundle.getString(LOG_VAR_RESOURCE_PREREQ, args), OiiolTextLogger.LOG_BASIC);
        }
    }

    private boolean isPreReqSpecified() {
        OiiiStageInventory stageInv = this.m_owner.getSession().getSourceAccess().getStageInventory();
        OiiiStageCompInvEntry sc = stageInv.getStageCompInvEntry(this.component.getCompInstallID());
        if (sc != null) {
            return !sc.isNoPreReq();
        }
        return true;
    }
}

