/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.MissingResourceException;
import oracle.sysman.oii.oiii.OiiiReadmeID;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiisReadmeDetails
implements Serializable,
OiivVerIndMergeCapable {
    static final long serialVersionUID = 810308377396792619L;
    OiiiReadmeID m_readmeID;
    String m_externalName;
    String m_description;
    String m_location;
    int m_type;
    String m_preferredDisplayTool;
    boolean m_applicableOnAllPlatforms = true;
    transient boolean m_notApplicableOnThisPlatform = false;
    int[] m_setOfPlatforms;
    String m_visibilityCheckVariable;
    transient OiixJarResourceBundle m_resBundle;
    public static final int NATIVE_TOOL = 0;
    public static final int INSTALLER_GUI = 1;
    private transient boolean m_storedInInv = false;
    private static final String READMEID = "readmeID";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String LOCATION = "location";
    private static final String TYPE = "type";
    private static final String DISPLAYTOOL = "displayTool";
    private static final String ALL_PLATFORMS = "allPlatforms";
    private static final String PLATFORMS = "platforms";
    private static final String VISIBILITYCHECKVARIABLE = "visibilityCheckVariable";

    public OiisReadmeDetails(OiiiReadmeID readmeID, String externalName, String description, String location, int type) {
        this(readmeID, externalName, description, location, type, "");
    }

    public OiisReadmeDetails(OiiiReadmeID readmeID, String externalName, String description, String location, int type, String preferredDisplayTool) {
        this.m_readmeID = readmeID;
        this.m_externalName = externalName;
        this.m_description = description;
        this.m_location = location;
        this.m_type = type;
        this.m_preferredDisplayTool = preferredDisplayTool;
        this.m_applicableOnAllPlatforms = true;
        this.m_notApplicableOnThisPlatform = false;
    }

    public OiisReadmeDetails(OiivVerIndObjectRep viObj) {
        this.m_storedInInv = true;
        OiivVerIndObjectRep oVerIndObj = (OiivVerIndObjectRep)viObj.getObjectForName(READMEID);
        if (oVerIndObj != null) {
            this.m_readmeID = new OiiiReadmeID(oVerIndObj);
        }
        this.m_externalName = (String)viObj.getObjectForName(NAME);
        this.m_description = (String)viObj.getObjectForName(DESCRIPTION);
        this.m_location = (String)viObj.getObjectForName(LOCATION);
        this.m_type = (Integer)viObj.getObjectForName(TYPE);
        this.m_applicableOnAllPlatforms = (Boolean)viObj.getObjectForName(ALL_PLATFORMS);
        this.m_setOfPlatforms = (int[])viObj.getObjectForName(PLATFORMS);
        this.m_preferredDisplayTool = (String)viObj.getObjectForName(DISPLAYTOOL);
        this.m_visibilityCheckVariable = (String)viObj.getObjectForName(VISIBILITYCHECKVARIABLE);
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        OiivVerIndObjectRep oVerIndObj = this.m_readmeID.getVerIndRep();
        retRep.addNVPair(READMEID, oVerIndObj);
        retRep.addNVPair(NAME, this.m_externalName);
        retRep.addNVPair(DESCRIPTION, this.m_description);
        retRep.addNVPair(LOCATION, this.m_location);
        retRep.addNVPair(TYPE, new Integer(this.m_type));
        retRep.addNVPair(ALL_PLATFORMS, new Boolean(this.m_applicableOnAllPlatforms));
        retRep.addNVPair(PLATFORMS, this.m_setOfPlatforms);
        retRep.addNVPair(DISPLAYTOOL, this.m_preferredDisplayTool);
        retRep.addNVPair(VISIBILITYCHECKVARIABLE, this.m_visibilityCheckVariable);
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return !this.m_storedInInv;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals(READMEID)) {
            return this.m_readmeID.equals(value);
        }
        if (key.equals(NAME)) {
            return this.m_externalName == null ? value == null : this.m_externalName.equals(value);
        }
        if (key.equals(DESCRIPTION)) {
            return this.m_description == null ? value == null : this.m_description.equals(value);
        }
        if (key.equals(LOCATION)) {
            return this.m_location == null ? value == null : this.m_location.equals(value);
        }
        if (key.equals(TYPE)) {
            return this.m_type == (Integer)value;
        }
        if (key.equals(ALL_PLATFORMS)) {
            return this.m_applicableOnAllPlatforms == (Boolean)value;
        }
        if (key.equals(PLATFORMS)) {
            return this.m_setOfPlatforms == null ? value == null : this.m_setOfPlatforms.equals(value);
        }
        if (key.equals(DISPLAYTOOL)) {
            return this.m_preferredDisplayTool == null ? value == null : this.m_preferredDisplayTool.equals(value);
        }
        if (key.equals(VISIBILITYCHECKVARIABLE)) {
            return this.m_visibilityCheckVariable == null ? value == null : this.m_visibilityCheckVariable.equals(value);
        }
        return false;
    }

    public OiivVerIndObjectRep mergeVerIndRep(OiivVerIndObjectRep vIndObj) {
        OiivVerIndObjectRep retRep = vIndObj;
        OiivVerIndObjectRep oVerIndObj = this.m_readmeID.mergeVerIndRep((OiivVerIndObjectRep)retRep.getObjectForName(READMEID));
        retRep.setNVPair(READMEID, oVerIndObj);
        retRep.setNVPair(NAME, this.m_externalName);
        retRep.setNVPair(DESCRIPTION, this.m_description);
        retRep.setNVPair(LOCATION, this.m_location);
        retRep.setNVPair(TYPE, new Integer(this.m_type));
        retRep.setNVPair(ALL_PLATFORMS, new Boolean(this.m_applicableOnAllPlatforms));
        retRep.setNVPair(PLATFORMS, this.m_setOfPlatforms);
        retRep.setNVPair(DISPLAYTOOL, this.m_preferredDisplayTool);
        retRep.setNVPair(VISIBILITYCHECKVARIABLE, this.m_visibilityCheckVariable);
        return retRep;
    }

    public void setPlatforms(int[] a) {
        int size = a.length;
        this.m_setOfPlatforms = new int[size];
        this.m_applicableOnAllPlatforms = false;
        for (int i = 0; i < size; ++i) {
            this.m_setOfPlatforms[i] = a[i];
        }
    }

    public int[] getPlatforms() {
        return this.m_setOfPlatforms;
    }

    public boolean isApplicableOnAllPlatforms() {
        return this.m_applicableOnAllPlatforms;
    }

    public boolean isApplicableOnThisPlatform() {
        if (this.isApplicableOnAllPlatforms()) {
            return true;
        }
        this.m_notApplicableOnThisPlatform = true;
        int currPlat = OiixPlatform.getCurrentPlatform();
        int size = this.m_setOfPlatforms.length;
        for (int i = 0; i < size; ++i) {
            if (currPlat != this.m_setOfPlatforms[i]) continue;
            this.m_notApplicableOnThisPlatform = false;
        }
        return !this.m_notApplicableOnThisPlatform;
    }

    public void setBundle(OiixJarResourceBundle res) {
        this.m_resBundle = res;
    }

    public int getType() {
        return this.m_type;
    }

    public OiiiReadmeID getReadmeID() {
        return this.m_readmeID;
    }

    public String getExternalName() {
        if (this.m_resBundle == null) {
            return this.m_externalName;
        }
        try {
            String ret = this.m_resBundle.getString(this.m_externalName);
            return ret;
        }
        catch (MissingResourceException e) {
            return this.m_externalName;
        }
    }

    public String getExternalNameID() {
        return this.m_externalName;
    }

    public String getDescription() {
        if (this.m_resBundle == null) {
            return this.m_description;
        }
        try {
            String ret = this.m_resBundle.getString(this.m_description);
            return ret;
        }
        catch (MissingResourceException e) {
            return this.m_description;
        }
    }

    public String getDescriptionID() {
        return this.m_description;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String s) {
        this.m_location = new String(s);
    }

    public void setPreferredDisplayTool(String s) {
        this.m_preferredDisplayTool = s;
    }

    public String getPreferredDisplayTool() {
        return this.m_preferredDisplayTool;
    }

    public void setVisibilityCheckVariable(String s) {
        this.m_visibilityCheckVariable = s;
    }

    public String getVisibilityCheckVariable() {
        return this.m_visibilityCheckVariable;
    }
}

