/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisSingleSize;
import oracle.sysman.oii.oiiv.OiivVerIndCapable;
import oracle.sysman.oii.oiiv.OiivVerIndObjectRep;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisSize
implements Serializable,
OiivVerIndCapable {
    static final long serialVersionUID = 2189931964588965701L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    private transient OiisLangIndexMapping m_langIndMap;
    private int m_nSize;
    private Vector m_vSize;
    private boolean m_bWasCreated;
    private static final String S_SIZES = "sizes";

    public OiisSize() {
        this.m_vSize = new Vector();
        this.m_bWasCreated = true;
    }

    public OiisSize(OiivVerIndObjectRep vIndObj) {
        Vector verIndSize = (Vector)vIndObj.getObjectForName(S_SIZES);
        this.m_vSize = OiivVerIndObjectRep.getVerDepFormOfVect(verIndSize);
        this.m_bWasCreated = false;
    }

    public OiivVerIndObjectRep getVerIndRep() {
        OiivVerIndObjectRep retRep = new OiivVerIndObjectRep();
        retRep.setClassName(this.getClass().getName());
        Vector verIndSize = OiivVerIndObjectRep.getVerIndepFormOfVect(this.m_vSize);
        retRep.addNVPair(S_SIZES, verIndSize);
        return retRep;
    }

    public boolean wasCreatedInThisSession() {
        return this.m_bWasCreated;
    }

    public boolean compareKeyValue(String key, Object value) {
        if (key.equals(S_SIZES)) {
            Vector vdSizes = OiivVerIndObjectRep.getVerDepFormOfVect((Vector)value);
            return OiixVectorOps.vectorsEqual(this.m_vSize, vdSizes);
        }
        return false;
    }

    public void setLangIndexMapping(OiisLangIndexMapping langIndMap) {
        this.m_langIndMap = langIndMap;
    }

    public void setSize(Integer nPlat, String sDepMode, Long nSize) {
        OiisSingleSize oTempSize = new OiisSingleSize(nPlat, null, sDepMode, new Long(0L));
        int nIndex = OiixVectorOps.vectIndexOf(this.m_vSize, (Object)oTempSize);
        this.m_bWasCreated = true;
        if (nIndex != -1) {
            OiisSingleSize oSize = (OiisSingleSize)this.m_vSize.elementAt(nIndex);
            oSize.setSize(nSize);
        } else {
            OiisSingleSize oSize = new OiisSingleSize(nPlat, null, sDepMode, nSize);
            this.m_vSize.addElement(oSize);
        }
    }

    public void updateSize(Integer nPlat, String sDepMode, long[] alSizes) {
        OiisSingleSize oTempSize = new OiisSingleSize(nPlat, sDepMode, null);
        int nIndex = OiixVectorOps.vectIndexOf(this.m_vSize, (Object)oTempSize);
        this.m_bWasCreated = true;
        if (nIndex != -1) {
            OiisSingleSize oSize = (OiisSingleSize)this.m_vSize.elementAt(nIndex);
            oSize.updateSize(alSizes);
        } else {
            OiisSingleSize oSize = new OiisSingleSize(nPlat, sDepMode, alSizes);
            this.m_vSize.addElement(oSize);
        }
    }

    public void updateLargestFileGroupJarSize(Integer nPlat, String sDepMode, long lSz) {
        OiisSingleSize oTempSize = new OiisSingleSize(nPlat, sDepMode, null);
        int nIndex = OiixVectorOps.vectIndexOf(this.m_vSize, (Object)oTempSize);
        this.m_bWasCreated = true;
        if (nIndex != -1) {
            OiisSingleSize oSize = (OiisSingleSize)this.m_vSize.elementAt(nIndex);
            oSize.updateLargestFileGroupJarSize(lSz);
        } else {
            oTempSize.updateLargestFileGroupJarSize(lSz);
            this.m_vSize.addElement(oTempSize);
        }
    }

    public Long getSize(Integer nPlat, String sDepMode) {
        OiisSingleSize oTempSize = new OiisSingleSize(nPlat, null, sDepMode, new Long(0L));
        int nIndex = OiixVectorOps.vectIndexOf(this.m_vSize, (Object)oTempSize);
        if (nIndex != -1) {
            OiisSingleSize oSize = (OiisSingleSize)this.m_vSize.elementAt(nIndex);
            long[] alSizes = oSize.getSizes();
            if (alSizes == null) {
                return oSize.getSize();
            }
            long lSize = 0L;
            int[] alCurLangSetIndex = this.m_langIndMap.getRelevantLangSetList();
            for (int i = 0; i < alCurLangSetIndex.length; ++i) {
                if (alCurLangSetIndex[i] >= alSizes.length) continue;
                lSize += alSizes[alCurLangSetIndex[i]];
            }
            return new Long(lSize += alSizes[alSizes.length - 1]);
        }
        return new Long(0L);
    }

    public Long getSize(Integer nPlat, String sDepMode, Vector langs) {
        OiisSingleSize oTempSize = new OiisSingleSize(nPlat, null, sDepMode, new Long(0L));
        int nIndex = OiixVectorOps.vectIndexOf(this.m_vSize, (Object)oTempSize);
        if (nIndex != -1) {
            OiisSingleSize oSize = (OiisSingleSize)this.m_vSize.elementAt(nIndex);
            long[] alSizes = oSize.getSizes();
            if (alSizes == null) {
                return oSize.getSize();
            }
            long lSize = 0L;
            int[] alCurLangSetIndex = this.m_langIndMap.getRelevantLangSetList(langs, false);
            for (int i = 0; i < alCurLangSetIndex.length; ++i) {
                if (alCurLangSetIndex[i] >= alSizes.length) continue;
                lSize += alSizes[alCurLangSetIndex[i]];
            }
            return new Long(lSize += alSizes[alSizes.length - 1]);
        }
        return new Long(0L);
    }

    public String toString() {
        return OiixVectorOps.objToString(this.m_vSize);
    }

    public void optimize() {
        int nCnt = this.m_vSize.size();
        Vector<OiisSingleSize> vSize = new Vector<OiisSingleSize>(nCnt);
        for (int i = 0; i < nCnt; ++i) {
            OiisSingleSize oss = (OiisSingleSize)this.m_vSize.elementAt(i);
            if (oss.getPlatform() != OiixPlatform.getCurrentPlatform()) continue;
            vSize.addElement(oss);
        }
        this.m_vSize = vSize;
    }

    public Vector getSingleSizes() {
        return this.m_vSize;
    }
}

