/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisPatchInstallation;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiisStagedCompHelper {
    public static OiisCompInstallation createCompInstall(OiiiStageCompInvEntry scie, OiiiSourceAccess sourceAccess) throws OiifbCancelException {
        return OiisStagedCompHelper.createCompInstall(scie, sourceAccess, null);
    }

    public static OiisCompInstallation createCompInstall(OiiiStageCompInvEntry scie, OiiiSourceAccess sourceAccess, OiicSessionContext sessionContext) throws OiifbCancelException {
        if (scie == null) {
            return null;
        }
        try {
            OiiiCompInstallID cid = scie.getCompInstallID();
            OiisCompInstallation ci = cid instanceof OiiiPatchInstallID ? new OiisPatchInstallation(sessionContext) : new OiisCompInstallation(sessionContext);
            ci.setPre22Comp(scie.isStageVersionPreX("2.2"));
            ci.setPre20Comp(scie.isStageVersionPreX("2.0"));
            ci.setFileSizeInfo(scie.getFileSizeInfoEx());
            OiisCompJarLoader cjLoader = sourceAccess.getCompJarLoader(scie);
            ci.setCompJarLoader(cjLoader);
            OiisCompProperties cp = scie.getCompProperties();
            if (cp != null) {
                ci.setProperties(cp);
                cp.setCompInstallID(cid);
                ResourceBundle rb = scie.getResourceBundle();
                OiixJarResourceBundle jrb = new OiixJarResourceBundle(rb);
                cp.setResBundle(jrb);
            } else {
                cp = ci.getProperties();
                scie.setCompProperties(cp);
                cjLoader.setCompJarInfo(cp.getCompJarInfo());
            }
            OiisDeps ieDeps = scie.getDeps();
            OiisDepInfo depInfo = scie.getDepInfo();
            if (ieDeps != null) {
                ci.setDeps(depInfo);
            }
            ci.setProdHomeCalcPresent(!scie.isNoProdHome());
            ci.setPreReqCalcPresent(!scie.isNoPreReq());
            ci.setPlatIndexMapping(scie.getPlatIndexMapping());
            ci.setLangIndexMapping(scie.getLangIndexMapping());
            ci.setDestIndexMapping(scie.getDestIndexMapping());
            return ci;
        }
        catch (Exception e) {
            if (e instanceof OiifbCancelException) {
                throw (OiifbCancelException)e;
            }
            e.printStackTrace();
            System.err.println("Error in loading component installation..");
            return null;
        }
    }

    public static OiisPatchSetInstallation createPatchSetInstall(OiiiStageCompInvEntry scie, OiiiSourceAccess sourceAccess) throws OiifbCancelException {
        if (scie == null) {
            return null;
        }
        try {
            OiisPatchSetInstallation psi = new OiisPatchSetInstallation();
            OiiiPatchSetInstallID cid = (OiiiPatchSetInstallID)scie.getCompInstallID();
            OiisCompJarLoader cjLoader = sourceAccess.getCompJarLoader(scie);
            psi.setCompJarLoader(cjLoader);
            OiisCompProperties cp = scie.getCompProperties();
            if (cp != null) {
                psi.setProperties(cp);
                cp.setCompInstallID(cid);
            } else {
                scie.setCompProperties(psi.getProperties());
            }
            OiisPatchSetContents psContents = scie.getPatchSetContents();
            if (psContents != null) {
                psi.setContents(psContents);
            } else {
                scie.setPatchSetContents(psi.getContents());
                cjLoader.setCompJarInfo(psi.getProperties().getCompJarInfo());
            }
            return psi;
        }
        catch (Exception e) {
            if (e instanceof OiifbCancelException) {
                throw (OiifbCancelException)e;
            }
            e.printStackTrace();
            System.err.println("Error in loading patchset installation..");
            return null;
        }
    }

    public static OiisCompInstallation createCompInstall(OiiiStageCompInvEntry scie, String sSourceRoot, OiicSessionContext oSessionCntxt) throws OiifbCancelException {
        if (scie == null) {
            return null;
        }
        try {
            String compJarLoc;
            File f;
            OiisCompInstallation ci = scie.getCompInstallID().getCompType() == 1 ? new OiisCompInstallation(oSessionCntxt) : new OiisPatchInstallation(oSessionCntxt);
            ci.setPre22Comp(scie.isStageVersionPreX("2.2"));
            ci.setPre20Comp(scie.isStageVersionPreX("2.0"));
            ci.setPlatIndexMapping(scie.getPlatIndexMapping());
            ci.setLangIndexMapping(scie.getLangIndexMapping());
            ci.setDestIndexMapping(scie.getDestIndexMapping());
            String compLoc = scie.getInstallDefnLoc();
            compLoc = OiixPathOps.concatPath(sSourceRoot, compLoc);
            String sJarName = scie.getJarName();
            if (sJarName == null) {
                sJarName = "compIns.jar";
            }
            if (!(f = new File(OiixPathOps.getNativeForm(compJarLoc = OiixPathOps.concatPath(compLoc, sJarName)))).exists()) {
                System.err.println("Error in loading component installation..");
                return null;
            }
            OiisCompJarLoader cjLoader = null;
            cjLoader = new OiisCompJarLoader(compJarLoc);
            ci.setCompJarLoader(cjLoader);
            OiisCompProperties cp = scie.getCompProperties();
            if (cp != null) {
                ci.setProperties(cp);
                ResourceBundle rb = scie.getResourceBundle();
                OiixJarResourceBundle jrb = new OiixJarResourceBundle(rb);
                cp.setResBundle(jrb);
            } else {
                scie.setCompProperties(ci.getProperties());
                cjLoader.setCompJarInfo(ci.getProperties().getCompJarInfo());
            }
            OiisDeps ieDeps = scie.getDeps();
            OiisDepInfo depInfo = scie.getDepInfo();
            if (ieDeps != null) {
                ci.setDeps(depInfo);
            }
            ci.setProdHomeCalcPresent(!scie.isNoProdHome());
            ci.setPreReqCalcPresent(!scie.isNoPreReq());
            return ci;
        }
        catch (Exception e) {
            if (e instanceof OiifbCancelException) {
                throw (OiifbCancelException)e;
            }
            e.printStackTrace();
            System.err.println("Error in loading component installation..");
            return null;
        }
    }

    public static OiisPatchSetInstallation createPatchSetInstall(OiiiStageCompInvEntry scie, String sSourceRoot) throws OiifbCancelException {
        if (scie == null) {
            return null;
        }
        try {
            String compJarLoc;
            File f;
            OiisPatchSetInstallation psi = new OiisPatchSetInstallation();
            OiiiPatchSetInstallID cid = (OiiiPatchSetInstallID)scie.getCompInstallID();
            String compLoc = scie.getInstallDefnLoc();
            compLoc = OiixPathOps.concatPath(sSourceRoot, compLoc);
            String sJarName = scie.getJarName();
            if (sJarName == null) {
                sJarName = "compIns.jar";
            }
            if (!(f = new File(OiixPathOps.getNativeForm(compJarLoc = OiixPathOps.concatPath(compLoc, sJarName)))).exists()) {
                System.err.println("Error in loading component installation..");
                return null;
            }
            OiisCompJarLoader cjLoader = null;
            cjLoader = new OiisCompJarLoader(compJarLoc);
            psi.setCompJarLoader(cjLoader);
            OiisCompProperties cp = scie.getCompProperties();
            if (cp != null) {
                psi.setProperties(cp);
            } else {
                scie.setCompProperties(psi.getProperties());
            }
            OiisPatchSetContents psContents = scie.getPatchSetContents();
            if (psContents != null) {
                psi.setContents(psContents);
            } else {
                scie.setPatchSetContents(psi.getContents());
                cjLoader.setCompJarInfo(psi.getProperties().getCompJarInfo());
            }
            return psi;
        }
        catch (Exception e) {
            if (e instanceof OiifbCancelException) {
                throw (OiifbCancelException)e;
            }
            e.printStackTrace();
            System.err.println("Error in loading patchset installation..");
            return null;
        }
    }
}

