/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiix.OiixJarClassLoader;

public class OiisStagedCompRep {
    private OiisCompProperties m_Properties = null;
    private OiisDepInfo m_Deps = null;
    private OiisFileMap m_FileMap = null;
    private String m_jarLoc = null;
    private OiisCompJarLoader m_compJarLoader = null;
    protected OiisFileSizeInfo m_fileSizeInfo = null;
    private OiicPullSession m_oSession;
    protected OiisPlatIndexMapping m_oPlatIndMap = null;
    protected OiisLangIndexMapping m_oLangIndMap = null;
    protected OiisDestinationIndexMapping m_oDestIndMap = null;
    protected boolean m_bPre20Comp;
    protected boolean m_bPre22Comp;

    public void setSession(OiicPullSession session) {
        this.m_oSession = session;
    }

    public void setPre20Comp(boolean bPre20Comp) {
        this.m_bPre20Comp = bPre20Comp;
    }

    public void setPre22Comp(boolean bPre22Comp) {
        this.m_bPre22Comp = bPre22Comp;
    }

    public boolean isPre20Comp() {
        return this.m_bPre20Comp;
    }

    public boolean isPre22Comp() {
        return this.m_bPre22Comp;
    }

    protected OiicPullSession getSession() {
        return this.m_oSession;
    }

    public OiisDestinationIndexMapping getDestIndexMapping() {
        return this.m_oDestIndMap;
    }

    public OiisPlatIndexMapping getPlatIndexMapping() {
        return this.m_oPlatIndMap;
    }

    public OiisLangIndexMapping getLangIndexMapping() {
        return this.m_oLangIndMap;
    }

    public void setDestIndexMapping(OiisDestinationIndexMapping destIndMap) {
        this.m_oDestIndMap = destIndMap;
    }

    public void setPlatIndexMapping(OiisPlatIndexMapping platIndMap) {
        this.m_oPlatIndMap = platIndMap;
    }

    public void setLangIndexMapping(OiisLangIndexMapping langIndMap) {
        this.m_oLangIndMap = langIndMap;
    }

    public OiisCompJarLoader getCompJarLoader() {
        return this.m_compJarLoader;
    }

    public OiisCompProperties getProperties() {
        if (this.m_Properties == null) {
            try {
                this.setProperties(this.m_compJarLoader.loadCompProperties());
                this.setCompJarInfo(this.m_compJarLoader.getCompJarInfo());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_Properties;
    }

    public OiiiCompInstallID getCompInstallID() {
        OiiiCompInstallID retVal = null;
        OiisCompProperties compProps = this.getProperties();
        if (compProps != null) {
            retVal = compProps.getCompInstallID();
        }
        return retVal;
    }

    public Vector getLanguages() {
        Vector retLangs = null;
        OiisCompProperties compProps = this.getProperties();
        if (compProps != null) {
            retLangs = compProps.getLanguages();
        }
        return retLangs;
    }

    public OiisDepInfo getDepInfo() {
        if (this.m_Deps == null) {
            try {
                this.setDeps(this.m_compJarLoader.loadCompDeps());
                this.m_Deps.setResourceBundle(this.m_compJarLoader.loadCompResources());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_Deps;
    }

    public String getDepModeName() {
        OiisDepInfo depInfo = this.getDepInfo();
        if (depInfo != null) {
            return depInfo.getDepModeName();
        }
        return "";
    }

    public OiisFileMap getFileMap() {
        if (this.m_FileMap == null) {
            try {
                OiisCompJarInfo compJarInfo = this.getCompJarInfo();
                OiisFileMap fileMap = this.m_compJarLoader.loadFileMap(compJarInfo);
                if (fileMap.getPlatIndexMapping() == null) {
                    fileMap.setPlatIndexMapping(this.getPlatIndexMapping());
                }
                if (fileMap.getLangIndexMapping() == null) {
                    fileMap.setLangIndexMapping(this.getLangIndexMapping());
                }
                this.setFileMap(fileMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_FileMap;
    }

    public void releaseFileMap() {
        this.m_FileMap = null;
    }

    public void releaseDeps() {
        if (this.m_Deps != null) {
            this.m_Deps.releaseDeps();
        }
    }

    public void setCompJarLoader(OiisCompJarLoader compJarLoader) {
        this.m_compJarLoader = compJarLoader;
        this.m_jarLoc = this.m_compJarLoader.getJarLoc();
    }

    public void setProperties(OiisCompProperties compProperties) {
        this.m_Properties = compProperties;
    }

    public void setCompJarInfo(OiisCompJarInfo compJarInfo) {
        this.m_Properties.setCompJarInfo(compJarInfo);
    }

    public OiisCompJarInfo getCompJarInfo() {
        return this.m_Properties.getCompJarInfo();
    }

    public void setDeps(OiisDepInfo compDeps) {
        this.m_Deps = compDeps;
    }

    public void setFileMap(OiisFileMap fileMap) {
        this.m_FileMap = fileMap;
        this.m_FileMap.setPlatIndexMapping(this.getPlatIndexMapping());
        this.m_FileMap.setLangIndexMapping(this.getLangIndexMapping());
        this.m_FileMap.setDestIndexMapping(this.getDestIndexMapping());
    }

    public void setJarLoc(String jarLoc) {
        this.m_jarLoc = jarLoc;
    }

    public String getJarLoc() {
        return this.m_jarLoc;
    }

    public void setFileSizeInfo(OiisFileSizeInfo fileSizeInfo) {
        this.m_fileSizeInfo = fileSizeInfo;
    }

    public OiisFileSizeInfo getFileSizeInfo() {
        return this.m_fileSizeInfo;
    }

    public long getSize(Vector langs) {
        if (this.m_fileSizeInfo != null) {
            return this.m_fileSizeInfo.getSizeEx(langs, null);
        }
        return this.getFileMap().getSize(langs);
    }

    public void dispose() {
        this.m_Properties = null;
        this.releaseFileMap();
        if (this.m_fileSizeInfo != null) {
            this.m_fileSizeInfo.dispose();
            this.m_fileSizeInfo = null;
        }
        if (this.isPre20Comp() && this.m_compJarLoader != null) {
            OiixJarClassLoader.forgetLoader(this.m_compJarLoader.getJarLoc());
        }
    }

    void disposeMaximumObjects() {
        this.releaseFileMap();
        if (this.m_fileSizeInfo != null) {
            this.m_fileSizeInfo.dispose();
            this.m_fileSizeInfo = null;
        }
    }
}

