/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisMakeConfig;
import oracle.sysman.oii.oiis.OiisRelinkInfo;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiisTargetStructure {
    public static final String MAKE_TAG = "ohmd:MAKE";
    public static final String INPUT_LIST_TAG = "ohmd:INPUT_LIST";
    public static final String INPUT_TAG = "ohmd:INPUT";
    public static final String COMP_LIST_TAG = "ohmd:COMP_LIST";
    public static final String COMP_TAG = "ohmd:COMP";
    public static final String PATCH_TAG = "ohmd:PATCH";
    public static final String NAME = "NAME";
    public static final String VERSION = "VERSION";
    public static final String VAL = "VAL";
    public static final String TARGET = "ohmd:TARGET";
    public static final String TARGETNAME = "TARGETNAME";
    public static final String FILENAME = "FILENAME";
    public static final String MAKEPATH = "MAKEPATH";
    public static final String ACTIONTYPE = "ACTIONTYPE";
    private String m_sOHLoc = OiisMakeConfig.sOHLoc;
    private String m_sTarget;
    private String m_sMakePath;
    private String m_sFilename;
    private String m_sactionType;
    private OiiiCompInstallID m_cid;
    private String[] m_sArgs;
    private ArrayList argsList;
    private ArrayList m_cidList;
    private ArrayList tgtList;

    public OiisTargetStructure(OixpIElement el) {
        this.setMakePath(el.getAttribValue(MAKEPATH));
        this.setFilename(el.getAttribValue(FILENAME));
        this.argsList = new ArrayList();
        this.tgtList = new ArrayList();
    }

    public OiisTargetStructure() {
    }

    public OiisTargetStructure(OiisRelinkInfo linkInfo) {
        this.m_sMakePath = linkInfo.getMakePath();
        String filename = linkInfo.getMakeFileName();
        this.m_sFilename = filename.replaceFirst(this.m_sOHLoc + File.separator, "");
        this.m_sTarget = linkInfo.getTarget();
        this.m_sArgs = linkInfo.getParamArguments();
        this.m_sactionType = linkInfo.getActionType();
        this.m_cidList = linkInfo.getCIDList();
    }

    public ArrayList getCIDList() {
        return this.m_cidList;
    }

    public void setCIDList(ArrayList cidList) {
        this.m_cidList = cidList;
    }

    public OiisTargetStructure(String target, String filename, String[] args) {
        this.m_sTarget = target;
        this.m_sFilename = filename.replaceFirst(this.m_sOHLoc + File.separator, "");
        this.m_sArgs = args;
    }

    public void setMakePath(String makePath) {
        this.m_sMakePath = makePath;
    }

    public void setTarget(String target) {
        this.m_sTarget = target;
    }

    public void setFilename(String filename) {
        this.m_sFilename = filename;
    }

    public String getActionType() {
        return this.m_sactionType;
    }

    public void setActionType(String actionType) {
        this.m_sactionType = actionType;
    }

    public void setArgs(String[] args) {
        this.m_sArgs = args;
    }

    public String getMakePath() {
        return this.m_sMakePath;
    }

    public String getTarget() {
        return this.m_sTarget;
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public String[] getArgs() {
        return this.m_sArgs;
    }

    public void addToList(OixpIElement el) {
        this.argsList.add(el.getAttribValue(VAL));
    }

    public void addToTargetList(OixpIElement el) {
        this.tgtList.add(el.getAttribValue(TARGETNAME));
    }

    public void convertToArray() {
        this.m_sArgs = this.argsList.toArray(new String[this.argsList.size()]);
    }

    public String toString() {
        return this.m_sTarget + "::" + this.m_sFilename + "::";
    }

    public String toString1() {
        return this.m_sTarget + "::" + this.m_sFilename + "::" + this.m_sactionType + "::" + OiixVectorOps.objToString(this.m_sArgs);
    }

    public boolean equals(OiisTargetStructure t) {
        return t != null && this.m_sTarget.equals(t.getTarget()) && this.m_sFilename.equals(t.getFilename()) && this.m_sMakePath.equals(t.getMakePath()) && this.m_sactionType.equalsIgnoreCase(t.getActionType()) && OiixVectorOps.objToString(this.m_sArgs).equals(OiixVectorOps.objToString(t.getArgs()));
    }

    public OiisTargetStructure returnClone() {
        OiisTargetStructure tNew = new OiisTargetStructure();
        tNew.setMakePath(this.m_sMakePath);
        tNew.setFilename(this.m_sFilename);
        tNew.setTarget(this.m_sTarget);
        tNew.setArgs(this.m_sArgs);
        tNew.setActionType(this.m_sactionType);
        tNew.setCIDList(this.m_cidList);
        return tNew;
    }

    public void writeXmlForm(PrintWriter pw) throws IOException {
        StringTokenizer st = new StringTokenizer(this.m_sTarget);
        while (st.hasMoreTokens()) {
            pw.println("<ohmd:MAKE ");
            pw.println("MAKEPATH=\"" + OixwXmlWriterOps.encodeSplChars(this.m_sMakePath) + "\" " + FILENAME + "=\"" + OixwXmlWriterOps.encodeSplChars(this.m_sFilename) + "\" >");
            pw.print("<ohmd:TARGET ");
            pw.println("ACTIONTYPE=\"" + OixwXmlWriterOps.encodeSplChars(this.m_sactionType) + "\" " + TARGETNAME + "=\"" + OixwXmlWriterOps.encodeSplChars(st.nextToken()) + "\" >");
            if (this.m_sArgs != null && this.m_sArgs.length > 0) {
                pw.println("<ohmd:INPUT_LIST>");
                for (int j = 0; j < this.m_sArgs.length; ++j) {
                    pw.println("<ohmd:INPUT VAL=\"" + this.m_sArgs[j] + "\"/>");
                }
                pw.println("</ohmd:INPUT_LIST>");
            }
            pw.println("<ohmd:COMP_LIST>");
            HashSet<String> compSet = new HashSet<String>();
            for (int j = 0; j < this.m_cidList.size(); ++j) {
                this.m_cid = (OiiiCompInstallID)this.m_cidList.get(j);
                if (this.m_cid == null) continue;
                if (this.m_cid.getCompType() == 1) {
                    compSet.add("<ohmd:COMP NAME=\"" + this.m_cid.getName() + "\" " + VERSION + "=\"" + this.m_cid.getVersion() + "\"/>");
                }
                if (this.m_cid.getCompType() != 2) continue;
                compSet.add("<ohmd:PATCH NAME=\"" + this.m_cid.getName() + "\" " + VERSION + "=\"" + this.m_cid.getVersion() + "\"/>");
            }
            Iterator it = compSet.iterator();
            while (it.hasNext()) {
                pw.println(it.next());
            }
            pw.println("</ohmd:COMP_LIST>");
            pw.println("</ohmd:TARGET>");
            pw.println("</ohmd:MAKE>");
        }
    }
}

