/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiit.OiitClusterLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiitClusterLocker {
    private static String[] m_clusterList = null;
    private static final String NODES_LOCK_FILE = "nodes.lock";
    private static final String CLUSTER_LOCK_FILE = "clusterWriter.lock";
    private static final String WRITER_LOCK_FILE = "writer.lock";

    public static boolean lockClusterNodes(String[] clusterList) throws OiitClusterLockNotAvailableException {
        if (clusterList != null && clusterList.length > 0) {
            m_clusterList = clusterList;
            ClusterCmd clsCmd = new ClusterCmd();
            String destLoc = OiixPathOps.concatPath(OiitClusterLocker.getNodesLockLoc(), NODES_LOCK_FILE);
            File destFile = new File(destLoc);
            if (destFile.exists()) {
                destFile.delete();
            }
            PrintWriter pwNodeWriter = null;
            try {
                pwNodeWriter = new PrintWriter(new FileOutputStream(destLoc, true), true);
                for (int i = 0; i < clusterList.length; ++i) {
                    pwNodeWriter.println(clusterList[i]);
                }
                pwNodeWriter.close();
            }
            catch (IOException ex) {
                Object[] obj = new String[2];
                OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
                String sInvLoc = oAreaControl.getAreaRoot();
                obj[0] = destLoc;
                obj[1] = sInvLoc;
                String sErr = OiixResourceBundle.getString("S_CLUSTER_LOCKING_IO_EXCEPTION_MSG", obj);
                throw new OiitClusterLockNotAvailableException(sErr);
            }
            String sClusterLockFile = OiixPathOps.concatPath(OiitClusterLocker.getNodesLockLoc(), CLUSTER_LOCK_FILE);
            File clusterLockFile = new File(sClusterLockFile);
            if (clusterLockFile.exists()) {
                clusterLockFile.delete();
            }
            Vector<String> vLockedNodes = null;
            Vector<String> vNodesWithClusterException = null;
            Vector<String> vNodesWithIOException = null;
            for (int i = 1; i < clusterList.length; ++i) {
                try {
                    if (!OiitClusterLocker.isNodeLocked(clusterList[i], sClusterLockFile)) continue;
                    if (vLockedNodes == null) {
                        vLockedNodes = new Vector<String>(1);
                    }
                    vLockedNodes.addElement(clusterList[i]);
                    continue;
                }
                catch (ClusterException ce) {
                    if (vNodesWithClusterException == null) {
                        vNodesWithClusterException = new Vector<String>(1);
                    }
                    vNodesWithClusterException.addElement(clusterList[i]);
                    continue;
                }
                catch (IOException ex) {
                    if (vNodesWithIOException == null) {
                        vNodesWithIOException = new Vector<String>(1);
                    }
                    vNodesWithIOException.addElement(clusterList[i]);
                }
            }
            if (vLockedNodes != null || vNodesWithClusterException != null || vNodesWithIOException != null) {
                Object[] args;
                String sInvLoc;
                OiiiInstallAreaControl oAreaControl;
                Vector<String> vErr = new Vector<String>(1);
                destFile = new File(destLoc);
                if (destFile.exists()) {
                    destFile.delete();
                }
                if (vLockedNodes != null) {
                    String[] lockedNodesArr = OiixVectorOps.vect2StrArr(vLockedNodes);
                    String lockedNodesStr = OiixFunctionOps.implodeList(lockedNodesArr, ",");
                    Object[] args2 = new String[]{lockedNodesStr};
                    vErr.addElement(OiixResourceBundle.getString("S_CLUSTER_INSTALL_IN_PROGRESS", args2));
                }
                if (vNodesWithClusterException != null) {
                    String[] nodesWithClusterException = OiixVectorOps.vect2StrArr(vNodesWithClusterException);
                    String nodesWithClusterExceptionStr = OiixFunctionOps.implodeList(nodesWithClusterException, ",");
                    oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
                    sInvLoc = oAreaControl.getAreaRoot();
                    args = new String[]{nodesWithClusterExceptionStr, sInvLoc};
                    vErr.addElement(OiixResourceBundle.getString("S_CLUSTER_LOCKING_REMOTE_COPY_FAILURE_MSG", args));
                }
                if (vNodesWithIOException != null) {
                    String[] nodesWithIOException = OiixVectorOps.vect2StrArr(vNodesWithIOException);
                    String nodesWithIOExceptionStr = OiixFunctionOps.implodeList(nodesWithIOException, ",");
                    oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
                    sInvLoc = oAreaControl.getAreaRoot();
                    args = new String[]{nodesWithIOExceptionStr};
                    args[1] = sInvLoc;
                    vErr.addElement(OiixResourceBundle.getString("S_CLUSTER_LOCKING_IO_FAILURE_MSG", args));
                }
                String[] sErrArr = OiixVectorOps.vect2StrArr(vErr);
                String sErrMsg = OiixFunctionOps.implodeList(sErrArr, "\n");
                throw new OiitClusterLockNotAvailableException(sErrMsg);
            }
            try {
                PrintWriter pwClusterWriter = null;
                pwClusterWriter = new PrintWriter(new FileOutputStream(sClusterLockFile, true), true);
                pwClusterWriter.println(clusterList[0]);
                pwClusterWriter.close();
                for (int i = 1; i < clusterList.length; ++i) {
                    clsCmd.createDirInNode(clusterList[i], OiitClusterLocker.getNodesLockLoc());
                    clsCmd.copyFileToNode(sClusterLockFile, clusterList[i], sClusterLockFile);
                }
            }
            catch (IOException ex) {
                Object[] obj = new String[]{sClusterLockFile};
                String sErr = OiixResourceBundle.getString("S_CLUSTER_LOCKING_IO_EXCEPTION_MSG", obj);
                throw new OiitClusterLockNotAvailableException(sErr);
            }
            catch (ClusterException e) {
                System.err.println(e.getMessage());
                String[] remoteNodes = new String[clusterList.length - 1];
                for (int i = 0; i < clusterList.length - 1; ++i) {
                    remoteNodes[i] = clusterList[i + 1];
                }
                String clusterListStr = OiixFunctionOps.implodeList(remoteNodes, ",");
                OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
                String sInvLoc = oAreaControl.getAreaRoot();
                Object[] args = new String[]{clusterListStr, sInvLoc};
                String sErr = OiixResourceBundle.getString("S_CLUSTER_LOCKING_REMOTE_COPY_FAILURE_MSG", args);
                throw new OiitClusterLockNotAvailableException(sErr);
            }
        }
        return true;
    }

    private static boolean isNodeLocked(String clusterNode, String clusterLockFile) throws IOException, ClusterException {
        block16: {
            String sNode = clusterNode;
            String sClusterLockFile = clusterLockFile;
            String sScratchLoc = System.getProperty("oracle.installer.scratchPath");
            String sScratchFile = null;
            String input = null;
            ClusterCmd clsCmd = new ClusterCmd();
            sScratchFile = OiixPathOps.concatPath(sScratchLoc, "clusterWriter.lock." + sNode);
            try {
                clsCmd.fileExists(sNode, sClusterLockFile);
            }
            catch (ClusterException ce) {
                return false;
            }
            if (!clsCmd.copyFileFromNode(sNode, sClusterLockFile, sScratchFile)) {
                return false;
            }
            BufferedReader bufIn1 = null;
            try {
                bufIn1 = new BufferedReader(new FileReader(sScratchFile));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                return false;
            }
            input = bufIn1.readLine();
            bufIn1.close();
            if (!input.equalsIgnoreCase(m_clusterList[0])) {
                sScratchFile = OiixPathOps.concatPath(sScratchLoc, "nodes.lock." + input);
                String sDestFile = OiixPathOps.concatPath(OiitClusterLocker.getNodesLockLoc(), NODES_LOCK_FILE);
                sDestFile = OiixPathOps.getNativeForm(sDestFile);
                String sWriterLockFile = OiixPathOps.concatPath(OiitClusterLocker.getNodesLockLoc(), WRITER_LOCK_FILE);
                sWriterLockFile = OiixPathOps.getNativeForm(sWriterLockFile);
                if (!clsCmd.copyFileFromNode(input, sDestFile, sScratchFile)) break block16;
                try {
                    bufIn1 = new BufferedReader(new FileReader(sScratchFile));
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                    return false;
                }
                input = bufIn1.readLine();
                while (input != null) {
                    if (input.equalsIgnoreCase(sNode)) {
                        long ltime1 = clsCmd.getModificationTime(sNode, sWriterLockFile);
                        try {
                            Thread.currentThread();
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                        long ltime2 = clsCmd.getModificationTime(sNode, sWriterLockFile);
                        return ltime2 > ltime1;
                    }
                    input = bufIn1.readLine();
                }
                bufIn1.close();
            }
        }
        return false;
    }

    public static String getNodesLockLoc() {
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        return oAreaControl.getLocksDir();
    }

    public static String getClusterLockFileLoc() {
        return OiixPathOps.concatPath(OiitClusterLocker.getNodesLockLoc(), CLUSTER_LOCK_FILE);
    }
}

