/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiit;

import java.io.File;
import java.io.IOException;
import oracle.sysman.oii.oiit.OiitLockHeartbeat;

public class OiitLockMonitor
extends OiitLockHeartbeat {
    private boolean m_bLockDetected;

    public OiitLockMonitor(String sFile) {
        super.setLockFileName(sFile);
    }

    public void releaseLock() {
        this.stopHeartbeat();
    }

    protected void update() throws IOException {
        File f = this.getLockFile();
        if (f.exists() && this.isWriterCurrent(f)) {
            this.setLockDetected(true);
            this.stopHeartbeat();
        }
    }

    private boolean isWriterCurrent(File oFile) {
        long timeStamp1 = oFile.lastModified();
        long timeStamp2 = System.currentTimeMillis();
        return timeStamp2 - timeStamp1 >= 1000L && timeStamp2 - timeStamp1 < 3000L;
    }

    private synchronized void setLockDetected(boolean bLockDetected) {
        this.m_bLockDetected = bLockDetected;
    }

    public synchronized boolean isLockDetected() {
        return this.m_bLockDetected;
    }
}

