/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiit;

import java.text.MessageFormat;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiitTargetLockNotAvailableException
extends Exception {
    public static final int CANC_WRITE_SESSION = 0;
    public static final int CANC_READ_SESSION = 1;
    public static final int ACTIVE_WRITER_IN_WL = 2;
    public static final int ACTIVE_READERS_IN_WL = 3;
    public static final int ACTIVE_WRITER_IN_RL = 4;
    public static final int INACTIVE_WRITER_IN_WL = 5;
    public static final int OTHER_INVALID_COND = 6;
    public static final String S_CANC_WRITE_SESSION = "S_CANC_WRITE_SESSION";
    public static final String S_CANC_READ_SESSION = "S_CANC_READ_SESSION";
    public static final String S_ACTIVE_WRITER_IN_WL = "S_ACTIVE_WRITER_IN_WL";
    public static final String S_ACTIVE_READERS_IN_WL = "S_ACTIVE_READERS_IN_WL";
    public static final String S_ACTIVE_WRITER_IN_RL = "S_ACTIVE_WRITER_IN_RL";
    public static final String S_INACTIVE_WRITER_IN_WL = "S_INACTIVE_WRITER_IN_WL";
    public static final String S_OTHER_INVALID_COND = "S_OTHER_INVALID_COND";
    private int m_reason;

    public OiitTargetLockNotAvailableException(int reason, String areaRoot) {
        super(OiitTargetLockNotAvailableException.getErrString(reason, areaRoot));
        this.m_reason = reason;
    }

    private static String getErrString(int reason, String areaRoot) {
        String msgKey = null;
        switch (reason) {
            case 0: {
                msgKey = S_CANC_WRITE_SESSION;
                break;
            }
            case 1: {
                msgKey = S_CANC_READ_SESSION;
                break;
            }
            case 2: {
                msgKey = S_ACTIVE_WRITER_IN_WL;
                break;
            }
            case 3: {
                msgKey = S_ACTIVE_READERS_IN_WL;
                break;
            }
            case 4: {
                msgKey = S_ACTIVE_WRITER_IN_RL;
                break;
            }
            case 5: {
                msgKey = S_INACTIVE_WRITER_IN_WL;
                break;
            }
            default: {
                msgKey = S_OTHER_INVALID_COND;
            }
        }
        String msg = OiixResourceBundle.getString(msgKey);
        String[] args = new String[]{areaRoot};
        MessageFormat mf = new MessageFormat(msg);
        return mf.format(args);
    }

    public int getReason() {
        return this.m_reason;
    }

    public static boolean isStandardReason(int reason) {
        return reason >= 0 && reason <= 4;
    }

    public boolean containsStandardReason() {
        return OiitTargetLockNotAvailableException.isStandardReason(this.m_reason);
    }
}

