/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiiv;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.BitSet;
import java.util.Vector;
import oracle.sysman.oii.oiiv.OiivKeeper;
import oracle.sysman.oii.oiiv.OiivVerIndCapable;
import oracle.sysman.oii.oiiv.OiivVerIndConversionException;
import oracle.sysman.oii.oiiv.OiivVerIndMergeCapable;
import oracle.sysman.oii.oiiv.OiivVerIndNameValuePair;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiivVerIndObjectRep
implements Serializable {
    static final long serialVersionUID = 4479850894202773884L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x800000;
    private String m_className;
    private Vector m_nameValuePairs = new Vector();

    public void setClassName(String className) {
        this.m_className = className;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void addNVPair(String name, Object obj) {
        if (OiixVectorOps.vectIndexOf(this.m_nameValuePairs, (Object)name) == -1) {
            this.m_nameValuePairs.addElement(new OiivVerIndNameValuePair(name, obj));
        }
    }

    public void setNVPair(String name, Object obj) {
        int nvPairPos = -1;
        nvPairPos = OiixVectorOps.vectIndexOf(this.m_nameValuePairs, (Object)name);
        if (nvPairPos != -1) {
            this.m_nameValuePairs.removeElementAt(nvPairPos);
        }
        this.m_nameValuePairs.addElement(new OiivVerIndNameValuePair(name, obj));
    }

    public Object getObjectForName(String name) {
        Object retObj = null;
        int pairPos = OiixVectorOps.vectIndexOf(this.m_nameValuePairs, (Object)name);
        if (pairPos != -1) {
            OiivVerIndNameValuePair nvp = (OiivVerIndNameValuePair)this.m_nameValuePairs.elementAt(pairPos);
            retObj = nvp.getObject();
        }
        return retObj;
    }

    public boolean isNamedValueEqualTo(String name, Object obj) {
        Object checkObj;
        Object objForName = this.getObjectForName(name);
        if (objForName instanceof OiivVerIndObjectRep) {
            try {
                checkObj = ((OiivVerIndObjectRep)objForName).getVerDepVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
                checkObj = objForName;
            }
        } else {
            checkObj = objForName;
        }
        return obj.equals(checkObj);
    }

    public Object getVerDepVersion() throws OiivVerIndConversionException {
        try {
            Class<?> objClass = Class.forName(this.getClassName());
            Class[] paramList = new Class[]{OiivVerIndObjectRep.class};
            Constructor<?> constructor = objClass.getConstructor(paramList);
            Object[] initArgs = new Object[]{this};
            Object retObj = constructor.newInstance(initArgs);
            return retObj;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new OiivVerIndConversionException(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            throw new OiivVerIndConversionException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            throw new OiivVerIndConversionException(iae.getMessage());
        }
        catch (IllegalArgumentException iare) {
            iare.printStackTrace();
            throw new OiivVerIndConversionException(iare.getMessage());
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            ite.getTargetException().printStackTrace();
            throw new OiivVerIndConversionException(ite.getMessage());
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
            throw new OiivVerIndConversionException(nsme.getMessage());
        }
        catch (SecurityException se) {
            se.printStackTrace();
            throw new OiivVerIndConversionException(se.getMessage());
        }
    }

    public String toString() {
        return "\n[Storing " + this.m_className + " as " + this.m_nameValuePairs + "]";
    }

    public static Vector getVerIndepFormOfVect(Vector vdvect) {
        Vector retVect = new Vector();
        int numVds = vdvect.size();
        for (int i = 0; i < numVds; ++i) {
            Object verDepObj = vdvect.elementAt(i);
            Object addElem = verDepObj instanceof OiivVerIndCapable ? ((OiivVerIndCapable)verDepObj).getVerIndRep() : verDepObj;
            retVect.addElement(addElem);
        }
        return retVect;
    }

    public static Vector getVerDepFormOfVect(Vector vivect) {
        Vector<Object> retVect = new Vector<Object>();
        int numVis = vivect.size();
        for (int i = 0; i < numVis; ++i) {
            Object verIndObj = vivect.elementAt(i);
            Object addElem = null;
            if (verIndObj instanceof OiivVerIndObjectRep) {
                try {
                    addElem = ((OiivVerIndObjectRep)verIndObj).getVerDepVersion();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    addElem = verIndObj;
                }
            } else {
                addElem = verIndObj;
            }
            retVect.addElement(addElem);
        }
        return retVect;
    }

    public static void mergeVDVectIntoVIVect(Vector vdVect, Vector viVect, String pKeyName) {
        String[] pKeyNames = new String[]{pKeyName};
        OiivVerIndObjectRep.mergeVDVectIntoVIVect(vdVect, viVect, pKeyNames);
    }

    public static void mergeVDVectIntoVIVect(Vector vdVect, Vector viVect, String[] pKeyNames) {
        int i;
        int i2;
        int posInCurrent;
        int numStoredObjs = viVect.size();
        BitSet objsToDelete = new BitSet(numStoredObjs);
        BitSet objsToUpdate = new BitSet(numStoredObjs);
        int numCurrentObjs = vdVect.size();
        BitSet objsToNotTransfer = new BitSet(numCurrentObjs);
        String vdObjTypeStr = null;
        if (numStoredObjs > 0) {
            vdObjTypeStr = ((OiivVerIndObjectRep)viVect.firstElement()).getClassName();
        }
        for (int i3 = 0; i3 < numStoredObjs; ++i3) {
            boolean update = false;
            OiivVerIndObjectRep vIndObj = (OiivVerIndObjectRep)viVect.elementAt(i3);
            boolean foundMatch = false;
            int numKeys = pKeyNames.length;
            Object[] pKeys = new Object[numKeys];
            for (int k = 0; k < numKeys; ++k) {
                pKeys[k] = vIndObj.getObjectForName(pKeyNames[k]);
            }
            posInCurrent = -1;
            while (!foundMatch && (posInCurrent = OiixVectorOps.vectIndexOf(vdVect, pKeys[0], posInCurrent + 1)) != -1) {
                Object matchObj = vdVect.elementAt(posInCurrent);
                if (matchObj instanceof OiivVerIndCapable) {
                    OiivVerIndCapable viMatchObj = (OiivVerIndCapable)matchObj;
                    boolean mismatch = false;
                    for (int k = 1; k < numKeys; ++k) {
                        if (viMatchObj.compareKeyValue(pKeyNames[k], pKeys[k])) continue;
                        mismatch = true;
                        break;
                    }
                    if (mismatch) continue;
                    foundMatch = true;
                    boolean bl = update = !viMatchObj.wasCreatedInThisSession();
                    if (update) {
                        OiivVerIndObjectRep newVIndObj;
                        if (matchObj instanceof OiivVerIndMergeCapable) {
                            OiivVerIndMergeCapable vimObj = (OiivVerIndMergeCapable)matchObj;
                            newVIndObj = vimObj.mergeVerIndRep(vIndObj);
                        } else {
                            newVIndObj = viMatchObj.getVerIndRep();
                        }
                        viVect.setElementAt(newVIndObj, i3);
                        objsToNotTransfer.set(posInCurrent);
                    }
                }
                if (update) continue;
                objsToDelete.set(i3);
            }
            if (foundMatch) continue;
            objsToDelete.set(i3);
        }
        int numDeletedObjs = 0;
        for (i2 = 0; i2 < numStoredObjs; ++i2) {
            if (!objsToDelete.get(i2)) continue;
            viVect.removeElementAt(i2 - numDeletedObjs);
            ++numDeletedObjs;
        }
        for (i2 = 0; i2 < numCurrentObjs; ++i2) {
            if (objsToNotTransfer.get(i2)) continue;
            Object obj = vdVect.elementAt(i2);
            OiivVerIndObjectRep objToAdd = null;
            objToAdd = obj instanceof OiivVerIndCapable ? ((OiivVerIndCapable)obj).getVerIndRep() : (OiivVerIndObjectRep)obj;
            viVect.addElement(objToAdd);
        }
        int nIndSize = viVect.size();
        Vector<OiivKeeper> temp = new Vector<OiivKeeper>(nIndSize);
        for (i = 0; i < nIndSize; ++i) {
            OiivVerIndObjectRep vIndObj = (OiivVerIndObjectRep)viVect.elementAt(i);
            vdObjTypeStr = vIndObj.getClassName();
            Object pKey = vIndObj.getObjectForName(pKeyNames[0]);
            posInCurrent = OiixVectorOps.vectIndexOf(vdVect, pKey);
            if (posInCurrent == -1) continue;
            temp.addElement(new OiivKeeper(vIndObj, posInCurrent));
        }
        nIndSize = temp.size();
        for (i = 0; i < nIndSize; ++i) {
            OiivKeeper vObj = (OiivKeeper)temp.elementAt(i);
            OiivVerIndObjectRep vIndObj = vObj.getObject();
            posInCurrent = vObj.getIndex();
            OiivVerIndObjectRep vIndReplObj = (OiivVerIndObjectRep)viVect.elementAt(posInCurrent);
            int nIndex = viVect.indexOf(vIndObj);
            if (nIndex == -1) continue;
            viVect.setElementAt(vIndReplObj, nIndex);
            viVect.setElementAt(vIndObj, posInCurrent);
        }
    }
}

