/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.IOException;
import java.io.OutputStream;
import oracle.sysman.oii.oiix.OiixStreamListener;

public class OiixBufferOutputStream
extends OutputStream {
    private static final int DEFAULT_SIZE = 512;
    private StringBuffer m_sbuf = new StringBuffer();
    private int m_charCount = 0;
    private OiixStreamListener m_streamListener = null;

    public void write(int b) throws IOException {
        this.m_sbuf.append((char)b);
        ++this.m_charCount;
        if (this.m_streamListener != null) {
            this.m_streamListener.newChar(this.m_charCount, (char)b);
        }
    }

    public void write(String str) throws IOException {
        this.m_sbuf.append(str);
        this.m_charCount += str.length();
        if (str.length() > 0 && this.m_streamListener != null) {
            this.m_streamListener.newChar(this.m_charCount, str.charAt(str.length() - 1));
        }
    }

    public int getLength() {
        return this.m_charCount;
    }

    public char[] getChars(int srcBegin, int srcEnd) {
        int numChars = srcEnd - srcBegin + 1;
        char[] retChars = null;
        if (numChars > 0) {
            retChars = new char[numChars];
            this.m_sbuf.getChars(srcBegin, srcEnd, retChars, 0);
        }
        return retChars;
    }

    public String getContents() {
        StringBuffer sBuff = new StringBuffer(this.m_sbuf.length());
        try {
            for (int i = 0; i < this.m_sbuf.length(); ++i) {
                char c = this.m_sbuf.charAt(i);
                if (c != '\r') {
                    sBuff.append(c);
                    continue;
                }
                if (i + 1 < this.m_sbuf.length() && this.m_sbuf.charAt(i + 1) == '\n') continue;
                sBuff.append('\n');
            }
        }
        catch (Exception e) {
            return this.m_sbuf.toString();
        }
        return sBuff.toString();
    }

    public void setStreamListener(OiixStreamListener streamListener) {
        this.m_streamListener = streamListener;
    }

    public OiixStreamListener getStreamListener() {
        return this.m_streamListener;
    }

    public void resetStreamListener() {
        this.m_streamListener = null;
    }
}

