/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.sysman.emCfg.client.CfwClient;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IActionReference;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.core.CfmFactory;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OiixCFOps {
    public static final String TAG_aggAction = "agg:Action";
    public static final String TAG_aggActionStep = "agg:ActionStep";
    public static final String TAG_aggPlugInInvocation = "agg:PlugInInvocation";
    public static final String TAG_aggPlugIn = "agg:PlugIn";
    public static final String TAG_aggCmdExec = "agg:CmdExec";
    public static final String TAG_aggNonSilent = "agg:NonSilent";
    public static final String TAG_aggPlugInRef = "agg:PlugInRef";
    public static final String TAG_aggNonSilentInvocation = "agg:NonSilentInvocation";
    public static final String TAG_aggSimplestAggregateRef = "agg:SimplestAggregateRef";
    public static final String TAG_aggParameterArgumentRef = "agg:ParameterArgumentRef";
    public static final String TAG_aggOptionArgument = "agg:OptionArgument";
    public static final String TAG_aggComplexAggregate = "agg:ComplexAggregate";
    public static final String TAG_aggDisplayResourceJar = "agg:DisplayResourceJar";
    public static final String TAG_aggPath = "agg:Path";
    public static final String TAG_aggAggrActionRef = "agg:AggregateActionRef";
    public static final String TAG_aggComplexAggregateRef = "agg:ComplexAggregateRef";
    public static final String ATTRIBUTE_idref = "idref";
    public static final String ATTRIBUTE_id = "id";
    public static final String ATTRIBUTE_invocation = "invocation";
    public static final String ATTRIBUTE_types = "types";
    public static final String ATTRIBUTE_silent = "silent";
    public static final String ATTRIBUTE_ownership = "ownership";
    public static final String ATTRIBUTE_owner = "owner";
    public static final String ATTRIBUTE_required = "required";
    public static final String ATTRIBUTE_standaloneonly = "standaloneonly";
    public static final String ATTRIBUTE_priority = "priority";
    public static final String ATTRIBUTE_VAL_exclusive = "exclusive";
    public static final String ATTRIBUTE_VAL_detached = "detached";
    public static final String ATTRIBUTE_EXPAND = "expand";
    public static final String ATTRIBUTE_VAL_true = "true";
    public static final String ATTRIBUTE_VAL_false = "false";
    public static final String ATTRIBUTE_DISP_ID = "display_id";
    public static final String uf_configure = "configure";
    public static final String uf_deconfigure = "deconfigure";
    public static final String uf_clone = "clone";
    public static final String uf_addnode = "addnode";
    public static final String uf_addlanguage = "addlanguage";
    public static final String uf_upgrade = "upgrade";
    public static final String uf_patchsetConfigure = "patchsetConfigure";
    public static final String configure = "configuration";
    public static final String deconfigure = "purgingdrastic";
    public static final String clone = "cloningdrastic";
    public static final String addnode = "addingnode";
    public static final String addlanguage = "addinglanguage";
    public static final String upgrade = "upgrade";
    public static final String patchconfigure = "patchsetconfigure";
    public static final String configureType = "configuration";
    public static final String deconfigureType = "purging:drastic";
    public static final String cloneType = "cloning:drastic";
    public static final String addnodeType = "adding_node";
    public static final String addlanguageType = "adding_language";
    public static final String upgradeType = "upgrade";
    public static final String patchconfigureType = "patch_set_configure";
    public static final int mode_perform = 1;
    public static final int mode_showStatus = 5;
    public static final int mode_listTools = 4;
    public static final String instancePath = "instancePath";
    public static final String descriptionPath = "descriptionPath";
    public static final String aggregateID = "aggregateID";
    public static final String COMPONENT_XML = "COMPONENT_XML";
    public static final String MODE = "MODE";
    public static final String requestType = "requestType";
    public static final String listTools = "listTools";
    public static final String showStatus = "showStatus";
    public static final String performConfig = "performConfig";
    public static final String perform = "perform";
    public static final String actionType = "actionType";
    public static final String actionID = "actionID";
    public static final String ACTION = "ACTION";
    public static final String oracleHome = "oracleHome";
    public static final String RESPONSE_FILE = "RESPONSE_FILE";
    public static final String responseFile = "responseFile";
    public static final String ORACLE_HOME = "ORACLE_HOME";
    public static final String INV_PTR_LOC = "INV_PTR_LOC";
    public static final String RUNCONFIG_CUSTOM_ACTION = "CUSTOM_ACTION";
    public static final String out = "out";
    public static final String err = "err";
    public static final String debug = "debug";
    public static final String retry = "retry";
    public static final String RERUN = "RERUN";
    public static final String CFM = "CFM";
    public static final String XML_EXTN = ".xml";
    public static final String CFM_WITH_DOTS = ".CFM.";
    public static final String INST_XML_EXTN = ".inst.xml";
    public static final String DOT = ".";
    public static final String agg = "agg";
    public static final String HTTP_wwwDOToracleDOTcom_sysman_emCfg_AggregateDescriptions = "http://www.oracle.com/sysman/emCfg/AggregateDescriptions";
    public static final String FORWARD_SLASH = "/";
    public static final String COMMON = "common";
    public static final String UTF8 = "UTF-8";
    public static final String XSL = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:output method=\"xml\"/><xsl:param name=\"indent-increment\" select=\"'   '\" /><xsl:template match=\"*\"><xsl:param name=\"indent\" select=\"'&#xA;'\"/><xsl:value-of select=\"$indent\"/><xsl:copy><xsl:copy-of select=\"@*\" /><xsl:apply-templates><xsl:with-param name=\"indent\" select=\"concat($indent, $indent-increment)\"/></xsl:apply-templates><xsl:if test=\"*\"><xsl:value-of select=\"$indent\"/></xsl:if></xsl:copy></xsl:template><xsl:template match=\"comment()|processing-instruction()\"><xsl:copy /></xsl:template><!-- WARNING: this is dangerous. Handle with care --><xsl:template match=\"text()[normalize-space()='']\"/></xsl:stylesheet>";
    public static final String YES = "yes";
    public static final String help = "help";
    public static final String OPTIONAL_CONFIG_TOOLS = "OPTIONAL_CONFIG_TOOLS";
    public static final String optionalTools = "optionalTools";
    private static final String UPGRADE_SYSTEM_KEY = "oracle.installer.configureAction";
    private static final String UPGRADE_SYSTEM_VAL = "upgrade";
    private static final String JRE_EXECUTABLE = "java";
    private static Vector m_cfwClients;
    public static String S_PERMS_FOR_CFW_FILES;
    public static String S_PERMS_FOR_CFW_DIR;
    public static String S_PERMS_FOR_CFW_FILES_TXT;
    private static Vector vHomesWithInternalPlugins;
    private static String sRunConfigCmd;

    public void OiixCFOps() {
    }

    public static IAggregate getAggregate(CfwSession cfs, String sCompName) {
        IAggregateReference[] aggrRef = null;
        try {
            if (null != cfs) {
                aggrRef = cfs.getAggregateReferences(COMMON);
            }
        }
        catch (CfwException excep) {
            OiiolTextLogger.appendException((Exception)((Object)excep));
        }
        if (aggrRef != null) {
            if (aggrRef.length == 0) {
                OiiolTextLogger.appendText("no Aggregate found by CF:Configuration not done");
                return null;
            }
            for (int i = 0; i < aggrRef.length; ++i) {
                if (null == sCompName || aggrRef[i].getSelfID().compareTo(sCompName) != 0) continue;
                try {
                    return cfs.getAggregate(aggrRef[i]);
                }
                catch (CfwException e) {
                    OiiolTextLogger.appendException((Exception)((Object)e));
                    return null;
                }
            }
        }
        OiiolTextLogger.appendText("for " + sCompName + " no aggregate found by cf: no configuration");
        return null;
    }

    public static IParameter getParameter(IAggregate cfwAggr, IParameterReference paramRef) {
        IParameter param = null;
        try {
            if (null != cfwAggr && null != paramRef) {
                param = cfwAggr.getParameter(paramRef);
            }
        }
        catch (CfwException exc) {
            OiiolTextLogger.appendText(exc.getMessage());
        }
        return param;
    }

    public static ActionType getActionType() {
        String sessionType = System.getProperty("oracle.installer.sessionType");
        if (sessionType.equalsIgnoreCase("Install")) {
            if (OiicInstaller.getConfigContext().isPatchSetInstall()) {
                return ActionType.PATCH_SET_CONFIGURE;
            }
            if (null != System.getProperty(UPGRADE_SYSTEM_KEY) && System.getProperty(UPGRADE_SYSTEM_KEY).equalsIgnoreCase("upgrade")) {
                return ActionType.UPGRADE;
            }
            return ActionType.CONFIGURATION;
        }
        if (sessionType.equalsIgnoreCase("DeInstall")) {
            return ActionType.PURGING_DRASTIC;
        }
        if (sessionType.equalsIgnoreCase("Clone")) {
            return ActionType.CLONING_DRASTIC;
        }
        if (sessionType.equalsIgnoreCase("AddNode")) {
            return ActionType.ADDING_NODE;
        }
        if (sessionType.equalsIgnoreCase("LangAddon")) {
            return ActionType.ADDING_LANGUAGE;
        }
        return null;
    }

    public static boolean isOverwriteConfigToolCommands() {
        boolean bAppendCfgCommands = new Boolean(System.getProperty("oracle.installer.appendConfigCommands", ATTRIBUTE_VAL_false));
        boolean bOverwriteCfgCommands = true;
        String sessionType = System.getProperty("oracle.installer.sessionType");
        if (sessionType.equalsIgnoreCase("Install")) {
            bOverwriteCfgCommands = !bAppendCfgCommands;
        }
        return bOverwriteCfgCommands;
    }

    public static String getConfigToolCommandsMessage(boolean bFailed) {
        String sConfigToolCommandMsg = "";
        String sMessageKey = "";
        Object[] saConfigToolCommandMsgArg = null;
        saConfigToolCommandMsgArg = new String[]{OiiolTextLogger.getConfigToolCommandsFileName()};
        sMessageKey = "S_INFO_CONFIGTOOLALLCOMMANDS_CREATED";
        if (bFailed) {
            saConfigToolCommandMsgArg = new String[]{OiiolTextLogger.getFailedConfigToolCommandsFileName()};
            sMessageKey = "S_INFO_CONFIGTOOLFAILEDCOMMANDS_CREATED";
        }
        sConfigToolCommandMsg = OiixResourceBundle.getString(sMessageKey, saConfigToolCommandMsgArg);
        return sConfigToolCommandMsg;
    }

    public static void logMsgForUnsuccessfulTools() {
        OiiolTextLogger.writeToLogAndConsole("--------------------------------------");
        OiiolTextLogger.writeToLogAndConsole(OiixCFOps.getConfigToolCommandsMessage(true));
        OiiolTextLogger.writeToLogAndConsole(OiixCFOps.getConfigToolCommandsMessage(false));
    }

    public static String getCommandForRunConfig(String sOraHome, boolean bFailed) {
        String sResult = null;
        Object[] msgArgs = new Object[]{new String(sOraHome), "sh", ATTRIBUTE_VAL_true, uf_configure};
        msgArgs[3] = OiixCFOps.getActionTypeAsStringForRunConfig();
        if (!OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            msgArgs[1] = "bat";
        }
        if (!bFailed) {
            if (!vHomesWithInternalPlugins.contains(sOraHome)) {
                vHomesWithInternalPlugins.addElement(sOraHome);
            }
            sResult = MessageFormat.format(sRunConfigCmd, msgArgs);
        } else {
            msgArgs[2] = ATTRIBUTE_VAL_false;
            if (vHomesWithInternalPlugins.contains(sOraHome)) {
                sResult = MessageFormat.format(sRunConfigCmd, msgArgs);
            }
        }
        OiiolTextLogger.appendText("\n The Runconfig command constructed is " + sResult);
        return sResult;
    }

    public static String getActionTypeAsStringForRunConfig() {
        String sessionType = System.getProperty("oracle.installer.sessionType");
        if (sessionType.equalsIgnoreCase("Install")) {
            if (OiicInstaller.getConfigContext().isPatchSetInstall()) {
                return uf_patchsetConfigure;
            }
            if (null != System.getProperty(UPGRADE_SYSTEM_KEY) && System.getProperty(UPGRADE_SYSTEM_KEY).equalsIgnoreCase("upgrade")) {
                return "upgrade";
            }
            return uf_configure;
        }
        if (sessionType.equalsIgnoreCase("DeInstall")) {
            return uf_deconfigure;
        }
        if (sessionType.equalsIgnoreCase("Clone")) {
            return uf_clone;
        }
        if (sessionType.equalsIgnoreCase("AddNode")) {
            return uf_addnode;
        }
        if (sessionType.equalsIgnoreCase("LangAddon")) {
            return uf_addlanguage;
        }
        return null;
    }

    public static String getActionTypeAsString() {
        String sessionType = System.getProperty("oracle.installer.sessionType");
        if (sessionType.equalsIgnoreCase("Install")) {
            if (OiicInstaller.getConfigContext().isPatchSetInstall()) {
                return patchconfigureType;
            }
            if (null != System.getProperty(UPGRADE_SYSTEM_KEY) && System.getProperty(UPGRADE_SYSTEM_KEY).equalsIgnoreCase("upgrade")) {
                return "upgrade";
            }
            return "configuration";
        }
        if (sessionType.equalsIgnoreCase("DeInstall")) {
            return deconfigureType;
        }
        if (sessionType.equalsIgnoreCase("Clone")) {
            return cloneType;
        }
        if (sessionType.equalsIgnoreCase("AddNode")) {
            return addnodeType;
        }
        if (sessionType.equalsIgnoreCase("LangAddon")) {
            return addlanguageType;
        }
        return null;
    }

    public static String getActionName() {
        String sessionType = System.getProperty("oracle.installer.sessionType");
        if (sessionType.equalsIgnoreCase("Install")) {
            if (OiicInstaller.getConfigContext().isPatchSetInstall()) {
                return patchconfigure;
            }
            if (null != System.getProperty(UPGRADE_SYSTEM_KEY) && System.getProperty(UPGRADE_SYSTEM_KEY).equalsIgnoreCase("upgrade")) {
                return "upgrade";
            }
            return "configuration";
        }
        if (sessionType.equalsIgnoreCase("DeInstall")) {
            return deconfigure;
        }
        if (sessionType.equalsIgnoreCase("Clone")) {
            return clone;
        }
        if (sessionType.equalsIgnoreCase("AddNode")) {
            return addnode;
        }
        if (sessionType.equalsIgnoreCase("LangAddon")) {
            return addlanguage;
        }
        return null;
    }

    public static String getActionTypeName(String actionName) {
        if (actionName.equalsIgnoreCase("configuration")) {
            return "configuration";
        }
        if (actionName.equalsIgnoreCase(deconfigure)) {
            return deconfigureType;
        }
        if (actionName.equalsIgnoreCase(clone)) {
            return cloneType;
        }
        if (actionName.equalsIgnoreCase(addnode)) {
            return addnodeType;
        }
        if (actionName.equalsIgnoreCase(addlanguage)) {
            return addlanguageType;
        }
        if (actionName.equalsIgnoreCase("upgrade")) {
            return "upgrade";
        }
        if (actionName.equalsIgnoreCase(patchconfigure)) {
            return patchconfigureType;
        }
        return null;
    }

    public static String getActionTypeNameFromUFActionName(String uf_actionName) {
        if (uf_actionName.equalsIgnoreCase(uf_configure)) {
            return "configuration";
        }
        if (uf_actionName.equalsIgnoreCase(uf_deconfigure)) {
            return deconfigureType;
        }
        if (uf_actionName.equalsIgnoreCase(uf_clone)) {
            return cloneType;
        }
        if (uf_actionName.equalsIgnoreCase(uf_addnode)) {
            return addnodeType;
        }
        if (uf_actionName.equalsIgnoreCase(uf_addlanguage)) {
            return addlanguageType;
        }
        if (uf_actionName.equalsIgnoreCase("upgrade")) {
            return "upgrade";
        }
        if (uf_actionName.equalsIgnoreCase(uf_patchsetConfigure)) {
            return patchconfigureType;
        }
        return null;
    }

    public static String getActionName(String actionTypeName) {
        if (actionTypeName.equalsIgnoreCase("configuration")) {
            return "configuration";
        }
        if (actionTypeName.equalsIgnoreCase(deconfigureType)) {
            return deconfigure;
        }
        if (actionTypeName.equalsIgnoreCase(cloneType)) {
            return clone;
        }
        if (actionTypeName.equalsIgnoreCase(addnodeType)) {
            return addnode;
        }
        if (actionTypeName.equalsIgnoreCase(addlanguageType)) {
            return addlanguage;
        }
        if (actionTypeName.equalsIgnoreCase("upgrade")) {
            return "upgrade";
        }
        if (actionTypeName.equalsIgnoreCase(patchconfigureType)) {
            return patchconfigure;
        }
        return null;
    }

    public static CfwSession getCfwSession(CfwClient cfc) {
        if (cfc == null) {
            return null;
        }
        CfwSession cs = null;
        try {
            cs = cfc.begin();
        }
        catch (CfwException e) {
            OiiolTextLogger.appendException((Exception)((Object)e));
            return cs;
        }
        return cs;
    }

    public static CfwClient getCfwClient(boolean bDebug, String sOraHome, String sAggrXMLPath, String sAggrInstancePath, List aggrsToLoad) {
        CfwClient cl = null;
        OiiolTextLogger.appendText("cf session for OH: " + sOraHome + " TL Aggr: " + aggrsToLoad + " instancePath: " + sAggrXMLPath);
        try {
            CfwClient.resetCfw();
            CfmFactory.reset();
            cl = CfwClient.connect((boolean)bDebug, (String)sOraHome, (String)sAggrXMLPath, (String)sAggrInstancePath, (List)aggrsToLoad);
        }
        catch (CfwException e) {
            OiiolTextLogger.appendException((Exception)((Object)e));
            return cl;
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
            return cl;
        }
        catch (Throwable er) {
            OiiolTextLogger.appendText(er.getMessage());
            OiiolTextLogger.appendText("Unable to get the Config Fw Client, hence Configuration tools shall not be executed");
            return cl;
        }
        if (null != cl) {
            if (null == m_cfwClients) {
                m_cfwClients = new Vector();
            }
            if (!m_cfwClients.contains(cl)) {
                m_cfwClients.add(cl);
            }
        }
        return cl;
    }

    public static void disconnectCfwClients() {
        if (null != m_cfwClients) {
            int iClientSize = m_cfwClients.size();
            for (int i = 0; i < iClientSize; ++i) {
                CfwClient client = (CfwClient)m_cfwClients.elementAt(i);
                client.disconnect();
            }
        }
    }

    public static IAction getAction(IAggregate TLAggregate, ActionType at) {
        IActionReference[] actionRefs = null;
        try {
            if (TLAggregate != null) {
                actionRefs = TLAggregate.getActionReferences();
            }
        }
        catch (CfwException e) {
            OiiolTextLogger.appendException((Exception)((Object)e));
        }
        if (actionRefs != null) {
            for (int j = 0; j < actionRefs.length; ++j) {
                if (actionRefs == null) continue;
                try {
                    IAction act = TLAggregate.getAction(actionRefs[j]);
                    if (act == null || !act.isType(at)) continue;
                    return act;
                }
                catch (CfwException e) {
                    OiiolTextLogger.appendException((Exception)((Object)e));
                    return null;
                }
            }
        }
        return null;
    }

    public static String getPlugInID(IMicroStepState mstate) {
        String plugInID = null;
        try {
            if (null != mstate) {
                plugInID = mstate.getPlugInID();
            }
        }
        catch (CfwException cfe) {
            OiiolTextLogger.appendException((Exception)((Object)cfe));
        }
        return plugInID;
    }

    public static String getPlugInCommand(CfwSession cfs, IMicroStepStateReference imssr) {
        String sPlugInCmd = null;
        if (null != cfs && null != imssr) {
            IMicroStepState state = cfs.getMicroStepState(imssr);
            try {
                IPlugInInvocationState pState = state.getPlugInInvocationState();
                String cmd = pState.getCommand() == null ? "#" : pState.getCommand();
                String args = pState.getArg() == null ? "" : pState.getArg();
                sPlugInCmd = cmd + " " + args;
            }
            catch (CfwException ce) {
                OiiolTextLogger.appendText(ce.getMessage());
            }
        }
        return sPlugInCmd;
    }

    public static IAggregateReference getAggregateReference(CfwSession cfs, String sAggrName) {
        IAggregateReference[] aggrRef = null;
        try {
            if (null != cfs) {
                aggrRef = cfs.getAggregateReferences(COMMON);
            }
        }
        catch (CfwException excep) {
            OiiolTextLogger.appendException((Exception)((Object)excep));
        }
        if (aggrRef != null) {
            for (int i = 0; i < aggrRef.length; ++i) {
                if (null == sAggrName || aggrRef[i].getSelfID().compareTo(sAggrName) != 0) continue;
                return aggrRef[i];
            }
        }
        return null;
    }

    public static int getActionStepIndex(IMicroStepStateReference plugIn, CfwSession cfSession) {
        int actionStepIndex = -1;
        IMicroStepState mstate = null;
        if (null != cfSession) {
            mstate = cfSession.getMicroStepState(plugIn);
        }
        try {
            if (null != mstate) {
                IActionStepState sstate = mstate.getActionStepState();
                actionStepIndex = Integer.parseInt(sstate.getSelfID());
            }
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendText(ce.getMessage());
        }
        return actionStepIndex;
    }

    public static int getMicroStepIndex(IMicroStepStateReference plugIn, CfwSession cfSession) {
        IMicroStepState mstate;
        int microStepIndex = -1;
        if (null != cfSession && null != plugIn && null != (mstate = cfSession.getMicroStepState(plugIn))) {
            microStepIndex = Integer.parseInt(mstate.getSelfID());
        }
        return microStepIndex;
    }

    public static String getPlugInName(IMicroStepStateReference plugIn, CfwSession cfSession) {
        String plugInName = null;
        if (null != plugIn && null != cfSession) {
            IMicroStepState mstate = cfSession.getMicroStepState(plugIn);
            try {
                plugInName = mstate.getPlugInID();
            }
            catch (CfwException ce) {
                OiiolTextLogger.appendText(ce.getMessage());
            }
        }
        return plugInName;
    }

    public static String getAggregateID(IMicroStepStateReference imssr, CfwSession cfs) {
        String aggrID = null;
        try {
            IMicroStepState mstate;
            if (null != cfs && null != (mstate = cfs.getMicroStepState(imssr))) {
                IActionState astate = mstate.getActionState();
                aggrID = astate.getOriginator().getSelfID();
            }
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendException((Exception)((Object)ce));
        }
        return aggrID;
    }

    public static String getActonID(IMicroStepStateReference imssr, CfwSession cfs) {
        String actionID = null;
        try {
            IMicroStepState mstate;
            if (null != cfs && null != (mstate = cfs.getMicroStepState(imssr))) {
                IActionState astate = mstate.getActionState();
                actionID = astate.getSelfID();
            }
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendException((Exception)((Object)ce));
        }
        return actionID;
    }

    public static void destroyCFSession() {
        CfwClient.resetCfw();
        CfmFactory.reset();
    }

    public static IAggregateReference[] getReferredAggregates(IAggregate aggr) {
        IAggregateReference[] TLAggrRefs = null;
        try {
            if (null != aggr) {
                TLAggrRefs = aggr.getReferredAggregateReferences();
            }
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendException((Exception)((Object)ce));
        }
        return TLAggrRefs;
    }

    public static IAggregate getAggregate(CfwSession cfs, IAggregateReference ar) {
        IAggregate aggr = null;
        try {
            if (null != cfs && null != ar) {
                aggr = cfs.getAggregate(ar);
            }
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendException((Exception)((Object)ce));
        }
        return aggr;
    }

    public static String getJreLocation() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return JRE_EXECUTABLE;
        }
        String jreLoc = "";
        jreLoc = javaHome + File.separator + "bin" + File.separator + JRE_EXECUTABLE;
        return OiixPathOps.getNativeForm(jreLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeXMLDocument(XMLDocument doc, String sFilename) {
        block11: {
            if (null == sFilename || null == doc) {
                return;
            }
            FileOutputStream oFileWriter = null;
            OutputStreamWriter oWriter = null;
            File xmlFile = new File(OiixPathOps.getNativeForm(sFilename));
            try {
                oFileWriter = new FileOutputStream(xmlFile);
                oWriter = new OutputStreamWriter((OutputStream)oFileWriter, UTF8);
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException(ioe);
            }
            BufferedWriter oBufferedWriter = new BufferedWriter(oWriter);
            PrintWriter oPrintWriter = new PrintWriter(oBufferedWriter);
            doc.print(oPrintWriter);
            Object var9_8 = null;
            try {
                oPrintWriter.close();
                oBufferedWriter.close();
                oWriter.close();
                oFileWriter.close();
            }
            catch (IOException ioe2) {
                OiiolTextLogger.appendException(ioe2);
            }
            break block11;
            {
                catch (IOException ioe) {
                    OiiolTextLogger.appendException(ioe);
                    Object var9_9 = null;
                    try {
                        oPrintWriter.close();
                        oBufferedWriter.close();
                        oWriter.close();
                        oFileWriter.close();
                    }
                    catch (IOException ioe2) {
                        OiiolTextLogger.appendException(ioe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    oPrintWriter.close();
                    oBufferedWriter.close();
                    oWriter.close();
                    oFileWriter.close();
                }
                catch (IOException ioe2) {
                    OiiolTextLogger.appendException(ioe2);
                }
                throw throwable;
            }
        }
    }

    public static void passParameter(IParameter p, Object v, int nType) {
        try {
            if (null != p && null != v) {
                if (p.isSettable()) {
                    if (nType == 1) {
                        String val = (String)v;
                        p.setSimplestAsString(val);
                    } else if (nType == 3) {
                        Boolean val = (Boolean)v;
                        p.setSimplestAsBoolean(val.booleanValue());
                    } else if (nType == 2) {
                        Integer val = (Integer)v;
                        p.setSimplestAsInt(val.intValue());
                    } else if (nType == OiisVariable.STRINGLIST) {
                        String[] val = (String[])v;
                        p.setSimplestAsStringArray(val);
                    } else {
                        OiiolTextLogger.appendText("type: " + nType + " not supported to be passed to CF");
                    }
                } else {
                    OiiolTextLogger.appendText(p.getSelfID() + " is not settable, hence not setting the value");
                }
            }
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendText(ce.getMessage());
        }
    }

    public static void letCFSaveConfigInfo(CfwSession cfs) {
        try {
            if (null != cfs) {
                cfs.save();
            }
        }
        catch (CfwException excep) {
            OiiolTextLogger.appendText(excep.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void getTransformedXML(Node n, String outputFileName) {
        block31: {
            ByteArrayInputStream bis = null;
            FileOutputStream fis = null;
            if (null == n || null == outputFileName) {
                return;
            }
            bis = new ByteArrayInputStream(XSL.getBytes(UTF8));
            InputSource is = new InputSource(bis);
            DOMParser parser = new DOMParser();
            parser.parse(is);
            XMLDocument doc = parser.getDocument();
            DOMSource xslsource = new DOMSource((Node)doc);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(xslsource);
            transformer.setOutputProperty("standalone", YES);
            fis = new FileOutputStream(outputFileName);
            StreamResult result = new StreamResult(fis);
            DOMSource source = new DOMSource(n);
            transformer.transform(source, result);
            Object var13_17 = null;
            try {
                if (null != fis) {
                    fis.close();
                }
                if (null != bis) {
                    bis.close();
                }
                break block31;
            }
            catch (IOException e2) {
                OiiolTextLogger.appendException(e2);
            }
            break block31;
            {
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    Object var13_18 = null;
                    try {
                        if (null != fis) {
                            fis.close();
                        }
                        if (null != bis) {
                            bis.close();
                        }
                        break block31;
                    }
                    catch (IOException e2) {
                        OiiolTextLogger.appendException(e2);
                    }
                    break block31;
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    Object var13_19 = null;
                    try {
                        if (null != fis) {
                            fis.close();
                        }
                        if (null != bis) {
                            bis.close();
                        }
                        break block31;
                    }
                    catch (IOException e2) {
                        OiiolTextLogger.appendException(e2);
                    }
                    break block31;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object var13_20 = null;
                    try {
                        if (null != fis) {
                            fis.close();
                        }
                        if (null != bis) {
                            bis.close();
                        }
                        break block31;
                    }
                    catch (IOException e2) {
                        OiiolTextLogger.appendException(e2);
                    }
                    break block31;
                }
                catch (XMLParseException e) {
                    e.printStackTrace();
                    Object var13_21 = null;
                    try {
                        if (null != fis) {
                            fis.close();
                        }
                        if (null != bis) {
                            bis.close();
                        }
                        break block31;
                    }
                    catch (IOException e2) {
                        OiiolTextLogger.appendException(e2);
                    }
                    break block31;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    Object var13_22 = null;
                    try {
                        if (null != fis) {
                            fis.close();
                        }
                        if (null != bis) {
                            bis.close();
                        }
                        break block31;
                    }
                    catch (IOException e2) {
                        OiiolTextLogger.appendException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_23 = null;
                try {
                    if (null != fis) {
                        fis.close();
                    }
                    if (null != bis) {
                        bis.close();
                    }
                }
                catch (IOException e2) {
                    OiiolTextLogger.appendException(e2);
                }
                throw throwable;
            }
        }
    }

    public static File[] getCFMFiles(File dir, CFMFileFilter filter) {
        if (null != dir) {
            return dir.listFiles(filter);
        }
        return null;
    }

    public CFMFileFilter getCFMFilter() {
        return new CFMFileFilter();
    }

    public CFMFileFilter getCFMFilterForFile(String filename) {
        CFMFileFilter filter = new CFMFileFilter();
        filter.setFileName(filename);
        return filter;
    }

    public NotCFMFileFilter getNotCFMFileFilter() {
        return new NotCFMFileFilter();
    }

    public Vector getAggregateIDsCopiedAtInstall(File dir, NotCFMFileFilter filter) {
        Vector<String> aggrIds = new Vector<String>();
        if (null != dir) {
            String[] nonCFMFiles = dir.list(filter);
            for (int j = 0; j < nonCFMFiles.length; ++j) {
                String aggrID = this.getAggregateIDFromXMLFileName(nonCFMFiles[j]);
                if (aggrID == null) continue;
                aggrIds.add(aggrID);
            }
        }
        return aggrIds;
    }

    public static boolean isPlugInToBeExecutedAsDetached(CfwSession cfs, IMicroStepStateReference mssr, OiiiCompIdOhPair cidOhP) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        String ohLoc = instInv.getHomeLocation(cidOhP.getOHIndex());
        IMicroStepState mstate = cfs.getMicroStepState(mssr);
        String plugInOH = null;
        IActionState astate = null;
        try {
            astate = mstate.getActionState();
            if (astate != null) {
                plugInOH = astate.getOriginator().getOracleHome();
            }
        }
        catch (CfwException cfe) {
            OiiolTextLogger.appendText(cfe.getMessage() + "plugin: " + mssr.getSelfID() + "not to be executed as detached");
            return false;
        }
        File f1 = new File(ohLoc);
        File f2 = new File(plugInOH);
        if (f1.getAbsolutePath().compareTo(f2.getAbsolutePath()) == 0) {
            return mssr.getOwnerID().compareTo(cidOhP.getCompID().getName()) != 0;
        }
        return true;
    }

    String getAggregateIDFromXMLFileName(String aggrXMLFileName) {
        int lastDotIndex = aggrXMLFileName.lastIndexOf(DOT);
        if (lastDotIndex == -1) {
            return null;
        }
        int secondLastDotIndex = aggrXMLFileName.lastIndexOf(DOT, lastDotIndex - 1);
        if (secondLastDotIndex == -1) {
            return null;
        }
        String aggrID = aggrXMLFileName.substring(0, secondLastDotIndex);
        if (aggrID != null && aggrID.length() != 0) {
            return aggrID;
        }
        return null;
    }

    public static String getRunConfigCommand(String sOraHome, String sMode, String sAction, String sXmlName, boolean bRerun) {
        String SPACE = " ";
        StringBuffer sb = new StringBuffer();
        sb.append(sOraHome + File.separator + "oui" + File.separator + "bin" + File.separator + "runConfig");
        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            sb.append(".sh" + SPACE);
        } else {
            sb.append(".bat" + SPACE);
        }
        sb.append("ORACLE_HOME=" + sOraHome + SPACE);
        sb.append("MODE= " + sMode + SPACE);
        sb.append("ACTION=" + sAction + SPACE);
        sb.append("INV_PTR_LOC=" + sOraHome + File.separator + "oraInst.loc" + SPACE);
        sb.append("RERUN=" + Boolean.toString(bRerun) + SPACE);
        sb.append("COMPONENT_XML={" + sXmlName + "}" + SPACE);
        return sb.toString();
    }

    public static void deleteCFInstanceFiles(String sDir, String sFilename) {
        OiixCFOps cfops = new OiixCFOps();
        File[] cfmFiles = null;
        if (null != sDir && sDir.length() > 0) {
            cfmFiles = null != sFilename && sFilename.length() > 0 ? OiixCFOps.getCFMFiles(new File(sDir), cfops.getCFMFilterForFile(sFilename)) : OiixCFOps.getCFMFiles(new File(sDir), cfops.getCFMFilter());
        }
        if (null != cfmFiles) {
            for (int fileCount = 0; fileCount < cfmFiles.length; ++fileCount) {
                cfmFiles[fileCount].delete();
                OiiolTextLogger.appendText("in install deleted file: " + cfmFiles[fileCount].getAbsolutePath(), OiiolTextLogger.LOG_TRACE);
            }
            OiiolTextLogger.appendText("deleted all the required instance files");
        }
    }

    public static void backupCFInstanceFiles(String sDir, String sFilename) {
        OiixCFOps cfops = new OiixCFOps();
        File[] cfmFiles = null;
        if (null != sDir && sDir.length() > 0) {
            cfmFiles = null != sFilename && sFilename.length() > 0 ? OiixCFOps.getCFMFiles(new File(sDir), cfops.getCFMFilterForFile(sFilename)) : OiixCFOps.getCFMFiles(new File(sDir), cfops.getCFMFilter());
        }
        if (null != cfmFiles) {
            for (int fileCount = 0; fileCount < cfmFiles.length; ++fileCount) {
                try {
                    OiixFileOps.backUpFile(cfmFiles[fileCount].getAbsolutePath(), cfmFiles[fileCount].getAbsolutePath() + ".bak");
                    OiiolTextLogger.appendText("in install backed up file: " + cfmFiles[fileCount].getAbsolutePath(), OiiolTextLogger.LOG_TRACE);
                    continue;
                }
                catch (IOException e) {
                    OiiolTextLogger.appendText(e.getMessage());
                }
            }
            OiiolTextLogger.appendText("did a back up of all the required instance files");
        }
    }

    public NSResolver getCFNSResolver() {
        return new CFNSResolver();
    }

    static {
        S_PERMS_FOR_CFW_FILES = "600";
        S_PERMS_FOR_CFW_DIR = "700";
        S_PERMS_FOR_CFW_FILES_TXT = "og-rwx";
        vHomesWithInternalPlugins = new Vector();
        sRunConfigCmd = "{0}" + File.separator + "oui" + File.separator + "bin" + File.separator + "runConfig." + "{1}" + " " + "ORACLE_HOME={0} MODE=perform ACTION={3} RERUN={2} $*";
    }

    private class CFNSResolver
    implements NSResolver {
        private CFNSResolver() {
        }

        public void CFNSResolver() {
        }

        public String resolveNamespacePrefix(String param1) {
            if (param1.equals(OiixCFOps.agg)) {
                return OiixCFOps.HTTP_wwwDOToracleDOTcom_sysman_emCfg_AggregateDescriptions;
            }
            return null;
        }
    }

    public class NotCFMFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            boolean flag = false;
            File file = new File(dir, name);
            if (file.isFile() && name.indexOf(OiixCFOps.CFM) == -1) {
                flag = true;
            }
            return flag;
        }
    }

    public class CFMFileFilter
    implements FilenameFilter {
        private String m_sFilename = "";

        public void setFileName(String sFilename) {
            this.m_sFilename = sFilename;
        }

        public boolean accept(File dir, String name) {
            boolean flag = true;
            File file = new File(dir, name);
            if (file.isFile()) {
                if (this.m_sFilename.length() > 0) {
                    flag = name.startsWith(this.m_sFilename) && name.indexOf(OiixCFOps.CFM_WITH_DOTS) > 0 && name.endsWith(OiixCFOps.INST_XML_EXTN);
                } else if (name.indexOf(OiixCFOps.CFM) == -1 && name.endsWith(OiixCFOps.XML_EXTN)) {
                    flag = false;
                }
            }
            return flag;
        }
    }
}

