/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

public class OiixCipher {
    private static final String CIPHER_KEY = "OUI";
    private String m_sData;

    public OiixCipher(String sData) {
        this.m_sData = sData;
    }

    public String encode() {
        return this.encode(this.m_sData, CIPHER_KEY);
    }

    public StringBuffer decode() {
        return this.decode(this.m_sData, CIPHER_KEY);
    }

    private String encode(String txt, String key) {
        StringBuffer sbTxt = new StringBuffer(txt);
        StringBuffer sbKey = new StringBuffer(key);
        StringBuffer buff1 = this.code(sbKey, sbTxt);
        sbTxt.setLength(0);
        sbKey.setLength(0);
        String out = this.encodeHex(buff1);
        buff1.setLength(0);
        return out;
    }

    private String encodeHex(StringBuffer input) {
        char[] tmp = new char[input.length()];
        String hex = new String();
        String pad = "0000";
        input.getChars(0, input.length(), tmp, 0);
        for (int i = 0; i < tmp.length; ++i) {
            String num = Integer.toHexString(tmp[i]);
            hex = hex + pad.substring(0, 4 - num.length()) + num;
        }
        return hex;
    }

    private StringBuffer code(StringBuffer key, StringBuffer txt) {
        StringBuffer out = new StringBuffer();
        char[] keyChars = new char[key.length()];
        key.getChars(0, key.length(), keyChars, 0);
        int klen = keyChars.length;
        char[] txtChars = new char[txt.length()];
        txt.getChars(0, txt.length(), txtChars, 0);
        int clen = txtChars.length;
        for (int i = 0; i < txtChars.length; ++i) {
            out.append((char)(txtChars[i] ^ keyChars[i % klen]));
        }
        return out;
    }

    private StringBuffer decode(String txt, String key) {
        StringBuffer sbTxt = this.decodeHex(txt);
        StringBuffer sbKey = new StringBuffer(key);
        StringBuffer out = this.code(sbKey, sbTxt);
        sbTxt.setLength(0);
        sbKey.setLength(0);
        return out;
    }

    private StringBuffer decodeHex(String hex) {
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < hex.length(); i += 4) {
            try {
                tmp.append((char)Integer.parseInt(hex.substring(i, i + 4), 16));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return tmp;
    }

    public static void main(String[] args) {
        String sData = args[0];
        OiixCipher enc = new OiixCipher(sData);
        String encode = enc.encode();
        System.out.println("Encoded Value :" + encode);
        OiixCipher dec = new OiixCipher(encode);
        String decode = dec.decode().toString();
        System.out.println("Decoded value :" + decode);
    }
}

