/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;

public class OiixDebug {
    public static final int OIIA_DEBUG = 1;
    public static final int OIIB_DEBUG = 2;
    public static final int OIIC_DEBUG = 4;
    public static final int OIID_DEBUG = 8;
    public static final int OIIFB_DEBUG = 16;
    public static final int OIIFD_DEBUG = 32;
    public static final int OIIFI_DEBUG = 64;
    public static final int OIIFM_DEBUG = 128;
    public static final int OIIFP_DEBUG = 256;
    public static final int OIIFR_DEBUG = 512;
    public static final int OIIFW_DEBUG = 1024;
    public static final int OIIG_DEBUG = 2048;
    public static final int OIII_DEBUG = 4096;
    public static final int OIIL_DEBUG = 8192;
    public static final int OIIOD_DEBUG = 16384;
    public static final int OIIOF_DEBUG = 32768;
    public static final int OIIOL_DEBUG = 65536;
    public static final int OIIPG_DEBUG = 131072;
    public static final int OIIPU_DEBUG = 262144;
    public static final int OIIPW_DEBUG = 524288;
    public static final int OIIR_DEBUG = 0x100000;
    public static final int OIIS_DEBUG = 0x200000;
    public static final int OIIT_DEBUG = 0x400000;
    public static final int OIIV_DEBUG = 0x800000;
    public static final int OIIX_DEBUG = 0x1000000;
    public static final int OII_PRINTTIME = 0x2000000;
    public static final int DBG_PKGS = 0;
    public static final int DEBUG_LEVEL = 2;
    public static final int INFORMATION_LEVEL = 3;
    public static final int WARNING_LEVEL = 4;
    public static final int ERROR_LEVEL = 15;
    public static final int CRITICAL_LEVEL = 16;
    public static boolean PRINT_TIME = Boolean.getBoolean("oracle.installer.printtime") || Boolean.getBoolean("oracle.installer.printtimeverbose");
    public static boolean RUNTIME_DBG = Boolean.getBoolean("OIIDEBUG");
    public static int RUNTIME_DBGLEVEL = Integer.getInteger("OIIDEBUGLEVEL", 2);
    public static boolean DEVTIME = true;
    public static boolean PRINT_MEMORY = Boolean.getBoolean("oracle.installer.printmemory");
    public static boolean PRINT_DISKUSAGE = Boolean.getBoolean("oracle.installer.printdiskusage");
    public static boolean PRINT_VERBOSETIME = Boolean.getBoolean("oracle.installer.printtimeverbose");
    private static PrintWriter m_memOut;
    private static PrintWriter m_duOut;
    private static PrintWriter m_timeOut;
    private static String DBGMEM_DELIM;
    private static long m_lTime;
    private static OiipgFileSystem m_system;

    public static void debug(String hdr, String msg) {
        System.err.println(hdr + "::" + msg);
    }

    public static void debug(String hdr, Throwable e) {
        System.err.println(hdr + "::" + OiixDebug.getThrowableBuf(e));
    }

    public static String getThrowableBuf(Throwable e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        e.printStackTrace(pw);
        pw.flush();
        pw.close();
        return baos.toString();
    }

    public static void printTime(String hdr, String sMsg) {
        if (PRINT_TIME) {
            Date dateNow = new Date();
            DateFormat df = DateFormat.getDateTimeInstance(3, 1);
            String sdateRep = df.format(dateNow);
            OiixDebug.debug(hdr, sMsg + sdateRep);
        }
    }

    public static void setMemoryLogFile(PrintWriter pw) {
        m_memOut = pw;
    }

    public static void setDiskUsageLogFile(PrintWriter pw) {
        m_duOut = pw;
    }

    public static void setTimeLogFile(PrintWriter pw) {
        m_timeOut = pw;
    }

    public static void initDiskUsageDebug() {
        m_system = new OiipgFileSystem();
    }

    public static void printMemoryHdr() {
        if (PRINT_MEMORY) {
            m_memOut.println(DBGMEM_DELIM + "Message " + DBGMEM_DELIM + "Free Memory" + DBGMEM_DELIM + "Total Memory" + DBGMEM_DELIM + " Current Time ( ms )");
        }
    }

    public static void printMemory(String sMsg, long lTime) {
        if (PRINT_MEMORY) {
            m_memOut.println(DBGMEM_DELIM + sMsg + DBGMEM_DELIM + Runtime.getRuntime().freeMemory() + DBGMEM_DELIM + Runtime.getRuntime().totalMemory() + DBGMEM_DELIM + lTime);
        }
    }

    public static void printDiskUsageHdr(Vector vVolumes) {
        if (vVolumes == null) {
            return;
        }
        if (PRINT_DISKUSAGE) {
            int nSize = vVolumes.size();
            if (nSize == 0) {
                return;
            }
            m_duOut.print(DBGMEM_DELIM + "Message");
            for (int i = 0; i < nSize; ++i) {
                String sVolume = (String)vVolumes.elementAt(i);
                m_duOut.print(DBGMEM_DELIM + "Volume - " + sVolume);
            }
            m_duOut.print(DBGMEM_DELIM + " Current Time ( ms )");
            m_duOut.println();
        }
    }

    public static void printDiskUsage(String sMsg, Vector vVolumes, long lTime) {
        if (vVolumes == null) {
            return;
        }
        if (PRINT_DISKUSAGE) {
            int nSize = vVolumes.size();
            if (nSize == 0) {
                return;
            }
            m_duOut.print(DBGMEM_DELIM + sMsg);
            for (int i = 0; i < nSize; ++i) {
                String sVolume = (String)vVolumes.elementAt(i);
                long lAvailSpace = m_system.getVolumeFreeSpace(sVolume);
                m_duOut.print(DBGMEM_DELIM + lAvailSpace);
            }
            m_duOut.print(DBGMEM_DELIM + lTime);
            m_duOut.println();
        }
    }

    public static void printTimeHdr() {
        if (PRINT_TIME) {
            m_timeOut.println(DBGMEM_DELIM + "Message" + DBGMEM_DELIM + "ElapsedTime" + DBGMEM_DELIM + " Current Time ( ms )");
        }
    }

    public static void printStartTimeMsg(String sMsg) {
        if (PRINT_TIME && m_timeOut != null) {
            m_lTime = System.currentTimeMillis();
            m_timeOut.print(DBGMEM_DELIM + sMsg);
        }
    }

    public static void printEndTimeMsg() {
        if (PRINT_TIME && m_timeOut != null) {
            m_timeOut.println(DBGMEM_DELIM + (System.currentTimeMillis() - m_lTime));
        }
    }

    public static void printTimeMsg(String sMsg, long lTime) {
        OiixDebug.printTimeMsg(sMsg, lTime, System.currentTimeMillis());
    }

    public static void printTimeMsg(String sMsg, long lTime, long lCurrentTime) {
        if (PRINT_TIME && m_timeOut != null) {
            m_timeOut.println(DBGMEM_DELIM + sMsg + DBGMEM_DELIM + lTime + DBGMEM_DELIM + lCurrentTime);
        }
    }

    public static void printDebugTMDMesages(String sMessage, long lCurrentTime, long lElapsedTime, Vector vVolumes) {
        OiixDebug.printTimeMsg(sMessage, lElapsedTime, lCurrentTime);
        OiixDebug.printMemory(sMessage, lCurrentTime);
        OiixDebug.printDiskUsage(sMessage, vVolumes, lCurrentTime);
    }

    public static void closeAllDebugLogs() {
        try {
            if (m_timeOut != null) {
                m_timeOut.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (m_duOut != null) {
                m_duOut.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (m_memOut != null) {
                m_memOut.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printConfigDebugTMDMesages(String sMessage, long lCurrentTime, long lElapsedTime, Vector vVolumeInfo) {
        OiixDebug.printDebugTMDMesages(sMessage, lCurrentTime, lElapsedTime, vVolumeInfo);
    }

    static {
        DBGMEM_DELIM = " # ";
    }
}

