/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbUIManager;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgInvalidLinkException;
import oracle.sysman.oii.oiip.oiipg.OiipgLinkAccessException;
import oracle.sysman.oii.oiip.oiipg.OiipgMethodUnsupportedOnPlatformException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixFileOps {
    private static final int BUFF_SIZE = 512;
    private static final byte[] buffer = new byte[512];
    public static int EOF = -1;
    public static final String S_BACKUP_EXTN = ".ouibak";
    public static final int S_BUFFERED_STREAM_SIZE = 8192;
    private static String s_explicitLibPerms = null;
    private static String[] s_expliciLibExtns = null;

    public static String getWindowsShortFileName(String path) {
        try {
            return OiipgFileSystem.getWindowsShortFileName(path);
        }
        catch (OiilNativeException ne) {
            ne.printStackTrace();
            return null;
        }
    }

    public static void setExplicitLibPerms(String perms) {
        if (s_explicitLibPerms == null) {
            s_explicitLibPerms = perms;
        }
    }

    public static String getExplicitLibPerms() {
        return s_explicitLibPerms;
    }

    public static void setExplicitLibExtns(String extns) {
        if (s_expliciLibExtns == null && extns != null && extns != "") {
            s_expliciLibExtns = OiixFunctionOps.explodeString(extns, ",");
        }
    }

    public static String[] getExplicitLibExtns() {
        return s_expliciLibExtns;
    }

    public static void setPermissions(String sFilename, String sPerms) throws IOException {
        File fSrc = new File(sFilename);
        if (!fSrc.exists()) {
            Object[] args = new Object[]{sFilename};
            throw new IOException(OiixResourceBundle.getString("S_SOURCE_DOESNT_EXIST", args));
        }
        OiipgFileSystem.setPermissions(sFilename, sPerms);
    }

    public static void chown(String sFile, String sOwner, String sGroup) throws IOException {
        File fSrc = new File(sFile);
        if (!fSrc.exists()) {
            Object[] args = new Object[]{sFile};
            throw new IOException(OiixResourceBundle.getString("S_SOURCE_DOESNT_EXIST", args));
        }
        OiipgFileSystem.chown(sFile, sOwner, sGroup);
    }

    public static void mkdirs(String sDir, String sOwner, String sGroup) throws IOException, OiifbCancelException {
        OiipgFileSystem.mkdirs(sDir, sOwner, sGroup);
    }

    public static boolean mkdirs(File fPath) {
        return OiipgFileSystem.mkdirs(fPath);
    }

    public static void copyFile(String source, String destination, boolean overwrite, boolean bMkDirs, boolean bSetPermissions, String sPerms, String sOwner, String sGroup) throws IOException, OiifbCancelException {
        OiixFileOps.copyFile(source, destination, overwrite, bMkDirs, bSetPermissions, sPerms, sOwner, sGroup, null);
    }

    public static long getVolumeFreeSpace(String driveName) {
        return new OiipgFileSystem().getVolumeFreeSpace(driveName);
    }

    public static String[] getAllVolumeNames() {
        return new OiipgFileSystem().getAllVolumeNames();
    }

    public static void copyFile(String source, String destination, boolean overwrite, boolean bMkDirs, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, OiifrProgressActionListener listnr) throws IOException, OiifbCancelException {
        OiixFileOps.copyFile(source, destination, overwrite, bMkDirs, bSetPermissions, sPerms, sOwner, sGroup, listnr, false);
    }

    public static void copyFile(String source, String destination, boolean overwrite, boolean bMkDirs, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, OiifrProgressActionListener listnr, boolean bBackup) throws IOException, OiifbCancelException {
        OiixFileOps.copyFile(source, destination, overwrite, bMkDirs, true, bSetPermissions, sPerms, sOwner, sGroup, listnr, bBackup);
    }

    public static void copyFile(String source, String destination, boolean overwrite, boolean bMkDirs, boolean bRetainPermissions, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, OiifrProgressActionListener listnr, boolean bBackup) throws IOException, OiifbCancelException {
        OiixFileOps.copyFile(source, destination, overwrite, bMkDirs, bRetainPermissions, bSetPermissions, sPerms, sOwner, sGroup, listnr, bBackup, false);
    }

    public static void copyFile(String source, String destination, boolean overwrite, boolean bMkDirs, boolean bRetainPermissions, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, OiifrProgressActionListener listnr, boolean bBackup, boolean bIgnoreChownExcpn) throws IOException, OiifbCancelException {
        if (source.equals(destination)) {
            throw new IOException(OiixResourceBundle.getString("S_SOURCE_DEST_SAME"));
        }
        File dest = new File(destination);
        if (dest.exists()) {
            if (!overwrite || !dest.canWrite()) {
                return;
            }
            if (bBackup) {
                try {
                    OiixFileOps.backUpFile(destination, destination + S_BACKUP_EXTN);
                }
                catch (IOException e) {
                    System.out.println("Could not backup file " + destination + " to " + destination + S_BACKUP_EXTN);
                }
            }
        }
        File fSrc = new File(source);
        String sErrMsgID = null;
        long lTime = System.currentTimeMillis();
        if (fSrc.exists()) {
            if (fSrc.isDirectory()) {
                sErrMsgID = "S_ERROR_COPYING_FILE_SOURCE_DIRECTORY";
            } else {
                lTime = fSrc.lastModified();
            }
        } else {
            sErrMsgID = "S_SOURCE_DOESNT_EXIST";
        }
        if (sErrMsgID != null) {
            Object[] args = new Object[]{source};
            String sErr = OiixResourceBundle.getString(sErrMsgID, args);
            Object[] args2 = new Object[]{source, destination, sErr};
            throw new IOException(OiixResourceBundle.getString("S_ERROR_COPYING_FILE", args2));
        }
        fSrc = null;
        if (bMkDirs) {
            String parentDir = OiixPathOps.getUnexpandedCanonicalPath(destination);
            parentDir = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(OiixPathOps.getStandardForm(parentDir)));
            File parentFile = new File(parentDir);
            OiipgFileSystem.mkdirs(parentDir, sOwner, sGroup);
        }
        FileInputStream is = new FileInputStream(new File(source));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(destination)), 8192);
        OiixFileOps.copyStream(is, os, source, destination, true, bRetainPermissions, bSetPermissions, sPerms, sOwner, sGroup, lTime, listnr, false, bIgnoreChownExcpn);
    }

    public static void copyFile(String source, String destination, boolean overwrite, boolean bMkDirs) throws IOException, OiifbCancelException {
        OiixFileOps.copyFile(source, destination, overwrite, bMkDirs, false, "0644", null, null);
    }

    public static void copyFile(String source, String destination, boolean overwrite) throws IOException, OiifbCancelException {
        OiixFileOps.copyFile(source, destination, overwrite, false);
    }

    public static void copyFileRec(String source, String destination, boolean overwrite) throws IOException, OiifbCancelException {
        OiixFileOps.copyFile(source, destination, overwrite, true);
    }

    public static void copyDir(File fSrcDir, File fDestDir) throws IOException {
        OiixFileOps.copyDir(fSrcDir, fDestDir, false);
    }

    public static void copyDir(File fSrcDir, File fDestDir, boolean bBackup) throws IOException {
        OiixFileOps.copyDir(fSrcDir, fDestDir, bBackup, false);
    }

    public static void copyDir(File fSrcDir, File fDestDir, boolean bBackup, boolean changePermissions) throws IOException {
        OiixFileOps.copyDir(fSrcDir, fDestDir, bBackup, changePermissions, false);
    }

    public static void copyDirWithPermissions(File fSrcDir, File fDestDir, boolean bBackup, boolean changePermissions) throws IOException {
        OiixFileOps.copyDir(fSrcDir, fDestDir, bBackup, changePermissions, true);
    }

    public static void copyDir(File fSrcDir, File fDestDir, boolean bBackup, boolean changePermissions, boolean copyPermissions) throws IOException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (!fSrcDir.exists() || !fSrcDir.isDirectory()) {
            throw new FileNotFoundException(OiixResourceBundle.getString("S_SOURCE_DOESNT_EXIST", new Object[]{fSrcDir.getAbsolutePath()}));
        }
        if (!fDestDir.exists() && !OiixFileOps.mkdirs(fDestDir)) {
            throw new IOException(OiixResourceBundle.getString("S_CANNOT_CREATE_DESTINATION_DIR", new Object[]{fDestDir.getAbsolutePath()}));
        }
        if (copyPermissions && curPlatGroup == -1) {
            try {
                OiipuUnixOps.chmod(fDestDir.getAbsolutePath(), OiixFileOps.getPermission(fSrcDir.getAbsolutePath()));
            }
            catch (OiilNativeException e) {
                e.printStackTrace();
            }
        }
        File[] files = fSrcDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File fSrcFile = files[i];
            String sDest = OiixPathOps.concatPath(fDestDir.getAbsolutePath(), fSrcFile.getName());
            if (fSrcFile.isDirectory()) {
                OiixFileOps.copyDir(fSrcFile, new File(sDest), bBackup, changePermissions, copyPermissions);
                continue;
            }
            try {
                if (bBackup && new File(sDest).exists()) {
                    try {
                        if (changePermissions) {
                            OiixFileOps.changePermissions(sDest, "0644");
                        }
                        OiixFileOps.backUpFile(sDest, sDest + S_BACKUP_EXTN);
                    }
                    catch (IOException e) {
                        System.out.println("Could not backup file " + sDest + " to " + sDest + S_BACKUP_EXTN);
                    }
                }
                OiixFileOps.copyFile(fSrcFile.getAbsolutePath(), sDest, true);
                continue;
            }
            catch (OiifbCancelException e) {
                throw new IOException(OiixResourceBundle.getString("S_ERROR_COPYING_FILE", new Object[]{fSrcFile.getAbsolutePath(), sDest, e.getMessage()}));
            }
        }
    }

    public static String backUpFile(String sFile, String sBackup) throws IOException {
        if (sFile == null || sBackup == null) {
            return null;
        }
        String sBackupFileName = sBackup;
        File oBackup = new File(sBackupFileName);
        int i = 1;
        while (oBackup.exists()) {
            sBackupFileName = sBackup + "." + i;
            oBackup = new File(sBackupFileName);
            ++i;
        }
        try {
            OiixFileOps.copyFile(sFile, sBackupFileName, true, true);
        }
        catch (OiifbCancelException e) {
            throw new IOException(e.getMessage());
        }
        return sBackupFileName;
    }

    public static void cleanupdelete(File delDir) {
        OiixFileOps.recdelete(delDir, true);
    }

    private static void recdelete(File delDir, boolean bRegisterFile) {
        if (!delDir.exists()) {
            return;
        }
        String[] conts = delDir.list();
        int contslen = 0;
        if (conts != null) {
            contslen = conts.length;
        }
        for (int i = 0; i < contslen; ++i) {
            File subFile = new File(delDir, conts[i]);
            if (subFile.isDirectory()) {
                OiixFileOps.recdelete(subFile, bRegisterFile);
                continue;
            }
            OiixFileOps.delFile(subFile, bRegisterFile);
        }
        OiixFileOps.delFile(delDir, bRegisterFile);
    }

    public static void recdelete(File delDir, File excludeDir) {
        if (!delDir.exists()) {
            return;
        }
        String[] conts = delDir.list();
        int contslen = 0;
        if (conts != null) {
            contslen = conts.length;
        }
        for (int i = 0; i < contslen; ++i) {
            File subFile = new File(delDir, conts[i]);
            if (subFile.isDirectory()) {
                if (subFile.compareTo(excludeDir) == 0) continue;
                OiixFileOps.recdelete(subFile, false);
                continue;
            }
            OiixFileOps.delFile(subFile, false);
        }
        OiixFileOps.delFile(delDir, false);
    }

    public static void recdeleteExcludeFiles(File delDir, File[] exclude) {
        if (!delDir.exists()) {
            return;
        }
        if (OiixFileOps.lookUp(delDir, exclude)) {
            return;
        }
        String[] conts = delDir.list();
        int contslen = 0;
        if (conts != null) {
            contslen = conts.length;
        }
        for (int i = 0; i < contslen; ++i) {
            File subFile = new File(delDir, conts[i]);
            if (OiixFileOps.lookUp(subFile, exclude)) continue;
            if (subFile.isDirectory()) {
                OiixFileOps.recdelete(subFile, false);
                continue;
            }
            OiixFileOps.delFile(subFile, false);
        }
        OiixFileOps.delFile(delDir, false);
    }

    public static boolean lookUp(File key, File[] list) {
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            if (key.compareTo(list[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public static void recdelete(File delDir) {
        OiixFileOps.recdelete(delDir, false);
    }

    private static void delFile(File f, boolean bRegisterFile) {
        if (!f.delete() && bRegisterFile && f.exists()) {
            OiipgFileSystem.registerFileToDelete(f);
        }
    }

    public static void recdelete(String alreadyExisted, String fileName) {
        String[] listofFiles;
        File f = new File(fileName);
        File fDontDelete = new File(OiixPathOps.getNativeForm(alreadyExisted));
        f.delete();
        for (File fParent = f.getParentFile(); !(fParent == null || fParent.equals(fDontDelete) || (listofFiles = fParent.list()) != null && listofFiles.length != 0); fParent = fParent.getParentFile()) {
            fParent.delete();
        }
    }

    public static int countFiles(String fileName) {
        int total = 0;
        try {
            File f = new File(fileName);
            if (!f.isDirectory()) {
                return 0;
            }
            String[] list = f.list();
            String sDirPath = f.getPath();
            for (int i = 0; i < list.length; ++i) {
                File fFile = new File(f, list[i]);
                if (fFile.isDirectory()) {
                    total += OiixFileOps.countFiles(fFile.getPath());
                    continue;
                }
                ++total;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return total;
    }

    public static void validateDiskSpace(long nSize, String toLoc, boolean bEnableCancel) throws OiifbCancelException {
        OiixFileOps.validateDiskSpace(nSize, toLoc, bEnableCancel, true);
    }

    public static void validateDiskSpace(long nSize, String toLoc, boolean bEnableCancel, boolean bAskRetry) throws OiifbCancelException {
        String sMsg = OiixResourceBundle.getString("S_DISK_FULL");
        Object[] sObjs = new String[]{toLoc};
        sMsg = MessageFormat.format(sMsg, sObjs);
        while (!OiipgFileSystem.isSpaceAvailable(nSize + 5120L, toLoc)) {
            if (bAskRetry) {
                OiifbIRetry oRetry = OiifbUIManager.getRetryInterface(sMsg);
                oRetry.setEnableCancel(bEnableCancel);
                if (oRetry.doModal() == 2) continue;
                throw new OiifbCancelException(sMsg, true);
            }
            throw new OiifbCancelException(sMsg, true);
        }
    }

    public static void validateDiskSpace(long nSize, String toLoc) throws OiifbCancelException {
        OiixFileOps.validateDiskSpace(nSize, toLoc, true);
    }

    public static void validateDiskSpace(String fromLoc, String toLoc) throws OiifbCancelException {
        File fSource = new File(fromLoc);
        OiixFileOps.validateDiskSpace(fSource.length(), toLoc);
    }

    public static void copyStream(InputStream is, OutputStream os, String sDestn) throws IOException, OiifbCancelException {
        OiixFileOps.copyStream(is, os, sDestn, true);
    }

    public static void copyStreamFromJar(InputStream is, OutputStream os, String sDestn, boolean bCloseStreams, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, long lTimeStamp, OiifrProgressActionListener listnr) throws IOException, OiifbCancelException {
        OiixFileOps.copyStream(is, os, sDestn, bCloseStreams, bSetPermissions, sPerms, sOwner, sGroup, lTimeStamp, listnr, true);
    }

    public static void copyStream(InputStream is, OutputStream os, String sDestn, boolean bCloseStreams, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, long lTimeStamp, OiifrProgressActionListener listnr) throws IOException, OiifbCancelException {
        OiixFileOps.copyStream(is, os, sDestn, bCloseStreams, bSetPermissions, sPerms, sOwner, sGroup, lTimeStamp, listnr, false);
    }

    private static void copyStream(InputStream is, OutputStream os, String sDestn, boolean bCloseStreams, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, long lTimeStamp, OiifrProgressActionListener listnr, boolean bIgnoreEOFExcpn) throws IOException, OiifbCancelException {
        OiixFileOps.copyStream(is, os, null, sDestn, bCloseStreams, false, bSetPermissions, sPerms, sOwner, sGroup, lTimeStamp, listnr, bIgnoreEOFExcpn);
    }

    private static void copyStream(InputStream is, OutputStream os, String sSrc, String sDestn, boolean bCloseStreams, boolean bRetainPermissions, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, long lTimeStamp, OiifrProgressActionListener listnr, boolean bIgnoreEOFExcpn) throws IOException, OiifbCancelException {
        OiixFileOps.copyStream(is, os, sSrc, sDestn, bCloseStreams, bRetainPermissions, bSetPermissions, sPerms, sOwner, sGroup, lTimeStamp, listnr, bIgnoreEOFExcpn, false);
    }

    private static void copyStream(InputStream is, OutputStream os, String sSrc, String sDestn, boolean bCloseStreams, boolean bRetainPermissions, boolean bSetPermissions, String sPerms, String sOwner, String sGroup, long lTimeStamp, OiifrProgressActionListener listnr, boolean bIgnoreEOFExcpn, boolean bIgnoreChownExcpn) throws IOException, OiifbCancelException {
        block5: {
            int retVal;
            OiixFileOps.copyStream(is, os, sDestn, bCloseStreams, listnr, bIgnoreEOFExcpn);
            OiixFileOps.setFileTime(sDestn, lTimeStamp);
            if (bRetainPermissions) {
                OiixFileOps.setPermissionsLike(sSrc, sDestn);
            } else if (bSetPermissions && (retVal = OiixFileOps.changePermissions(sDestn, sPerms)) != 0) {
                Object[] args = new String[]{sDestn, sPerms, ""};
                String exString = OiixResourceBundle.getString("S_PERMISSIONS_NOT_SET", args);
                throw new IOException(exString);
            }
            try {
                OiixFileOps.changeOwnership(sDestn, sOwner, sGroup);
            }
            catch (IOException e) {
                if (bIgnoreChownExcpn) break block5;
                throw e;
            }
        }
    }

    public static boolean setFileModifiedTime(String sFile, long lModTime) {
        if (lModTime < 0L) {
            lModTime = new Date().getTime();
        }
        File f = new File(sFile);
        return f.setLastModified(lModTime);
    }

    public static void setFileTime(String sFile, long lModTime) {
        OiixFileOps.setFileModifiedTime(sFile, lModTime);
    }

    public static void copyStream(InputStream is, OutputStream os, String sDestn, boolean bCloseStreams) throws IOException, OiifbCancelException {
        OiixFileOps.copyStream(is, os, sDestn, bCloseStreams, null, false);
    }

    private static void copyStream(InputStream is, OutputStream os, String sDestn, boolean bCloseInputStream, OiifrProgressActionListener listnr, boolean bIgnoreEOFExcpn) throws IOException, OiifbCancelException {
        OiixFileOps.copyStream(is, os, sDestn, bCloseInputStream, listnr, bIgnoreEOFExcpn, buffer, 512);
    }

    public static void copyStream(InputStream is, OutputStream os, String sDestn, boolean bCloseInputStream, OiifrProgressActionListener listnr, boolean bIgnoreEOFExcpn, byte[] copybuffer, int nReadCapacity) throws IOException, OiifbCancelException {
        if (is != null && os != null) {
            int nBytes = 0;
            boolean nBytesRead = false;
            int sizeRead = 0;
            while ((sizeRead = is.read(copybuffer)) != -1) {
                try {
                    os.write(copybuffer, 0, sizeRead);
                    if (listnr == null) continue;
                    listnr.addBytes(sizeRead);
                }
                catch (EOFException e) {
                    if (bIgnoreEOFExcpn) continue;
                    throw e;
                }
                catch (IOException ioe) {
                    if (!OiipgFileSystem.isSpaceAvailable((long)nBytes + 5120L, sDestn)) {
                        OiixFileOps.validateDiskSpace(nBytes, sDestn, false, false);
                        continue;
                    }
                    throw ioe;
                }
            }
            if (os != null) {
                os.close();
            }
            if (bCloseInputStream && is != null) {
                is.close();
            }
        } else {
            if (is == null) {
                throw new IOException(OiixResourceBundle.getString("S_INPUT_STREAM_IS_NULL"));
            }
            if (os == null) {
                throw new IOException(OiixResourceBundle.getString("S_OUTPUT_STREAM_IS_NULL"));
            }
        }
    }

    public static void copyStreamFromURL(InputStream is, OutputStream os, String sDestn, boolean bCloseInputStream, OiifrProgressActionListener listnr, boolean bIgnoreEOFExcpn, byte[] copybuffer, int nReadCapacity) throws IOException, OiifbCancelException {
        if (is != null && os != null) {
            int nBytes = 0;
            boolean nBytesRead = false;
            int sizeRead = 0;
            int available = 0;
            int retryCount = Integer.parseInt(System.getProperty("oracle.installer.httpRetryCount"));
            int retryInterval = Integer.parseInt(System.getProperty("oracle.installer.httpRetryInterval"));
            available = is.available();
            if (available == 0) {
                for (int i = 0; i < retryCount; ++i) {
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    available = is.available();
                    if (available > 0) break;
                }
            }
            if (available > 0) {
                int n = available = available > nReadCapacity ? nReadCapacity : available;
                while ((sizeRead = is.read(copybuffer, 0, available)) != -1) {
                    try {
                        os.write(copybuffer, 0, sizeRead);
                        if (listnr == null) continue;
                        listnr.addBytes(sizeRead);
                    }
                    catch (EOFException e) {
                        if (bIgnoreEOFExcpn) continue;
                        throw e;
                    }
                    catch (IOException ioe) {
                        if (!OiipgFileSystem.isSpaceAvailable((long)nBytes + 5120L, sDestn)) {
                            OiixFileOps.validateDiskSpace(nBytes, sDestn, false, false);
                            continue;
                        }
                        throw ioe;
                    }
                }
            } else {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                os.close();
            }
            if (bCloseInputStream && is != null) {
                is.close();
            }
        } else {
            if (is == null) {
                throw new IOException(OiixResourceBundle.getString("S_INPUT_STREAM_IS_NULL"));
            }
            if (os == null) {
                throw new IOException(OiixResourceBundle.getString("S_OUTPUT_STREAM_IS_NULL"));
            }
        }
    }

    public static void writeStream(BufferedOutputStream bos, byte[] buf, int byteRead, String destLoc) throws IOException, OiifbCancelException {
        boolean bWriteSuccess = false;
        while (!bWriteSuccess) {
            try {
                bos.write(buf, 0, byteRead);
                bWriteSuccess = true;
            }
            catch (IOException ioe) {
                if (!OiipgFileSystem.isSpaceAvailable((long)byteRead + 5120L, destLoc)) {
                    OiixFileOps.validateDiskSpace(byteRead, destLoc, false, false);
                    bWriteSuccess = false;
                    continue;
                }
                throw ioe;
            }
        }
    }

    public static String getFirstDirToBeCreated(String path) {
        File parentdir;
        File f = new File(path);
        String curDir = path;
        String parent = f.getParent();
        while (parent != null && !(parentdir = new File(parent)).exists()) {
            curDir = parent;
            parent = parentdir.getParent();
        }
        return curDir;
    }

    public static String createDirForDest(String filename) throws IOException {
        File parentdir;
        File f = new File(filename);
        String str = f.getParent();
        while (str != null && !(parentdir = new File(str)).exists()) {
            str = parentdir.getParent();
        }
        File ff = new File(filename);
        try {
            OiixFileOps.mkdirs(ff);
        }
        catch (Exception ie) {
            OiixFileOps.mkdirs(ff);
        }
        if (str == null) {
            str = "/";
        }
        return str;
    }

    public static void copyFileAsText(String sSource, String sDest) throws IOException {
        String sLine = null;
        FileInputStream fis = new FileInputStream(sSource);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        FileOutputStream fos = null;
        PrintWriter pw = null;
        fos = new FileOutputStream(sDest);
        pw = new PrintWriter(fos);
        while ((sLine = br.readLine()) != null) {
            pw.println(sLine);
        }
        pw.close();
        fos.close();
        fis.close();
        isr.close();
        br.close();
    }

    public static long getTotalFileSize(File f, boolean bRecurse) {
        long nTotalSize = 0L;
        if (f.isFile()) {
            nTotalSize = f.length();
        } else {
            String[] fileList = f.list();
            String sPath = f.getAbsolutePath();
            if (fileList != null) {
                for (int i = 0; i < fileList.length; ++i) {
                    String filePath = OiixPathOps.concatPath(sPath, fileList[i]);
                    File f1 = new File(filePath);
                    if (bRecurse && f1.isDirectory()) {
                        nTotalSize += OiixFileOps.getTotalFileSize(f1, bRecurse);
                        continue;
                    }
                    nTotalSize += f1.length();
                }
            }
        }
        return nTotalSize;
    }

    public static void setPermissions(String destFile, String filePermissions, String owner, String group) throws IOException {
        int rVal = OiixFileOps.changePermissions(destFile, filePermissions);
        if (rVal != 0) {
            Object[] args = new String[]{destFile, filePermissions, ""};
            String exString = OiixResourceBundle.getString("S_PERMISSIONS_NOT_SET", args);
            throw new IOException(exString);
        }
        OiixFileOps.changeOwnership(destFile, owner, group);
    }

    private static int changeOwnership(String destFile, String owner, String group) throws IOException {
        if (owner == null) {
            owner = "";
        }
        if (group == null) {
            group = "";
        }
        return OiipgFileSystem.chown(destFile, owner, group);
    }

    public static int setPermissionsLike(String sSrc, String sDestn) throws IOException {
        return OiipgFileSystem.setPermissionsLike(sSrc, sDestn);
    }

    public static int createFileWithPermissions(String sFileName, String sPerms) {
        int status = -99;
        try {
            if (null != sFileName && sFileName.length() > 0) {
                File f = new File(sFileName);
                OiixFileOps.mkdirs(f);
                f.createNewFile();
                status = OiixFileOps.changePermissions(f.getAbsolutePath(), sPerms);
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
        }
        return status;
    }

    public static int changePermissions(String destFile, String filePermissions) {
        String DEF_FILE_PERM = "0664";
        String DEF_DIR_PERM = "0755";
        if (null == filePermissions || filePermissions.trim().length() == 0) {
            return 0;
        }
        boolean isDir = false;
        File fDest = new File(destFile);
        if (fDest.isDirectory()) {
            isDir = true;
        }
        if (filePermissions == null) {
            filePermissions = isDir ? DEF_DIR_PERM : DEF_FILE_PERM;
        } else if ((filePermissions = filePermissions.trim()).length() == 0) {
            filePermissions = isDir ? DEF_DIR_PERM : DEF_FILE_PERM;
        }
        int nPerm = 420;
        try {
            Integer numPerm = Integer.valueOf(filePermissions, 8);
            nPerm = numPerm;
        }
        catch (NumberFormatException ne) {
            StringBuffer bf = new StringBuffer();
            bf.append("chmod ");
            bf.append(filePermissions);
            bf.append(" ");
            bf.append(destFile);
            return OiipgFileSystem.sysFunction(new String(bf));
        }
        return OiixFileOps.changePermission(destFile, nPerm);
    }

    public static int sysFunction(String command) {
        return OiipgFileSystem.sysFunction(command);
    }

    public static int changeOwner(String fileName, String owner) {
        int retVal = -1;
        try {
            retVal = OiipgFileSystem.chown(fileName, owner, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return retVal;
    }

    public static int changeGroup(String fileName, String group) {
        return OiipgFileSystem.changeGroup(fileName, group);
    }

    public static int changeOwnerAndGroup(String fileName, String owner, String group) {
        return OiipgFileSystem.changeOwnerAndGroup(fileName, owner, group);
    }

    public static int changePermission(String fileName, int nFilePerm) {
        return OiipgFileSystem.changePermission(fileName, nFilePerm);
    }

    public static int getPermission(String fileName) {
        return OiipgFileSystem.getPermission(fileName);
    }

    public static String getDllVersion(String sFilename) throws OiilNativeException {
        return OiipgFileSystem.getDllVersion(sFilename);
    }

    public static String getFixedDllVersion(String sFilename) throws OiilNativeException {
        return OiipgFileSystem.getFixedDllVersion(sFilename);
    }

    public static boolean isFileInUse(String sFilename) throws OiilNativeException {
        return OiipgFileSystem.isFileInUse(sFilename);
    }

    public static int touchFile(String filename) throws OiipgMethodUnsupportedOnPlatformException {
        return OiipgFileSystem.touchFile(filename);
    }

    public static int executeMakeFile(String command, String logFile) {
        return OiipgFileSystem.executeMakeFile(command, logFile);
    }

    public static int deleteLink(String linkPath) {
        return OiipgFileSystem.deleteLink(linkPath);
    }

    public static boolean linkExists(String linkPath) throws OiipgLinkAccessException, OiipgInvalidLinkException {
        return OiipgFileSystem.linkExists(linkPath);
    }

    public static boolean validLinkExists(String linkPath) {
        return OiipgFileSystem.validLinkExists(linkPath);
    }

    public static int createLink(String source, String dest) {
        return OiipgFileSystem.createLink(source, dest);
    }

    public static void deleteParentDirs(String fileName) {
        OiixFileOps.deleteParentDirs(fileName, false);
    }

    public static void deleteParentDirs(String fileName, boolean bCluster) {
        File parentdir;
        String[] listofFiles;
        File f = new File(fileName);
        String str = f.getParent();
        while (str != null && ((listofFiles = (parentdir = new File(str)).list()) == null || listofFiles.length == 0)) {
            OiipgCFSDriveCheck cfsDriveCheck;
            if (bCluster && !(cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker()).isDriveOnCFS(parentdir.getPath())) {
                OiipgClusterLogger.logRmdirCommands(parentdir.getPath());
            }
            parentdir.delete();
            str = parentdir.getParent();
        }
    }

    public static void deleteParentDirs(String fileName, int levels) {
        File parentdir;
        String[] listofFiles;
        File f = new File(fileName);
        String str = f.getParent();
        while (str != null && levels != 0 && ((listofFiles = (parentdir = new File(str)).list()) == null || listofFiles.length == 0)) {
            parentdir.delete();
            str = parentdir.getParent();
            --levels;
        }
    }

    public static void instantiateFile(String sourceFile, String destFile, HashMap oSearchReplaceMap, String sDelimiter) throws FileNotFoundException, IOException {
        OiixFileOps.instantiateFile(sourceFile, destFile, oSearchReplaceMap, sDelimiter, null);
    }

    public static void instantiateFile(String sourceFile, String destFile, HashMap oSearchReplaceMap, String sDelimiter, String encoding) throws FileNotFoundException, IOException {
        try {
            String input;
            PrintWriter pos;
            BufferedReader bis;
            if (encoding != null && encoding.trim().length() > 0) {
                bis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), encoding));
                pos = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), encoding)));
            } else {
                bis = new BufferedReader(new FileReader(sourceFile));
                pos = new PrintWriter(new BufferedWriter(new FileWriter(destFile)));
            }
            while ((input = bis.readLine()) != null) {
                String processedString = OiixFileOps.processString(input, oSearchReplaceMap, sDelimiter);
                pos.write(processedString);
                pos.println();
            }
            bis.close();
            pos.close();
        }
        catch (FileNotFoundException f) {
            throw f;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String processString(String input, HashMap oSearchReplaceMap, String sDelimiter) {
        StringBuffer output = new StringBuffer();
        boolean i = false;
        boolean SIMPLE_STRING = false;
        boolean SUBSTITUTE_STRING = true;
        int iLastProcessed = -1;
        int iCurIdx = 0;
        boolean iState = SIMPLE_STRING;
        String sSubstitute = "";
        String sReplace = "";
        while (iCurIdx < input.length()) {
            if ((iCurIdx = input.indexOf(sDelimiter, iCurIdx)) == -1) {
                iCurIdx = input.length();
                continue;
            }
            if (iState == SIMPLE_STRING) {
                output.append(input.substring(iLastProcessed + 1, iCurIdx));
                iState = SUBSTITUTE_STRING;
            } else if (iState == SUBSTITUTE_STRING) {
                sSubstitute = input.substring(iLastProcessed, iCurIdx + 1);
                sReplace = (String)oSearchReplaceMap.get(sSubstitute.toLowerCase());
                if (sReplace == null) {
                    sReplace = sSubstitute;
                }
                output.append(sReplace);
                iState = SIMPLE_STRING;
            }
            iLastProcessed = iCurIdx++;
        }
        int idx = iLastProcessed;
        idx = iState == SIMPLE_STRING ? iLastProcessed + 1 : iLastProcessed;
        if (idx != input.length()) {
            output.append(input.substring(idx, iCurIdx));
        }
        return output.toString();
    }

    public static void getVariablesFromString(String input, HashMap oVariables, String sDelimiter) {
        boolean SIMPLE_STRING = false;
        boolean SUBSTITUTE_STRING = true;
        int iLastProcessed = -1;
        int iCurIdx = 0;
        boolean iState = SIMPLE_STRING;
        String sSubstitute = "";
        while (iCurIdx < input.length()) {
            if ((iCurIdx = input.indexOf(sDelimiter, iCurIdx)) == -1) {
                iCurIdx = input.length();
                continue;
            }
            if (iState == SIMPLE_STRING) {
                iState = SUBSTITUTE_STRING;
            } else if (iState == SUBSTITUTE_STRING) {
                sSubstitute = input.substring(iLastProcessed, iCurIdx + 1);
                oVariables.put(sSubstitute, sSubstitute);
                iState = SIMPLE_STRING;
            }
            iLastProcessed = iCurIdx++;
        }
    }

    public static void appendFilePw(PrintWriter writer, String appendFile) throws IOException {
        if (writer == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(appendFile));
        String str = reader.readLine();
        while (str != null) {
            writer.println(str);
            str = reader.readLine();
        }
        reader.close();
    }

    public static void appendFile(String origFile, String appendFile) throws IOException {
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(origFile, true)), true);
        OiixFileOps.appendFilePw(writer, appendFile);
        writer.close();
    }

    public static void appendLine(String origFile, String appendStr) throws IOException {
        PrintWriter writer = new PrintWriter((Writer)new FileWriter(new File(origFile), true), true);
        writer.println(appendStr);
        writer.close();
    }

    public static boolean rename(String srcFile, String destFile) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        File src = new File(srcFile);
        if (!src.exists()) {
            return false;
        }
        File dest = new File(destFile);
        if (dest.exists()) {
            dest.delete();
        }
        return src.renameTo(dest);
    }

    public static Vector searchFiles(String lookupDir, String endsWith) {
        Vector<String> files = new Vector<String>();
        File fParent = new File(lookupDir = OiixPathOps.getNativeForm(lookupDir));
        String[] listofFiles = fParent.list();
        int nCount = listofFiles == null ? 0 : listofFiles.length;
        int nSubStrLen = endsWith.length();
        for (int i = 0; i < nCount; ++i) {
            File subFile = new File(listofFiles[i]);
            if (subFile.isDirectory()) continue;
            int nIndex = listofFiles[i].length() - nSubStrLen;
            if (listofFiles[i].indexOf(endsWith) != nIndex) continue;
            files.add(listofFiles[i]);
        }
        return files;
    }
}

