/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiShipHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixRetryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiixFunctionOps {
    public static String[] newList() {
        String[] sArr = new String[]{};
        return sArr;
    }

    public static String elementAt(String[] sa, Integer pos) {
        int ipos = pos;
        if (ipos >= 0 && ipos < sa.length) {
            return sa[ipos];
        }
        return "";
    }

    public static String[] insertElementAt(String[] sa, String elem, Integer pos) {
        Vector vl = OiixFunctionOps.sarr2vect(sa);
        int ipos = pos;
        if (ipos >= 0 && ipos < sa.length) {
            vl.insertElementAt(elem, ipos);
        } else {
            vl.addElement(elem);
        }
        return OiixFunctionOps.vect2sarr(vl);
    }

    public static Boolean isEmpty(String[] a) {
        return new Boolean(a.length == 0);
    }

    public static String[] removeElement(String[] sa, String elem) {
        Vector vl = OiixFunctionOps.sarr2vect(sa);
        vl.removeElement(elem);
        return OiixFunctionOps.vect2sarr(vl);
    }

    public static String[] removeElementAt(String[] sa, Integer pos) {
        Vector vl = OiixFunctionOps.sarr2vect(sa);
        int ipos = pos;
        if (ipos >= 0 && ipos < sa.length) {
            vl.removeElementAt(ipos);
        }
        return OiixFunctionOps.vect2sarr(vl);
    }

    public static Integer size(String[] sa) {
        return new Integer(sa.length);
    }

    public static Boolean contains(String[] sa, String elem) {
        Vector vl1 = OiixFunctionOps.sarr2vect(sa);
        return new Boolean(vl1.contains(elem));
    }

    public static Integer nextPosOfElement(String[] sa, String elem, Integer startPos) {
        Vector vl1 = OiixFunctionOps.sarr2vect(sa);
        int ipos = startPos;
        if (ipos < 0 || ipos >= sa.length) {
            return new Integer(-1);
        }
        return new Integer(vl1.indexOf(elem, ipos));
    }

    public static Integer prevPosOfElement(String[] sa, String elem, Integer endPos) {
        Vector vl1 = OiixFunctionOps.sarr2vect(sa);
        int ipos = endPos;
        if (ipos < 0 || ipos >= sa.length) {
            return new Integer(-1);
        }
        return new Integer(vl1.lastIndexOf(elem, ipos));
    }

    public static String[] clone(String[] sa1) {
        Vector vl1;
        Vector retv = vl1 = OiixFunctionOps.sarr2vect(sa1);
        return OiixFunctionOps.vect2sarr(retv);
    }

    public static boolean subset(String[] sa1, String[] sa2) {
        if (sa1 == null || sa1.length <= 0) {
            return true;
        }
        if (sa2 == null || sa2.length <= 0) {
            return false;
        }
        Vector vl1 = OiixFunctionOps.sarr2vect(sa1);
        Vector vl2 = OiixFunctionOps.sarr2vect(sa2);
        return OiixVectorOps.vectorSubset(vl1, vl2);
    }

    public static String[] intersect(String[] sa1, String[] sa2) {
        Vector vl1 = OiixFunctionOps.sarr2vect(sa1);
        Vector vl2 = OiixFunctionOps.sarr2vect(sa2);
        Vector retv = OiixVectorOps.intersect(vl1, vl2);
        return OiixFunctionOps.vect2sarr(retv);
    }

    public static String[] reverse(String[] sa1) {
        Vector vl1 = OiixFunctionOps.sarr2vect(sa1);
        Vector retv = OiixVectorOps.reverse(vl1);
        return OiixFunctionOps.vect2sarr(retv);
    }

    public static String[] sort(String[] sa1) {
        Vector vl1 = OiixFunctionOps.sarr2vect(sa1);
        Vector retv = OiixVectorOps.sort(vl1);
        return OiixFunctionOps.vect2sarr(retv);
    }

    public static String[] subtract(String[] sa1, String[] sa2) {
        Vector vl1 = OiixFunctionOps.sarr2vect(sa1);
        Vector vl2 = OiixFunctionOps.sarr2vect(sa2);
        Vector retv = OiixVectorOps.subtract(vl1, vl2);
        return OiixFunctionOps.vect2sarr(retv);
    }

    public static String[] subtractStr(String[] sa1Arr, String sa2) {
        return OiixFunctionOps.subtractStr(sa1Arr, sa2, true);
    }

    public static String[] subtractStr(String[] sa1Arr, String sa2, boolean isCaseSensitive) {
        if (sa2 == null) {
            return sa1Arr;
        }
        if (sa1Arr == null || sa1Arr.length == 0) {
            return null;
        }
        String[] sa2Arr = new String[]{sa2};
        if (isCaseSensitive) {
            return OiixFunctionOps.subtract(sa1Arr, sa2Arr);
        }
        return OiixFunctionOps.removeElementIgnoringCase(sa1Arr, sa2);
    }

    public static String[] unionStr(String sa1, String[] sa2Arr) {
        if (sa1 == null) {
            return sa2Arr;
        }
        String[] sa1Arr = new String[]{sa1};
        if (sa2Arr == null || sa2Arr.length == 0) {
            return sa1Arr;
        }
        return OiixFunctionOps.union(sa1Arr, sa2Arr);
    }

    public static String[] union(String[] sa1, String[] sa2) {
        Vector vl1 = OiixFunctionOps.sarr2vect(sa1);
        Vector vl2 = OiixFunctionOps.sarr2vect(sa2);
        Vector retv = OiixVectorOps.union(vl1, vl2);
        return OiixFunctionOps.vect2sarr(retv);
    }

    public static String implodeList(String[] sarr, String sDele) {
        int numElems;
        String v_sRetVal;
        String string = v_sRetVal = null != sarr ? "" : null;
        if (sarr != null && (numElems = sarr.length) > 0) {
            StringBuffer sOneString = new StringBuffer();
            if (sDele == null) {
                sDele = "";
            }
            for (int i = 0; i < numElems - 1; ++i) {
                if (null != sarr[i]) {
                    sOneString.append(sarr[i]);
                }
                sOneString.append(sDele);
            }
            if (null != sarr[numElems - 1]) {
                sOneString.append(sarr[numElems - 1]);
            }
            v_sRetVal = sOneString.toString();
        }
        return v_sRetVal;
    }

    public static String[] explodeString(String str, String sDele) {
        String v_sDelim = sDele == null || sDele.equals("") ? " " : sDele;
        int v_iDelimLen = v_sDelim.length();
        String v_str = null != str ? str : "";
        Vector<String> v = new Vector<String>();
        int index = -1;
        while (0 < v_str.length()) {
            index = v_str.indexOf(v_sDelim, 0);
            String sOne = -1 == index ? v_str : v_str.substring(0, index);
            sOne = sOne.trim();
            v.addElement(sOne);
            v_str = -1 == index ? "" : v_str.substring(index + v_iDelimLen);
        }
        return OiixFunctionOps.vect2sarr(v);
    }

    private static Vector sarr2vect(String[] sarr) {
        Vector<String> vect = new Vector<String>();
        int numElems = sarr.length;
        for (int i = 0; i < numElems; ++i) {
            vect.addElement(sarr[i]);
        }
        return vect;
    }

    private static String[] vect2sarr(Vector vect) {
        int numElems = vect.size();
        String[] sarr = new String[numElems];
        for (int i = 0; i < numElems; ++i) {
            sarr[i] = (String)vect.elementAt(i);
        }
        return sarr;
    }

    public static String[] splitString(String str, String sDele) {
        if (str == null || str.trim().length() == 0) {
            return new String[0];
        }
        String v_sDelim = sDele == null || sDele.equals("") ? " " : sDele;
        String v_str = str.trim();
        return v_str.split(v_sDelim);
    }

    public static Integer strLength(String a) {
        return new Integer(a.length());
    }

    public static String numToString(Integer num) {
        return String.valueOf(num);
    }

    public static String boolToString(Boolean bval) {
        return String.valueOf(bval);
    }

    public static Integer parseInt(String a) {
        int anum = 0;
        try {
            anum = Integer.parseInt(a.trim());
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            System.err.println("Returning 0 instead");
            anum = 0;
        }
        return new Integer(anum);
    }

    public static Boolean parseBool(String a) {
        return Boolean.valueOf(a);
    }

    public static Boolean startsWith(String a, String b) {
        return new Boolean(a.startsWith(b));
    }

    public static Boolean endsWith(String a, String b) {
        return new Boolean(a.endsWith(b));
    }

    public static Boolean strContains(String a, String b) {
        return new Boolean(a.indexOf(b) != -1);
    }

    public static Boolean strEquals(String a, String b) {
        return new Boolean(a.equals(b));
    }

    public static Boolean strEqualsIgnoreCase(String a, String b) {
        return new Boolean(a.equalsIgnoreCase(b));
    }

    public static String toLowerCase(String a) {
        return a.toLowerCase();
    }

    public static String toUpperCase(String a) {
        return a.toUpperCase();
    }

    public static Integer strCompare(String a, String b) {
        return new Integer(a.compareTo(b));
    }

    public static String charAt(String a, Integer pos) {
        int nIndex = pos;
        if (nIndex < 0) {
            nIndex = 0;
        }
        if (nIndex >= a.length()) {
            nIndex = a.length() - 1;
        }
        return "" + a.charAt(nIndex);
    }

    public static String substring(String a, Integer startPos, Integer endPos) {
        int endIndex;
        int startIndex = startPos;
        if (startIndex < 0 || startIndex >= a.length()) {
            startIndex = 0;
        }
        if ((endIndex = endPos.intValue()) > a.length()) {
            endIndex = a.length();
        }
        if (endIndex < 0 || endIndex < startIndex) {
            endIndex = startIndex;
        }
        return a.substring(startIndex, endIndex);
    }

    public static String trim(String a) {
        return a.trim();
    }

    public static Integer strIndexOf(String a, String b) {
        return new Integer(a.indexOf(b));
    }

    public static Integer strLastIndexOf(String a, String b) {
        return new Integer(a.lastIndexOf(b));
    }

    public static String replaceStr(String str, String origS, String newS) {
        StringBuffer retBuf = new StringBuffer();
        int lastPos = str.indexOf(origS);
        int curPos = 0;
        int origStrLen = origS.length();
        while (lastPos != -1) {
            retBuf.append(str.substring(curPos, lastPos));
            retBuf.append(newS);
            curPos = lastPos + origStrLen;
            lastPos = str.indexOf(origS, curPos);
        }
        retBuf.append(str.substring(curPos));
        return retBuf.toString();
    }

    public static String msgFormat(String pattern, String[] arguments) {
        String sMsg = null;
        try {
            sMsg = MessageFormat.format(pattern, arguments);
        }
        catch (Exception e) {
            sMsg = pattern;
        }
        return sMsg;
    }

    public static String pathify(String path) {
        String retBuf = OiixPathOps.unEscape(path);
        retBuf = retBuf.replace('\\', '/');
        retBuf = retBuf.replace('/', File.separatorChar);
        return retBuf;
    }

    public static String concatPath(String path, String relPath) {
        String stdPath = OiixPathOps.getStandardForm(path);
        String concPath = OiixPathOps.concatPath(stdPath, relPath);
        return OiixPathOps.getNativeForm(concPath);
    }

    public static Boolean validatePath(String path) {
        try {
            OiipgFileSystem.validatePath(path);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public static Boolean writablePath(String path) {
        try {
            OiipgFileSystem.checkWritablePath(path);
        }
        catch (Exception e) {
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public static Boolean existsFile(String fileName) {
        if (null == fileName) {
            return Boolean.FALSE;
        }
        File file = new File(fileName);
        return new Boolean(file.exists());
    }

    public static Boolean isDirectory(String fileName) {
        if (null == fileName) {
            return Boolean.FALSE;
        }
        File file = new File(fileName);
        if (file.exists() && file.isDirectory()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getStandardForm(String filePath) {
        if (null == filePath) {
            return "";
        }
        return OiixPathOps.getStandardCanonicalPath(filePath);
    }

    public static String[] getFileList(String dirPath) {
        if (null == dirPath) {
            return new String[0];
        }
        File file = new File(dirPath);
        if (!file.isDirectory()) {
            return new String[0];
        }
        int len = file.list().length;
        String[] sa = new String[len];
        System.arraycopy(file.list(), 0, sa, 0, len);
        return sa;
    }

    public static String addToLog(String str) {
        OiiolTextLogger.appendText(str);
        return str;
    }

    public static String addToConfigLog(String str) {
        OiiolTextLogger.writeToConfigLog(str);
        OiiolTextLogger.appendText(str);
        return str;
    }

    public static String addToLogWithLogLevel(String str, Integer logLevel) {
        OiiolTextLogger.appendText(str, logLevel);
        return str;
    }

    public static String setProgressMessage(String sMessage) {
        OiixProgressListener prgListener = OiicSessionInterfaceManager.getInterfaceManager().getProgressListener();
        if (prgListener != null) {
            prgListener.setStatus(sMessage);
        }
        return sMessage;
    }

    public static Boolean showWarning(String sMessage, Boolean bRetry) throws OiifbCancelException, OiixRetryException {
        OiifbIRetry actionDlg;
        int retVal;
        OiiolTextLogger.appendText(sMessage);
        int flags = 0;
        if (bRetry.booleanValue()) {
            flags = 6;
        }
        if ((retVal = (actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(OiixResourceBundle.getString("S_WARNING"), sMessage, flags, 1, false)).doModal()) == 2) {
            throw new OiixRetryException();
        }
        return Boolean.TRUE;
    }

    public static Boolean showWarning(String sMessage) {
        OiiolTextLogger.appendText(sMessage);
        int flags = 0;
        OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(OiixResourceBundle.getString("S_WARNING"), sMessage, flags, 1, false);
        actionDlg.doModal();
        return Boolean.TRUE;
    }

    public static Integer showAlert(String title, String msg, Integer iconType, Boolean isError, Integer nButtons, Integer defaultButton) {
        int alertType = 30;
        int userChoice = 0;
        int defaultChoice = 1;
        if (null == title || null == msg) {
            return new Integer(-1);
        }
        switch (iconType) {
            case 1: {
                alertType = 30;
                break;
            }
            case 2: {
                alertType = 40;
                break;
            }
            case 3: {
                alertType = 50;
            }
        }
        int severity = isError != false ? 20 : 10;
        switch (nButtons) {
            case 1: {
                userChoice |= 1;
                break;
            }
            case 21: {
                userChoice |= 5;
                break;
            }
            case 22: {
                userChoice |= 3;
                break;
            }
            case 3: {
                userChoice |= 7;
                break;
            }
            default: {
                userChoice |= 1;
            }
        }
        switch (defaultButton) {
            case 1: {
                defaultChoice = 1;
                break;
            }
            case 2: {
                if (nButtons == 21) {
                    defaultChoice = 4;
                }
                if (nButtons != 3 && nButtons != 22) break;
                defaultChoice = 2;
                break;
            }
            case 3: {
                if (nButtons != 3) break;
                defaultChoice = 4;
            }
        }
        int choice = OiifmAlert.displayAlert(title, msg, alertType, userChoice, defaultChoice, severity);
        switch (choice) {
            case 1: {
                return new Integer(1);
            }
            case 2: {
                return new Integer(2);
            }
            case 4: {
                if (nButtons == 3) {
                    return new Integer(3);
                }
                return new Integer(2);
            }
        }
        return new Integer(-1);
    }

    public static String nlsGetSystemLanguage() {
        return OiicInstaller.getSystemLocale().getLanguage();
    }

    public static String nlsGetSystemCountry() {
        return OiicInstaller.getSystemLocale().getCountry();
    }

    public static String nlsGetSystemVariant() {
        return OiicInstaller.getSystemLocale().getVariant();
    }

    public static Boolean isCloneMode() {
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            return System.getProperty("oracle.installer.sessionType", "none").equalsIgnoreCase("Clone") ? Boolean.TRUE : Boolean.FALSE;
        }
        return OiicInstaller.getSessionWrapper().getCurSession().isCloneMode() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean isAddNodeMode() {
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            return System.getProperty("oracle.installer.sessionType", "none").equalsIgnoreCase("AddNode") ? Boolean.TRUE : Boolean.FALSE;
        }
        return OiicInstaller.getSessionWrapper().getCurSession().isAddNodeMode() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean isInstallMode() {
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            return System.getProperty("oracle.installer.sessionType", "none").equalsIgnoreCase("Install") ? Boolean.TRUE : Boolean.FALSE;
        }
        return OiicInstaller.getSessionWrapper().getCurSession().isInstallMode() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getFromLocation() {
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            return OiicAPIInstaller.getAPIInstallerInstance().getOUIAPISession().getFromLocation();
        }
        return OiicInstaller.getSessionWrapper().getCurSession().getFromLocation();
    }

    public static String getSystemProperty(String propName, String defValue) {
        propName = propName.trim();
        String propValue = "";
        try {
            propValue = System.getProperty(propName, defValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return propValue;
    }

    public static String setSystemProperty(String propName, String propValue) {
        propName = propName.trim();
        try {
            propValue = propValue.trim();
            System.setProperty(propName, propValue);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
                OiiolTextLogger.appendText("Set " + propName + " to " + propValue);
            }
        }
        catch (IllegalArgumentException e) {
            propValue = "";
        }
        return propValue;
    }

    public static Integer longCompare(String s1, String s2) {
        boolean bException = false;
        long l1 = 0L;
        long l2 = 0L;
        int EQUALS = 0;
        int LESSER = -1;
        int GREATER = 1;
        int EXCEPTION = -2;
        if (s1 == null || s1.length() == 0 || s2 == null || s2.length() == 0) {
            return new Integer(EXCEPTION);
        }
        s1 = s1.trim();
        s2 = s2.trim();
        try {
            l1 = Long.parseLong(s1);
            l2 = Long.parseLong(s2);
        }
        catch (NumberFormatException nfe) {
            bException = true;
        }
        if (bException) {
            return new Integer(EXCEPTION);
        }
        if (l1 == l2) {
            return new Integer(EQUALS);
        }
        if (l1 > l2) {
            return new Integer(GREATER);
        }
        return new Integer(LESSER);
    }

    public static String setChainInstallProgress(Boolean bShow, String sTitle, String sText) {
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            ((OiicPullSession)((Object)OiicAPIInstaller.getAPIInstallerInstance().getOUIAPISession())).setChainInstallProgress(bShow, sTitle, sText);
        } else {
            OiicInstaller.getSessionWrapper().getCurSession().setChainInstallProgress(bShow, sTitle, sText);
        }
        return "";
    }

    public static String setCustomRootShMessage(String sMessage) {
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            ((OiicPullSession)((Object)OiicAPIInstaller.getAPIInstallerInstance().getOUIAPISession())).setCustomRootShMessage(sMessage);
        } else {
            OiicInstaller.getSessionWrapper().getCurSession().setCustomRootShMessage(sMessage);
        }
        return "";
    }

    public static Integer abs(Integer nNumber) {
        return new Integer(Math.abs(nNumber));
    }

    public static Integer mod(Integer nDividend, Integer nDivisor) {
        return new Integer(nDividend % nDivisor);
    }

    public static Boolean isPlatformWindows() {
        int platID = OiixPlatform.getCurrentPlatform();
        int platGrp = OiixPlatform.getPlatGroup(platID);
        if (-3 == platGrp) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isPlatformUnix() {
        int platID = OiixPlatform.getCurrentPlatform();
        int platGrp = OiixPlatform.getPlatGroup(platID);
        if (-1 == platGrp) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isPlatformLinux() {
        int platID = OiixPlatform.getCurrentPlatform();
        int platGrp = OiixPlatform.getPlatGroup(platID);
        if (-1 == platGrp && (46 == platID || 211 == platID || 110 == platID)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getPlatformDirectoryName() {
        String platDir = OiixPlatform.getCurrentPlatformDirectoryName();
        if (null != platDir) {
            return platDir;
        }
        return "";
    }

    private static OiiiOracleHomeInfo getOracleHomeInfoObject() {
        String oracleHome = null;
        OiiiOracleHomeInfo oHome = null;
        try {
            oracleHome = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") ? (String)((OiicPullSession)((Object)OiicAPIInstaller.getAPIInstallerInstance().getOUIAPISession())).getSessionVarValue("ORACLE_HOME") : (String)OiicInstaller.getSessionWrapper().getCurSession().getSessionVarValue("ORACLE_HOME");
            oHome = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") ? ((OiicPullSession)((Object)OiicAPIInstaller.getAPIInstallerInstance().getOUIAPISession())).getInstallInventory().getHomeWithLocation(oracleHome) : OiicInstaller.getSessionWrapper().getCurSession().getInstallInventory().getHomeWithLocation(oracleHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oHome;
    }

    private static OiiiInstallInventory getInstallInventory() {
        OiiiInstallInventory instInv = null;
        instInv = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") ? ((OiicPullSession)((Object)OiicAPIInstaller.getAPIInstallerInstance().getOUIAPISession())).getInstallInventory() : OiicInstaller.getSessionWrapper().getCurSession().getInstallInventory();
        return instInv;
    }

    public static String getAdditionalOracleHomeProperty(String propertyName) {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null && propertyName != null) {
                String propertyValue = oHome.getAdditionalOracleHomeProperty(propertyName);
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer getOracleHomePropertyAruId() {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null) {
                Integer propertyValue = new Integer(oHome.getARUID());
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getOracleHomePropertyAruIdDescription() {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null) {
                String propertyValue = oHome.getARUIDDescription();
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getOracleHomePropertyGUID() {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null) {
                String propertyValue = oHome.getGUID();
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Boolean getOracleHomePropertyIsCRSHome() {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null) {
                Boolean propertyValue = new Boolean(oHome.isCRSHome());
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getOracleHomePropertyClusterNodes() {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null) {
                Vector propertyValue = oHome.getNodeList();
                return OiixFunctionOps.vect2sarr(propertyValue);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getOracleHomePropertyLocalNode() {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null) {
                String propertyValue = oHome.getLocalNode();
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static OiiiShipHomeInfo getOiiiShipHomeInfoObject() {
        OiiiShipHomeInfo shHome = null;
        shHome = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") ? ((OiicPullSession)((Object)OiicAPIInstaller.getAPIInstallerInstance().getOUIAPISession())).getSourceAccess().getStageInventory().getSHPropObj() : OiicInstaller.getSessionWrapper().getCurSession().getSourceAccess().getStageInventory().getSHPropObj();
        return shHome;
    }

    public static String getAdditionalShipHomeProperty(String propertyName) {
        try {
            OiiiShipHomeInfo shHome = OiixFunctionOps.getOiiiShipHomeInfoObject();
            if (shHome != null && propertyName != null) {
                String propertyValue = shHome.getAdditionalOracleHomeProperty(propertyName);
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer getShipHomePropertyAruId() {
        try {
            OiiiShipHomeInfo shHome = OiixFunctionOps.getOiiiShipHomeInfoObject();
            if (shHome != null) {
                Integer propertyValue = new Integer(shHome.getARUID());
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getShipHomePropertyAruIdDescription() {
        try {
            OiiiShipHomeInfo shHome = OiixFunctionOps.getOiiiShipHomeInfoObject();
            if (shHome != null) {
                String propertyValue = shHome.getARUIDDescription();
                return propertyValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setAdditionalOracleHomeProperty(String propertyName, String propertyValue) {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null && propertyName != null && propertyValue != null) {
                oHome.setAdditionalOracleHomeProperty(propertyName, propertyValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addDependeeHome(String homeLoc) {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null && homeLoc != null) {
                OiiiInstallInventory instInv = OiixFunctionOps.getInstallInventory();
                instInv.updateHomeDeps(oHome.getLocation(), homeLoc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ArrayList parseClusterConfFile(String sCCFile, int nColumns) throws FileNotFoundException, IOException {
        File fCCFile = new File(sCCFile);
        FileInputStream fInStream = new FileInputStream(fCCFile);
        return OiixFunctionOps.parseClusterConfFile(fInStream, nColumns);
    }

    public static String[] getDependeeHomes() {
        try {
            OiiiOracleHomeInfo oHome = OiixFunctionOps.getOracleHomeInfoObject();
            if (oHome != null) {
                Vector depHomeList = new Vector(oHome.getDepHomeList());
                return OiixVectorOps.vect2StrArr(depHomeList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ArrayList parseClusterConfFile(InputStream iCCFStream, int nColumns) throws IOException {
        String curLine = null;
        String[] tempString = null;
        ArrayList<String[]> nodeRows = new ArrayList<String[]>();
        ArrayList<String> nodeInfoCCF = new ArrayList<String>();
        BufferedReader bufReaderObj = new BufferedReader(new InputStreamReader(iCCFStream));
        boolean indexCounter = false;
        while ((curLine = bufReaderObj.readLine()) != null) {
            curLine = curLine.trim();
            OiiolTextLogger.appendText(curLine, 3);
            if (curLine.startsWith("#") || curLine.length() == 0) continue;
            tempString = curLine.split("\\s+");
            if (tempString.length != nColumns) {
                nodeInfoCCF.clear();
                continue;
            }
            for (int i = 0; i < nColumns; ++i) {
                if (tempString[i].equals("-")) {
                    tempString[i] = " ";
                }
                nodeInfoCCF.add(tempString[i]);
            }
            nodeRows.add(nodeInfoCCF.toArray(new String[nodeInfoCCF.size()]));
            nodeInfoCCF.clear();
        }
        return nodeRows;
    }

    private static String[] removeElementIgnoringCase(String[] input, String element) {
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < input.length; ++i) {
            String item = input[i];
            if (element.equalsIgnoreCase(item)) continue;
            result.add(item);
        }
        return result.toArray(new String[0]);
    }

    public static String getJreMemoryOptions() {
        String name = "JRE_MEMORY_OPTIONS";
        String sDefValue = "\" -mx150m\"";
        String jreMemoryOptions = OiixOraparam.getOraparamProfileString(name, sDefValue);
        if (null != jreMemoryOptions) {
            return jreMemoryOptions;
        }
        return sDefValue;
    }
}

