/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiixGeneralQueries {
    public static String getClusterList() {
        String sSelectedNodes = System.getProperty("oracle.installer.clusterlist");
        if (sSelectedNodes == null) {
            return "";
        }
        return sSelectedNodes;
    }

    public static Boolean setClusterNewNodesList(String clusterNewNodes) {
        Properties sysProp = System.getProperties();
        sysProp.put("CLUSTER_NEW_NODES", clusterNewNodes);
        sysProp.put("oracle.installer.bootstrap", "true");
        OiixGeneralQueries.setClusterON();
        return new Boolean(true);
    }

    public static Boolean setClusterNewNodesVIPList(String clusterNewNodesVIP) {
        return new Boolean(true);
    }

    public static Boolean setClusterList(String sSelectedNodes) {
        Properties sysProp = System.getProperties();
        sysProp.put("oracle.installer.clusterlist", sSelectedNodes);
        sysProp.put("oracle.installer.clusterSwitch", "ON");
        return new Boolean(true);
    }

    public static Boolean setClusterOFF() {
        Properties sysProp = System.getProperties();
        sysProp.put("oracle.installer.clusterSwitch", "OFF");
        return new Boolean(true);
    }

    public static Boolean setClusterON() {
        Properties sysProp = System.getProperties();
        sysProp.put("oracle.installer.clusterSwitch", "ON");
        return new Boolean(true);
    }

    public static String getSystemDate() {
        Calendar cd = Calendar.getInstance();
        String dateStamp = cd.get(2) + 1 + "-";
        dateStamp = dateStamp + cd.get(5) + "-";
        dateStamp = dateStamp + cd.get(1);
        return dateStamp;
    }

    public static String getSystemTime() {
        Date d = new Date();
        DateFormat df = DateFormat.getTimeInstance();
        String timeStamp = df.format(d);
        return timeStamp;
    }

    public static Integer getFreeSpaceux(String drive, Boolean returnInMegaBytes) {
        if (drive == null || drive.trim().equals("") || drive.trim().equals("null")) {
            return new Integer(0);
        }
        long toReturn = OiixFileOps.getVolumeFreeSpace(drive);
        double divideBy = 1024.0;
        if (returnInMegaBytes != null && returnInMegaBytes.booleanValue()) {
            divideBy = 1048576.0;
        }
        int retVal = (int)Math.round((double)toReturn / divideBy);
        return new Integer(retVal);
    }

    public static String getCurrentPlatformOSName() {
        return OiixPlatform.getCurrentPlatformOSName();
    }

    public static String getCurrentPlatformOSVer() {
        return OiixPlatform.getCurrentPlatformOSVer();
    }

    public static String getCurrentPlatformCommonNameEx() {
        return OiixPlatform.getCurrentPlatformCommonNameEx();
    }

    public static boolean isPlatInGroup(int groupID, int platID) {
        return OiixPlatform.isPlatInGroup(groupID, platID);
    }

    public static String getEnv(String varName) {
        return OiixEnvironmentOps.getEnv(varName);
    }

    public static void setEnv(String varName, String value) {
        OiixEnvironmentOps.setEnv(varName, value);
    }

    public static String getCurrentWorkingDir() {
        return OiixEnvironmentOps.getCurrentWorkingDir();
    }

    public static String[] getAllVolumeNames() {
        return OiixFileOps.getAllVolumeNames();
    }
}

