/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.help.Help;
import oracle.help.library.Book;
import oracle.help.library.helpbook.HelpBook;
import oracle.help.library.helpbook.HelpBookException;
import oracle.help.library.helpset.HelpSet;
import oracle.help.library.helpset.HelpSetParseException;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifm.OiifmImage;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiip.oiipg.OiipgHelp;
import oracle.sysman.oii.oiir.OiirHelpKeys;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixHelpDetails;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceVariants;

public class OiixHelp {
    private static final String S_INST_BOOKNAME = "installer.hs";
    private static final String S_INST_HELPNAME = "InstHelp";
    public static final String S_COMP_HELPNAME = "CompHelp";
    private static final String S_INST_HELPROOT = "oracle/sysman/oii/oiir";
    private static Book s_instBook = null;
    private static Help s_helpContext = null;
    private static Hashtable s_bookTable = new Hashtable(10);
    private static String s_scratchLoc = "/tmp";
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x1000000;

    private static Help getHelpContext() {
        if (s_helpContext == null) {
            try {
                Class<?> browserClass = Class.forName("oracle.help.htmlBrowser.ICEBrowser");
                s_helpContext = new Help(browserClass);
            }
            catch (ClassNotFoundException e) {
                s_helpContext = new Help();
            }
            String sHelpEncoding = OiipgHelp.getHelpEncoding();
            if (sHelpEncoding != null) {
                Help.setHelpEncoding((String)sHelpEncoding);
            }
            OiifmImage imgBundle = new OiifmImage(null, "Oiir");
            Image image = imgBundle.getImage("1501");
            s_helpContext.setIconImage(image);
        }
        return s_helpContext;
    }

    public static void dispose() {
        boolean bInitializeInstBook = s_instBook != null;
        s_instBook = null;
        if (s_helpContext != null) {
            s_helpContext.setVisible(false);
            s_helpContext.removeAllBooks();
            s_helpContext.dispose();
            s_helpContext = null;
        }
        s_bookTable = new Hashtable(10);
        s_scratchLoc = "/tmp";
        if (bInitializeInstBook) {
            OiixHelp.addInstHelp();
        }
    }

    public static void addHelp(String bookID, String baseLoc, String baseName, String bookName) {
        try {
            String bookLoc = OiixPathOps.directorify(OiixPathOps.getStandardForm("file:" + baseLoc));
            HelpBook book = new HelpBook(bookLoc, baseName, bookName);
            OiixHelp.getHelpContext().addBook((Book)book);
            s_bookTable.put(bookID, book);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void displayHelp(String bookID, String key) {
        Book book = (Book)s_bookTable.get(bookID);
        if (book != null) {
            try {
                OiixHelp.getHelpContext().showTopic(book, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addInstHelp() {
        String bookName = S_INST_BOOKNAME;
        String bookLoc = OiixHelp.getInstHelpLoc();
        if (bookLoc != null) {
            bookLoc = OiixPathOps.directorify(bookLoc);
            try {
                String sHelpEncoding;
                if (bookLoc.endsWith("/")) {
                    bookLoc = bookLoc.substring(0, bookLoc.length() - 1);
                }
                if ((sHelpEncoding = OiipgHelp.getHelpEncoding()) != null) {
                    Help.setHelpEncoding((String)sHelpEncoding);
                }
                if ((s_instBook = new HelpSet(OiirHelpKeys.class, OiixPathOps.concatPath(bookLoc, bookName))) != null) {
                    OiixHelp.getHelpContext().addBook(s_instBook);
                    OiixHelp.getHelpContext().setDefaultBook(s_instBook);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void displayInstHelp(String key, Window parent) {
        if (s_instBook != null) {
            OiixHelp.getHelpContext();
            Help.registerClientWindow((Window)parent);
            OiixHelp.displayInstHelp(key);
            OiixHelp.getHelpContext();
            Help.unregisterClientWindow((Window)parent);
        }
    }

    public static void displayInstHelp(String key) {
        if (s_instBook != null) {
            try {
                OiixHelp.getHelpContext().showTopic(s_instBook, key);
            }
            catch (Exception e) {
                System.err.println("Help Topic not found for: " + key);
                e.printStackTrace();
                try {
                    OiixHelp.getHelpContext().showTopic(s_instBook, key.toLowerCase());
                }
                catch (Exception e1) {
                    System.err.println("Help Topic not found for: " + key.toLowerCase());
                    e1.printStackTrace();
                    try {
                        OiixHelp.getHelpContext().showTopic(s_instBook, key.toUpperCase());
                    }
                    catch (Exception e2) {
                        System.err.println("Help Topic not found for: " + key.toUpperCase());
                        e2.printStackTrace();
                    }
                }
            }
        }
    }

    public static void displayHelp(OiixHelpDetails helpDetails) {
        if (helpDetails.isInstHelp()) {
            OiixHelp.displayInstHelp(helpDetails.getKey());
        } else if (helpDetails.getCompInstallID() == null) {
            OiixHelp.displayCompHelp(helpDetails.getVariableOwner(), helpDetails.getKey());
        } else {
            OiixHelp.displayCompHelp(helpDetails.getVariableOwner(), helpDetails.getCompInstallID(), helpDetails.getKey(), helpDetails.getDefaultInstHelp());
        }
    }

    public static void showContents() {
        OiixHelp.getHelpContext().showNavigatorWindow();
    }

    public static void displayCompHelp(OiisVariableOwner vo, String key) {
        OiisCompContext cc = (OiisCompContext)vo;
        OiiiCompInstallID cid = cc.getCompInstallID();
        Book book = (Book)s_bookTable.get(cid);
        if (book == null) {
            try {
                OiixHelp.addCompHelp(vo, cid);
            }
            catch (IOException e) {
                // empty catch block
            }
            book = (Book)s_bookTable.get(cid);
        }
        try {
            OiixHelp.showHelpTopic(book, key);
        }
        catch (TopicDisplayException e) {
            OiixHelp.displayInstHelp("PerComponentHelp");
        }
    }

    public static void displayCompHelp(OiisVariableOwner vo, OiiiCompInstallID cid, String key, String defaultInstHelp) {
        OiicSessionContext cc = (OiicSessionContext)vo;
        Book book = (Book)s_bookTable.get(cid);
        boolean helpAdded = false;
        if (book == null) {
            try {
                helpAdded = OiixHelp.addCompHelp(vo, cid);
            }
            catch (IOException e) {
                // empty catch block
            }
            book = (Book)s_bookTable.get(cid);
            if (!helpAdded) {
                OiixHelp.displayInstHelp(defaultInstHelp);
                return;
            }
        }
        try {
            OiixHelp.showHelpTopic(book, cid.getName() + "_" + cid.getVersion().getVerString() + "_" + key);
        }
        catch (TopicDisplayException e1) {
            try {
                OiixHelp.showHelpTopic(book, key);
            }
            catch (TopicDisplayException e) {
                OiixHelp.displayInstHelp(defaultInstHelp);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void showHelpTopic(Book book, String key) throws TopicDisplayException {
        if (book != null) {
            try {
                OiixHelp.getHelpContext().showTopic(book, key + OiixPlatform.getCurrentPlatform());
                return;
            }
            catch (Exception e) {
                if (!(e instanceof TopicDisplayException)) return;
                throw (TopicDisplayException)((Object)e);
            }
        } else {
            System.err.println("OiixHelp::WARNING: Component not in list of HelpBooks");
            throw new TopicDisplayException(key);
        }
    }

    private static String getInstHelpLoc() {
        Enumeration vars = OiixResourceVariants.genResourceVariants();
        while (vars.hasMoreElements()) {
            String helpLoc = OiixPathOps.concatPath("help", S_INST_HELPNAME + (String)vars.nextElement());
            String helpFile = OiixPathOps.concatPath(helpLoc, S_INST_BOOKNAME);
            helpFile = OiixPathOps.concatPath(S_INST_HELPROOT, helpFile);
            try {
                URL hhcURL = ClassLoader.getSystemResource(helpFile);
                if (hhcURL == null) continue;
                return helpLoc;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static String sysResToFileURL(URL sysRes) {
        String fileName = sysRes.getFile();
        if (fileName.startsWith("/FILE")) {
            int plusLoc;
            if ((fileName = fileName.substring(5)).startsWith(".")) {
                fileName = System.getProperty("user.dir") + fileName.substring(1);
            }
            if ((plusLoc = fileName.indexOf("/+/")) != -1) {
                String tmpName = fileName.substring(0, plusLoc);
                fileName = tmpName + fileName.substring(plusLoc + 2);
            }
            return "file:" + fileName;
        }
        return null;
    }

    private static boolean addCompHelp(OiisVariableOwner vo, OiiiCompInstallID cid) throws IOException {
        boolean bSuccess = false;
        OiisCompJarLoader compJarLoader = null;
        OiixJarClassLoader jarClassLoader = null;
        OiisCompInstallation compIns = null;
        OiicPullSession pSession = vo.getSession();
        int compType = cid.getCompType();
        if (compType == 1 || compType == 2) {
            compIns = ((OiicInstallSession)pSession).getCompInstall(cid);
            compJarLoader = compIns.getCompJarLoader();
            jarClassLoader = compIns.getHelpJarClassLoader();
        } else {
            jarClassLoader = null;
        }
        if (jarClassLoader != null) {
            String baseName = cid.getName();
            boolean bCreateHelpBook = false;
            OiisCompProperties props = compIns.getProperties();
            String bookName = props.getHelpBookName();
            if (bookName == null) {
                bookName = pSession.getStgCompName(cid);
                bCreateHelpBook = true;
            }
            try {
                Class cl = jarClassLoader.loadClass("compHlp");
                String helpDir = compIns.getHelpDir();
                Book book = bCreateHelpBook ? OiixHelp.createHelpBook(cl, helpDir, baseName, bookName) : OiixHelp.createHelpSet(cl, helpDir, bookName);
                OiixHelp.getHelpContext().addBook(book);
                s_bookTable.put(cid, book);
                bSuccess = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return bSuccess;
    }

    private static Book createHelpBook(Class cl, String helpDir, String baseName, String bookName) {
        if (helpDir.endsWith("/")) {
            helpDir = helpDir.substring(0, helpDir.length() - 1);
        }
        HelpBook helpBook = null;
        try {
            helpBook = new HelpBook(cl, helpDir, baseName, bookName);
        }
        catch (HelpBookException e) {
            // empty catch block
        }
        return helpBook;
    }

    private static Book createHelpSet(Class cl, String helpDir, String bookName) {
        bookName = OiixPathOps.concatPath(helpDir, bookName);
        HelpSet helpSet = null;
        try {
            helpSet = new HelpSet(cl, bookName);
        }
        catch (HelpSetParseException e) {
            // empty catch block
        }
        return helpSet;
    }

    private static void debug(String msg) {
    }

    public static void setScratchLoc(String scratchLoc) {
        s_scratchLoc = scratchLoc;
    }

    private static String getCompScratchLoc(String compName) {
        int i = 0;
        boolean found = false;
        String helpPath = null;
        String sPath = OiixPathOps.concatPath(s_scratchLoc, "OiixHelp");
        while (!found) {
            File sLoc = new File(OiixPathOps.concatPath(sPath, compName), String.valueOf(i++));
            if (!sLoc.exists()) {
                OiixFileOps.mkdirs(sLoc);
                found = true;
            }
            helpPath = sLoc.getPath();
            OiixHelp.debug("getCompScratchLoc(): looking at " + helpPath);
        }
        OiixHelp.debug("getCompScratchLoc(): final selection: " + helpPath);
        return helpPath;
    }

    private static String extractCompHelp(String helpJarLoc, String compName) {
        String helpLoc = OiixHelp.getCompScratchLoc(compName);
        try {
            OiixJarClassLoader jcl = new OiixJarClassLoader(helpJarLoc);
            jcl.extractJar(helpLoc);
        }
        catch (Exception e) {
            helpLoc = null;
        }
        return helpLoc;
    }

    public static void clearCompHelp() {
        Enumeration books = s_bookTable.elements();
        while (books.hasMoreElements()) {
            Book b = (Book)books.nextElement();
            OiixHelp.getHelpContext().removeBook(b);
        }
        s_bookTable.clear();
    }
}

