/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixIniComment;
import oracle.sysman.oii.oiix.OiixIniObject;
import oracle.sysman.oii.oiix.OiixIniPair;
import oracle.sysman.oii.oiix.OiixIniParsingException;
import oracle.sysman.oii.oiix.OiixIniRawText;
import oracle.sysman.oii.oiix.OiixIniSection;
import oracle.sysman.oii.oiix.OiixIterator;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiiz.OiizResourceBundle;

public class OiixIniFile {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x1000000;
    public static final String NEW_LINE = System.getProperty("line.separator");
    private Vector m_Contents = new Vector();
    private int m_currentContext = -1;
    private boolean m_bPreserveFormat = false;
    private boolean m_bLoggingEnabled = false;
    private static final int SECTION = 1;
    private static final int COMMENT = 2;
    private static final int RAW_TEXT = 3;
    private static final int VARIABLE = 4;
    public static final String DEFAULT = "DEFAULT_SECTION";
    private String m_sFileName;
    private static String sCommentChar = OiixResourceBundle.getString("S_COMMENT_CHAR");
    private String m_strVersion;
    private Vector m_vIncludeFiles;

    public OiixIniFile(String fileName) {
        this(fileName, false);
    }

    public OiixIniFile(String fileName, boolean bPreserveFormat) {
        this.m_sFileName = fileName;
        this.m_bPreserveFormat = bPreserveFormat;
    }

    public Vector getIncludeFiles() {
        return this.m_vIncludeFiles;
    }

    private void setIncludeFiles(Vector vVect) {
        this.m_vIncludeFiles = vVect;
    }

    private void setRSPVersion(String strVersion) {
        this.m_strVersion = strVersion;
    }

    public String getRSPVersion() {
        return this.m_strVersion;
    }

    public void setLoggingEnabled(boolean bLoggingEnabled) {
        this.m_bLoggingEnabled = bLoggingEnabled;
    }

    public void setHeader(String sHeader) {
        int i;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            try {
                this.m_bPreserveFormat = true;
                this.readIniFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        int firstSectionIdx = 0;
        for (i = 0; i < this.m_Contents.size(); ++i) {
            Object item = this.m_Contents.elementAt(i);
            if (!(item instanceof OiixIniSection)) continue;
            firstSectionIdx = i;
            break;
        }
        for (i = 0; i < firstSectionIdx; ++i) {
            this.m_Contents.removeElementAt(0);
        }
        this.m_Contents.insertElementAt(new OiixIniComment(sHeader), 0);
    }

    public String getHeader() {
        Object item;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            try {
                this.m_bPreserveFormat = true;
                this.readIniFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String sHeader = "";
        OiixIterator iterator = this.getIterator(false);
        while (iterator.hasMoreItems() && !((item = iterator.nextItem()) instanceof OiixIniSection)) {
            sHeader = sHeader + item.toString();
            sHeader = sHeader + NEW_LINE;
        }
        return sHeader;
    }

    public Vector getVarsInSection(String sectionName) throws IOException {
        OiixIniSection section = this.getSection(sectionName);
        if (section == null) {
            return null;
        }
        Vector<String> varNames = new Vector<String>();
        OiixIterator iterator = section.getIterator(true);
        while (iterator.hasMoreItems()) {
            OiixIniPair pair = (OiixIniPair)iterator.nextItem();
            varNames.addElement(pair.getName());
        }
        return varNames;
    }

    public String getProfileString(String sectionName, String variable, String defValue) throws IOException {
        OiixIniPair pair;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            this.m_bPreserveFormat = true;
            this.readIniFile();
        }
        if ((pair = this.getPair(sectionName, variable)) == null) {
            return defValue;
        }
        return pair.getValue();
    }

    public String[] getProfileStringList(String sectionName, String variable, String[] defValue) throws IOException {
        OiixIniPair pair;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            this.m_bPreserveFormat = true;
            this.readIniFile();
        }
        if ((pair = this.getPair(sectionName, variable)) == null) {
            return defValue;
        }
        String value = pair.getValue();
        return this.extractStringList(value);
    }

    public String[] extractStringList(String value) {
        String DELIMS = ",";
        if (!value.startsWith("{") || !value.endsWith("}")) {
            return null;
        }
        value = value.substring(1, value.length() - 1);
        String[] sArray = OiixFunctionOps.explodeString(value, ",");
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i].startsWith("\"") && sArray[i].endsWith("\"")) {
                sArray[i] = sArray[i].substring(1, sArray[i].length() - 1);
                continue;
            }
            if (!sArray[i].startsWith("\"") || sArray[i].endsWith("\"")) continue;
            return null;
        }
        return sArray;
    }

    public void setProfileString(String sectionName, String variable, String value) {
        OiixIniPair pair;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            try {
                this.m_bPreserveFormat = true;
                this.readIniFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((pair = this.getPair(sectionName, variable)) != null) {
            pair.setValue(value);
        } else {
            try {
                this.addPair(sectionName, variable, value);
            }
            catch (OiixIniParsingException e) {
                e.printStackTrace();
            }
        }
    }

    public void setProfileString(String sectionName, String variable, String value, String sDesc) {
        this.setProfileString(sectionName, variable, value);
        OiixIniSection section = this.getSection(sectionName);
        if (sDesc != null && sDesc.length() != 0) {
            section.setPairDesc(variable, sDesc);
        }
    }

    public void writeFile() throws IOException {
        this.writeFileTo(this.m_sFileName);
    }

    public void writeFileTo(String sFullPath) throws IOException {
        FileOutputStream outStream = new FileOutputStream(new File(sFullPath));
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        BufferedWriter writer = new BufferedWriter(outWriter);
        OiixIterator iterator = this.getIterator(false);
        while (iterator.hasMoreItems()) {
            OiixIniObject item = (OiixIniObject)iterator.nextItem();
            item.write(writer);
            writer.write(NEW_LINE);
        }
        writer.close();
        outWriter.close();
        outStream.close();
    }

    public void writeIniFile() throws IOException {
        this.writeFile();
    }

    public void addItem(OiixIniObject item) {
        if (item instanceof OiixIniPair) {
            throw new IllegalArgumentException("Not a valid INI item");
        }
        this.m_Contents.addElement(item);
    }

    public OiixIniSection addSection(String sName) {
        OiixIniSection section = this.getSection(sName);
        if (section == null) {
            section = new OiixIniSection(sName);
            this.m_Contents.addElement(section);
        }
        return section;
    }

    public OiixIniSection getSection(String sName) {
        OiixIterator iterator = this.getIterator(true);
        while (iterator.hasMoreItems()) {
            OiixIniSection section = (OiixIniSection)iterator.nextItem();
            if (!section.getName().equalsIgnoreCase(sName)) continue;
            return section;
        }
        return null;
    }

    public void addPair(String sSection, String sName, String sValue) throws OiixIniParsingException {
        OiixIniSection section = this.getSection(sSection);
        if (section == null) {
            section = this.addSection(sSection);
        }
        section.addItem(new OiixIniPair(sName, sValue, true));
    }

    public OiixIniPair getPair(String sSection, String sName) {
        OiixIniSection section = this.getSection(sSection);
        if (section == null) {
            return null;
        }
        return section.getPair(sName);
    }

    public String getValue(String sSection, String sName) {
        String sValue = null;
        OiixIniPair pair = this.getPair(sSection, sName);
        if (pair != null) {
            sValue = pair.getValue();
        }
        return sValue;
    }

    public void readFile() throws IOException, OiixIniParsingException {
        String currentLine;
        this.m_Contents = new Vector();
        OiixIniComment currentComment = null;
        OiixIniRawText currentRawText = null;
        OiixIniPair currentPair = null;
        String sLHSName = null;
        int lineNumber = 0;
        OiixIniSection currentSection = null;
        String sectionName = DEFAULT;
        currentSection = new OiixIniSection(sectionName, lineNumber);
        this.addItem(currentSection);
        lineNumber = 0;
        FileInputStream inStream1 = new FileInputStream(new File(this.m_sFileName));
        InputStreamReader insReader1 = new InputStreamReader(inStream1);
        BufferedReader reader1 = new BufferedReader(insReader1);
        boolean bAdded = false;
        boolean m_bPreserveFormat = false;
        while ((currentLine = reader1.readLine()) != null) {
            ++lineNumber;
            String currentLineCopy = new String(currentLine);
            if ((currentLine = currentLine.trim()).startsWith("[") && currentLine.endsWith("]")) {
                sectionName = currentLine.substring(1, currentLine.length() - 1);
                if (sectionName.equals(DEFAULT)) continue;
                currentSection = new OiixIniSection(sectionName, lineNumber);
                this.addItem(currentSection);
                this.m_currentContext = 1;
                continue;
            }
            if (currentLine.startsWith(sCommentChar)) {
                if (!m_bPreserveFormat) {
                    this.m_currentContext = 2;
                    continue;
                }
                if (this.m_currentContext == 2 && currentComment != null) {
                    currentComment.addLine(currentLine);
                    continue;
                }
                currentComment = new OiixIniComment(currentLine, lineNumber);
                if (currentSection != null) {
                    currentSection.addItem(currentComment);
                } else {
                    this.addItem(currentComment);
                }
                this.m_currentContext = 2;
                continue;
            }
            if (this.m_currentContext == 4 && currentPair != null && !currentPair.isValueFinal()) {
                currentPair.addValueLine(currentLineCopy);
                continue;
            }
            if (currentLine.indexOf(61) != -1) {
                int idx = currentLine.indexOf(61);
                sLHSName = currentLine.substring(0, idx);
                String sRHSValue = currentLine.substring(idx + 1);
                if (currentSection != null) {
                    currentPair = new OiixIniPair(sLHSName, sRHSValue, m_bPreserveFormat, lineNumber);
                    currentSection.addItem(currentPair);
                }
                this.m_currentContext = 4;
                continue;
            }
            if (!m_bPreserveFormat) {
                this.m_currentContext = 3;
                continue;
            }
            if (this.m_currentContext == 3 && currentRawText != null) {
                currentRawText.addLine(currentLine);
            } else {
                currentRawText = new OiixIniRawText(currentLine, lineNumber);
                if (currentSection != null) {
                    currentSection.addItem(currentRawText);
                } else {
                    this.addItem(currentRawText);
                }
            }
            this.m_currentContext = 3;
        }
        String strSection = null;
        if (this.getSection(OiizResourceBundle.getString("S_RSP_GENERAL")) != null) {
            strSection = this.getSection(OiizResourceBundle.getString("S_RSP_GENERAL")).toString();
            strSection = strSection.substring(strSection.indexOf("[") + 1, strSection.indexOf("]"));
        }
        if (strSection == null) {
            strSection = this.getSection(DEFAULT).toString();
            strSection = strSection.substring(strSection.indexOf("[") + 1, strSection.indexOf("]"));
        }
        String strRspLHS = OiizResourceBundle.getString("S_RSP_VERSTR");
        String strRspRHS = null;
        if (strSection != null) {
            strRspRHS = this.getValue(strSection, strRspLHS);
            strRspRHS = OiiiVersion.getStandardForm(strRspRHS).toString();
        }
        if (strRspRHS != null) {
            String str170 = OiiiVersion.getStandardForm(OiizResourceBundle.getString("S_RSP_VERSION")).toString();
            String str210 = OiiiVersion.getStandardForm(OiizResourceBundle.getString("S_RSP_VERSION_2.2.1")).toString();
            if (OiiiVersion.validate(strRspRHS)) {
                if (strRspRHS.equalsIgnoreCase(str170)) {
                    if (this.m_Contents != null) {
                        String strSess;
                        boolean bGen = false;
                        boolean bSess = false;
                        String strGen = OiizResourceBundle.getString("S_RSP_GENERAL");
                        if (this.getSection(strGen) == null) {
                            bGen = true;
                        }
                        if (this.getSection(strSess = OiizResourceBundle.getString("S_RSP_SESSION")) == null) {
                            bSess = true;
                        }
                        if (bGen || bSess) {
                            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_RSP_VER"));
                        } else {
                            this.setRSPVersion(strRspRHS);
                        }
                    }
                } else if (strRspRHS.equalsIgnoreCase(str210)) {
                    if (this.m_Contents != null && this.m_Contents.size() == 1) {
                        strSection = this.getSection(DEFAULT).toString();
                        this.setRSPVersion(strRspRHS);
                        String strInclude = currentSection.getValue("INCLUDE");
                        if (strInclude != null && strInclude.startsWith("{") && strInclude.endsWith("}")) {
                            strInclude = strInclude.substring(strInclude.indexOf("{") + 1, strInclude.indexOf("}"));
                            StringTokenizer tkInclude = new StringTokenizer(strInclude, ",");
                            while (tkInclude.hasMoreTokens()) {
                                String strFile;
                                if (this.m_vIncludeFiles == null) {
                                    this.m_vIncludeFiles = new Vector();
                                }
                                if ((strFile = tkInclude.nextElement().toString().trim()).charAt(0) == '\"') {
                                    strFile = strFile.substring(1, strFile.length() - 1);
                                }
                                this.m_vIncludeFiles.add(strFile);
                            }
                        }
                    } else {
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_RSP_VER"));
                    }
                } else {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_RSP_VER"));
                }
            } else {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_RSP_VER"));
            }
        }
        reader1.close();
        insReader1.close();
        inStream1.close();
    }

    private void readIniFile() throws IOException {
        try {
            this.readFile();
        }
        catch (OiixIniParsingException e) {
            System.out.println(e.getMessage());
        }
    }

    public OiixIterator getIterator(boolean bSectionsOnly) {
        OiixIniFileIterator iterator = new OiixIniFileIterator(bSectionsOnly);
        return iterator;
    }

    class OiixIniFileIterator
    implements OiixIterator {
        private int m_nCurrent = 0;
        private boolean m_bSectionsOnly;

        public OiixIniFileIterator(boolean bSectionsOnly) {
            this.m_bSectionsOnly = bSectionsOnly;
        }

        public Object nextItem() {
            return OiixIniFile.this.m_Contents.elementAt(this.m_nCurrent++);
        }

        public boolean hasMoreItems() {
            if (!this.m_bSectionsOnly) {
                return this.m_nCurrent < OiixIniFile.this.m_Contents.size();
            }
            while (this.m_nCurrent < OiixIniFile.this.m_Contents.size()) {
                Object item = OiixIniFile.this.m_Contents.elementAt(this.m_nCurrent);
                if (item instanceof OiixIniSection) {
                    return true;
                }
                ++this.m_nCurrent;
            }
            return false;
        }

        public void insertBefore(Object item) {
            if (!(item instanceof OiixIniObject)) {
                throw new IllegalArgumentException("Not a valid INI element");
            }
            if (this.m_nCurrent == 0) {
                OiixIniFile.this.m_Contents.insertElementAt(item, 0);
            } else {
                OiixIniFile.this.m_Contents.insertElementAt(item, this.m_nCurrent - 1);
            }
            ++this.m_nCurrent;
        }

        public void insertAfter(Object item) {
            if (!(item instanceof OiixIniObject)) {
                throw new IllegalArgumentException("Not a valid section element");
            }
            OiixIniFile.this.m_Contents.insertElementAt(item, this.m_nCurrent);
        }

        public void remove() {
            OiixIniFile.this.m_Contents.removeElementAt(this.m_nCurrent - 1);
        }
    }
}

