/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixIniComment;
import oracle.sysman.oii.oiix.OiixIniObject;
import oracle.sysman.oii.oiix.OiixIniPair;
import oracle.sysman.oii.oiix.OiixIterator;

public class OiixIniSection
extends OiixIniObject {
    private String m_sName;
    private Vector m_Contents;

    public OiixIniSection(String name) {
        this(name, 0);
    }

    public OiixIniSection(String name, int lineNumber) {
        this.m_sName = name;
        this.setStartLineNumber(lineNumber);
        this.m_Contents = new Vector(10, 10);
    }

    public void addItem(OiixIniObject item) {
        if (item instanceof OiixIniSection) {
            return;
        }
        this.m_Contents.addElement(item);
    }

    public OiixIniPair getPair(String sName) {
        OiixIterator iterator = this.getIterator(true);
        while (iterator.hasMoreItems()) {
            OiixIniPair pair = (OiixIniPair)iterator.nextItem();
            if (!pair.getName().equalsIgnoreCase(sName)) continue;
            return pair;
        }
        return null;
    }

    void setPairDesc(String sName, String sDesc) {
        int lastVarIdx = 0;
        int currentIdx = 0;
        for (currentIdx = 0; currentIdx < this.m_Contents.size(); ++currentIdx) {
            Object item = this.m_Contents.elementAt(currentIdx);
            if (!(item instanceof OiixIniPair)) continue;
            String s = ((OiixIniPair)item).getName();
            if (s.equalsIgnoreCase(sName)) break;
            lastVarIdx = currentIdx;
        }
        for (int i = lastVarIdx + 1; i < currentIdx; ++i) {
            this.m_Contents.removeElementAt(lastVarIdx + 1);
        }
        if (currentIdx == 0) {
            this.m_Contents.insertElementAt(new OiixIniComment(sDesc), 0);
        } else {
            this.m_Contents.insertElementAt(new OiixIniComment(sDesc), lastVarIdx + 1);
        }
    }

    public String getName() {
        return this.m_sName;
    }

    public String getValue(String sName) {
        OiixIniPair pair = this.getPair(sName);
        if (pair == null) {
            return null;
        }
        return pair.getValue();
    }

    public OiixIterator getIterator(boolean bVarsOnly) {
        OiixSectionIterator iterator = new OiixSectionIterator(bVarsOnly);
        return iterator;
    }

    public void write(Writer writer) throws IOException {
        super.write(writer);
        OiixSectionIterator iterator = new OiixSectionIterator(false);
        while (iterator.hasMoreItems()) {
            OiixIniObject item = (OiixIniObject)iterator.nextItem();
            item.write(writer);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.m_sName);
        sb.append(']');
        sb.append(NEW_LINE);
        return sb.toString();
    }

    class OiixSectionIterator
    implements OiixIterator {
        private int m_nCurrent = 0;
        private boolean m_bVarsOnly;

        private OiixSectionIterator(boolean bVarsOnly) {
            this.m_bVarsOnly = bVarsOnly;
        }

        public boolean hasMoreItems() {
            if (!this.m_bVarsOnly) {
                return this.m_nCurrent < OiixIniSection.this.m_Contents.size();
            }
            boolean bFound = false;
            while (this.m_nCurrent < OiixIniSection.this.m_Contents.size()) {
                Object item = OiixIniSection.this.m_Contents.elementAt(this.m_nCurrent);
                if (item instanceof OiixIniPair) {
                    return true;
                }
                ++this.m_nCurrent;
            }
            return false;
        }

        public Object nextItem() {
            return OiixIniSection.this.m_Contents.elementAt(this.m_nCurrent++);
        }

        public void insertBefore(Object item) {
            if (!(item instanceof OiixIniObject)) {
                throw new IllegalArgumentException("Not a valid section element");
            }
            if (this.m_nCurrent == 0) {
                OiixIniSection.this.m_Contents.insertElementAt(item, 0);
            } else {
                OiixIniSection.this.m_Contents.insertElementAt(item, this.m_nCurrent - 1);
            }
            ++this.m_nCurrent;
        }

        public void insertAfter(Object item) {
            if (!(item instanceof OiixIniObject)) {
                throw new IllegalArgumentException("Not a valid section element");
            }
            OiixIniSection.this.m_Contents.insertElementAt(item, this.m_nCurrent);
        }

        public void remove() {
            OiixIniSection.this.m_Contents.removeElementAt(this.m_nCurrent - 1);
        }
    }
}

