/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifd.OiifdDeinstallPromptDlg;
import oracle.sysman.oii.oiif.oiifj.OiifjInstallErrorDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisInstantiateInfo;
import oracle.sysman.oii.oiis.OiisPatchInstallation;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstantiateString;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiixInstantiateOps {
    public void instantiate(OiisInstantiateInfo input, OiisCompInstallation compInstall, OiicPullSession instSession, OiixProgressListener oListnr) throws OiifbCancelException {
        OiifbProgressControl progCtrl;
        long lTime = 0L;
        if (OiixDebug.PRINT_MEMORY) {
            lTime = System.currentTimeMillis();
            OiixDebug.printMemory("ACTION:START:instantiate", lTime);
        }
        if (!(progCtrl = instSession.getActionsPhaseWCDE().getProgressControl()).canContinue()) {
            boolean cancelSession = (Boolean)progCtrl.getCancelCondition();
            String exStr = OiixResourceBundle.getString("S_USER_CANCEL");
            throw new OiifbCancelException(exStr, cancelSession);
        }
        boolean retry = false;
        do {
            try {
                this.instantiateAndHandleExcpn(input, compInstall, instSession, oListnr);
            }
            catch (OiilActionException ae) {
                String severity = String.valueOf(ae.getExceptionSeverity());
                Object[] exargs = new String[]{"instantiate", ae.getExceptionName(), ae.getExceptionString(), severity};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35900", exargs));
                StringBuffer sb = new StringBuffer();
                sb.append(OiixResourceBundle.getString("S_LOG_EXCEPTION_HANDLING_OPTIONS"));
                int button_ops = 0;
                button_ops = 0;
                button_ops |= 2;
                sb.append(OiixResourceBundle.getString("S_LOG_RETRY1"));
                if (ae.getExceptionSeverity() != -1) {
                    button_ops |= 4;
                    sb.append(OiixResourceBundle.getString("S_LOG_IGNORE1"));
                }
                int userInput = 0;
                try {
                    OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(ae.getMessage(), button_ops, 1);
                    boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
                    if (!OiicPullSession.isSilentMode() && !isAPIMode) {
                        ((OiifjInstallErrorDlg)actionDlg).setExitOnCancel(true);
                    }
                    userInput = actionDlg.doModal();
                    actionDlg = null;
                    Thread.yield();
                }
                catch (Exception e) {
                    OiiolTextLogger.appendException(e);
                }
                sb.append(OiiolTextLogger.NEW_LINE);
                sb.append(OiixResourceBundle.getString("S_LOG_USER_CHOICE"));
                switch (userInput) {
                    case 2: {
                        retry = true;
                        sb.append(OiixResourceBundle.getString("S_LOG_RETRY2"));
                        break;
                    }
                    case 4: {
                        retry = false;
                        sb.append(OiixResourceBundle.getString("S_LOG_IGNORE2"));
                        input.setActionType(3);
                        break;
                    }
                    case 32: {
                        sb.append(OiixResourceBundle.getString("S_LOG_USER_SELECTED_STOPONLY"));
                        OiiolTextLogger.appendText(sb.toString());
                        throw new OiifbCancelException(ae.getMessage(), false);
                    }
                    case 16: {
                        sb.append(OiixResourceBundle.getString("S_LOG_USER_SELECTED_STOPALL"));
                        OiiolTextLogger.appendText(sb.toString());
                        throw new OiifbCancelException(ae.getMessage(), true);
                    }
                }
                OiiolTextLogger.appendText(sb.toString());
            }
        } while (retry);
        if (OiixDebug.PRINT_MEMORY) {
            lTime = System.currentTimeMillis();
            OiixDebug.printMemory("ACTION:END:instantiate", lTime);
        }
    }

    public void instantiateAndHandleExcpn(OiisInstantiateInfo input, OiisCompInstallation compInstall, OiicPullSession instSession, OiixProgressListener oListnr) throws OiilActionException {
        String[] selectedNodes;
        ArrayList vVars = input.getVarsToReplace();
        String[] varNameList = new String[vVars.size()];
        varNameList = vVars.toArray(varNameList);
        String sourceFile = input.getSource();
        String destFile = input.getDest();
        String sDelimiter = input.getDelimiter();
        String sCondn = input.getCondVar();
        sourceFile = this.replaceVarVal(compInstall.getContext(), sourceFile);
        destFile = this.replaceVarVal(compInstall.getContext(), destFile);
        sDelimiter = this.replaceVarVal(compInstall.getContext(), sDelimiter);
        sCondn = this.replaceVarVal(compInstall.getContext(), sCondn);
        if (sCondn.equalsIgnoreCase("false")) {
            return;
        }
        this.toLog(input);
        HashMap oSearchReplaceMap = this.getSearchReplaceMap(compInstall, varNameList, sDelimiter);
        destFile = destFile.replace('/', File.separatorChar);
        String destBackUpFile = destFile + ".ouibak";
        String whatExisted = null;
        try {
            whatExisted = OiixInstantiateOps.createDirForDest(destFile);
        }
        catch (Exception anye) {
            int severity = 2;
            String[] variables1 = new String[1];
            String[] values1 = new String[1];
            variables1[0] = new String("%1%");
            values1[0] = new String(destFile);
            String exName = "UnableToWriteDestinationException";
            String errString = OiixResourceBundle.getString("UnableToWriteDestinationException_desc");
            String exString = OiixInstantiateString.processString(errString, variables1, values1);
            throw new OiilActionException(exName, exString, severity);
        }
        int permissions = 436;
        try {
            if (OiixPathOps.isHttpLocation(sourceFile)) {
                sourceFile = OiixInstantiateOps.getLocalCopy(sourceFile);
            }
        }
        catch (IOException ie) {
            // empty catch block
        }
        sourceFile = sourceFile.replace('/', File.separatorChar);
        boolean bSameFile = false;
        if (destFile.equals(sourceFile)) {
            bSameFile = true;
        }
        File srcFile = new File(sourceFile);
        String sSrcFile = sourceFile;
        boolean bSourceNotFound = false;
        if (!srcFile.exists() && instSession.isInstallMode()) {
            int severity = 2;
            String[] vars = new String[1];
            String[] vals = new String[1];
            vars[0] = new String("%1%");
            vals[0] = new String(sourceFile);
            String exName = "FileNotFoundException";
            String errString = OiixResourceBundle.getString("FileNotFoundException_desc");
            String exString = OiixInstantiateString.processString(errString, vars, vals);
            throw new OiilActionException(exName, exString, severity);
        }
        OiixInstantiateOps.backupTemplate(sourceFile, compInstall, instSession, false);
        if (!srcFile.exists()) {
            String sFallBackSrc = null;
            try {
                sFallBackSrc = this.getTemplatesLocation(sourceFile, compInstall.getContext(), instSession.getOHIndex());
            }
            catch (IOException e) {
                String sDesc = OiixResourceBundle.getString("S_ACTION_SOURCE_MISSING");
                Object[] args = new String[]{sourceFile};
                sDesc = MessageFormat.format(sDesc, args);
                String sMsg = OiixResourceBundle.getString("S_LOG_ALERT_WARNING") + " " + sDesc;
                OiiolTextLogger.appendText(sMsg, OiiolTextLogger.LOG_BASIC);
                return;
            }
            if (sFallBackSrc != null) {
                sSrcFile = sFallBackSrc;
                srcFile = new File(sFallBackSrc);
                if (!srcFile.exists() || sFallBackSrc.equals(sourceFile)) {
                    String sDesc = OiixResourceBundle.getString("S_ACTION_SOURCE_MISSING");
                    Object[] args = new String[]{sourceFile};
                    sDesc = MessageFormat.format(sDesc, args);
                    String sMsg = OiixResourceBundle.getString("S_LOG_ALERT_WARNING") + " " + sDesc;
                    OiiolTextLogger.appendText(sMsg, OiiolTextLogger.LOG_BASIC);
                    return;
                }
                Object[] sArgs = new String[]{sSrcFile, destFile};
                String sMsg = OiixResourceBundle.getString("S_USING_BACKUP_AS_SOURCE", sArgs);
                OiiolTextLogger.appendText(sMsg);
                bSameFile = false;
            }
        }
        int curPlatId = OiixPlatform.getCurrentPlatform();
        switch (OiixPlatform.getPlatGroup(curPlatId)) {
            case -1: {
                permissions = OiixFileOps.getPermission(sSrcFile);
                if (permissions != -1) break;
                int severity = 2;
                String[] vars = new String[1];
                String[] vals = new String[1];
                vars[0] = new String("%1%");
                vals[0] = new String(sSrcFile);
                String exName = "GetFilePermissionException";
                String errString = OiixResourceBundle.getString("GetFilePermissionException_desc");
                String exString = OiixInstantiateString.processString(errString, vars, vals);
                throw new OiilActionException(exName, exString, severity);
            }
        }
        if (oListnr != null) {
            Object[] args = new String[]{sSrcFile};
            String sProgMsg = MessageFormat.format(OiixResourceBundle.getString("S_INSTANTIATEFILE_PROG_MSG"), args);
            oListnr.setStatus(sProgMsg);
        }
        if (bSameFile) {
            destFile = destFile + "_instanTpFl";
        }
        if (!bSameFile && new File(destFile).exists()) {
            try {
                OiixFileOps.backUpFile(destFile, destBackUpFile);
                if (instSession.isCloneMode()) {
                    OiixFileOps.changePermissions(destFile, "0644");
                }
            }
            catch (IOException e) {
                Object[] args = new String[]{destFile};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_CANNOT_BACKUP_TEMPLATE", args));
            }
        }
        this.instantiateTheFile(sSrcFile, destFile, oSearchReplaceMap, sDelimiter);
        if (bSameFile) {
            File fl = new File(sourceFile);
            fl.delete();
            fl = new File(destFile);
            fl.renameTo(new File(sourceFile));
        }
        switch (OiixPlatform.getPlatGroup(curPlatId)) {
            case -1: {
                if (bSameFile) {
                    OiixFileOps.changePermission(sourceFile, permissions);
                    break;
                }
                OiixFileOps.changePermission(destFile, permissions);
                break;
            }
        }
        if (!bSameFile) {
            instSession.registerFile(destFile, compInstall.getCompInstallID());
        }
        if ((selectedNodes = (String[])instSession.getSessionContext().getVarValue("REMOTE_NODES")) != null && selectedNodes.length > 0) {
            OiipgClusterLogger.logCopyFile(destFile);
        }
    }

    public String replaceVarVal(OiisCompContext oContext, String sourceString) {
        int startIdx = sourceString.indexOf("%");
        int endIdx = sourceString.lastIndexOf("%");
        if (startIdx != -1 && endIdx != startIdx) {
            String replaceVar;
            String varVal = replaceVar = sourceString.substring(startIdx + 1, endIdx);
            OiisVariable oVar = oContext.getVariable(replaceVar);
            if (oVar != null) {
                String sVarType = OiisVariable.getTypeString(oVar.getType());
                if (sVarType.equals(OiisDataTypes.STRING.getName())) {
                    varVal = (String)oVar.getValue();
                } else if (sVarType.equals(OiisDataTypes.BOOL.getName())) {
                    varVal = ((Boolean)oVar.getValue()).toString();
                }
                String endString = "";
                if (sourceString.length() > endIdx + 1) {
                    endString = sourceString.substring(endIdx + 1);
                }
                return varVal + endString;
            }
        }
        return sourceString;
    }

    private String getFallBackLocation(String srcFile, String sFallBackRoot, OiisCompContext oContext) throws IOException {
        String sOracleHome = (String)oContext.getVariable("ORACLE_HOME").getValue();
        String sFallBackLoc = null;
        if (sOracleHome != null) {
            sOracleHome = OiixPathOps.getStandardForm(sOracleHome);
            if ((srcFile = OiixPathOps.getStandardForm(srcFile)).startsWith(sOracleHome)) {
                srcFile = srcFile.substring(sOracleHome.length());
                sFallBackLoc = OiixPathOps.concatPath(sFallBackRoot, srcFile);
                return sFallBackLoc;
            }
        }
        Object[] sArgs = new String[]{srcFile};
        throw new IOException(OiixResourceBundle.getString("S_SOURCE_NOT_IN_ORACLE_HOME", sArgs));
    }

    private String getTemplatesLocation(String srcFile, OiisCompContext oContext, int ohIndex) throws IOException {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        return this.getFallBackLocation(srcFile, iac.getTemplatesLoc(ohIndex), oContext);
    }

    private boolean isVarInList(String[] list, String varName) {
        for (int i = 0; i < list.length; ++i) {
            if (!varName.equalsIgnoreCase(list[i])) continue;
            return true;
        }
        return false;
    }

    private String getValueAsString(Object value) {
        String val = "";
        if (value != null) {
            if (value instanceof String[]) {
                val = OiixFunctionOps.implodeList((String[])value, ",");
            } else if (value instanceof String) {
                val = (String)value;
            } else if (value instanceof Number) {
                val = ((Number)value).toString();
            } else if (value instanceof Boolean) {
                val = ((Boolean)value).toString();
            }
        }
        return val;
    }

    private HashMap getSearchReplaceMap(OiisCompInstallation compInstall, String[] varNameList, String sDelimiter) {
        String sValue;
        Object value;
        String name;
        Vector vars = compInstall.getContext().getInstantiableVariables();
        OiisCompConstants constants = compInstall.getContext().getCompConstants();
        int constSize = 0;
        if (constants != null) {
            constSize = constants.size();
        }
        HashMap<String, String> oSearchReplaceMap = new HashMap<String, String>();
        boolean i = false;
        if (varNameList != null) {
            varNameList = this.normalizeVarNameList(varNameList);
        }
        Enumeration var = vars.elements();
        while (var.hasMoreElements()) {
            OiisVariable theVar = (OiisVariable)var.nextElement();
            name = theVar.getName();
            if (varNameList != null && !this.isVarInList(varNameList, name)) continue;
            value = theVar.getValue();
            sValue = this.getValueAsString(value);
            oSearchReplaceMap.put(this.createKey(sDelimiter + name + sDelimiter), sValue);
        }
        if (constants != null) {
            Enumeration constList = constants.getAllConstants();
            while (constList.hasMoreElements()) {
                OiisGenericConstant theConst = (OiisGenericConstant)constList.nextElement();
                name = theConst.getName();
                if (varNameList != null && !this.isVarInList(varNameList, name)) continue;
                value = theConst.getValue();
                sValue = this.getValueAsString(value);
                oSearchReplaceMap.put(this.createKey(sDelimiter + name + sDelimiter), sValue);
            }
        }
        return oSearchReplaceMap;
    }

    public static boolean backupTemplate(String sourceFile, OiisCompInstallation compInstall, OiicPullSession instSession, boolean createIfSourceDoesNotExist) {
        try {
            OiiiCompInstallID cid;
            if (instSession.isCloneMode()) {
                return false;
            }
            String sFallBackSrc = OiixInstantiateOps.getTemplatesLocationHelper(sourceFile, compInstall.getContext(), instSession.getOHIndex());
            File fFallBackSrc = new File(sFallBackSrc);
            Map backedupTemplates = instSession.getBackedupTemplates();
            if (fFallBackSrc.exists() && (cid = (OiiiCompInstallID)backedupTemplates.get(fFallBackSrc)) != null) {
                if (cid instanceof OiiiPatchInstallID) {
                    return false;
                }
                if (cid instanceof OiiiCompInstallID && !(compInstall instanceof OiisPatchInstallation)) {
                    return false;
                }
            }
            if (!new File(sourceFile).exists() && createIfSourceDoesNotExist) {
                String sFile = OiixPathOps.getStandardForm(sourceFile);
                String sParentDir = OiixPathOps.getParentDir(sFile);
                OiixFileOps.createDirForDest(sParentDir);
                new File(sourceFile).createNewFile();
            }
            OiixFileOps.copyFile(sourceFile, sFallBackSrc, true, true);
            backedupTemplates.put(fFallBackSrc, compInstall.getCompInstallID());
            return true;
        }
        catch (Exception e) {
            Object[] args = new String[]{sourceFile};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_CANNOT_BACKUP_TEMPLATE", args));
            return false;
        }
    }

    private static String getTemplatesLocationHelper(String srcFile, OiisCompContext oContext, int ohIndex) throws IOException {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sFallBackRoot = iac.getTemplatesLoc(ohIndex);
        String sOracleHome = (String)oContext.getVariable("ORACLE_HOME").getValue();
        String sFallBackLoc = null;
        if (sOracleHome != null) {
            sOracleHome = OiixPathOps.getCanonicalPath(sOracleHome);
            if ((srcFile = OiixPathOps.getCanonicalPath(srcFile)).startsWith(sOracleHome)) {
                srcFile = srcFile.substring(sOracleHome.length());
                sFallBackLoc = OiixPathOps.concatPath(sFallBackRoot, srcFile);
                return sFallBackLoc;
            }
        }
        Object[] sArgs = new String[]{srcFile};
        throw new IOException(OiixResourceBundle.getString("S_SOURCE_NOT_IN_ORACLE_HOME", sArgs));
    }

    public static String getLocalCopy(String fileName) throws IOException {
        String stdFn = OiixPathOps.getStandardForm(fileName);
        String srcLoc = OiixPathOps.getParentDir(stdFn);
        String srcOff = OiixPathOps.getFileName(stdFn);
        String sTempLoc = System.getProperty("oracle.installer.scratchPath");
        OiiofFileLoader fileLoader = OiiofFileLoaderFactory.createFileLoader(srcLoc, sTempLoc);
        try {
            fileName = fileLoader.getLocalCopy(srcOff);
        }
        catch (OiifbCancelException ie) {
            throw new IOException(ie.getMessage());
        }
        return fileName;
    }

    private String createKey(String str) {
        return str.toLowerCase();
    }

    private String[] normalizeVarNameList(String[] varList) {
        if (varList == null) {
            return null;
        }
        String[] normalizedVarList = new String[varList.length];
        for (int j = 0; j < varList.length; ++j) {
            normalizedVarList[j] = varList[j] != null ? varList[j].trim() : "";
        }
        return normalizedVarList;
    }

    public void deInstantiate(OiisInstantiateInfo input, OiicInstallTimeSession instSession, OiisCompContext oContext, OiiiCompIdOhPair deinstallIdOh) throws OiilDeinstallException {
        if (Boolean.getBoolean("oracle.installer.removeallfiles")) {
            return;
        }
        String sourceFile = input.getSource();
        String destFile = input.getDest();
        String sCond = input.getCondVar();
        if (destFile.lastIndexOf(47) == destFile.length() - 1) {
            String fileName = sourceFile.substring(sourceFile.lastIndexOf(47) + 1);
            destFile = destFile + fileName;
        }
        destFile = destFile.replace('/', File.separatorChar);
        if ((sCond = this.replaceVarVal(oContext, sCond)).equalsIgnoreCase("false")) {
            return;
        }
        this.toLog(input);
        destFile = this.replaceVarVal(oContext, destFile);
        String[] selectedNodes = (String[])instSession.getSessionContext().getVarValue("REMOTE_NODES");
        File fileObj = new File(destFile);
        if (fileObj.exists() && !fileObj.delete()) {
            int severity = 2;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(destFile);
            String exName = "FileDeleteException";
            String errString = OiixResourceBundle.getString("FileDeleteException_desc");
            String exString = OiixInstantiateString.processString(errString, variables, values);
            throw new OiilDeinstallException(exName, exString, severity);
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        String sHomePath = null;
        sHomePath = deinstallIdOh.getCompID().isNOHComp() ? iac.getAreaRoot() : instInv.getHomeLocation(deinstallIdOh.getOHIndex());
        iac.deregisterFile(sHomePath, destFile, deinstallIdOh.getCompID());
        boolean bCluster = false;
        if (selectedNodes != null && selectedNodes.length > 0) {
            bCluster = true;
        }
        OiixInstantiateOps.deleteFile(null, destFile, bCluster);
        if (bCluster) {
            OiipgClusterLogger.logRmfileCommands(destFile);
        }
    }

    public void toLog(OiisInstantiateInfo input) {
        StringBuffer sb = new StringBuffer();
        sb.append(OiixResourceBundle.getString("S_CALLING"));
        sb.append(OiixResourceBundle.getString("S_ACTION"));
        sb.append("  ");
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "DATA_DRIVEN_INSTANTIATE_ACTION"));
        sb.append(OiiolTextLogger.getLogLevelStr(OiiolTextLogger.LOG_BASIC));
        sb.append("\t");
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "SOURCE_FILE_GLOBAL_INSTANTIATE"));
        sb.append(" = ");
        sb.append(input.getSource());
        sb.append(OiiolTextLogger.getLogLevelStr(OiiolTextLogger.LOG_BASIC));
        sb.append("\t");
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "DESTINATION_FILE_GLOBAL_INSTANTIATE"));
        sb.append(" = ");
        sb.append(input.getDest());
        sb.append(OiiolTextLogger.getLogLevelStr(OiiolTextLogger.LOG_BASIC));
        sb.append("\t");
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "DELIMITER_GLOBAL_INSTALTIATE"));
        sb.append(" = ");
        sb.append(input.getDelimiter());
        sb.append(OiiolTextLogger.getLogLevelStr(OiiolTextLogger.LOG_BASIC));
        sb.append("\t");
        sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "VARIABLES_GLOBAL_INSTANTIATE"));
        sb.append(" = ");
        sb.append("{");
        ArrayList vars = input.getVarsToReplace();
        for (int j = 0; j < vars.size(); ++j) {
            sb.append(vars.get(j) + " ");
        }
        sb.append("}");
        sb.append(OiiolTextLogger.NEW_LINE);
        OiiolTextLogger.appendText(sb.toString(), OiiolTextLogger.LOG_BASIC);
    }

    private void instantiateTheFile(String sourceFile, String destFile, HashMap oSearchReplaceMap, String sDelimiter) throws OiilActionException {
        try {
            String input;
            BufferedReader bis = new BufferedReader(new FileReader(sourceFile));
            PrintWriter pos = new PrintWriter(new BufferedWriter(new FileWriter(destFile)));
            while ((input = bis.readLine()) != null) {
                String processedString = OiixInstantiateOps.processString(input, oSearchReplaceMap, sDelimiter);
                pos.write(processedString);
                pos.println();
            }
            bis.close();
            pos.close();
        }
        catch (FileNotFoundException f) {
            int severity = 2;
            String[] vars = new String[1];
            String[] vals = new String[1];
            vars[0] = new String("%1%");
            vals[0] = new String(f.getMessage());
            String exName = "FileNotFoundException";
            String errString = OiixResourceBundle.getString("FileNotFoundException_desc");
            String exString = OiixInstantiateString.processString(errString, vars, vals);
            throw new OiilActionException(exName, exString, severity);
        }
        catch (IOException ex) {
            int severity = 2;
            String[] vars = new String[2];
            String[] vals = new String[2];
            vars[0] = new String("%1%");
            vals[0] = new String(sourceFile);
            vars[1] = new String("%2%");
            vals[1] = new String(destFile);
            String exName = "IOException";
            String errString = OiixResourceBundle.getString("IOException_desc");
            String exString = OiixInstantiateString.processString(errString, vars, vals);
            throw new OiilActionException(exName, exString, severity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String processString(String input, HashMap oSearchReplaceMap, String sDelimiter) {
        String returnStr = input;
        if (input.indexOf(sDelimiter) != -1) {
            Iterator iter = oSearchReplaceMap.keySet().iterator();
            while (iter.hasNext()) {
                String sVarName = (String)iter.next();
                String spattern = "(?i)(?<!" + sDelimiter + ")" + sVarName;
                String varVal = (String)oSearchReplaceMap.get(sVarName);
                varVal = varVal.replaceAll("\\\\", "\\\\\\\\");
                returnStr = returnStr.replaceAll(spattern, varVal);
            }
            returnStr = returnStr.replaceAll(sDelimiter + sDelimiter, sDelimiter);
        }
        return returnStr;
    }

    public static String createDirForDest(String filename) throws IOException {
        File parentdir;
        File f = new File(filename);
        String str = f.getParent();
        while (str != null && !(parentdir = new File(str)).exists()) {
            str = parentdir.getParent();
        }
        String parentFile = f.getParent();
        if (parentFile != null) {
            File ff = new File(parentFile);
            OiixFileOps.mkdirs(ff);
        }
        return str;
    }

    private static void deleteFile(String alreadyExisted, String fileName, boolean bCluster) {
        File parentdir;
        String[] listofFiles;
        File f = new File(fileName);
        String str = f.getParent();
        while (!(str == null && str.equals(alreadyExisted) || (listofFiles = (parentdir = new File(str)).list()).length != 0)) {
            if (parentdir.delete() && bCluster) {
                OiipgClusterLogger.logRmdirCommands(str);
            }
            str = parentdir.getParent();
        }
    }

    public static void saveInstantiates(String FileLoc, ArrayList listInst) {
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        try {
            OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(FileLoc)));
            FileWriter fWriter = new FileWriter(FileLoc);
            BufferedWriter bWriter = new BufferedWriter(fWriter);
            PrintWriter pWriter = new PrintWriter(bWriter);
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
            XMLElement elemInstList = new XMLElement("INSTANTIATE_LIST");
            OiiiCompInstallID prevId = null;
            XMLElement elemComp = null;
            for (int idx = 0; idx < listInst.size(); ++idx) {
                ArrayList vars;
                String sDelim;
                int actionType;
                OiisInstantiateInfo info = (OiisInstantiateInfo)listInst.get(idx);
                OiiiCompInstallID id = info.getCompInstallId();
                if (prevId == null || !id.equals(prevId)) {
                    prevId = id;
                    elemComp = new XMLElement("COMPONENT");
                    elemComp.setAttribute("NAME", id.getName());
                    elemComp.setAttribute("VERSION", id.getVersion().getVerString());
                    elemComp.setAttribute("PLATFORMS", OiilXMLHelper.platVect2String(id.getPlatforms(), " "));
                    elemInstList.appendChild((Node)elemComp);
                }
                XMLElement elemInst = new XMLElement("INSTANTIATE");
                String condVar = info.getCondVar();
                if (condVar != null && !condVar.equals("")) {
                    elemInst.setAttribute("CONDITION", condVar);
                }
                if ((actionType = info.getActionType()) != 2) {
                    if (actionType == 0) {
                        elemInst.setAttribute("ACTIONTYPE", "INSTALL");
                    } else if (actionType == 1) {
                        elemInst.setAttribute("ACTIONTYPE", "DEINSTALL");
                    } else {
                        elemInst.setAttribute("ACTIONTYPE", "NONE");
                    }
                }
                XMLElement elemSource = new XMLElement("SOURCE");
                elemSource.setAttribute("FILENAME", info.getSource());
                elemInst.appendChild((Node)elemSource);
                String sDest = info.getDest();
                if (sDest != null && !sDest.equals("")) {
                    XMLElement elemDest = new XMLElement("DESTINATION");
                    elemDest.setAttribute("FILENAME", sDest);
                    elemInst.appendChild((Node)elemDest);
                }
                if ((sDelim = info.getDelimiter()) != null && !sDelim.equals("")) {
                    XMLElement elemDelim = new XMLElement("DELIMITER");
                    elemDelim.setAttribute("SPECIALCHAR", sDelim);
                    elemInst.appendChild((Node)elemDelim);
                }
                if ((vars = info.getVarsToReplace()) != null && !vars.isEmpty()) {
                    XMLElement elemRepl = new XMLElement("REPLACE_VARS");
                    for (int i = 0; i < vars.size(); ++i) {
                        XMLElement elemVar = new XMLElement("VARIABLE");
                        elemVar.setAttribute("NAME", (String)vars.get(i));
                        elemRepl.appendChild((Node)elemVar);
                    }
                    elemInst.appendChild((Node)elemRepl);
                }
                elemComp.appendChild((Node)elemInst);
            }
            elemInstList.print(pWriter);
            pWriter.close();
            bWriter.close();
            fWriter.close();
        }
        catch (IOException io) {
            OiiolTextLogger.appendText("Error in writing" + FileLoc, 0);
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("XML Writer, Writing Global Instantiates ", System.currentTimeMillis() - lTime);
        }
    }

    private class InputDialog
    implements Runnable {
        private String m_sInput;
        private Frame m_oFrame = ((OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager()).getMainFrame();
        private String m_sType;
        private String m_sDesc;

        public InputDialog(String sType, String sDesc) {
            this.m_sType = sType;
            this.m_sDesc = sDesc;
        }

        public void run() {
            OiifdDeinstallPromptDlg oDlg = new OiifdDeinstallPromptDlg(this.m_oFrame, this.m_sType, this.m_sDesc);
            int nRet = oDlg.runDialog();
            this.m_sInput = nRet == 1 ? oDlg.getTextValue() : "";
        }

        public String getUserInput() {
            return this.m_sInput;
        }
    }
}

