/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixManifest;
import oracle.sysman.oii.oiix.OiixOptimizer;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixJarClassLoader
extends ClassLoader {
    private String m_jarLoc;
    private ZipFile m_jarFile;
    private boolean m_bKeepOpen;
    private Vector m_jarEntries = new Vector();
    private Hashtable m_classCache = new Hashtable();
    private Hashtable m_resourceCache = new Hashtable();
    private Vector m_vExtractedClasses = null;
    private static Hashtable s_loaders;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x1000000;
    private static boolean s_bEnableMultipleLoad;

    protected OiixJarClassLoader(String jarLoc, boolean bkeepOpen) throws IOException {
        this.m_jarLoc = OiixPathOps.getCanonicalPath(jarLoc);
        OiixJarClassLoader loader = (OiixJarClassLoader)s_loaders.get(this.m_jarLoc);
        if (loader != null) {
            OiixJarClassLoader.forgetLoader(this.m_jarLoc);
        }
        s_loaders.put(this.m_jarLoc, this);
        this.m_bKeepOpen = bkeepOpen;
        this.updateEntriesList();
    }

    protected OiixJarClassLoader(String jarLoc) throws IOException {
        this(jarLoc, false);
    }

    public static void setEnableMultipleLoading(boolean bEnable) {
        s_bEnableMultipleLoad = bEnable;
    }

    public void updateEntriesList() throws IOException {
        this.m_jarEntries.removeAllElements();
        this.m_classCache.clear();
        this.m_resourceCache.clear();
        this.closeJarFile();
        String m_jarFileName = OiixPathOps.getNativeForm(this.m_jarLoc);
        try {
            this.m_jarFile = new ZipFile(m_jarFileName);
            Enumeration<? extends ZipEntry> enum_1 = this.m_jarFile.entries();
            while (enum_1.hasMoreElements()) {
                ZipEntry ze = enum_1.nextElement();
                this.m_jarEntries.addElement(ze.getName());
            }
            if (!this.m_bKeepOpen) {
                this.closeJarFile();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void closeJarFile() {
        if (this.m_jarFile != null) {
            try {
                this.m_jarFile.close();
                this.m_jarFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateEntriesList(String jarLoc) throws IOException {
        OiixJarClassLoader jcl = OiixJarClassLoader.getLoader(jarLoc);
        jcl.updateEntriesList();
    }

    public static OiixJarClassLoader getLoader(String jarLoc) {
        try {
            String canJarLoc = OiixPathOps.getCanonicalPath(jarLoc);
            return (OiixJarClassLoader)s_loaders.get(canJarLoc);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static void clearLoaderList() {
        Enumeration e = s_loaders.elements();
        while (e.hasMoreElements()) {
            OiixJarClassLoader loader = (OiixJarClassLoader)e.nextElement();
            loader.closeJarFile();
        }
        s_loaders.clear();
    }

    public static void forgetLoader(String jarLoc) {
        try {
            String canJarLoc = OiixPathOps.getCanonicalPath(jarLoc);
            OiixJarClassLoader loader = OiixJarClassLoader.getLoader(jarLoc);
            if (loader != null) {
                loader.closeJarFile();
                s_loaders.remove(canJarLoc);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static OiixJarClassLoader newClassLoader(String jarLoc) throws IOException {
        return new OiixJarClassLoader(jarLoc);
    }

    public static OiixJarClassLoader createLoader(String jarLoc, boolean cacheJar, boolean bkeepOpen) throws IOException {
        OiixJarClassLoader ret = null;
        if (cacheJar) {
            ret = OiixJarClassLoader.getLoader(jarLoc);
        }
        if (ret == null) {
            ret = new OiixJarClassLoader(jarLoc, bkeepOpen);
        }
        return ret;
    }

    public static OiixJarClassLoader createLoader(String jarLoc, boolean cacheJar) throws IOException {
        return OiixJarClassLoader.createLoader(jarLoc, cacheJar, false);
    }

    public static OiixJarClassLoader createLoader(String jarLoc) throws IOException {
        return OiixJarClassLoader.createLoader(jarLoc, false);
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        Class c = null;
        ClassNotFoundException ex = null;
        if (s_loaders != null) {
            Iterator iter = s_loaders.values().iterator();
            while (iter.hasNext()) {
                OiixJarClassLoader jcl = (OiixJarClassLoader)iter.next();
                try {
                    c = jcl.loadClassCurrent(name, true);
                    if (c == null) continue;
                    return c;
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
            }
        } else {
            c = Class.forName(name);
        }
        if (c == null && ex != null) {
            throw ex;
        }
        return c;
    }

    private synchronized Class loadClassCurrent(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.m_classCache.get(name);
        if (c == null) {
            byte[] data;
            if (OiixJarClassLoader.coreJavaClassName(name) || this.isExtractedClass(name)) {
                try {
                    c = this.findSystemClass(name);
                }
                catch (ClassNotFoundException ce) {
                    c = null;
                }
            }
            if (c == null && (data = this.loadClassData(name)) != null) {
                c = this.defineClass(name, data, 0, data.length);
                if (resolve) {
                    this.resolveClass(c);
                }
                this.m_classCache.put(name, c);
            }
            if (c == null) {
                try {
                    if (!OiixJarClassLoader.localResourceClassName(name)) {
                        c = this.findSystemClass(name);
                    }
                }
                catch (ClassNotFoundException ce) {
                    c = null;
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c;
        try {
            c = this.loadClassCurrent(name, resolve);
        }
        catch (ClassNotFoundException ce) {
            c = null;
        }
        if (s_bEnableMultipleLoad && c == null) {
            try {
                c = OiixJarClassLoader.getClass(name);
            }
            catch (ClassNotFoundException ce) {
                c = null;
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    private boolean isExtractedClass(String sClass) {
        return this.m_vExtractedClasses != null && this.m_vExtractedClasses.contains(sClass);
    }

    private static boolean coreJavaClassName(String sClass) {
        boolean bCore = false;
        if (sClass.startsWith("java.")) {
            bCore = true;
        }
        return bCore;
    }

    private static boolean localResourceClassName(String name) {
        return name.startsWith("Components") || name.startsWith("libRes") || name.startsWith("oracle.sysman.oii.oiix.OiixBaseResourceBundle");
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    public void extractClass(String className, String destFile) {
        try {
            this.extractClass(className, destFile, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void extractClass(String className, String destFile, boolean throwException) throws IOException, OiifbCancelException {
        block6: {
            byte[] data = null;
            try {
                FileOutputStream fos = new FileOutputStream(destFile);
                data = this.loadClassData(className);
                if (data != null) {
                    OiixFileOps.validateDiskSpace(data.length, destFile);
                }
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                OiixFileOps.writeStream(bos, data, data.length, destFile);
                if (this.m_vExtractedClasses == null) {
                    this.m_vExtractedClasses = new Vector(5);
                }
                this.m_vExtractedClasses.addElement(className);
                bos.close();
                fos.close();
            }
            catch (IOException ex) {
                if (throwException) {
                    throw ex;
                }
            }
            catch (OiifbCancelException ex) {
                if (!throwException) break block6;
                throw ex;
            }
        }
    }

    public void extractFile(String entryName, String destFile) {
        try {
            this.extractFile(entryName, destFile, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void extractFile(String entryName, String destFile, boolean throwException) throws IOException, OiifbCancelException {
        block5: {
            byte[] data = null;
            try {
                data = this.getEntryBuf(entryName);
                if (data == null) {
                    Object[] obj = new String[]{entryName, this.m_jarLoc};
                    String sMsg = MessageFormat.format(OiixResourceBundle.getString("S_FNF_IN_JAR"), obj);
                    throw new IOException(sMsg);
                }
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                OiixFileOps.writeStream(bos, data, data.length, destFile);
                bos.close();
                fos.close();
            }
            catch (IOException ex) {
                File f;
                if (throwException && (!(f = new File(destFile)).exists() || f.length() == 0L)) {
                    throw ex;
                }
            }
            catch (OiifbCancelException ex) {
                if (!throwException) break block5;
                throw ex;
            }
        }
    }

    public boolean entryExists(String entryName) {
        return this.m_jarEntries.contains(entryName);
    }

    public boolean directoryExists(String dirName) {
        for (int i = 0; i < this.m_jarEntries.size(); ++i) {
            String sCurrentEntry = (String)this.m_jarEntries.elementAt(i);
            if (!sCurrentEntry.startsWith(dirName)) continue;
            return true;
        }
        return false;
    }

    private byte[] loadClassData(String name) {
        String entryName = name.replace('.', '/') + ".class";
        if (this.entryExists(entryName)) {
            return this.getEntryBuf(entryName);
        }
        return null;
    }

    public OiixManifest getManifest() {
        if (this.entryExists("META-INF/MANIFEST.MF")) {
            try {
                ZipFile zf = this.m_jarFile;
                if (!this.m_bKeepOpen) {
                    zf = new ZipFile(this.m_jarLoc);
                }
                ZipEntry ze = zf.getEntry("META-INF/MANIFEST.MF");
                InputStream is = zf.getInputStream(ze);
                OiixManifest mf = new OiixManifest(is);
                is.close();
                if (!this.m_bKeepOpen) {
                    zf.close();
                }
                return mf;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected byte[] getEntryBuf(String entryName) {
        byte[] buf = null;
        try {
            buf = this.getEntryBufImpl(this.m_jarLoc, entryName);
        }
        catch (IOException e) {
            return null;
        }
        return buf;
    }

    protected synchronized byte[] getEntryBufImpl(String jarLoc, String entryName) throws IOException {
        ZipEntry ze;
        byte[] buf = null;
        if (this.m_jarFile == null) {
            this.m_jarFile = new ZipFile(OiixPathOps.getNativeForm(this.m_jarLoc));
        }
        ZipFile zf = this.m_jarFile;
        if (!this.m_bKeepOpen) {
            zf = new ZipFile(this.m_jarLoc);
        }
        if ((ze = zf.getEntry(entryName)) != null) {
            int size = (int)ze.getSize();
            buf = new byte[size];
            InputStream is = zf.getInputStream(ze);
            int BUFSIZ = OiixOptimizer.getBufLen(is.available());
            BufferedInputStream bis = new BufferedInputStream(is, BUFSIZ);
            int readcount = 0;
            byte[] tempbuf = new byte[BUFSIZ];
            try {
                int bytesRead;
                while ((bytesRead = bis.read(tempbuf, 0, BUFSIZ)) != -1) {
                    System.arraycopy(tempbuf, 0, buf, readcount, bytesRead);
                    readcount += bytesRead;
                }
            }
            catch (EOFException ee) {
                // empty catch block
            }
            bis.close();
            is.close();
            if (readcount != size) {
                buf = null;
            }
        }
        if (!this.m_bKeepOpen) {
            zf.close();
        }
        return buf;
    }

    public static InputStream getLocalResourceAsStream(String jarLoc, String name) {
        OiixJarClassLoader loader = OiixJarClassLoader.getLoader(jarLoc);
        if (loader != null) {
            return loader.getLocalResourceAsStream(name);
        }
        return null;
    }

    public static Object getLocalResource(String jarLoc, String name) {
        OiixJarClassLoader loader = OiixJarClassLoader.getLoader(jarLoc);
        if (loader != null) {
            return loader.getLocalResource(name);
        }
        return null;
    }

    private Object getLocalResource(String name) {
        if (this.entryExists(name)) {
            byte[] buf = this.getResourceBuf(name);
            ByteArrayInputStream is = new ByteArrayInputStream(buf);
            return is;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream back = OiixJarClassLoader.getSystemResourceAsStream(name);
        if (back != null) {
            return back;
        }
        return this.getLocalResourceAsStream(name);
    }

    public URL getResource(String name) {
        URL back = OiixJarClassLoader.getSystemResource(name);
        if (back != null) {
            return back;
        }
        return this.getLocalResourceURL(name);
    }

    public URL getLocalResourceURL(String name) {
        if (this.entryExists(name)) {
            try {
                URL url = new URL("oiix", null, this.m_jarLoc + "/+/" + name);
                return url;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public InputStream getLocalResourceAsStream(String name) {
        boolean bEntryFound = this.entryExists(name);
        if (!bEntryFound) {
            name = name.replace('\\', '/');
            bEntryFound = this.entryExists(name);
        }
        if (!bEntryFound) {
            name = name.replace('/', '\\');
            bEntryFound = this.entryExists(name);
        }
        if (bEntryFound) {
            byte[] buf = this.getResourceBuf(name);
            if (buf == null) {
                return null;
            }
            return new ByteArrayInputStream(buf);
        }
        return null;
    }

    private byte[] getResourceBuf(String name) {
        byte[] buf = (byte[])this.m_resourceCache.get(name);
        if (buf == null && (buf = this.getEntryBuf(name)) != null) {
            this.m_resourceCache.put(name, buf);
        }
        return buf;
    }

    public void extractDir(String dirName, String dest) throws IOException {
        this.extractDir(dirName, dest, true);
    }

    public void extractDir(String dirName, String dest, boolean bPreserve) throws IOException {
        File destDir;
        if (this.m_jarFile == null) {
            this.m_jarFile = new ZipFile(OiixPathOps.getNativeForm(this.m_jarLoc));
        }
        ZipFile zf = this.m_jarFile;
        if (!this.m_bKeepOpen) {
            zf = new ZipFile(this.m_jarLoc);
        }
        if (!(destDir = new File(dest)).exists()) {
            OiixFileOps.mkdirs(destDir);
        }
        Enumeration entries = this.m_jarEntries.elements();
        while (entries.hasMoreElements()) {
            String fname = (String)entries.nextElement();
            String sEntryName = OiixPathOps.getStandardForm(fname);
            if (dirName != null && !sEntryName.startsWith(dirName)) continue;
            ZipEntry ze = zf.getEntry(fname);
            if (ze.isDirectory()) {
                File dir;
                if (!bPreserve || (dir = new File(OiixPathOps.concatPath(dest, fname))).exists()) continue;
                OiixFileOps.mkdirs(dir);
                continue;
            }
            String sDestName = OiixPathOps.getFileName(sEntryName);
            String parentS = OiixPathOps.getParentDir(sEntryName);
            if (parentS != null && bPreserve) {
                String parentPath = OiixPathOps.getNativeForm(OiixPathOps.concatPath(dest, parentS));
                File parent = new File(parentPath);
                if (!parent.exists()) {
                    OiixFileOps.mkdirs(parent);
                }
                sDestName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(dest, sEntryName));
            } else {
                sDestName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(dest, sDestName));
            }
            this.extractFile(fname, sDestName);
        }
        if (!this.m_bKeepOpen) {
            zf.close();
        }
    }

    public void extractJar(String dest) throws IOException {
        this.extractDir(null, dest);
    }

    static {
        Properties systemProps = System.getProperties();
        String curProtPkgs = systemProps.getProperty("java.protocol.handler.pkgs", "");
        systemProps.put("java.protocol.handler.pkgs", curProtPkgs + "|" + "oracle.sysman.oii");
        System.setProperties(systemProps);
        s_loaders = new Hashtable();
        s_bEnableMultipleLoad = false;
    }
}

