/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarModifyException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixJarModifier {
    private Hashtable m_zipEntryHash;
    private String m_sModJarLoc;
    private String m_sModJarBakLoc;
    private String m_sTargetJarLoc;
    private FileOutputStream m_fos;
    private ZipOutputStream m_zos;
    private int m_iInserts = 0;
    private int m_iRemovals = 0;
    private boolean m_bFileExists;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x1000000;
    public static final int MAX_SUGGESTED_ENTRIES = 2000;
    public static final String DIR_ENTRY_COMMENT = "EMPTY_DIR";
    private int m_iJarState = 0;
    public static final int NONE = 0;
    public static final int OPEN = 1;
    public static final int COMMIT = 2;
    public static final int ROLLBACK = 3;
    public static final int CLEANUP = 4;
    public static final int REVERT = 5;
    private static final String S_OLD = "old";
    public static final boolean CREATE_BACKUP = true;
    public static final boolean CREATE_NO_BACKUP = false;
    private int m_iEntryCount = 0;
    private boolean m_bBackupCreated = false;
    private boolean m_bCreateBackup = false;
    private boolean m_bCopyAsText = false;
    private String m_sLineSeparator = System.getProperty("line.separator");
    private static int s_zipLevel = -1;
    private static final int BUFF_SIZE = 32768;
    private static final int MIN_BUFF_SIZE = 128;

    public OiixJarModifier(String modJarLoc) {
        this(modJarLoc, false, false);
    }

    public OiixJarModifier(String modJarLoc, boolean bNativeForm) {
        this(modJarLoc, bNativeForm, false);
    }

    public OiixJarModifier(String modJarLoc, boolean bNativeForm, boolean bCreateBackup) {
        if (bNativeForm) {
            this.m_sModJarLoc = modJarLoc;
        } else {
            try {
                this.m_sModJarLoc = OiixPathOps.getNativeForm(OiixPathOps.getCanonicalPath(modJarLoc));
            }
            catch (IOException ie) {
                this.m_sModJarLoc = modJarLoc;
            }
        }
        this.initialize();
        this.m_iJarState = 0;
        this.m_bCreateBackup = bCreateBackup;
    }

    private void initialize() {
        this.m_sModJarBakLoc = this.m_sModJarLoc + ".bak";
        this.m_sTargetJarLoc = this.m_sModJarLoc + ".new";
        this.m_zipEntryHash = null;
        this.m_zos = null;
        this.m_iEntryCount = 0;
        this.m_iInserts = 0;
        this.m_iRemovals = 0;
    }

    synchronized int getState() {
        return this.m_iJarState;
    }

    public void setState(int iState) throws IOException, OiifbCancelException {
        if (iState != this.m_iJarState) {
            switch (iState) {
                case 1: {
                    this.startModify();
                    break;
                }
                case 2: {
                    this.endModify();
                    break;
                }
                case 3: {
                    this.cancelModify();
                    break;
                }
                case 4: {
                    this.cleanup();
                    break;
                }
                case 5: {
                    this.revert();
                }
            }
        }
    }

    private synchronized void startModify() throws IOException {
        if (this.m_iJarState != 1) {
            this.initialize();
            this.m_zipEntryHash = new Hashtable();
            this.m_iRemovals = 0;
            this.m_iInserts = 0;
            this.m_bFileExists = false;
            File modJarFile = new File(this.m_sModJarLoc);
            if (modJarFile.exists()) {
                this.m_bFileExists = true;
                ZipFile ozf = new ZipFile(this.m_sModJarLoc);
                Enumeration<? extends ZipEntry> en = ozf.entries();
                while (en.hasMoreElements()) {
                    ZipEntry ze = en.nextElement();
                    this.m_zipEntryHash.put(ze.getName(), S_OLD);
                    ++this.m_iEntryCount;
                }
                ozf.close();
            } else {
                this.m_sTargetJarLoc = this.m_sModJarLoc;
            }
            this.m_fos = new FileOutputStream(this.m_sTargetJarLoc);
            this.m_zos = new ZipOutputStream(this.m_fos);
            this.m_zos.setLevel(s_zipLevel);
            this.m_iJarState = 1;
        }
    }

    public boolean contains(String sEntryName) {
        if (this.m_zipEntryHash != null && sEntryName != null) {
            return this.m_zipEntryHash.containsKey(sEntryName);
        }
        return false;
    }

    public String getJarName() {
        return this.m_sModJarLoc;
    }

    private void closeOutputStreams() throws IOException {
        if (this.m_zos != null) {
            if (this.getEntryCount() > 0) {
                try {
                    this.m_zos.close();
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
            }
            this.m_zos = null;
        }
        if (this.m_fos != null) {
            this.m_fos.close();
            this.m_fos = null;
        }
    }

    public synchronized ZipEntry insertEntryFromStream(InputStream is, String entryName, long modTime) throws IOException, OiifbCancelException, OiixJarModifyException {
        if (this.m_iJarState != 1) {
            throw new OiixJarModifyException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOT_IN_MODIFY_SESSION"));
        }
        String status = (String)this.m_zipEntryHash.get(entryName);
        if (status != null && !status.equals(S_OLD)) {
            Object[] objs = new String[]{entryName, status};
            String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ENTRY_ALREADY_WRITTEN");
            throw new OiixJarModifyException(MessageFormat.format(msg, objs));
        }
        entryName = OiixPathOps.getStandardForm(entryName);
        ZipEntry ze = new ZipEntry(entryName);
        ze.setMethod(8);
        ze.setTime(modTime);
        this.m_zipEntryHash.put(entryName, "InputStream");
        if (is == null) {
            this.m_zos.putNextEntry(ze);
            this.m_zos.closeEntry();
            this.m_zos.setComment(DIR_ENTRY_COMMENT);
        } else {
            this.insertZipEntryFromStream(is, this.m_zos, ze);
        }
        if (status != null) {
            ++this.m_iRemovals;
        }
        ++this.m_iInserts;
        return ze;
    }

    public synchronized ZipEntry insertEntryFromStream(InputStream is, String entryName) throws IOException, OiifbCancelException, OiixJarModifyException {
        return this.insertEntryFromStream(is, entryName, new Date().getTime());
    }

    public synchronized ZipEntry insertEntryFromStream(File fileObj, String entryName) throws IOException, OiifbCancelException, OiixJarModifyException {
        FileInputStream fis = fileObj.isDirectory() ? null : new FileInputStream(fileObj);
        ZipEntry ze = this.insertEntryFromStream(fis, entryName, fileObj.lastModified());
        if (fis != null) {
            fis.close();
        }
        return ze;
    }

    public synchronized void insertEntriesFromJar(String inputJar, String entryStart, String curDir, String newDir, boolean immedException, String[] saSuffixesToOmit) throws IOException, OiifbCancelException, OiixJarModifyException {
        StringBuffer exceptStr = new StringBuffer();
        if (this.m_iJarState != 1) {
            throw new OiixJarModifyException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOT_IN_MODIFY_SESSION"));
        }
        if (entryStart.startsWith(curDir)) {
            ZipFile izf = new ZipFile(OiixPathOps.getNativeForm(inputJar));
            Enumeration<? extends ZipEntry> en = izf.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                String oldName = ze.getName();
                if (!oldName.startsWith(entryStart) || this.isOmittedEntry(oldName, saSuffixesToOmit)) continue;
                ZipEntry nze = this.cloneZipEntry(ze, curDir, newDir);
                String newName = nze.getName();
                String status = (String)this.m_zipEntryHash.get(newName);
                if (status != null && (!status.equals(S_OLD) || status.equals(inputJar))) {
                    Object[] objs = new String[]{newName, status};
                    String thisExcept = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ENTRY_ALREADY_WRITTEN");
                    if (immedException) {
                        throw new OiixJarModifyException(MessageFormat.format(thisExcept, objs));
                    }
                    exceptStr.append(MessageFormat.format(thisExcept, objs) + '\n');
                    continue;
                }
                this.m_zipEntryHash.put(newName, inputJar);
                this.insertZipEntry(izf, this.m_zos, ze, nze);
                if (status != null) {
                    ++this.m_iRemovals;
                }
                ++this.m_iInserts;
            }
            izf.close();
            if (!immedException && exceptStr.length() > 0) {
                throw new OiixJarModifyException(exceptStr.toString());
            }
        }
    }

    private boolean isOmittedEntry(String sEntryName, String[] saSuffixesToOmit) {
        boolean retVal = false;
        if (saSuffixesToOmit != null && sEntryName != null) {
            for (int i = 0; i < saSuffixesToOmit.length; ++i) {
                if (saSuffixesToOmit[i] == null || !sEntryName.trim().endsWith(saSuffixesToOmit[i].trim())) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public synchronized void insertEntriesFromJar(String inputJar, String entryStart, String curDir, String newDir, boolean immedException) throws IOException, OiifbCancelException, OiixJarModifyException {
        this.insertEntriesFromJar(inputJar, entryStart, curDir, newDir, immedException, null);
    }

    public synchronized void insertEntriesFromJar(String inputJar, String entryStart, String curDir, String newDir) throws IOException, OiifbCancelException, OiixJarModifyException {
        this.insertEntriesFromJar(inputJar, entryStart, curDir, newDir, false);
    }

    public synchronized void insertEntryFromJar(String inputJar, String entryName, String curDir, String newDir) throws IOException, OiifbCancelException, OiixJarModifyException {
        if (this.m_iJarState != 1) {
            throw new OiixJarModifyException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOT_IN_MODIFY_SESSION"));
        }
        ZipFile izf = new ZipFile(OiixPathOps.getNativeForm(inputJar));
        ZipEntry ze = izf.getEntry(entryName);
        if (entryName.startsWith(curDir) && ze != null) {
            ZipEntry nze = this.cloneZipEntry(ze, curDir, newDir);
            String newName = nze.getName();
            String status = (String)this.m_zipEntryHash.get(newName);
            if (status != null && (!status.equals(S_OLD) || status.equals(inputJar))) {
                Object[] objs = new String[]{newName, status};
                String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ENTRY_ALREADY_WRITTEN");
                throw new OiixJarModifyException(MessageFormat.format(msg, objs));
            }
            this.m_zipEntryHash.put(newName, inputJar);
            this.insertZipEntry(izf, this.m_zos, ze, nze);
            if (status != null) {
                ++this.m_iRemovals;
            }
            ++this.m_iInserts;
        }
        izf.close();
    }

    private ZipEntry cloneZipEntry(ZipEntry ze, String curDir, String newDir) {
        String origName = ze.getName();
        String newName = newDir + origName.substring(curDir.length());
        newName = OiixPathOps.getStandardForm(newName);
        ZipEntry nze = new ZipEntry(newName);
        nze.setComment(ze.getComment());
        nze.setCrc(ze.getCrc());
        nze.setExtra(ze.getExtra());
        nze.setMethod(ze.getMethod());
        nze.setSize(ze.getSize());
        nze.setTime(ze.getTime());
        return nze;
    }

    private void insertZipEntry(ZipFile inputZipFile, ZipOutputStream zos, ZipEntry ze, ZipEntry nze) throws IOException, OiifbCancelException {
        String comm = ze.getComment();
        if (comm != null) {
            zos.setComment(comm);
        }
        zos.setMethod(ze.getMethod());
        nze.setSize(ze.getSize());
        this.insertZipEntryFromStream(inputZipFile.getInputStream(ze), zos, nze);
    }

    private void insertZipEntryFromStream(InputStream is, ZipOutputStream zos, ZipEntry nze) throws IOException, OiifbCancelException {
        zos.putNextEntry(nze);
        int bufferSize = Math.min(32768, is.available());
        if (bufferSize <= 0) {
            bufferSize = 128;
        }
        BufferedOutputStream bos = new BufferedOutputStream(zos, bufferSize);
        if (bufferSize > 0) {
            byte[] buf = new byte[bufferSize];
            BufferedInputStream bis = new BufferedInputStream(is, bufferSize);
            long nZipSize = nze.getSize();
            if (nZipSize != -1L && (long)bufferSize > nZipSize) {
                bufferSize = (int)nZipSize;
            }
            if (!this.m_bCopyAsText) {
                long nTotalBytesRead = 0L;
                int byteRead = 0;
                do {
                    byteRead = -1;
                    try {
                        byteRead = bis.read(buf, 0, bufferSize);
                    }
                    catch (EOFException ie) {
                        // empty catch block
                    }
                    if (byteRead == -1) break;
                    try {
                        bos.write(buf, 0, byteRead);
                    }
                    catch (IOException ioe) {
                        if (!OiipgFileSystem.isSpaceAvailable((long)byteRead + 5120L, this.m_sModJarLoc)) {
                            OiixFileOps.validateDiskSpace(byteRead, this.m_sModJarLoc);
                        }
                        throw ioe;
                    }
                    if (nZipSize == -1L || (nTotalBytesRead += (long)byteRead) + (long)bufferSize <= nZipSize) continue;
                    bufferSize = (int)(nZipSize - nTotalBytesRead);
                } while (byteRead != 0 && byteRead != -1);
            } else {
                BufferedReader br = new BufferedReader(new InputStreamReader(bis));
                PrintStream pr = new PrintStream(bos);
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        pr.print(s);
                        pr.print(this.m_sLineSeparator);
                    }
                }
                catch (EOFException ie) {
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                pr.flush();
            }
        }
        bos.flush();
        zos.closeEntry();
    }

    public synchronized void removeEntries(String entryStart) throws OiixJarModifyException {
        int iDeletions = 0;
        if (this.m_iJarState != 1) {
            throw new OiixJarModifyException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOT_IN_MODIFY_SESSION"));
        }
        Enumeration en = this.m_zipEntryHash.keys();
        while (en.hasMoreElements()) {
            String status;
            Object hEn;
            String enName = (String)en.nextElement();
            if (!enName.startsWith(entryStart) || (hEn = this.m_zipEntryHash.get(enName)) == null || !(status = (String)hEn).equals(S_OLD)) continue;
            ++iDeletions;
            this.m_zipEntryHash.remove(enName);
        }
        this.m_iRemovals += iDeletions;
        if (iDeletions == 0) {
            throw new OiixJarModifyException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOSUCH_ENTRIES"));
        }
    }

    public synchronized Vector getCurrentEntries() {
        Vector<String> retVect = new Vector<String>(this.m_zipEntryHash.size(), 5);
        Enumeration en = this.m_zipEntryHash.keys();
        while (en.hasMoreElements()) {
            String enName = (String)en.nextElement();
            retVect.addElement(enName);
        }
        return retVect;
    }

    public synchronized void removeEntry(String entryName) throws OiixJarModifyException {
        if (this.m_iJarState != 1) {
            throw new OiixJarModifyException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOT_IN_MODIFY_SESSION"));
        }
        String status = (String)this.m_zipEntryHash.get(entryName);
        if (status != null) {
            if (status.equals(S_OLD)) {
                ++this.m_iRemovals;
                this.m_zipEntryHash.remove(entryName);
            }
        } else {
            throw new OiixJarModifyException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NOSUCH_ENTRIES"));
        }
    }

    private synchronized void cancelModify() throws IOException {
        if (this.m_iJarState == 1) {
            this.m_iJarState = 3;
            this.m_iRemovals = 0;
            this.m_iInserts = 0;
            this.closeOutputStreams();
            File oTargetJarFile = new File(this.m_sTargetJarLoc);
            oTargetJarFile.delete();
            this.m_zipEntryHash = null;
            this.m_iJarState = 0;
        }
    }

    private synchronized void endModify() throws IOException, OiifbCancelException {
        if (this.m_iJarState == 1) {
            this.m_iJarState = 2;
            if (this.m_bFileExists) {
                if (this.m_iInserts > 0 || this.m_iRemovals > 0) {
                    ZipFile ozf = new ZipFile(this.m_sModJarLoc);
                    Enumeration<? extends ZipEntry> en = ozf.entries();
                    while (en.hasMoreElements()) {
                        String status;
                        ZipEntry ze = en.nextElement();
                        String enName = ze.getName();
                        Object hEn = this.m_zipEntryHash.get(enName);
                        if (hEn == null || !(status = (String)hEn).equals(S_OLD)) continue;
                        ZipEntry nze = this.cloneZipEntry(ze, enName, enName);
                        this.insertZipEntry(ozf, this.m_zos, ze, nze);
                    }
                    ozf.close();
                    this.closeOutputStreams();
                    File oModJarFile = new File(this.m_sModJarLoc);
                    if (oModJarFile.exists()) {
                        if (this.m_bCreateBackup) {
                            File oModJarBakFile = new File(this.m_sModJarBakLoc);
                            if (oModJarBakFile.exists()) {
                                oModJarBakFile.delete();
                            }
                            this.m_bBackupCreated = oModJarFile.renameTo(oModJarBakFile);
                        }
                        oModJarFile.delete();
                    }
                    File oTargetJarFile = new File(this.m_sTargetJarLoc);
                    if (this.getEntryCount() > 0) {
                        oTargetJarFile.renameTo(oModJarFile);
                    }
                    oTargetJarFile.delete();
                } else {
                    this.closeOutputStreams();
                    File oTargetJarFile = new File(this.m_sTargetJarLoc);
                    oTargetJarFile.delete();
                }
            } else {
                this.closeOutputStreams();
            }
            this.m_zipEntryHash = null;
            this.m_iJarState = 0;
            if (this.m_bFileExists) {
                OiixJarClassLoader.forgetLoader(this.m_sModJarLoc);
            }
        }
    }

    private void cleanup() {
        File f;
        if (this.m_iJarState == 0 && this.m_bCreateBackup && this.m_bBackupCreated && (f = new File(this.m_sModJarBakLoc)).delete()) {
            this.m_bBackupCreated = false;
        }
    }

    private void revert() {
        if (this.m_iJarState == 0 && this.m_bCreateBackup && this.m_bBackupCreated) {
            File fBackup = new File(this.m_sModJarBakLoc);
            File fOriginal = new File(this.m_sModJarLoc);
            if (fOriginal.exists() && fOriginal.delete() && fBackup.renameTo(fOriginal) && fBackup.delete()) {
                this.m_bBackupCreated = false;
            }
        }
    }

    public synchronized int getEntryCount() {
        return this.m_iEntryCount + this.m_iInserts - this.m_iRemovals;
    }

    public boolean getCopyAsText() {
        return this.m_bCopyAsText;
    }

    public void setCopyAsText(boolean bFlag) {
        this.m_bCopyAsText = bFlag;
    }

    public String getLineSeparator() {
        return this.m_sLineSeparator;
    }

    public void setLineSeparator(String sNewSep) {
        if (sNewSep != null) {
            this.m_sLineSeparator = sNewSep;
        }
    }

    public static int getZipLevel() {
        return s_zipLevel;
    }

    public static void setZipLevel(int iNewLevel) throws OiixJarModifyException {
        switch (iNewLevel) {
            case -1: 
            case 0: 
            case 1: 
            case 9: {
                s_zipLevel = iNewLevel;
                break;
            }
            default: {
                throw new OiixJarModifyException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVALID_ZIPLEVEL"));
            }
        }
    }
}

