/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiix.OiixJarModifier;
import oracle.sysman.oii.oiix.OiixObjectPool;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiixJarModifierPool
extends OiixObjectPool {
    private static OiixJarModifierPool s_oJarModifierPool = null;
    private Hashtable m_oJarModifierTable = new Hashtable();
    private int m_iJarModifierState = 0;

    private OiixJarModifierPool() {
    }

    public static final OiixJarModifierPool getJarModifierPool() {
        if (s_oJarModifierPool == null) {
            s_oJarModifierPool = new OiixJarModifierPool();
        }
        return s_oJarModifierPool;
    }

    public int getState() {
        return this.m_iJarModifierState;
    }

    public void setState(int iState) throws IOException {
        StringBuffer sb = new StringBuffer("");
        if (this.m_iJarModifierState != iState) {
            this.m_iJarModifierState = iState;
            Enumeration enum_1 = this.m_oJarModifierTable.elements();
            while (enum_1.hasMoreElements()) {
                OiixJarModifier oJM = (OiixJarModifier)enum_1.nextElement();
                if (oJM == null) continue;
                try {
                    oJM.setState(iState);
                }
                catch (IOException e) {
                    sb.append(e.getMessage() + "\n");
                }
                catch (OiifbCancelException e) {
                    sb.append(e.getMessage() + "\n");
                }
            }
            if ((iState == 2 || iState == 3) && sb.length() == 0) {
                this.m_iJarModifierState = 0;
            }
            if (sb.length() > 0) {
                throw new IOException(sb.toString());
            }
        }
    }

    public boolean containsJar(String sJarName) {
        return this.containsJar(sJarName, false);
    }

    private boolean containsJar(String sJarName, boolean bNativeForm) {
        if (sJarName == null) {
            return false;
        }
        if (!bNativeForm) {
            try {
                sJarName = OiixPathOps.getNativeForm(OiixPathOps.getCanonicalPath(sJarName));
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.m_oJarModifierTable.containsKey(sJarName);
    }

    private OiixJarModifier createJarModifier(String sJarName) throws IOException {
        OiixJarModifier oJarModifer = new OiixJarModifier(sJarName, false, true);
        try {
            oJarModifer.setState(this.m_iJarModifierState);
        }
        catch (OiifbCancelException e) {
            throw new IOException(e.getMessage());
        }
        return oJarModifer;
    }

    public OiixJarModifier get(String sJarName) throws IOException {
        OiixJarModifier oJarModifier = null;
        if (sJarName != null) {
            if (this.containsJar(sJarName = OiixPathOps.getNativeForm(OiixPathOps.getCanonicalPath(sJarName)), true)) {
                oJarModifier = (OiixJarModifier)this.m_oJarModifierTable.get(sJarName);
            } else {
                oJarModifier = this.createJarModifier(sJarName);
                this.m_oJarModifierTable.put(sJarName, oJarModifier);
            }
        }
        return oJarModifier;
    }

    public Enumeration getJarModifiers() {
        return this.m_oJarModifierTable.elements();
    }

    public synchronized void clearPool() {
        try {
            this.setState(2);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        this.m_oJarModifierTable.clear();
    }
}

