/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.sysman.oii.oiic.OiicInstallAddOnException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiixJarOps {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x1000000;

    public static void extractFiles(String sourcefile, String destination) throws IOException {
        ZipFile zf = new ZipFile(sourcefile);
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry zen = e.nextElement();
            System.out.println(zen.getName());
            InputStream in = zf.getInputStream(zen);
            try {
                String str = destination + '/' + zen.getName();
                str = str.replace('/', File.separatorChar);
                File f = new File(str);
                if (f.getName().length() == 0) {
                    OiixFileOps.mkdirs(f);
                } else {
                    File pf = new File(f.getParent());
                    OiixFileOps.mkdirs(pf);
                    FileOutputStream fos = new FileOutputStream(str);
                    BufferedInputStream bis = new BufferedInputStream(in);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    try {
                        int byteRead;
                        while ((byteRead = bis.read()) != -1) {
                            bos.write(byteRead);
                        }
                    }
                    catch (EOFException ee) {
                        // empty catch block
                    }
                    bos.flush();
                    fos.close();
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        zf.close();
    }

    public static void extractFile(String sourceFile, String sourceJarfile, String destination) throws IOException {
        ZipEntry zen = null;
        boolean srcFileExists = false;
        ZipFile zf = new ZipFile(sourceJarfile);
        String sFileName = null;
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            zen = e.nextElement();
            if (zen.getName().compareTo(sourceFile) != 0) continue;
            srcFileExists = true;
            String sAbsFileName = zen.getName();
            String sParentDir = new File(sAbsFileName).getParent();
            sFileName = sAbsFileName.substring(sParentDir.length() + 1);
            break;
        }
        if (srcFileExists) {
            InputStream in = zf.getInputStream(zen);
            try {
                String str = OiixPathOps.getStandardForm(destination) + "/" + OiixPathOps.getStandardForm(sFileName);
                str = OiixPathOps.getNativeForm(str);
                File f = new File(str);
                if (f.getName().length() == 0) {
                    OiixFileOps.mkdirs(f);
                } else {
                    File pf = new File(f.getParent());
                    OiixFileOps.mkdirs(pf);
                    FileOutputStream fos = new FileOutputStream(str);
                    BufferedInputStream bis = new BufferedInputStream(in);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    try {
                        int byteRead;
                        while ((byteRead = bis.read()) != -1) {
                            bos.write(byteRead);
                        }
                    }
                    catch (EOFException ee) {
                        // empty catch block
                    }
                    bos.flush();
                    fos.close();
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        zf.close();
    }

    public static void extractJar(String jarFile, String destDir, boolean generic) throws IOException {
        int BUFFER = 2048;
        try {
            byte[] data = new byte[2048];
            JarFile jarfile = new JarFile(jarFile);
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                int count;
                JarEntry entry = e.nextElement();
                BufferedInputStream is = new BufferedInputStream(jarfile.getInputStream(entry));
                String path = entry.getName();
                int start = path.lastIndexOf("/");
                String basis = null;
                if (start != -1) {
                    basis = path.substring(0, start);
                }
                String filename = path.substring(start + 1);
                File tmpPath = new File(destDir);
                if (basis != null && basis.length() != 0) {
                    tmpPath = new File(tmpPath, basis);
                    tmpPath.mkdirs();
                }
                if (filename == null || filename.length() == 0) continue;
                File destfile = new File(tmpPath, filename);
                FileOutputStream fos = new FileOutputStream(destfile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((count = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                is.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException(fnfe.getMessage());
        }
    }

    public static void extractJar(String jarFile, String destDir) throws OiicInstallAddOnException {
        int BUFFER = 2048;
        try {
            byte[] data = new byte[2048];
            JarFile jarfile = new JarFile(jarFile);
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                int count;
                JarEntry entry = e.nextElement();
                BufferedInputStream is = new BufferedInputStream(jarfile.getInputStream(entry));
                String path = entry.getName();
                int start = path.lastIndexOf("/");
                String basis = null;
                if (start != -1) {
                    basis = path.substring(0, start);
                }
                String filename = path.substring(start + 1);
                File tmpPath = new File(destDir);
                if (basis != null && basis.length() != 0) {
                    tmpPath = new File(tmpPath, basis);
                    tmpPath.mkdirs();
                }
                if (filename == null || filename.length() == 0) continue;
                File destfile = new File(tmpPath, filename);
                FileOutputStream fos = new FileOutputStream(destfile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((count = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                is.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new OiicInstallAddOnException(fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new OiicInstallAddOnException(ioe.getMessage());
        }
    }
}

