/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixCompJarResourceIF;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarResourceIF;
import oracle.sysman.oii.oiix.OiixLanguage;

public class OiixJarResourceBundle {
    private static final String JAR_RESOURCE_LOADER = "OiJarResourceLoader";
    private static final String COMP_JAR_RESOURCE_LOADER = "OiCompJarResourceLoader";
    private static final String COMP_JAR_RESOURCE_BUNDLE = "OiCompJarResourceBundle";
    public static final String PACKAGED_COMP_JAR_RESOURCE_BUNDLE = "oracle.sysman.oii.oiix.OiixBaseResourceBundle";
    private Vector m_rb = new Vector(5, 5);
    private ResourceBundle m_oEnglishBundle;
    private static boolean debug = false;
    private boolean m_bEnglishLoadAttempted = false;
    private static Boolean m_bDebugMode = null;

    public static boolean isDebugMode() {
        if (m_bDebugMode == null) {
            m_bDebugMode = new Boolean(Boolean.getBoolean("oracle.installer.debug"));
        }
        return m_bDebugMode;
    }

    public OiixJarResourceBundle() {
    }

    public OiixJarResourceBundle(ResourceBundle rb) {
        if (rb != null) {
            this.m_rb.addElement(rb);
        } else if (OiixJarResourceBundle.isDebugMode()) {
            Throwable t = new Throwable("ResourceBundle is null");
            t.fillInStackTrace();
            t.printStackTrace(System.err);
        }
        if (debug) {
            System.out.println("Adding rb: " + rb.toString());
        }
    }

    public void addResourceBundle(ResourceBundle rb) {
        if (rb != null) {
            this.m_rb.addElement(rb);
        } else if (OiixJarResourceBundle.isDebugMode()) {
            Throwable t = new Throwable("ResourceBundle is null");
            t.fillInStackTrace();
            t.printStackTrace(System.err);
        }
        if (debug) {
            System.out.println("Adding rb: " + rb.toString());
        }
    }

    public String getString(String key) throws MissingResourceException {
        return (String)this.getObject(key);
    }

    public String getString(String key, String defVal) {
        return (String)this.getObject(key, defVal);
    }

    public String getEnglishString(String key) {
        ResourceBundle rb = this.getEnglishBundle();
        String str = key;
        if (rb != null) {
            str = rb.getString(key);
        }
        return str;
    }

    public Object getObject(String key) throws MissingResourceException {
        block8: {
            int vsize = this.m_rb.size();
            if (key == null) {
                return null;
            }
            if (vsize == 0) {
                return key;
            }
            for (int i = 0; i < vsize; ++i) {
                try {
                    return ((ResourceBundle)this.m_rb.elementAt(i)).getObject(key);
                }
                catch (MissingResourceException re) {
                    if (!debug) continue;
                    re.printStackTrace();
                    continue;
                }
            }
            ResourceBundle rb = this.getEnglishBundle();
            try {
                if (rb != null) {
                    return rb.getObject(key);
                }
            }
            catch (MissingResourceException re) {
                if (!debug) break block8;
                re.printStackTrace();
            }
        }
        return key;
    }

    private ResourceBundle getEnglishBundle() {
        if (!this.m_bEnglishLoadAttempted) {
            try {
                ResourceBundle rb = (ResourceBundle)this.m_rb.elementAt(0);
                Class<?> cl = rb.getClass();
                ClassLoader cloader = cl.getClassLoader();
                this.m_oEnglishBundle = rb = OiixJarResourceBundle.extractLanguageBundle((OiixJarClassLoader)cloader, OiixLanguage.ENGLISH);
                this.addResourceBundle(rb);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_bEnglishLoadAttempted = true;
        }
        return this.m_oEnglishBundle;
    }

    public Object getObject(String key, Object defVal) {
        try {
            return this.getObject(key);
        }
        catch (MissingResourceException e) {
            return defVal;
        }
    }

    public Enumeration getKeys() {
        ResourceBundle rb = this.getEnglishBundle();
        if (rb != null) {
            return rb.getKeys();
        }
        if (this.m_rb != null) {
            rb = (ResourceBundle)this.m_rb.elementAt(0);
            return rb.getKeys();
        }
        return null;
    }

    public static ResourceBundle extractBundle(OiixJarClassLoader jcl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        OiixJarResourceIF res = (OiixJarResourceIF)jcl.loadClass(JAR_RESOURCE_LOADER).newInstance();
        return res.getJarBundle();
    }

    public static ResourceBundle extractBundle(String jarLoc) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        OiixJarClassLoader jcl = OiixJarClassLoader.createLoader(jarLoc);
        OiixJarResourceIF res = (OiixJarResourceIF)jcl.loadClass(JAR_RESOURCE_LOADER).newInstance();
        return res.getJarBundle();
    }

    public static ResourceBundle extractLanguageBundle(OiixJarClassLoader jcl, Locale l) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        OiixCompJarResourceIF res = (OiixCompJarResourceIF)jcl.loadClass(COMP_JAR_RESOURCE_LOADER).newInstance();
        return res.getLanguageBundle(l);
    }

    public static ResourceBundle extractLanguageBundle(OiixJarClassLoader jcl, String sResBundle, Locale l, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (sResBundle == null) {
            sResBundle = PACKAGED_COMP_JAR_RESOURCE_BUNDLE;
        }
        Class<?> oResClass = null;
        Class oResBundleClass = null;
        if (jcl != null) {
            oResClass = jcl.loadClass(sResBundle);
        } else {
            oResBundleClass = OiixJarClassLoader.getClass(className);
            ClassLoader cl = oResBundleClass.getClassLoader();
            oResClass = cl.loadClass(sResBundle);
        }
        if (l == null) {
            l = OiixLanguage.getDefaultLocale();
        }
        Class[] aoConstructArgs = new Class[]{Class.forName("java.lang.String"), Class.forName("java.util.Locale")};
        ResourceBundle resBundle = null;
        try {
            Constructor<?> oConstruct = oResClass.getConstructor(aoConstructArgs);
            Object[] aoArgs = new Object[]{className, l};
            OiixJarResourceIF res = (OiixJarResourceIF)oConstruct.newInstance(aoArgs);
            resBundle = res.getJarBundle();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.err.println("Jar class loader: " + jcl);
            System.err.println("Locale: " + l);
            System.err.println("className: " + className);
            System.err.println("Error InvocationTargetException: " + e.getTargetException().toString());
            e.getTargetException().printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return resBundle;
    }

    public static ResourceBundle extractCompResBundle(String jarLoc) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        OiixJarClassLoader jcl = OiixJarClassLoader.createLoader(jarLoc);
        OiixCompJarResourceIF res = (OiixCompJarResourceIF)jcl.loadClass(COMP_JAR_RESOURCE_LOADER).newInstance();
        return res.getJarBundle();
    }

    public static Object extractCompBundle(OiixJarClassLoader jcl) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        return jcl.loadClass(COMP_JAR_RESOURCE_BUNDLE).newInstance();
    }

    public static OiixJarResourceBundle setInternalCompResBundle(OiixJarClassLoader jcl, ResourceBundle externalBundle) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        Object internalBundle = OiixJarResourceBundle.extractCompBundle(jcl);
        OiixJarResourceBundle extBundle = new OiixJarResourceBundle();
        extBundle.addResourceBundle(externalBundle);
        OiixCompJarResourceIF cRes = (OiixCompJarResourceIF)internalBundle;
        cRes.setJarBundle(extBundle);
        return extBundle;
    }
}

